/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.web.support.util;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Optional;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public final class RestUtils {
    private static final String USERNAME_ATTRIBUTE_NAME = "username";

    private RestUtils() {
    }

    public static String getUserIdFromSession() {
        RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
        return (String)attributes.getAttribute(USERNAME_ATTRIBUTE_NAME, 1);
    }

    public static String getUserIdFromSession(HttpServletRequest request) {
        return Optional.ofNullable(request.getSession(false)).map(s -> (String)s.getAttribute(USERNAME_ATTRIBUTE_NAME)).orElse("");
    }
}

