/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.util.xhtml;

import com.suncode.plugin.efaktura.util.xhtml.EfakturaXHTMLImporterImpl;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.Map;
import org.docx4j.jaxb.Context;
import org.docx4j.model.properties.paragraph.Indent;
import org.docx4j.openpackaging.parts.WordprocessingML.NumberingDefinitionsPart;
import org.docx4j.org.xhtmlrenderer.css.constants.CSSName;
import org.docx4j.org.xhtmlrenderer.css.style.derived.LengthValue;
import org.docx4j.org.xhtmlrenderer.render.BlockBox;
import org.docx4j.wml.Jc;
import org.docx4j.wml.JcEnumeration;
import org.docx4j.wml.Lvl;
import org.docx4j.wml.NumFmt;
import org.docx4j.wml.NumberFormat;
import org.docx4j.wml.Numbering;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.RFonts;
import org.docx4j.wml.RPr;
import org.docx4j.wml.STHint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;

public class ListHelper {
    public static Logger log = LoggerFactory.getLogger(EfakturaXHTMLImporterImpl.class);
    private ObjectFactory wmlObjectFactory = Context.getWmlObjectFactory();
    private NumberingDefinitionsPart ndp;
    private LinkedList<BlockBox> listStack = new LinkedList();
    private Numbering.AbstractNum abstractList;
    private Numbering.Num concreteList;

    public ListHelper(NumberingDefinitionsPart ndp) {
        this.ndp = ndp;
    }

    protected void pushListStack(BlockBox ca) {
        this.listStack.push(ca);
    }

    protected BlockBox popListStack() {
        BlockBox box = this.listStack.pop();
        if (this.listStack.size() == 0) {
            this.concreteList = null;
        }
        return box;
    }

    protected BlockBox peekListStack() {
        return this.listStack.peek();
    }

    protected int getDepth() {
        return this.listStack.size();
    }

    protected Numbering.AbstractNum createNewAbstractList() {
        Numbering.AbstractNum numberingabstractnum = Context.getWmlObjectFactory().createNumberingAbstractNum();
        numberingabstractnum.setAbstractNumId(BigInteger.valueOf(0L));
        Numbering.AbstractNum.MultiLevelType numberingabstractnummultileveltype = Context.getWmlObjectFactory().createNumberingAbstractNumMultiLevelType();
        numberingabstractnum.setMultiLevelType(numberingabstractnummultileveltype);
        numberingabstractnummultileveltype.setVal("multilevel");
        return numberingabstractnum;
    }

    private Lvl getLevel(Numbering.AbstractNum theList, int level) {
        if (level > 8) {
            level = 8;
        }
        for (Lvl lvl : theList.getLvl()) {
            if (lvl.getIlvl().intValue() != level) continue;
            return lvl;
        }
        return null;
    }

    private NumberFormat getNumberFormatFromCSSListStyleType(String listStyleType) {
        if (listStyleType.equals("disc") || listStyleType.equals("circle") || listStyleType.equals("square")) {
            return NumberFormat.BULLET;
        }
        if (listStyleType.equals("decimal")) {
            return NumberFormat.DECIMAL;
        }
        if (listStyleType.equals("decimal-leading-zero")) {
            return NumberFormat.DECIMAL_ZERO;
        }
        if (listStyleType.equals("lower-roman")) {
            return NumberFormat.LOWER_ROMAN;
        }
        if (listStyleType.equals("upper-roman")) {
            return NumberFormat.UPPER_ROMAN;
        }
        if (listStyleType.equals("lower-greek")) {
            return NumberFormat.DECIMAL;
        }
        if (listStyleType.equals("lower-latin")) {
            return NumberFormat.LOWER_LETTER;
        }
        if (listStyleType.equals("upper-latin")) {
            return NumberFormat.UPPER_LETTER;
        }
        if (listStyleType.equals("armenian")) {
            return NumberFormat.DECIMAL;
        }
        if (listStyleType.equals("georgian")) {
            return NumberFormat.DECIMAL;
        }
        if (listStyleType.equals("lower-alpha")) {
            return NumberFormat.LOWER_LETTER;
        }
        if (listStyleType.equals("upper-alpha")) {
            return NumberFormat.UPPER_LETTER;
        }
        if (listStyleType.equals("none")) {
            return NumberFormat.NONE;
        }
        if (listStyleType.equals("inherit")) {
            return NumberFormat.DECIMAL;
        }
        return NumberFormat.DECIMAL;
    }

    private String getLvlTextFromCSSListStyleType(String listStyleType, int level) {
        if (listStyleType.equals("disc")) {
            return "\uf0b7";
        }
        if (listStyleType.equals("circle")) {
            return "o";
        }
        if (listStyleType.equals("square")) {
            return "\uf0a7";
        }
        return "%" + level;
    }

    private RFonts geRFontsForCSSListStyleType(String listStyleType) {
        RFonts rfonts = null;
        if (listStyleType.equals("disc")) {
            rfonts = this.wmlObjectFactory.createRFonts();
            rfonts.setAscii("Symbol");
            rfonts.setHint(STHint.DEFAULT);
            rfonts.setHAnsi("Symbol");
        }
        if (listStyleType.equals("circle")) {
            rfonts = this.wmlObjectFactory.createRFonts();
            rfonts.setAscii("Courier New");
            rfonts.setHint(STHint.DEFAULT);
            rfonts.setHAnsi("Courier New");
            rfonts.setCs("Courier New");
        }
        if (listStyleType.equals("square")) {
            rfonts = this.wmlObjectFactory.createRFonts();
            rfonts.setAscii("Wingdings");
            rfonts.setHint(STHint.DEFAULT);
            rfonts.setHAnsi("Wingdings");
        }
        return rfonts;
    }

    protected PPrBase.Ind getInd(int twip) {
        PPrBase.Ind ind = Context.getWmlObjectFactory().createPPrBaseInd();
        ind.setLeft(BigInteger.valueOf(twip + 360));
        ind.setHanging(BigInteger.valueOf(360L));
        return ind;
    }

    protected int getAncestorIndentation() {
        int totalPadding = 0;
        for (BlockBox bb : this.listStack) {
            LengthValue padding = (LengthValue)bb.getStyle().valueByName(CSSName.PADDING_LEFT);
            log.debug("+padding-left: " + (totalPadding += Indent.getTwip((CSSPrimitiveValue)padding.getCSSPrimitiveValue())));
            LengthValue margin = (LengthValue)bb.getStyle().valueByName(CSSName.MARGIN_LEFT);
            log.debug("+margin-left: " + (totalPadding += Indent.getTwip((CSSPrimitiveValue)margin.getCSSPrimitiveValue())));
        }
        return totalPadding;
    }

    private Lvl createLevel(int level, Map<String, CSSValue> cssMap) {
        if (level > 8) {
            level = 8;
        }
        Lvl lvl = this.wmlObjectFactory.createLvl();
        lvl.setIlvl(BigInteger.valueOf(level));
        PPr ppr = this.wmlObjectFactory.createPPr();
        lvl.setPPr(ppr);
        ppr.setInd(this.getInd(this.getAncestorIndentation()));
        NumFmt numfmt = this.wmlObjectFactory.createNumFmt();
        lvl.setNumFmt(numfmt);
        numfmt.setVal(this.getNumberFormatFromCSSListStyleType(cssMap.get("list-style-type").getCssText()));
        Lvl.LvlText lvllvltext = this.wmlObjectFactory.createLvlLvlText();
        lvl.setLvlText(lvllvltext);
        lvllvltext.setVal(this.getLvlTextFromCSSListStyleType(cssMap.get("list-style-type").getCssText(), level + 1));
        RFonts rfonts = this.geRFontsForCSSListStyleType(cssMap.get("list-style-type").getCssText());
        if (rfonts != null) {
            RPr rpr = this.wmlObjectFactory.createRPr();
            rpr.setRFonts(rfonts);
            lvl.setRPr(rpr);
        }
        Jc jc = this.wmlObjectFactory.createJc();
        lvl.setLvlJc(jc);
        jc.setVal(JcEnumeration.LEFT);
        Lvl.Start lvlstart = this.wmlObjectFactory.createLvlStart();
        lvl.setStart(lvlstart);
        lvlstart.setVal(BigInteger.valueOf(1L));
        return lvl;
    }

    void addNumbering(P p, Element e, Map<String, CSSValue> cssMap) {
        Lvl lvl;
        if (this.concreteList == null) {
            this.abstractList = this.createNewAbstractList();
            this.concreteList = this.ndp.addAbstractListNumberingDefinition(this.abstractList);
        }
        if ((lvl = this.getLevel(this.abstractList, this.listStack.size() - 1)) == null) {
            this.abstractList.getLvl().add(this.createLevel(this.listStack.size() - 1, cssMap));
        }
        this.setNumbering(p.getPPr(), this.concreteList.getNumId());
    }

    protected void setNumbering(PPr pPr, BigInteger numId) {
        PPrBase.NumPr numPr = Context.getWmlObjectFactory().createPPrBaseNumPr();
        pPr.setNumPr(numPr);
        PPrBase.NumPr.NumId numIdElement = Context.getWmlObjectFactory().createPPrBaseNumPrNumId();
        numPr.setNumId(numIdElement);
        numIdElement.setVal(numId);
        PPrBase.NumPr.Ilvl ilvlElement = Context.getWmlObjectFactory().createPPrBaseNumPrIlvl();
        numPr.setIlvl(ilvlElement);
        ilvlElement.setVal(BigInteger.valueOf(this.listStack.size() - 1));
    }
}

