/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.util.recordindex;

import com.suncode.plugin.efaktura.util.TagElement;
import com.suncode.plugin.efaktura.util.recordindex.PdfTableRecord;
import com.suncode.plugin.efaktura.util.recordindex.PdfTableRecordProcessor;
import com.suncode.plugin.efaktura.util.recordindex.PdfTableRecordProcessorImpl;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.text.TextPosition;

public class RecordIndexResolverPDFTextStripper
extends PDFTextStripper {
    private String startPhrase;
    private String stopPhrase;
    private float xStart;
    private float xStop;
    private String tableEnd;
    private String recordFormatAction;
    private PdfTableRecordProcessor recordProcessor;
    private List<String> storage;
    private boolean tableEnded;

    public RecordIndexResolverPDFTextStripper(TagElement oneTag) throws IOException {
        this.startPhrase = oneTag.getValue();
        this.stopPhrase = oneTag.getLastvalue();
        this.xStart = oneTag.getXStartPos();
        this.xStop = oneTag.getXStopPos();
        this.tableEnd = oneTag.getTableEnd();
        this.recordFormatAction = oneTag.getRecordFormatAction();
        this.recordProcessor = new PdfTableRecordProcessorImpl();
        this.storage = new ArrayList<String>();
        this.tableEnded = false;
    }

    private void populateCharactersPositions(PDDocument pdDoc) throws IOException {
        this.setSortByPosition(true);
        this.document = pdDoc;
        this.output = new StringWriter();
        this.processPages(this.document.getDocumentCatalog().getPages());
    }

    protected void endPage(PDPage page) throws IOException {
        if (!this.tableEnded) {
            StringBuilder lineText = new StringBuilder();
            StringBuilder xSectorLineText = new StringBuilder();
            boolean collecting = false;
            float previousLineY = 0.0f;
            PdfTableRecord record = new PdfTableRecord();
            for (List textPositions : this.getCharactersByArticle()) {
                for (TextPosition textPosition : textPositions) {
                    String character = textPosition.getUnicode();
                    float x = textPosition.getX();
                    float y = textPosition.getY();
                    if (y > previousLineY) {
                        previousLineY = y;
                        lineText = new StringBuilder();
                        if (collecting) {
                            this.collectLine(xSectorLineText, record);
                        }
                        xSectorLineText = new StringBuilder();
                    }
                    lineText.append(character);
                    if (lineText.indexOf(this.startPhrase) != -1) {
                        collecting = true;
                        this.collectRecord(record);
                    }
                    if (collecting && lineText.indexOf(this.stopPhrase) != -1) {
                        this.collectRecord(record);
                        collecting = false;
                    }
                    if (collecting && lineText.indexOf(this.tableEnd) != -1) {
                        this.collectRecord(record);
                        collecting = false;
                        this.tableEnded = false;
                    }
                    if (!(x > this.xStart) || !(x < this.xStop)) continue;
                    xSectorLineText.append(character);
                }
                if (!collecting) continue;
                this.collectLine(xSectorLineText, record);
            }
            if (collecting) {
                this.collectRecord(record);
            }
        }
    }

    private void collectLine(StringBuilder xSectorLineText, PdfTableRecord record) {
        String line = xSectorLineText.toString().trim();
        if (line.length() > 0) {
            record.addLine(line);
        }
    }

    private void collectRecord(PdfTableRecord record) {
        if (record.hasLines()) {
            String value = this.recordProcessor.process(record, this.recordFormatAction);
            this.storage.add(value);
            record.reset();
        }
    }

    public List<String> getRecordIndexValues(PDDocument pdDoc) throws IOException {
        this.populateCharactersPositions(pdDoc);
        return this.storage;
    }
}

