/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.util;

import com.suncode.plugin.efaktura.util.AdditionalOptions;
import com.suncode.plugin.efaktura.util.PlusEFakturaTools;
import com.suncode.plugin.efaktura.util.exception.IndexesMappingException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SubjectAsIndexesResolver {
    public static Logger log = Logger.getLogger(SubjectAsIndexesResolver.class);
    public static Logger clientLog = Logger.getLogger((String)"PlusEFakturaClientLog");
    private final String delimiter;
    private final String sequence;
    private final String subject;
    private final String archiveClass;
    private final AdditionalOptions additionalOptions;

    public SubjectAsIndexesResolver(String delimiter, String sequence, String subject, String archiveClass, AdditionalOptions additionalOptions) {
        this.delimiter = delimiter;
        this.sequence = sequence;
        this.subject = subject;
        this.archiveClass = archiveClass;
        this.additionalOptions = additionalOptions;
    }

    public Set<String> resolve() throws IndexesMappingException {
        HashSet<String> indexes = new HashSet<String>();
        Iterator<String> indexesNames = this.getIterator(this.sequence);
        Iterator<String> indexesValues = this.getIterator(this.subject);
        while (indexesNames.hasNext() && indexesValues.hasNext()) {
            String indexName = indexesNames.next();
            String indexValue = indexesValues.next();
            String indexId = PlusEFakturaTools.getIndexIdForDocClass(this.archiveClass, indexName);
            if (!indexId.equalsIgnoreCase("-1")) {
                indexes.add(indexId + ";" + indexValue);
                continue;
            }
            log.warn((Object)("Indeks o nazwie " + indexName + " nie istnieje w klasie dokumentow " + this.archiveClass + ". Brak mozliwosci przypisania wartosci dla mapowania indeksow z tematu wiadomosci"));
            clientLog.warn((Object)("Indeks o nazwie " + indexName + " nie istnieje w klasie dokumentow " + this.archiveClass + ". Brak mozliwosci przypisania wartosci dla mapowania indeksow z tematu wiadomosci"));
            PlusEFakturaTools.handleException(this.additionalOptions);
        }
        if (indexesNames.hasNext()) {
            log.warn((Object)"Pozostaly niezmapowane indeksy dla mapowania indeksow z tematu wiadomosci");
            clientLog.warn((Object)"Pozostaly niezmapowane indeksy dla mapowania indeksow z tematu wiadomosci");
            PlusEFakturaTools.handleException(this.additionalOptions);
        }
        return indexes;
    }

    private Iterator<String> getIterator(String value) {
        String valueToSplit = StringUtils.defaultString((String)value);
        return Arrays.asList(valueToSplit.split(this.delimiter, -1)).iterator();
    }
}

