/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.util;

import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.parser.PdfTextExtractor;
import com.suncode.plugin.efaktura.util.Constants;
import com.suncode.plugin.efaktura.util.PlusEFakturaTools;
import com.suncode.plugin.efaktura.util.exception.PlusEFakturaException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.RandomAccessReadBufferedFile;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;

public class PDFAnalyzer {
    public static Logger log = Logger.getLogger(PDFAnalyzer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readPDFWithPdfBox_1_7_1(File file) {
        log.trace((Object)"********** readPDFWithPdfBox_1_7_1(File file) **********");
        PDFParser parser = null;
        String parsedText = "";
        PDFTextStripper pdfStripper = null;
        PDDocument pdDoc = null;
        COSDocument cosDoc = null;
        RandomAccessReadBufferedFile read = null;
        try {
            if (file == null || !file.exists()) {
                throw new PlusEFakturaException("Plik poddawany analizie nie istnieje");
            }
            read = new RandomAccessReadBufferedFile(file);
            parser = new PDFParser((RandomAccessRead)read);
            cosDoc = parser.parse().getDocument();
            pdDoc = new PDDocument(cosDoc);
            pdDoc.setAllSecurityToBeRemoved(true);
            pdfStripper = new PDFTextStripper();
            parsedText = pdfStripper.getText(pdDoc);
            parsedText = PDFAnalyzer.conversions(parsedText);
        }
        catch (PlusEFakturaException e) {
            log.warn((Object)e.getMessage());
        }
        catch (Throwable e) {
            parsedText = PDFAnalyzer.readPDFWithIText(file);
        }
        finally {
            try {
                if (cosDoc != null) {
                    cosDoc.close();
                }
                if (pdDoc != null) {
                    pdDoc.close();
                }
                if (read != null) {
                    read.close();
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return parsedText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readPDFWithIText(File file) {
        log.trace((Object)"********** readPDFWithIText(File file) **********");
        String parsedText = "";
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            PdfReader reader = new PdfReader((InputStream)fis);
            int ret = reader.getNumberOfPages();
            PdfTextExtractor extractor = new PdfTextExtractor(reader);
            for (int i = 1; i <= ret; ++i) {
                String pageText = extractor.getTextFromPage(i);
                if (pageText == null) continue;
                if (Constants.ENTER.compareToIgnoreCase("\n") == 0) {
                    pageText = pageText.replaceAll("\r", "");
                } else if (Constants.ENTER.compareToIgnoreCase("\r\n") == 0) {
                    pageText = pageText.replaceAll("\n", Constants.ENTER);
                    pageText = pageText.replaceAll("\r\r", "\r");
                }
                parsedText = parsedText.concat(pageText);
                if (i == ret) continue;
                parsedText = parsedText.concat(Constants.ENTER);
            }
            parsedText = PDFAnalyzer.conversions(parsedText);
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return parsedText;
    }

    private static String conversions(String parsedText) throws Exception {
        if ((parsedText = PlusEFakturaTools.decodeText(parsedText, false, false)) != null) {
            parsedText = parsedText.replaceAll("FL017Ch", "\u017c");
            parsedText = parsedText.replaceAll("FL0142h", "\u0142");
            parsedText = parsedText.replaceAll("FL0141h", "\u0141");
            parsedText = parsedText.replaceAll("FL015Bh", "\u015b");
            parsedText = parsedText.replaceAll("FL0107h", "\u0107");
            parsedText = parsedText.replaceAll("FL0143h", "\u0143");
            parsedText = parsedText.replaceAll("FL0105h", "\u0105");
            parsedText = parsedText.replaceAll("FL0119h", "\u0119");
            if ((parsedText = parsedText.trim()).endsWith(Constants.ENTER)) {
                parsedText = parsedText.substring(0, parsedText.length() - Constants.ENTER.length());
            }
        }
        return parsedText;
    }
}

