/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class CertInstallation {
    public static Logger log = Logger.getLogger(CertInstallation.class);

    public static void installCert(String host, int port, String sPassphrase) throws Exception {
        File file;
        log.trace((Object)("************ installCert(host=" + host + ", port=" + String.valueOf(port) + ", sPassphrase=" + sPassphrase + ") ************"));
        char[] passphrase = null;
        if (StringUtils.isBlank((CharSequence)host) || port < 0) {
            throw new Exception("Niepoprawne parametry dla pobrania certyfikatu");
        }
        if (sPassphrase != null) {
            passphrase = sPassphrase.toCharArray();
        }
        if (!(file = new File("jssecacerts")).exists() || !file.isFile()) {
            char SEP = File.separatorChar;
            File dir = new File(System.getProperty("java.home") + SEP + "lib" + SEP + "security");
            file = new File(dir, "jssecacerts");
            if (!file.exists() || !file.isFile()) {
                file = new File(dir, "cacerts");
            }
        }
        log.info((Object)("Loading KeyStore " + file.getAbsolutePath() + "..."));
        FileInputStream in = new FileInputStream(file);
        KeyStore ks = null;
        try {
            ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(in, passphrase);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
            catch (Exception exception) {}
        }
        SSLContext context = SSLContext.getInstance("TLS");
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(ks);
        X509TrustManager defaultTrustManager = (X509TrustManager)tmf.getTrustManagers()[0];
        SavingTrustManager tm = new SavingTrustManager(defaultTrustManager);
        context.init(null, new TrustManager[]{tm}, null);
        SSLSocketFactory factory = context.getSocketFactory();
        log.info((Object)("Opening connection to " + host + ":" + port + "..."));
        SSLSocket socket = (SSLSocket)factory.createSocket(host, port);
        socket.setSoTimeout(10000);
        try {
            log.info((Object)"Starting SSL handshake...");
            socket.startHandshake();
            socket.close();
            log.info((Object)"Certificate is already trusted");
        }
        catch (SSLException e) {
            log.info((Object)"Certificate is not trusted");
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static class SavingTrustManager
    implements X509TrustManager {
        private final X509TrustManager tm;
        private X509Certificate[] chain;

        SavingTrustManager(X509TrustManager tm) {
            this.tm = tm;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.chain = chain;
            this.tm.checkServerTrusted(chain, authType);
        }
    }
}

