/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.service.module;

import com.suncode.plugin.efaktura.service.plugin.PluginService;
import com.suncode.plugin.efaktura.web.support.dto.StyleDto;
import com.suncode.plugin.efaktura.web.support.dto.builder.StyleDtoBuilder;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

@Service
public class StyleService {
    private static final String PROGRAM_RESOURCES_LOCATION_PATTERN = "/resources/style/program/dist/*.css";
    private static final String ADMINISTRATION_RESOURCES_LOCATION_PATTERN = "/resources/style/administration/*.css";
    @Autowired
    private PluginService pluginService;
    @Autowired
    private StyleDtoBuilder styleDtoBuilder;

    public List<StyleDto> getAllForProgram() {
        ArrayList<StyleDto> dtos = new ArrayList<StyleDto>();
        dtos.addAll(this.getProgramStyle());
        return dtos;
    }

    public List<StyleDto> getAllForAdministration() {
        ArrayList<StyleDto> dtos = new ArrayList<StyleDto>();
        dtos.addAll(this.getAdministrationStyle());
        return dtos;
    }

    private List<StyleDto> getProgramStyle() {
        return this.getStyle(PROGRAM_RESOURCES_LOCATION_PATTERN);
    }

    private List<StyleDto> getAdministrationStyle() {
        return this.getStyle(ADMINISTRATION_RESOURCES_LOCATION_PATTERN);
    }

    private List<StyleDto> getStyle(String locationPattern) {
        Resource[] resources = this.pluginService.getResources(locationPattern);
        return this.styleDtoBuilder.build(resources);
    }
}

