/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.scheduledtask;

import com.suncode.plugin.efaktura.model.license.License;
import com.suncode.plugin.efaktura.service.license.LicenseService;
import com.suncode.plugin.efaktura.util.ForwardEmailAction;
import com.suncode.plugin.efaktura.util.Mailbox;
import com.suncode.plugin.efaktura.util.PasswordManager;
import com.suncode.plugin.efaktura.util.PlusEFakturaTools;
import com.suncode.plugin.efaktura.util.exception.LicenseException;
import com.suncode.plugin.efaktura.util.exception.PlusEFakturaException;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.service.ConfigurationFileService;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.Date;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.configuration2.INIConfiguration;
import org.apache.commons.configuration2.SubnodeConfiguration;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@ScheduledTask
public class RunModuleScheduledTask {
    public static Logger log = Logger.getLogger(RunModuleScheduledTask.class);
    public static Logger clientLog = Logger.getLogger((String)"PlusEFakturaClientLog");
    private static final String PASSWORD_ENCRYPTING_PREFIX = "encrypted:";
    @Autowired
    private Plugin plugin;
    @Autowired
    private ConfigurationFileService configurationFileService;
    @Autowired
    private LicenseService licenseService;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("efaktura-run-module-scheduled-task")).name("efaktura.scheduled-task.run-module.name")).description("efaktura.scheduled-task.run-module.description")).parameter().id("configFilePath").name("efaktura.scheduled-task.run-module.parameters.config-file-path.name").type((Type)Types.STRING).create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void execute(@Param String configFilePath) {
        long startTime;
        block10: {
            log.info((Object)("**************** runModule(configurationId=" + configFilePath + ") *****************"));
            clientLog.info((Object)"Rozpoczecie pracy modulu Plus E-faktura");
            startTime = new Date().getTime();
            INIConfiguration configFile = INIConfiguration.builder().build();
            File fConfigFile = null;
            InputStreamReader configFileReader = null;
            try {
                if (RunModuleScheduledTask.isFilePath(configFilePath)) {
                    fConfigFile = new File(configFilePath);
                    if (!fConfigFile.exists()) {
                        throw new PlusEFakturaException("Brak pliku konfiguracyjnego modulu Plus E-faktura w lokalizacji " + configFilePath);
                    }
                    configFileReader = new FileReader(fConfigFile);
                    configFile.read((Reader)configFileReader);
                } else {
                    InputStream inputStream = this.configurationFileService.readFile(this.plugin.getKey(), configFilePath);
                    configFileReader = new InputStreamReader(inputStream);
                }
                configFile.read((Reader)configFileReader);
                this.executeRunModule(configFile, configFilePath);
                IOUtils.closeQuietly((Reader)configFileReader);
            }
            catch (PlusEFakturaException exception) {
                log.warn((Object)exception.getMessage());
                clientLog.warn((Object)exception.getMessage());
            }
            catch (Exception exception2) {
                log.error((Object)exception2.getMessage(), (Throwable)exception2);
                break block10;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtils.closeQuietly(configFileReader);
            }
        }
        long stopTime = new Date().getTime();
        String durationTime = PlusEFakturaTools.formatDuration(stopTime - startTime);
        log.info((Object)("Czas wywolania modulu Plus E-faktura: " + durationTime));
        clientLog.info((Object)("Czas wywolania modulu Plus E-faktura: " + durationTime));
        clientLog.info((Object)"Zakonczenie pracy modulu Plus E-faktura");
    }

    public static boolean isFilePath(String filePath) {
        try {
            if (StringUtils.contains((CharSequence)filePath, (CharSequence)"/") || StringUtils.contains((CharSequence)filePath, (CharSequence)"\\")) {
                Paths.get(filePath, new String[0]);
                return true;
            }
            return false;
        }
        catch (NullPointerException | InvalidPathException ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeRunModule(INIConfiguration configFile, String configFilePath) {
        log.info((Object)"**************** executeRunModule() *****************");
        License license = null;
        int noOfInvoices = -1;
        int limitSize = -1;
        int invoicesToFinishLicense = 100;
        try {
            int i;
            license = this.licenseService.renew();
            limitSize = this.licenseService.getLimit(license.getPath());
            noOfInvoices = this.licenseService.getNoOfInvoices(license.getPath());
            if (limitSize != 0) {
                String licenseNotificationActive = configFile.getSection("PlusEFakturaConfiguration").getString("ActivateLicenseNotification");
                if (StringUtils.isNotBlank((CharSequence)licenseNotificationActive) && licenseNotificationActive.equalsIgnoreCase("TRUE")) {
                    SubnodeConfiguration licenseNotificationSection = configFile.getSection("LicenseNotification");
                    String sInvoicesToFinishLicense = licenseNotificationSection.getString("InvoicesToFinishLicense");
                    if (StringUtils.isNotBlank((CharSequence)sInvoicesToFinishLicense)) {
                        try {
                            invoicesToFinishLicense = Integer.parseInt(sInvoicesToFinishLicense);
                        }
                        catch (NumberFormatException e) {
                            log.warn((Object)"Niepoprawna wartosc pola InvoicesToFinishLicense w sekcji LicenseNotification w pliku konfiguracyjnym modulu Plus E-faktura");
                            invoicesToFinishLicense = 100;
                        }
                    }
                    if (limitSize - noOfInvoices <= invoicesToFinishLicense && this.licenseService.shouldSendLimitExceedNotification(license)) {
                        String sEmail = licenseNotificationSection.getString("Email");
                        String sEmailPassword = licenseNotificationSection.getString("EmailPassword");
                        String sOutgoingEmailPort = licenseNotificationSection.getString("OutgoingEmailPort");
                        String sEmailServer = licenseNotificationSection.getString("EmailServer");
                        String sAuth = licenseNotificationSection.getString("Authentication");
                        String sSendTo = licenseNotificationSection.getString("SendNotificationTo");
                        String sSSL = licenseNotificationSection.getString("SSL");
                        String sStartTls = licenseNotificationSection.getString("StartTLS");
                        String sOAuth = licenseNotificationSection.getString("OAuth");
                        if (sSSL == null && sStartTls == null) {
                            sSSL = "false";
                            sStartTls = "true";
                        }
                        try {
                            String[] sSendToTab;
                            if (StringUtils.isBlank((CharSequence)sAuth)) {
                                throw new PlusEFakturaException("Brak okreslonego pola Authentication w sekcji LicenseNotification w pliku konfiguracyjnym modulu Plus E-faktura");
                            }
                            if (StringUtils.isBlank((CharSequence)sEmail)) {
                                throw new PlusEFakturaException("Brak okreslonego pola Email w sekcji LicenseNotification w pliku konfiguracyjnym modulu Plus E-faktura");
                            }
                            if (sAuth.equalsIgnoreCase("TRUE") && StringUtils.isBlank((CharSequence)sEmailPassword)) {
                                throw new PlusEFakturaException("Brak okreslonego pola EmailPassword w sekcji LicenseNotification w pliku konfiguracyjnym modulu Plus E-faktura");
                            }
                            if (StringUtils.isBlank((CharSequence)sOutgoingEmailPort)) {
                                throw new PlusEFakturaException("Brak okreslonego pola OutgoingEmailPort w sekcji LicenseNotification w pliku konfiguracyjnym modulu Plus E-faktura");
                            }
                            if (StringUtils.isBlank((CharSequence)sEmailServer)) {
                                throw new PlusEFakturaException("Brak okreslonego pola EmailServer w sekcji LicenseNotification w pliku konfiguracyjnym modulu Plus E-faktura");
                            }
                            if (StringUtils.isBlank((CharSequence)sSendTo)) {
                                throw new PlusEFakturaException("Brak okreslonego pola SendNotificationTo w sekcji LicenseNotification w pliku konfiguracyjnym modulu Plus E-faktura");
                            }
                            try {
                                Integer.parseInt(sOutgoingEmailPort);
                            }
                            catch (NumberFormatException nfe) {
                                throw new PlusEFakturaException("Pole OutgoingEmailPort w sekcji LicenseNotification w pliku konfiguracyjnym modulu Plus E-faktura nie okresla wymaganej wartosci liczbowej");
                            }
                            String[] monkey = sEmail.split("@");
                            if (monkey.length != 2) {
                                throw new PlusEFakturaException("Niepoprawny format adresu e-mail w polu Email w sekcji LicenseNotification w pliku konfiguracyjnym modulu Plus E-faktura");
                            }
                            String sSubject = "";
                            Object sContent = "";
                            if (limitSize - noOfInvoices <= 0) {
                                sSubject = "Wygasla licencja modu\u0142u Plus E-faktura";
                                sContent = "UWAGA!!! Wygas\u0142a licencja modu\u0142u Plus E-faktura. Skontaktuj si\u0119 z dostawc\u0105 w celu wykupienia nowej licencji.";
                            } else {
                                sSubject = "Licencja modu\u0142u Plus E-faktura bliska wyczerpania";
                                sContent = "UWAGA!!! Zbli\u017ca si\u0119 limit wyczerpania licencji modu\u0142u Plus E-faktura. Do wyczerpania pozosta\u0142o " + (limitSize - noOfInvoices) + " faktur. Skontaktuj si\u0119 z dostawc\u0105 PlusWorkflow w celu wykupienia nowej licencji.";
                            }
                            boolean limitNotification = true;
                            for (String oneSendTo : sSendToTab = sSendTo.split(";")) {
                                try {
                                    monkey = oneSendTo.split("@");
                                    if (monkey.length != 2) {
                                        throw new PlusEFakturaException("Niepoprawny format adresu e-mail (" + oneSendTo + ") w polu SendNotificationTo w sekcji LicenseNotification w pliku konfiguracyjnym modulu Plus E-faktura");
                                    }
                                    boolean sent = ForwardEmailAction.sendLicenseNotification(oneSendTo, sEmail, sEmailPassword, sOutgoingEmailPort, sEmailServer, sSubject, (String)sContent, sAuth, sOAuth, sSSL, sStartTls);
                                    if (sent) continue;
                                    throw new PlusEFakturaException("Nie udalo sie wyslac powiadomienia o wygasnieciu licencji na adres " + oneSendTo);
                                }
                                catch (PlusEFakturaException exception) {
                                    log.warn((Object)exception.getMessage());
                                    limitNotification = false;
                                }
                                catch (Exception exception) {
                                    log.error((Object)exception.getMessage(), (Throwable)exception);
                                    limitNotification = false;
                                }
                            }
                            if (limitNotification) {
                                log.info((Object)"Blokowanie ponownego wysylania powiadomienia o wygascieniu licencji");
                                license.setNotificationLimit(true);
                                this.licenseService.edit(license);
                            }
                        }
                        catch (PlusEFakturaException exception) {
                            log.warn((Object)"Brak mozliwosci wyslania e-maila informujacego o wyczerpujacej sie licencji modulu Plus E-faktura");
                            clientLog.warn((Object)"Brak mozliwosci wyslania e-maila informujacego o wyczerpujacej sie licencji modulu Plus E-faktura");
                            log.warn((Object)exception.getMessage());
                        }
                        catch (Exception exception) {
                            log.warn((Object)"Brak mozliwosci wyslania e-maila informujacego o wyczerpujacej sie licencji modulu Plus E-faktura");
                            clientLog.warn((Object)"Brak mozliwosci wyslania e-maila informujacego o wyczerpujacej sie licencji modulu Plus E-faktura");
                            log.error((Object)exception.getMessage(), (Throwable)exception);
                        }
                    }
                }
                if (limitSize < 0 || noOfInvoices < 0 || limitSize <= noOfInvoices) {
                    throw new LicenseException("UWAGA!!! Przekroczono miesieczny limit " + limitSize + " faktur. Skontaktuj sie z dostawca PlusWorkflow w celu wykupienia dodatkowej licencji.");
                }
                log.info((Object)("Do wyczerpania licencji pozostalo " + (limitSize - noOfInvoices) + " faktur"));
                clientLog.info((Object)("Do wyczerpania licencji pozostalo " + (limitSize - noOfInvoices) + " faktur"));
            } else {
                log.info((Object)"Korzystasz z wersji nielimitowanej modulu Plus E-faktura");
                clientLog.info((Object)"Korzystasz z wersji nielimitowanej modulu Plus E-faktura");
            }
            SubnodeConfiguration mailboxesParamsSection = configFile.getSection("MailboxesParams");
            String sEmails = mailboxesParamsSection.getString("Emails");
            String sEmailsLogins = mailboxesParamsSection.getString("EmailsLogins");
            String sEmailsPasswords = mailboxesParamsSection.getString("EmailsPasswords");
            String sIncomingEmailsPorts = mailboxesParamsSection.getString("IncomingEmailsPorts");
            String sOutgoingEmailsPorts = mailboxesParamsSection.getString("OutgoingEmailsPorts");
            String sEmailsServers = mailboxesParamsSection.getString("EmailsServers");
            String sAuths = mailboxesParamsSection.getString("Authentications");
            String sSSLs = mailboxesParamsSection.getString("SSLs");
            String sStartTLSs = mailboxesParamsSection.getString("StartTLSs");
            String sNTLMs = mailboxesParamsSection.getString("NTLMs");
            String sRecentModes = mailboxesParamsSection.getString("RecentModes");
            String sImapsPartialFetch = mailboxesParamsSection.getString("IMAPsPartialFetch");
            String sImapsFetchSize = mailboxesParamsSection.getString("IMAPsFetchSize");
            String sSharedAccounts = mailboxesParamsSection.getString("SharedAccounts");
            String sMailboxesFolders = mailboxesParamsSection.getString("MailboxesFolders");
            String sProtocols = mailboxesParamsSection.getString("Protocols");
            String incomingEmailsServers = mailboxesParamsSection.getString("IncomingEmailsServers");
            String outgoingEmailsServers = mailboxesParamsSection.getString("OutgoingEmailsServers");
            String sOAuths = mailboxesParamsSection.getString("OAuth");
            if (StringUtils.isBlank((CharSequence)sEmails)) {
                throw new PlusEFakturaException("Brak okreslonego pola Emails w pliku konfiguracyjnym modulu Plus E-faktura");
            }
            if (StringUtils.isBlank((CharSequence)sEmailsLogins)) {
                throw new PlusEFakturaException("Brak okreslonego pola EmailsLogins w pliku konfiguracyjnym modulu Plus E-faktura");
            }
            if (StringUtils.isBlank((CharSequence)sEmailsPasswords)) {
                throw new PlusEFakturaException("Brak okreslonego pola EmailsPasswords w pliku konfiguracyjnym modulu Plus E-faktura");
            }
            if (StringUtils.isBlank((CharSequence)sIncomingEmailsPorts)) {
                throw new PlusEFakturaException("Brak okreslonego pola IncomingEmailsPorts w pliku konfiguracyjnym modulu Plus E-faktura");
            }
            if (StringUtils.isBlank((CharSequence)sOutgoingEmailsPorts)) {
                throw new PlusEFakturaException("Brak okreslonego pola OutgoingEmailsPorts w pliku konfiguracyjnym modulu Plus E-faktura");
            }
            if (StringUtils.isBlank((CharSequence)sEmailsServers) && StringUtils.isBlank((CharSequence)incomingEmailsServers)) {
                throw new PlusEFakturaException("Brak okreslonego pola EmailsServers lub IncomingEmailsServers w pliku konfiguracyjnym modulu Plus E-faktura");
            }
            if (StringUtils.isBlank((CharSequence)sEmailsServers) && StringUtils.isBlank((CharSequence)outgoingEmailsServers)) {
                throw new PlusEFakturaException("Brak okreslonego pola EmailsServers lub OutgoingEmailsServers w pliku konfiguracyjnym modulu Plus E-faktura");
            }
            if (StringUtils.isBlank((CharSequence)sAuths)) {
                throw new PlusEFakturaException("Brak okreslonego pola Authorizations w sekcji MailboxesParams w pliku konfiguracyjnym modulu Plus E-faktura");
            }
            if (StringUtils.isBlank((CharSequence)sSSLs)) {
                throw new PlusEFakturaException("Brak okreslonego pola SSLs w sekcji MailboxesParams w pliku konfiguracyjnym modulu Plus E-faktura");
            }
            String[] sEmailsTab = sEmails.split(";");
            String[] sEmailsLoginsTab = sEmailsLogins.split(";");
            String[] sEmailsPasswordsTab = sEmailsPasswords.split(";");
            String[] sIncomingEmailsPortsTab = sIncomingEmailsPorts.split(";");
            String[] sOutgoingEmailsPortsTab = sOutgoingEmailsPorts.split(";");
            String[] sAuthsTab = sAuths.split(";");
            String[] sSSLsTab = sSSLs.split(";");
            String[] sStartTLSsTab = null;
            String[] sNTLMsTab = null;
            String[] sRecentModesTab = null;
            String[] sImapsPartialFetchTab = null;
            String[] sImapsFetchSizeTab = null;
            String[] sSharedAccountsTab = null;
            String[] sMailboxesFoldersTab = null;
            String[] sProtocolsTab = null;
            String[] sOAuthTab = null;
            String[] incomingEmailsServersTab = null;
            String[] outgoingEmailsServersTab = null;
            incomingEmailsServersTab = StringUtils.isNotBlank((CharSequence)incomingEmailsServers) ? incomingEmailsServers.split(";") : sEmailsServers.split(";");
            outgoingEmailsServersTab = StringUtils.isNotBlank((CharSequence)outgoingEmailsServers) ? outgoingEmailsServers.split(";") : sEmailsServers.split(";");
            if (StringUtils.isNotBlank((CharSequence)sStartTLSs)) {
                sStartTLSsTab = sStartTLSs.split(";");
            }
            if (StringUtils.isNotBlank((CharSequence)sNTLMs)) {
                sNTLMsTab = sNTLMs.split(";");
            }
            if (StringUtils.isNotBlank((CharSequence)sRecentModes)) {
                sRecentModesTab = sRecentModes.split(";");
            }
            if (StringUtils.isNotBlank((CharSequence)sImapsPartialFetch)) {
                sImapsPartialFetchTab = sImapsPartialFetch.split(";");
            }
            if (StringUtils.isNotBlank((CharSequence)sImapsFetchSize)) {
                sImapsFetchSizeTab = sImapsFetchSize.split(";");
            }
            if (StringUtils.isNotBlank((CharSequence)sSharedAccounts)) {
                sSharedAccountsTab = sSharedAccounts.split(";");
            }
            if (StringUtils.isNotBlank((CharSequence)sMailboxesFolders)) {
                sMailboxesFoldersTab = sMailboxesFolders.split(";");
            }
            if (StringUtils.isNotBlank((CharSequence)sProtocols)) {
                sProtocolsTab = sProtocols.split(";");
            }
            if (StringUtils.isNotBlank((CharSequence)sOAuths)) {
                sOAuthTab = sOAuths.split(";");
            }
            if (sEmailsTab.length != sEmailsLoginsTab.length || sEmailsTab.length != sEmailsPasswordsTab.length || sEmailsTab.length != sIncomingEmailsPortsTab.length || sEmailsTab.length != sOutgoingEmailsPortsTab.length || sEmailsTab.length != incomingEmailsServersTab.length || sEmailsTab.length != outgoingEmailsServersTab.length || sEmailsTab.length != sAuthsTab.length || sEmailsTab.length != sSSLsTab.length || sStartTLSsTab != null && sEmailsTab.length != sStartTLSsTab.length || sNTLMsTab != null && sEmailsTab.length != sNTLMsTab.length || sRecentModesTab != null && sEmailsTab.length != sRecentModesTab.length || sImapsPartialFetchTab != null && sEmailsTab.length != sImapsPartialFetchTab.length || sImapsFetchSizeTab != null && sEmailsTab.length != sImapsFetchSizeTab.length || sSharedAccountsTab != null && sEmailsTab.length != sSharedAccountsTab.length || sMailboxesFoldersTab != null && sEmailsTab.length != sMailboxesFoldersTab.length || sProtocolsTab != null && sEmailsTab.length != sProtocolsTab.length || sOAuthTab != null && sEmailsTab.length != sOAuthTab.length) {
                throw new PlusEFakturaException("Niezgodnosc ilosci parametrow rozdzielonych srednikiem w sekcji MailboxesParams w pliku konfiguracyjnym modulu Plus E-faktura");
            }
            String encodePasswords = configFile.getSection("PlusEFakturaConfiguration").getString("EncodePasswords");
            for (i = 0; i < sEmailsPasswordsTab.length; ++i) {
                String password2 = sEmailsPasswordsTab[i];
                if (!StringUtils.startsWith((CharSequence)password2, (CharSequence)PASSWORD_ENCRYPTING_PREFIX)) continue;
                sEmailsPasswordsTab[i] = PasswordManager.decrypt(StringUtils.substringAfter((String)password2, (String)PASSWORD_ENCRYPTING_PREFIX));
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)encodePasswords, (CharSequence)"TRUE")) {
                PasswordEncryptionInfo passwordEncryptionInfo = new PasswordEncryptionInfo();
                String encryptedPasswords = Stream.of(sEmailsPasswords.split(";")).filter(password -> !StringUtils.startsWith((CharSequence)password, (CharSequence)PASSWORD_ENCRYPTING_PREFIX)).map(password -> {
                    try {
                        passwordEncryptionInfo.anyEncrypted();
                        return PASSWORD_ENCRYPTING_PREFIX + PasswordManager.encrypt(password);
                    }
                    catch (Exception exception) {
                        throw new UnsupportedOperationException(exception);
                    }
                }).collect(Collectors.joining(";"));
                if (passwordEncryptionInfo.isAnyEncrypted()) {
                    FileInputStream tmpFileInputStream;
                    File tmpFile;
                    FileWriter writer;
                    block86: {
                        configFile.getSection("MailboxesParams").setProperty("EmailsPasswords", (Object)encryptedPasswords);
                        writer = null;
                        tmpFile = null;
                        tmpFileInputStream = null;
                        try {
                            if (RunModuleScheduledTask.isFilePath(configFilePath)) {
                                writer = new FileWriter(configFilePath);
                                configFile.write((Writer)writer);
                                break block86;
                            }
                            tmpFile = File.createTempFile("tmp", ".conf");
                            writer = new FileWriter(tmpFile);
                            configFile.write((Writer)writer);
                            tmpFileInputStream = new FileInputStream(tmpFile);
                            this.configurationFileService.saveFile(this.plugin.getKey(), configFilePath, (InputStream)tmpFileInputStream);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(writer);
                            IOUtils.closeQuietly(tmpFileInputStream);
                            if (tmpFile != null && tmpFile.exists()) {
                                tmpFile.delete();
                            }
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly((Writer)writer);
                    IOUtils.closeQuietly(tmpFileInputStream);
                    if (tmpFile != null && tmpFile.exists()) {
                        tmpFile.delete();
                    }
                }
            }
            try {
                for (i = 0; i < sEmailsTab.length; ++i) {
                    String sStartTLS = "";
                    String sNTLM = "";
                    String sRecentMode = "";
                    String sImapPartialFetch = "";
                    int iImapFetchSize = 0;
                    String sSharedAccount = "";
                    String sMailboxFolder = "";
                    String sProtocol = "";
                    String sOAuth = "";
                    if (sStartTLSsTab != null) {
                        sStartTLS = sStartTLSsTab[i].toLowerCase();
                    } else {
                        log.warn((Object)("Nie okreslono uzycia szyfrowania TLS. Wykorzystanie ustawienia domyslnego dla skrzynki " + sEmailsTab[i]));
                        sStartTLS = "true";
                    }
                    if (sNTLMsTab != null) {
                        sNTLM = sNTLMsTab[i];
                    } else {
                        log.warn((Object)("Nie okreslono uzycia protokolu NTLM. Wykorzystanie ustawienia domyslnego dla skrzynki " + sEmailsTab[i]));
                        sNTLM = "false";
                    }
                    if (sRecentModesTab != null) {
                        sRecentMode = sRecentModesTab[i];
                    } else {
                        log.warn((Object)("Nie okreslono uzycia recent mode. Wykorzystanie ustawienia domyslnego dla skrzynki " + sEmailsTab[i]));
                        sRecentMode = "false";
                    }
                    if (sImapsPartialFetchTab != null) {
                        sImapPartialFetch = sImapsPartialFetchTab[i];
                    } else {
                        log.warn((Object)("Nie okreslono uzycia partial fetch dla protokolu IMAP. Wykorzystanie ustawienia domyslnego dla skrzynki " + sEmailsTab[i]));
                        sImapPartialFetch = "true";
                    }
                    if (sImapsFetchSizeTab != null) {
                        try {
                            iImapFetchSize = Integer.parseInt(sImapsFetchSizeTab[i]);
                        }
                        catch (NumberFormatException e) {
                            throw new PlusEFakturaException("Niepoprawny format liczby w pliku konfiguracyjnym modulu Plus E-faktura, sekcja MailboxesParams, pole IMAPsFetchSize");
                        }
                    } else {
                        log.warn((Object)("Nie okreslono uzycia fetch size dla protokolu IMAP. Wykorzystanie ustawienia domyslnego dla skrzynki " + sEmailsTab[i]));
                        iImapFetchSize = 16384;
                    }
                    if (sSharedAccountsTab != null) {
                        sSharedAccount = sSharedAccountsTab[i];
                    } else {
                        log.warn((Object)("Nie okreslono uzycia kont udostepnionych. Wykorzystanie ustawienia domyslnego dla skrzynki " + sEmailsTab[i]));
                        sSharedAccount = "false";
                    }
                    if (sMailboxesFoldersTab != null) {
                        sMailboxFolder = sMailboxesFoldersTab[i];
                    } else {
                        log.warn((Object)("Nie okreslono nazwy folderu z odebranymi wiadomosciami. Wykorzystanie ustawienia domyslnego dla skrzynki " + sEmailsTab[i]));
                        sMailboxFolder = "INBOX";
                    }
                    if (sProtocolsTab != null) {
                        sProtocol = sProtocolsTab[i];
                        if (!(sProtocol = sProtocol.toLowerCase()).contains("pop3") && !sProtocol.contains("imap")) {
                            log.warn((Object)("Niepoprawnie okreslony protokol dla skrzynki " + sEmailsTab[i] + " w polu Protocols w sekcji MailboxesParams w pliku konfiguracyjnym modulu Plus E-faktura"));
                            continue;
                        }
                    } else {
                        log.warn((Object)("Nie okreslono protokolu odbioru poczty. Wykorzystanie domyslnego protokolu POP3 dla skrzynki " + sEmailsTab[i]));
                        sProtocol = "pop3";
                    }
                    int iIncomingPort = -1;
                    try {
                        iIncomingPort = Integer.parseInt(sIncomingEmailsPortsTab[i]);
                    }
                    catch (NumberFormatException e) {
                        throw new PlusEFakturaException("Niepoprawny format liczby w pliku konfiguracyjnym modulu Plus E-faktura, sekcja MailboxesParams, pole IncomingEmailsPorts");
                    }
                    if (sOAuthTab != null) {
                        sOAuth = sOAuthTab[i].toLowerCase();
                    } else {
                        log.warn((Object)("Nie okreslono uzycia OAuth2. Wykorzystanie ustawienia domyslnego dla skrzynki " + sEmailsTab[i]));
                        sOAuth = "false";
                    }
                    Mailbox mailbox = new Mailbox();
                    mailbox.checkMailbox(configFile, sEmailsTab[i], sEmailsLoginsTab[i], sEmailsPasswordsTab[i], iIncomingPort, sOutgoingEmailsPortsTab[i], incomingEmailsServersTab[i], outgoingEmailsServersTab[i], sAuthsTab[i], sProtocol, sSSLsTab[i], sStartTLS, sNTLM, sRecentMode, sImapPartialFetch, iImapFetchSize, sSharedAccount, sMailboxFolder, license, limitSize, sOAuth);
                }
            }
            catch (LicenseException exception) {
                log.warn((Object)exception.getMessage());
                clientLog.warn((Object)exception.getMessage());
            }
        }
        catch (LicenseException exception) {
            log.warn((Object)exception.getMessage());
            clientLog.warn((Object)exception.getMessage());
        }
        catch (PlusEFakturaException exception) {
            log.warn((Object)exception.getMessage());
            clientLog.warn((Object)exception.getMessage());
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    private class PasswordEncryptionInfo {
        private boolean anyEncrypted;

        private PasswordEncryptionInfo() {
        }

        public void anyEncrypted() {
            this.anyEncrypted = true;
        }

        public boolean isAnyEncrypted() {
            return this.anyEncrypted;
        }
    }
}

