/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.scheduledtask;

import com.suncode.plugin.efaktura.model.template.Template;
import com.suncode.plugin.efaktura.service.template.TemplateService;
import com.suncode.plugin.efaktura.service.xml.XmlAnalyzerService;
import com.suncode.plugin.efaktura.util.PlusEFakturaTools;
import com.suncode.plugin.efaktura.util.exception.PlusEFakturaException;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.util.ServiceFactory;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@ScheduledTask
public class LogTemplateVersionScheduledTask {
    public static Logger log = Logger.getLogger(LogTemplateVersionScheduledTask.class);
    public static Logger clientLog = Logger.getLogger((String)"PlusEFakturaClientLog");
    @Autowired
    private TemplateService templateService;
    @Autowired
    private XmlAnalyzerService xmlAnalyzerService;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("efaktura-log-template-version-scheduled-task")).name("efaktura.scheduled-task.log-template-version.name")).description("efaktura.scheduled-task.log-template-version.description")).create();
    }

    public void execute(Logger logger) {
        log.info((Object)"**************** logTemplateVersionToAllTemplates *****************");
        long startTime = new Date().getTime();
        try {
            this.templateService.getAll().forEach(template -> this.logTemplateVersion((Template)template, logger));
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
        }
        long stopTime = new Date().getTime();
        log.info((Object)("Czas wykonania zadania logowania wersji szablonow: " + PlusEFakturaTools.formatDuration(stopTime - startTime)));
    }

    private void logTemplateVersion(Template template, Logger logger) {
        try {
            long fileId = template.getTemplateDefinition().getFileId();
            if (fileId == -1L) {
                return;
            }
            FileService fileService = ServiceFactory.getFileService();
            WfFile wfFile = fileService.getFile(Long.valueOf(fileId), new String[0]);
            if (wfFile == null || StringUtils.isBlank((CharSequence)wfFile.getFullPath())) {
                throw new PlusEFakturaException("Brak sciezki do szablonu o identyfikatorze " + template.getId());
            }
            String templatePath = wfFile.getFullPath();
            String xmlFileContent = this.xmlAnalyzerService.convertXMLFileToStringFromFilePath(templatePath);
            Document xmlTemplate = this.xmlAnalyzerService.convertStringToXMLFile(xmlFileContent);
            if (xmlTemplate == null) {
                throw new PlusEFakturaException("Nie udalo sie pobrac szablonu XML faktur o identyfikatorze " + template.getId());
            }
            xmlTemplate.getDocumentElement().normalize();
            Element root = xmlTemplate.getDocumentElement();
            String rootName = root.getNodeName();
            if (!rootName.equals("PlusEFakturaTemplate")) {
                throw new PlusEFakturaException("Szablon o identyfikatorze " + template.getId() + " nie jest szablonem modulu Plus E-faktura");
            }
            String version = root.getAttribute("version");
            logger.info((Object)("Wersja szablonu o identyfikatorze " + template.getId() + " w lokalizacji " + templatePath + ": " + version));
            log.info((Object)("Wersja szablonu o identyfikatorze " + template.getId() + " w lokalizacji " + templatePath + ": " + version));
        }
        catch (PlusEFakturaException exception) {
            logger.error((Object)exception.getMessage());
            log.error((Object)exception.getMessage());
        }
    }
}

