/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.editopdf;

import com.suncode.plugin.efaktura.editopdf.ValueFunction;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ValueFunctionBuilder {
    private static final String PARAMETERS_PREFIX = "(";
    private static final String PARAMETERS_POSTFIX = ")";
    private static final String PARAMETERS_SEPARATOR_ESCAPE = "\\,";
    private static final String PARAMETERS_SEPARATOR_REPLACEMENT = "@PARAMETERS_SEPARATOR_REPLACEMENT@";
    private static final String PARAMETERS_SEPARATOR = ",";

    public ValueFunction build(String functionDefinition) {
        ValueFunction function = new ValueFunction();
        function.setName(this.buildName(functionDefinition));
        function.setParameters(this.buildParameters(functionDefinition));
        return function;
    }

    private String buildName(String functionDefinition) {
        return StringUtils.substringBefore((String)functionDefinition, (String)PARAMETERS_PREFIX);
    }

    private List<String> buildParameters(String functionDefinition) {
        ArrayList<String> parameters = new ArrayList<String>();
        String parametersDefinition = this.buildParametersDefinition(functionDefinition);
        if (StringUtils.isNotEmpty((CharSequence)parametersDefinition)) {
            String[] splitted;
            for (String parameterDefinition : splitted = parametersDefinition.split(PARAMETERS_SEPARATOR, -1)) {
                parameters.add(this.buildParameter(parameterDefinition));
            }
        }
        return parameters;
    }

    private String buildParametersDefinition(String functionDefinition) {
        String part = StringUtils.substringAfter((String)functionDefinition, (String)PARAMETERS_PREFIX);
        part = StringUtils.substringBeforeLast((String)part, (String)PARAMETERS_POSTFIX);
        return StringUtils.replace((String)part, (String)PARAMETERS_SEPARATOR_ESCAPE, (String)PARAMETERS_SEPARATOR_REPLACEMENT);
    }

    private String buildParameter(String parameterDefinition) {
        return StringUtils.replace((String)parameterDefinition, (String)PARAMETERS_SEPARATOR_REPLACEMENT, (String)PARAMETERS_SEPARATOR);
    }
}

