/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.editopdf;

import com.suncode.plugin.efaktura.editopdf.EdiToSegmentsParser;
import com.suncode.plugin.efaktura.editopdf.Record;
import com.suncode.plugin.efaktura.editopdf.SectionName;
import com.suncode.plugin.efaktura.editopdf.Segments;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Component;

@Component(value="unEdifactD96AEdiToSegmentsParser")
public class UnEdifactD96AEdiToSegmentsParserImpl
implements EdiToSegmentsParser {
    public static Logger log = Logger.getLogger(UnEdifactD96AEdiToSegmentsParserImpl.class);
    private static final String RELEASE_CHARACTER = "?";
    private static final String SEGMENT_TERMINATOR = "'";
    private static final String SEGMENT_TAG = "+";
    private static final String COMPONENT_SEPARATOR = ":";
    private static final String SEGMENT_TERMINATOR_SUBSTITUTION = "@SEGMENT_TERMINATOR@";
    private static final String SEGMENT_TAG_SUBSTITUTION = "@SEGMENT_TAG@";
    private static final String COMPONENT_SEPARATOR_SUBSTITUTION = "@COMPONENT_SEPARATOR@";
    private static final int FIRST_ELEMENT = 0;
    private static final String LIN_LABEL = "LIN";
    private static final String HEADER_DETAILS_SECTION_SEPARATOR = "D";
    private static final String UNS_LABEL = "UNS";
    private static final String DETAILS_SUMMARY_SECTION_SEPARATOR = "S";
    private static final int SECOND_ELEMENT = 1;

    @Override
    public Segments parse(byte[] fileBytes) {
        Segments segments = new Segments();
        SectionName sectionName = SectionName.HEADER;
        List<String> lines = this.readLines(fileBytes);
        if (CollectionUtils.isNotEmpty(lines)) {
            for (String line : lines) {
                List<String> values = this.readValues(line);
                String label = this.getLabel(values);
                sectionName = this.getSectionName(label, values, sectionName);
                Record record = this.buildRecord(values);
                segments.addRecord(sectionName, label, record);
            }
        }
        return segments;
    }

    private List<String> readLines(byte[] fileBytes) {
        String string = IOUtils.toString((byte[])fileBytes, (String)"UTF-8");
        string = StringUtils.remove((String)string, (String)"\r");
        string = StringUtils.remove((String)string, (String)"\n");
        string = StringUtils.replace((String)string, (String)this.buildRelaseSeparatorPart(SEGMENT_TERMINATOR), (String)SEGMENT_TERMINATOR_SUBSTITUTION);
        string = StringUtils.replace((String)string, (String)this.buildRelaseSeparatorPart(SEGMENT_TAG), (String)SEGMENT_TAG_SUBSTITUTION);
        string = StringUtils.replace((String)string, (String)this.buildRelaseSeparatorPart(COMPONENT_SEPARATOR), (String)COMPONENT_SEPARATOR_SUBSTITUTION);
        return this.readFragments(string, SEGMENT_TERMINATOR);
    }

    private String buildRelaseSeparatorPart(String separator) {
        StringBuilder part = new StringBuilder();
        part.append(RELEASE_CHARACTER);
        part.append(separator);
        return part.toString();
    }

    private List<String> readFragments(String text, String separator) {
        String regex = this.buildFragmentRegex(separator);
        String[] fragments = text.split(regex, -1);
        return Arrays.asList(fragments);
    }

    private String buildFragmentRegex(String separator) {
        StringBuilder regex = new StringBuilder();
        regex.append("[");
        regex.append(separator);
        regex.append("]");
        return regex.toString();
    }

    private List<String> readValues(String line) {
        ArrayList<String> values = new ArrayList<String>();
        List<String> segments = this.readFragments(line, SEGMENT_TAG);
        if (CollectionUtils.isNotEmpty(segments)) {
            for (String segment : segments) {
                List<String> components = this.readFragments(segment, COMPONENT_SEPARATOR);
                if (!CollectionUtils.isNotEmpty(components)) continue;
                for (String component : components) {
                    values.add(this.formatComponent(component));
                }
            }
        }
        return values;
    }

    private String formatComponent(String component) {
        component = StringUtils.replace((String)component, (String)SEGMENT_TERMINATOR_SUBSTITUTION, (String)SEGMENT_TERMINATOR);
        component = StringUtils.replace((String)component, (String)SEGMENT_TAG_SUBSTITUTION, (String)SEGMENT_TAG);
        component = StringUtils.replace((String)component, (String)COMPONENT_SEPARATOR_SUBSTITUTION, (String)COMPONENT_SEPARATOR);
        return StringUtils.trim((String)component);
    }

    private String getLabel(List<String> values) {
        if (CollectionUtils.isNotEmpty(values)) {
            return values.get(FIRST_ELEMENT);
        }
        return "";
    }

    private SectionName getSectionName(String label, List<String> values, SectionName previousSectionName) {
        if (this.isDetailsSectionStart(label, values)) {
            return SectionName.DETAILS;
        }
        if (this.isSummarySectionStart(label, values)) {
            return SectionName.SUMMARY;
        }
        return previousSectionName;
    }

    private boolean isDetailsSectionStart(String label, List<String> values) {
        return this.isUNSSectionWithValue(label, values, HEADER_DETAILS_SECTION_SEPARATOR) || StringUtils.equals((CharSequence)label, (CharSequence)LIN_LABEL);
    }

    private boolean isSummarySectionStart(String label, List<String> values) {
        return this.isUNSSectionWithValue(label, values, DETAILS_SUMMARY_SECTION_SEPARATOR);
    }

    private boolean isUNSSectionWithValue(String label, List<String> values, String value) {
        return StringUtils.equals((CharSequence)label, (CharSequence)UNS_LABEL) && CollectionUtils.size(values) >= 2 && StringUtils.equals((CharSequence)values.get(SECOND_ELEMENT), (CharSequence)value);
    }

    private Record buildRecord(List<String> values) {
        Record record = new Record();
        if (CollectionUtils.isNotEmpty(values)) {
            for (int i = 1; i < CollectionUtils.size(values); ++i) {
                String value = values.get(i);
                record.addValue(value);
            }
        }
        return record;
    }
}

