/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.docxtopdf;

import com.suncode.plugin.efaktura.docxtopdf.DocxToPdfConverter;
import com.suncode.plugin.efaktura.docxtopdf.OfficeManagerHolder;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.artofsolving.jodconverter.OfficeDocumentConverter;
import org.artofsolving.jodconverter.office.OfficeManager;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.springframework.stereotype.Component;

@Component(value="officeDocxToPdfConverter")
public class OfficeDocxToPdfConverterImpl
implements DocxToPdfConverter {
    public static Logger log = Logger.getLogger(OfficeDocxToPdfConverterImpl.class);
    private static final String TEMP_FILE_PREFIX = "temp";
    private static final String INPUT_TEMP_FILE_POSTFIX = ".docx";
    private static final String OUTPUT_TEMP_FILE_POSTFIX = ".pdf";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] convert(WordprocessingMLPackage docx) {
        OfficeManager officeManager = OfficeManagerHolder.getInstance().getOfficeManager();
        if (officeManager == null) {
            return null;
        }
        if (!officeManager.isRunning()) {
            officeManager.start();
        }
        File inputTempFile = null;
        File outputTempFile = null;
        try {
            inputTempFile = this.createInputTempFile(docx);
            outputTempFile = this.createOutputTempFile();
            OfficeDocumentConverter converter = new OfficeDocumentConverter(officeManager);
            converter.convert(inputTempFile, outputTempFile);
            byte[] byArray = FileUtils.readFileToByteArray((File)outputTempFile);
            return byArray;
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            this.deleteTempFile(inputTempFile);
            this.deleteTempFile(outputTempFile);
            if (officeManager.isRunning()) {
                officeManager.stop();
            }
        }
    }

    private File createInputTempFile(WordprocessingMLPackage docx) throws IOException, Docx4JException {
        File file = this.createTempFile(INPUT_TEMP_FILE_POSTFIX);
        docx.save(file);
        return file;
    }

    private File createOutputTempFile() throws IOException {
        return this.createTempFile(OUTPUT_TEMP_FILE_POSTFIX);
    }

    private File createTempFile(String postfix) throws IOException {
        return File.createTempFile(TEMP_FILE_PREFIX, postfix);
    }

    private void deleteTempFile(File tempFile) {
        FileUtils.deleteQuietly((File)tempFile);
    }
}

