/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.docxtopdf;

import com.suncode.plugin.efaktura.docxtopdf.DocxToPdfConverter;
import com.suncode.plugin.efaktura.util.ClassLoaderUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.docx4j.Docx4J;
import org.docx4j.convert.out.FOSettings;
import org.docx4j.fonts.BestMatchingMapper;
import org.docx4j.fonts.Mapper;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.RFonts;
import org.docx4j.wml.RPr;
import org.docx4j.wml.Style;
import org.docx4j.wml.Styles;
import org.springframework.stereotype.Component;

@Component(value="docx4jDocxToPdfConverter")
public class Docx4jDocxToPdfConverterImpl
implements DocxToPdfConverter {
    public static Logger log = Logger.getLogger(Docx4jDocxToPdfConverterImpl.class);
    private static final ObjectFactory OBJECT_FACTORY = Context.getWmlObjectFactory();
    private static final String DEFAULT_FONT = "Tahoma";

    @Override
    public byte[] convert(WordprocessingMLPackage template) {
        byte[] byArray;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            this.setDefaultFont(template);
            BestMatchingMapper fontMapper = new BestMatchingMapper();
            template.setFontMapper((Mapper)fontMapper);
            FOSettings settings = this.buildConversionSettings(template);
            ClassLoaderUtils.doInContextClassLoader(() -> Docx4J.toFO((FOSettings)settings, (OutputStream)outputStream, (int)1));
            byArray = outputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
                return null;
            }
        }
        outputStream.close();
        return byArray;
    }

    private void setDefaultFont(WordprocessingMLPackage template) throws Docx4JException {
        MainDocumentPart mainDocumentPart = template.getMainDocumentPart();
        Styles styles = (Styles)mainDocumentPart.getStyleDefinitionsPart().getContents();
        for (Style style : styles.getStyle()) {
            RFonts fonts;
            RPr properties = style.getRPr();
            if (properties == null) {
                properties = OBJECT_FACTORY.createRPr();
                style.setRPr(properties);
            }
            if ((fonts = properties.getRFonts()) == null) {
                fonts = OBJECT_FACTORY.createRFonts();
                properties.setRFonts(fonts);
            }
            fonts.setAscii(DEFAULT_FONT);
            fonts.setHAnsi(DEFAULT_FONT);
            fonts.setCs(DEFAULT_FONT);
        }
    }

    private FOSettings buildConversionSettings(WordprocessingMLPackage template) {
        FOSettings settings = Docx4J.createFOSettings();
        settings.setWmlPackage((OpcPackage)template);
        return settings;
    }
}

