/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.dao.attachment;

import com.plusmpm.database.hibernate.HibernateUtil;
import com.suncode.plugin.efaktura.dao.EfakturaHibernateEditableDao;
import com.suncode.plugin.efaktura.dao.attachment.AttachmentDao;
import com.suncode.plugin.efaktura.model.attachment.Attachment;
import com.suncode.plugin.efaktura.model.attachment.OldAttachment;
import com.suncode.plugin.efaktura.util.AttachmentDetectionType;
import com.suncode.pwfl.search.SortDirection;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.jdbc.ReturningWork;
import org.springframework.stereotype.Repository;

@Repository
public class AttachmentDaoImpl
extends EfakturaHibernateEditableDao<Attachment, Long>
implements AttachmentDao {
    private static final String OLD_ATTACHMENT_TABLE_NAME = "pm_plusefaktura_atts";
    private static final String FIND_ALL_OLD_ATTACHMENTS_QUERY = "select fromemail, detectiontype, detectionvalue, actiontype, actionvalue from pm_plusefaktura_atts";

    @Override
    public List<Attachment> findAll(Integer start, Integer limit, String sortBy, SortDirection sortDirection) {
        DetachedCriteria criteria = DetachedCriteria.forClass(Attachment.class);
        criteria.addOrder(sortDirection == SortDirection.ASC ? Order.asc((String)sortBy) : Order.desc((String)sortBy));
        return this.findByCriteria(criteria, start, limit);
    }

    @Override
    public List<Attachment> findAllByFromEmail(String fromEmail) {
        DetachedCriteria criteria = DetachedCriteria.forClass(Attachment.class);
        criteria.add((Criterion)Restrictions.eq((String)"emailFrom", (Object)fromEmail));
        return this.findByCriteria(criteria);
    }

    @Override
    public Optional<Attachment> findByParameters(String fromEmail, String detectionType, String detectionValue) {
        DetachedCriteria criteria = DetachedCriteria.forClass(Attachment.class);
        criteria.add((Criterion)Restrictions.eq((String)"emailFrom", (Object)fromEmail));
        criteria.add((Criterion)Restrictions.eq((String)"detectionType", (Object)((Object)AttachmentDetectionType.getByName(detectionType))));
        criteria.add((Criterion)Restrictions.eq((String)"detectionValue", (Object)detectionValue));
        return Optional.ofNullable((Attachment)this.findOne(criteria));
    }

    @Override
    public List<OldAttachment> findAllOldAttachments() {
        if (this.doesOldTableExist()) {
            return (List)this.getSession().doReturningWork((ReturningWork)new ReturningWork<List<OldAttachment>>(){

                public List<OldAttachment> execute(Connection connection) throws SQLException {
                    PreparedStatement statement = connection.prepareStatement(AttachmentDaoImpl.FIND_ALL_OLD_ATTACHMENTS_QUERY);
                    ResultSet resultSet = statement.executeQuery();
                    ArrayList<OldAttachment> oldAttachments = new ArrayList<OldAttachment>();
                    while (resultSet.next()) {
                        oldAttachments.add(AttachmentDaoImpl.this.buildOldAttachment(resultSet));
                    }
                    return oldAttachments;
                }
            });
        }
        return new ArrayList<OldAttachment>();
    }

    private boolean doesOldTableExist() {
        return HibernateUtil.tableExists((String)OLD_ATTACHMENT_TABLE_NAME);
    }

    private OldAttachment buildOldAttachment(ResultSet resultSet) throws SQLException {
        OldAttachment oldAttachment = new OldAttachment();
        oldAttachment.setFromEmail(resultSet.getString(1));
        oldAttachment.setDetectionType(resultSet.getString(2));
        oldAttachment.setDetectionValue(resultSet.getString(3));
        oldAttachment.setActionType(resultSet.getString(4));
        oldAttachment.setActionValue(resultSet.getString(5));
        return oldAttachment;
    }
}

