/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.model.template;

import com.suncode.plugin.efaktura.model.template.EmailFrom;
import com.suncode.plugin.efaktura.model.template.OldTemplate;
import com.suncode.plugin.efaktura.model.template.TemplateDefinition;
import com.suncode.plugin.efaktura.util.TemplatePhraseLocation;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

@Entity
@Table(name="pm_efaktura_template", uniqueConstraints={@UniqueConstraint(columnNames={"name"})})
@SequenceGenerator(name="efaktura_template", sequenceName="pm_efaktura_template_id")
public class Template
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="efaktura_template")
    private Long id;
    @OneToMany(mappedBy="template", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<EmailFrom> emailsFrom = new ArrayList<EmailFrom>();
    @Column(name="email_to")
    private String emailTo;
    @Embedded
    private TemplateDefinition templateDefinition;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<EmailFrom> getEmailsFrom() {
        return this.emailsFrom;
    }

    public void setEmailsFrom(List<EmailFrom> emailsFrom) {
        if (CollectionUtils.isNotEmpty(emailsFrom)) {
            emailsFrom.forEach(this::addEmailFrom);
        }
    }

    public String getEmailTo() {
        return this.emailTo;
    }

    public void setEmailTo(String emailTo) {
        this.emailTo = emailTo;
    }

    public TemplateDefinition getTemplateDefinition() {
        return this.templateDefinition;
    }

    public void setTemplateDefinition(TemplateDefinition templateDefinition) {
        this.templateDefinition = templateDefinition;
    }

    public void addEmailFrom(EmailFrom emailFrom) {
        this.getEmailsFrom().add(emailFrom);
        emailFrom.setTemplate(this);
    }

    public static Template fromOldTemplate(OldTemplate oldTemplate) {
        TemplateDefinition templateDefinition = new TemplateDefinition();
        templateDefinition.setName("template_" + System.nanoTime());
        templateDefinition.setPhrase(oldTemplate.getPhrase());
        templateDefinition.setPhraseLocation(TemplatePhraseLocation.getByDescription(oldTemplate.getPhraseLocation()));
        templateDefinition.setPriority(oldTemplate.getPriority());
        templateDefinition.setFileId(oldTemplate.getFileId());
        Template template = new Template();
        template.setEmailTo(oldTemplate.getReceivingEmail());
        template.setTemplateDefinition(templateDefinition);
        template.addEmailFrom(new EmailFrom(oldTemplate.getEmail()));
        return template;
    }
}

