/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.util;

import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.pop3.POP3Folder;
import com.sun.mail.util.MimeUtil;
import com.sun.mail.util.PropUtil;
import com.suncode.plugin.efaktura.model.seenattachment.SeenAttachment;
import com.suncode.plugin.efaktura.util.AddAttachmentsToArchiveAction;
import com.suncode.plugin.efaktura.util.AddResult;
import com.suncode.plugin.efaktura.util.AdditionalOptions;
import com.suncode.plugin.efaktura.util.AttachmentPart;
import com.suncode.plugin.efaktura.util.InterfaceExecutor;
import com.suncode.plugin.efaktura.util.MsgStatus;
import com.suncode.plugin.efaktura.util.SubjectAsIndexesResolver;
import com.suncode.plugin.efaktura.util.TextDecoder;
import com.suncode.plugin.efaktura.util.exception.AttachmentServiceException;
import com.suncode.plugin.efaktura.util.exception.IndexesMappingException;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassIndex;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.database.sequence.SequenceUtils;
import com.suncode.pwfl.util.SpringContext;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.text.Normalizer;
import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Folder;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Store;
import javax.mail.URLName;
import javax.mail.internet.ContentDisposition;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParameterList;
import javax.mail.internet.ParseException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.poi.hmef.Attachment;
import org.apache.poi.hmef.HMEFMessage;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.parser.Parser;
import org.jsoup.safety.Safelist;

public class PlusEFakturaTools {
    public static Logger log = Logger.getLogger(PlusEFakturaTools.class);
    public static Logger clientLog = Logger.getLogger((String)"PlusEFakturaClientLog");
    private static final String BODYSTRUCTURE_EXCEPTION_MESSAGE = "Unable to load BODYSTRUCTURE";
    private static final String TABULATOR = "\t";
    private static final Integer EMAIL_CONTENT_MAX_LENGTH = 4000;
    private static final String CONTENT_TYPE_NAME_PART = "name=\"";
    private static final String CONTENT_TYPE_NAME_PART_SIMPLE = "name=";
    private static final String CONTENT_TYPE_FILENAME_PART = "file=";
    public static final String NO_EXTENSION = "NO_EXTENSION";
    public static final String ALL_EXTENSIONS = "*";
    public static final int MAX_INDEX_LENGTH = 4000;
    public static String[] MIMETypesTable = new String[]{"application/atom+xml", "application/json", "application/javascript", "application/octet-stream", "application/ogg", "application/pdf", "application/postscript", "application/soap+xml", "application/x-woff", "application/xhtml+xml", "application/xml-dtd", "application/xop+xml", "application/zip", "application/x-gzip", "audio/basic", "audio/mid", "audio/mpeg", "audio/x-aiff", "audio/x-mpegurl", "audio/x-pn-realaudio", "audio/x-wav", "image/bmp", "image/cis-cod", "image/gif", "image/ef", "image/jpeg", "image/pipeg", "image/pjpeg", "image/png", "image/svg+xml", "image/tiff", "image/x-cmu-raster", "image/x-cmx", "image/x-icon", "image/x-png", "image/x-portable-anymap", "image/x-portable-bitmap", "image/x-portable-graymap", "image/x-portable-pixmap", "image/x-rgb", "image/x-xbitmap", "image/x-xpixmap", "image/x-xwindowdump", "message/rfc822", "text/css", "text/h323", "text/html", "text/iuls", "text/plain", "text/richtext", "text/scriptlet", "text/tab-separated-values", "text/webviewhtml", "text/x-component", "text/x-setext", "text/x-vcard", "video/mpeg", "video/quicktime", "video/x-la-asf", "video/x-ms-asf", "video/x-msvideo", "video/x-sgi-movie", "x-world/x-vrml"};
    public static String[] ExtsTable = new String[]{"atom;xml", "json", "js", "pdf", "ogg", "pdf", "ps", "xml", "woff", "xhtml;xht;xml;html;htm", "dtd", "xml", "zip", "gz", "au;snd", "mid;rmi", "mp3", "aif;aifc;aiff", "m3u", "ra;ram", "wav", "bmp", "cod", "gif", "ief", "jpe;jpeg;jpg", "jfif", "jpeg", "png", "svg", "tif;tiff", "ras", "cmx", "ico", "png", "pnm", "pbm", "pgm", "ppm", "rgb", "xbm", "xpm", "xwd", "mht;mhtml;nws", "css", "323", "htm;html;stm", "uls", "bas;c;h;txt", "rtx", "sct", "tsv", "htt", "htc", "etx", "vcf", "mp2;mpa;mpe;mpeg;mpg;mpv2", "mov;qt", "lsf;lsx", "asf;asr;asx", "avi", "movie", "flr;vrml;wrl;wrz;xaf;xof"};

    public static List<AttachmentPart> getAttachmentParts(Multipart multipart) {
        ArrayList<AttachmentPart> attachmentParts = new ArrayList<AttachmentPart>();
        int multipartCounter = 0;
        try {
            while (true) {
                BodyPart partFromMultipart;
                List<Part> partDecomposition;
                if ((partDecomposition = PlusEFakturaTools.deepPartSearch((Part)(partFromMultipart = multipart.getBodyPart(multipartCounter)))) != null && partDecomposition.size() > 0) {
                    for (Part part : partDecomposition) {
                        String disposition = PlusEFakturaTools.getPartDisposition(part);
                        String fileName = PlusEFakturaTools.getPartFileName(part);
                        if (disposition != null) {
                            if (disposition.equalsIgnoreCase("attachment")) {
                                if (fileName != null && fileName.toLowerCase().endsWith("dat")) {
                                    try {
                                        InputStream inputStream = part.getInputStream();
                                        Throwable throwable = null;
                                        try {
                                            HMEFMessage hmefMessage = new HMEFMessage(inputStream);
                                            for (Attachment hmefAttachment : hmefMessage.getAttachments()) {
                                                attachmentParts.add(new AttachmentPart(hmefAttachment.getFilename(), new ByteArrayInputStream(hmefAttachment.getContents())));
                                            }
                                        }
                                        catch (Throwable throwable2) {
                                            throwable = throwable2;
                                            throw throwable2;
                                        }
                                        finally {
                                            if (inputStream == null) continue;
                                            if (throwable != null) {
                                                try {
                                                    inputStream.close();
                                                }
                                                catch (Throwable throwable3) {
                                                    throwable.addSuppressed(throwable3);
                                                }
                                                continue;
                                            }
                                            inputStream.close();
                                        }
                                    }
                                    catch (Exception e) {
                                        log.error((Object)e.getMessage(), (Throwable)e);
                                    }
                                    continue;
                                }
                                attachmentParts.add(new AttachmentPart(fileName, part.getInputStream()));
                                continue;
                            }
                            if (!disposition.equalsIgnoreCase("inline") || fileName == null) continue;
                            attachmentParts.add(new AttachmentPart(fileName, part.getInputStream()));
                            continue;
                        }
                        if (fileName == null) continue;
                        attachmentParts.add(new AttachmentPart(fileName, part.getInputStream()));
                    }
                }
                ++multipartCounter;
            }
        }
        catch (Throwable throwable) {
            return attachmentParts;
        }
    }

    public static boolean shouldProcessExtension(String extension, String processedExtension) {
        return extension.equalsIgnoreCase(processedExtension) || processedExtension.equalsIgnoreCase(ALL_EXTENSIONS) || extension.isEmpty() && processedExtension.equalsIgnoreCase(NO_EXTENSION);
    }

    public static String formatDuration(long duration) {
        long days = TimeUnit.MILLISECONDS.toDays(duration);
        long hours = TimeUnit.MILLISECONDS.toHours(duration) - TimeUnit.DAYS.toHours(TimeUnit.MILLISECONDS.toDays(duration));
        long minutes = TimeUnit.MILLISECONDS.toMinutes(duration) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(duration));
        long seconds = TimeUnit.MILLISECONDS.toSeconds(duration) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(duration));
        long miliseconds = TimeUnit.MILLISECONDS.toMillis(duration) - TimeUnit.SECONDS.toMillis(TimeUnit.MILLISECONDS.toSeconds(duration));
        if (days > 0L) {
            return days + " dni, " + hours + " godzin, " + minutes + " minut, " + seconds + " sekund, " + miliseconds + " milisekund";
        }
        if (hours > 0L) {
            return hours + " godzin, " + minutes + " minut, " + seconds + " sekund, " + miliseconds + " milisekund";
        }
        if (minutes > 0L) {
            return minutes + " minut, " + seconds + " sekund, " + miliseconds + " milisekund";
        }
        if (seconds > 0L) {
            return seconds + " sekund, " + miliseconds + " milisekund";
        }
        if (miliseconds > 0L) {
            return miliseconds + " milisekund";
        }
        return "ponizej jednej milisekundy";
    }

    public static String getSHA1Checksum(String filename) throws Exception {
        byte[] b = PlusEFakturaTools.createChecksum(filename);
        String result = "";
        for (int i = 0; i < b.length; ++i) {
            result = result + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
        }
        return result;
    }

    private static byte[] createChecksum(String filename) throws Exception {
        int numRead;
        FileInputStream fis = new FileInputStream(filename);
        byte[] buffer = new byte[1024];
        MessageDigest complete = MessageDigest.getInstance("SHA1");
        do {
            if ((numRead = ((InputStream)fis).read(buffer)) <= 0) continue;
            complete.update(buffer, 0, numRead);
        } while (numRead != -1);
        ((InputStream)fis).close();
        return complete.digest();
    }

    public static String convertBackslashesToSlashes(String sText) throws Exception {
        log.trace((Object)"********** convertBackslashesToSlashes( sText ) *************");
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(sText);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '\\') {
                result.append("/");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        sText = result.toString();
        return sText;
    }

    public static Object getPartContent(Part part) throws IOException, MessagingException {
        try {
            return part.getContent();
        }
        catch (UnsupportedEncodingException exception) {
            return new MimeMessage((MimeMessage)part).getContent();
        }
        catch (MessagingException exception) {
            if (part instanceof MimeMessage && BODYSTRUCTURE_EXCEPTION_MESSAGE.equalsIgnoreCase(exception.getMessage())) {
                return new MimeMessage((MimeMessage)part).getContent();
            }
            throw exception;
        }
    }

    public static List<Part> deepPartSearch(Part part) {
        ArrayList<Object> listOfParts = null;
        try {
            if (part != null) {
                listOfParts = new ArrayList<Object>();
                Multipart multipart = null;
                Object o = PlusEFakturaTools.getPartContent(part);
                if (o instanceof Multipart) {
                    multipart = (Multipart)o;
                    int multipartCounter = 0;
                    try {
                        while (true) {
                            BodyPart internalPart;
                            String contentType;
                            if (PlusEFakturaTools.isMixedMultipart(contentType = (internalPart = multipart.getBodyPart(multipartCounter)).getContentType())) {
                                listOfParts.addAll(PlusEFakturaTools.deepPartSearch((Part)internalPart));
                            }
                            listOfParts.add(internalPart);
                            ++multipartCounter;
                        }
                    }
                    catch (Throwable internalPart) {
                    }
                } else {
                    Object content;
                    String contentType = part.getContentType();
                    if (PlusEFakturaTools.isMimeMessagePart(contentType, content = PlusEFakturaTools.getPartContent(part))) {
                        MimeMessage messagePart = (MimeMessage)content;
                        listOfParts.addAll(PlusEFakturaTools.deepPartSearch((Part)messagePart));
                    }
                    listOfParts.add(part);
                }
            }
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
        }
        return listOfParts;
    }

    private static boolean isMimeMessagePart(String contentType, Object content) {
        return StringUtils.equalsIgnoreCase((CharSequence)"message/rfc822", (CharSequence)contentType) && content instanceof MimeMessage;
    }

    private static boolean isMixedMultipart(String contentType) {
        return StringUtils.contains((CharSequence)contentType, (CharSequence)"multipart/mixed");
    }

    public static String getPartFileName(Part part) throws MessagingException {
        String contentTypeFileName;
        String disposition = PlusEFakturaTools.getPartDisposition(part);
        String fileName = PlusEFakturaTools.getFileName(part);
        String contentTypeName = part.getContentType();
        if (StringUtils.contains((CharSequence)contentTypeName, (CharSequence)";;")) {
            contentTypeName = StringUtils.replace((String)contentTypeName, (String)";;", (String)";");
            part.setHeader("Content-Type", contentTypeName);
        }
        ContentType contentType = PlusEFakturaTools.getContentType(contentTypeName);
        log.info((Object)"Pobieranie nazwy za\u0142\u0105cznika. Dane pocz\u0105tkowe");
        log.info((Object)("Disposition: " + disposition));
        log.info((Object)("fileName: " + fileName));
        log.info((Object)("contentTypeName: " + contentTypeName));
        if (StringUtils.isNotBlank((CharSequence)fileName)) {
            fileName = PlusEFakturaTools.decodeText(fileName, true, true);
            log.info((Object)("fileName po operacji dekodowania: " + fileName));
            if (StringUtils.isNotBlank((CharSequence)fileName) && !StringUtils.contains((CharSequence)fileName, (CharSequence)".") && StringUtils.isNotBlank((CharSequence)contentType.getSubType())) {
                fileName = fileName + "." + contentType.getSubType();
                log.info((Object)("Brak rozszerzenia. Dodano rozszerzenie " + contentType.getSubType()));
            }
            return fileName;
        }
        if (StringUtils.contains((CharSequence)contentTypeName, (CharSequence)CONTENT_TYPE_NAME_PART)) {
            contentTypeFileName = StringUtils.substringBetween((String)contentTypeName, (String)CONTENT_TYPE_NAME_PART, (String)"\"");
            if (StringUtils.contains((CharSequence)contentTypeFileName, (CharSequence)";")) {
                contentTypeFileName = StringUtils.substringBefore((String)contentTypeFileName, (String)";");
            }
            if (StringUtils.contains((CharSequence)contentTypeFileName, (CharSequence)".")) {
                return PlusEFakturaTools.decodeText(contentTypeFileName, true, true);
            }
        } else if (StringUtils.contains((CharSequence)contentTypeName, (CharSequence)CONTENT_TYPE_NAME_PART_SIMPLE)) {
            contentTypeFileName = StringUtils.substringAfter((String)contentTypeName, (String)CONTENT_TYPE_NAME_PART_SIMPLE);
            if (StringUtils.startsWith((CharSequence)contentTypeFileName, (CharSequence)"\"") || StringUtils.endsWith((CharSequence)contentTypeFileName, (CharSequence)"\"")) {
                contentTypeFileName = StringUtils.substringBetween((String)contentTypeFileName, (String)"\"");
            }
            if (StringUtils.contains((CharSequence)contentTypeFileName, (CharSequence)";")) {
                contentTypeFileName = StringUtils.substringBefore((String)contentTypeFileName, (String)";");
            }
            if (StringUtils.contains((CharSequence)contentTypeFileName, (CharSequence)".")) {
                return PlusEFakturaTools.decodeText(contentTypeFileName, true, true);
            }
        } else if (StringUtils.contains((CharSequence)contentTypeName, (CharSequence)CONTENT_TYPE_FILENAME_PART)) {
            contentTypeFileName = StringUtils.substringAfter((String)contentTypeName, (String)CONTENT_TYPE_FILENAME_PART);
            if (StringUtils.contains((CharSequence)contentTypeFileName, (CharSequence)";")) {
                contentTypeFileName = StringUtils.substringBefore((String)contentTypeFileName, (String)";");
            }
            if (StringUtils.contains((CharSequence)(contentTypeFileName = PlusEFakturaTools.decodeText(contentTypeFileName, true, true)), (CharSequence)".")) {
                return contentTypeFileName;
            }
        }
        if (StringUtils.isBlank((CharSequence)fileName) && StringUtils.equalsIgnoreCase((CharSequence)disposition, (CharSequence)"attachment")) {
            log.info((Object)"Brak nazwy za\u0142\u0105cznika. Analiza parametr\u00f3w");
            ParameterList parameters = contentType.getParameterList();
            if (parameters != null) {
                Enumeration parameterNames = parameters.getNames();
                while (parameterNames.hasMoreElements()) {
                    String parameterName = (String)parameterNames.nextElement();
                    if (!StringUtils.containsIgnoreCase((CharSequence)parameterName, (CharSequence)"name")) continue;
                    String parameterValue = contentType.getParameter(parameterName);
                    log.info((Object)("Parametr " + parameterName + " posiada warto\u015b\u0107 " + parameterValue));
                    return PlusEFakturaTools.decodeText(parameterValue, true, true);
                }
            }
        }
        return fileName;
    }

    public static String getPartDisposition(Part part) {
        try {
            return part.getDisposition();
        }
        catch (MessagingException exception) {
            log.warn((Object)exception.getMessage());
            return null;
        }
    }

    private static String getFileName(Part part) throws MessagingException {
        if (part instanceof MimePart) {
            MimePart mimePart = (MimePart)part;
            String filename = null;
            boolean decodeFileName = PropUtil.getBooleanSystemProperty((String)"mail.mime.decodefilename", (boolean)false);
            String s = mimePart.getHeader("Content-Type", null);
            if ((s = MimeUtil.cleanContentType((MimePart)mimePart, (String)s)) == null) {
                try {
                    Enumeration headers = mimePart.getAllHeaders();
                    while (headers.hasMoreElements()) {
                        Header header = (Header)headers.nextElement();
                        if (!StringUtils.equals((CharSequence)header.getName(), (CharSequence)"Content-Type")) continue;
                        s = header.getValue();
                        break;
                    }
                }
                catch (Exception exception) {
                    log.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
            if (s != null) {
                try {
                    log.info((Object)"Pobieranie nazwy za\u0142\u0105cznika z ContentType");
                    ContentType ct = new ContentType(s);
                    String contentTypeFileName = ct.getParameter("name");
                    if (StringUtils.contains((CharSequence)contentTypeFileName, (CharSequence)".")) {
                        filename = contentTypeFileName;
                    }
                }
                catch (ParseException ct) {
                    // empty catch block
                }
            }
            if (filename == null && (s = mimePart.getHeader("Content-Disposition", null)) != null) {
                try {
                    log.info((Object)"Pobieranie nazwy za\u0142\u0105cznika z ContentDisposition");
                    ContentDisposition cd = new ContentDisposition(s);
                    filename = cd.getParameter("filename");
                }
                catch (ParseException cd) {
                    // empty catch block
                }
            }
            if (decodeFileName && filename != null) {
                try {
                    log.info((Object)("Dekodowanie nazwy za\u0142\u0105cznika " + filename + " za pomoc\u0105 MimeUtility"));
                    filename = MimeUtility.decodeText((String)filename);
                }
                catch (UnsupportedEncodingException ex) {
                    throw new MessagingException("Can't decode filename", (Exception)ex);
                }
            }
            return filename;
        }
        return part.getFileName();
    }

    public static ContentType getContentType(String contentTypeName) throws MessagingException {
        String partContentType = StringUtils.defaultString((String)contentTypeName);
        if (StringUtils.startsWith((CharSequence)partContentType, (CharSequence)"\"")) {
            partContentType = StringUtils.replaceOnce((String)partContentType, (String)"\"", (String)"");
            partContentType = StringUtils.replaceOnce((String)partContentType, (String)"\";", (String)";");
        }
        if (StringUtils.contains((CharSequence)partContentType, (CharSequence)"Content-Transfer-Encoding:")) {
            partContentType = StringUtils.replaceOnce((String)partContentType, (String)": ", (String)"=");
        }
        if (!StringUtils.contains((CharSequence)partContentType, (CharSequence)"/")) {
            partContentType = contentTypeName + "/" + contentTypeName;
        }
        try {
            return new ContentType(partContentType);
        }
        catch (Exception e) {
            String substring = StringUtils.substringBefore((String)partContentType, (String)";");
            if (!StringUtils.contains((CharSequence)substring, (CharSequence)"/")) {
                substring = substring + "/" + substring;
            }
            return new ContentType(substring);
        }
    }

    public static String decodeText(String text, boolean urlDecode, boolean removeNewLines) {
        log.trace((Object)("******************** decodeText(text=" + text + ", urlDecode=" + urlDecode + ") ********************"));
        if (StringUtils.isNotEmpty((CharSequence)text)) {
            TextDecoder[] textDecoders;
            for (TextDecoder textDecoder : textDecoders = new TextDecoder[]{new TextDecoder(PlusEFakturaTools.isQuotedPrintable(text) ? "=[?]UTF-8[?]Q.+?[?]=" : "=[?]UTF-8.+?[?]=", false, urlDecode, 2), new TextDecoder("utf-8''", true, urlDecode, 2)}) {
                log.info((Object)("Dekodowanie nazwy za\u0142\u0105cznika dekoderem: " + textDecoder.toString()));
                text = PlusEFakturaTools.decodeText(text, textDecoder);
            }
        }
        if (removeNewLines) {
            text = StringUtils.replaceAll((String)text, (String)" \r", (String)"");
            text = StringUtils.replaceAll((String)text, (String)"\n ", (String)"");
            text = StringUtils.replaceAll((String)text, (String)"\r", (String)"");
            text = StringUtils.replaceAll((String)text, (String)"\n", (String)"");
        }
        return text;
    }

    private static boolean isQuotedPrintable(String text) {
        return StringUtils.containsIgnoreCase((CharSequence)text, (CharSequence)"=?UTF-8?Q?");
    }

    private static String decodeText(String text, TextDecoder textDecoder) {
        StringBuilder decodedText = new StringBuilder();
        Pattern pattern = Pattern.compile(textDecoder.getRegex(), textDecoder.getFlags());
        Matcher matcher = pattern.matcher(text);
        int lastIndex = 0;
        while (matcher.find()) {
            String part = matcher.group();
            String firstPart = text.substring(lastIndex, matcher.start());
            lastIndex = matcher.end();
            if (StringUtils.isNotBlank((CharSequence)firstPart) && PlusEFakturaTools.isNotTabulator(firstPart)) {
                decodedText.append(StringUtils.trim((String)firstPart));
            }
            if (textDecoder.isSkipMatch()) continue;
            decodedText.append(PlusEFakturaTools.decodeTextPart(StringUtils.trim((String)part), textDecoder.isUrlDecode()));
        }
        String lastPart = text.substring(lastIndex);
        if (StringUtils.isNotBlank((CharSequence)lastPart) && PlusEFakturaTools.isNotTabulator(lastPart)) {
            decodedText.append(PlusEFakturaTools.decodeTextPart(lastPart, textDecoder.isUrlDecode()));
        }
        return decodedText.toString();
    }

    private static boolean isNotTabulator(String text) {
        return !text.equalsIgnoreCase(TABULATOR);
    }

    private static String decodeTextPart(String sText, boolean urlDecode) {
        log.trace((Object)("******************** decodeTextPart(sText=" + sText + ", urlDecode=" + urlDecode + ") ********************"));
        String ret = null;
        try {
            ret = MimeUtility.decodeText((String)sText);
            ret = Normalizer.normalize(ret, Normalizer.Form.NFKC);
            if (urlDecode && StringUtils.contains((CharSequence)ret, (CharSequence)"%")) {
                ret = URLDecoder.decode(ret, "UTF-8");
            }
            if (PlusEFakturaTools.isQuotedPrintable(ret)) {
                ret = StringUtils.replaceFirst((String)ret, (String)"=[?]UTF-8[?]Q[?]", (String)"");
                ret = StringUtils.replaceFirst((String)ret, (String)"[?]=", (String)"");
                InputStream stringStream = IOUtils.toInputStream((String)ret);
                InputStream decodedStream = MimeUtility.decode((InputStream)stringStream, (String)"quoted-printable");
                ret = IOUtils.toString((InputStream)decodedStream, (String)"UTF-8");
            }
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
        }
        return ret;
    }

    public static File saveBytesToFile(String dirPath, String extension, byte[] bytes) throws Exception {
        SecureRandom random = new SecureRandom();
        long value = Math.abs(random.nextLong());
        String name = String.valueOf(value);
        if ((dirPath = PlusEFakturaTools.convertBackslashesToSlashes(dirPath)).endsWith("/")) {
            dirPath = dirPath.substring(0, dirPath.length() - 1);
        }
        StringBuilder path = new StringBuilder();
        path.append(dirPath);
        path.append(File.separator);
        path.append(name);
        path.append(".");
        path.append(extension);
        File file = new File(path.toString());
        FileUtils.writeByteArrayToFile((File)file, (byte[])bytes);
        return file;
    }

    public static String getAddressFromString(String address) {
        log.trace((Object)("********** getAddressFromString(address=" + address + ") *************"));
        String emailAddress = null;
        try {
            if (address == null || address.length() == 0) {
                return null;
            }
            emailAddress = address;
            int id1 = address.indexOf("<");
            int id2 = address.indexOf(">");
            while (id1 != -1 || id2 != -1) {
                StringBuffer sb = new StringBuffer();
                int counter = id1 + 1;
                int j = 0;
                while (counter < id2) {
                    sb.insert(j, address.charAt(counter));
                    ++counter;
                    ++j;
                }
                if (sb.toString().contains("@")) {
                    emailAddress = sb.toString();
                    break;
                }
                id1 = address.indexOf("<", id1 + 1);
                id2 = address.indexOf(">", id2 + 1);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return emailAddress;
    }

    public static Address[] getFromWithForwardingDetection(Message message) throws MessagingException {
        String deliveredTo = PlusEFakturaTools.getDeliveredTo(message);
        if (StringUtils.isNotBlank((CharSequence)deliveredTo) && PlusEFakturaTools.isNotWithinTo(message, deliveredTo)) {
            return message.getRecipients(Message.RecipientType.TO);
        }
        return message.getFrom();
    }

    private static String getDeliveredTo(Message message) throws MessagingException {
        Object[] headers = message.getHeader("Delivered-To");
        if (ArrayUtils.isNotEmpty((Object[])headers)) {
            for (Object header : headers) {
                if (!StringUtils.contains((CharSequence)header, (CharSequence)"@")) continue;
                return header;
            }
        }
        return null;
    }

    private static boolean isNotWithinTo(Message message, String mail) throws MessagingException {
        Object[] addresses = message.getRecipients(Message.RecipientType.TO);
        if (ArrayUtils.isNotEmpty((Object[])addresses)) {
            String decodedMail = PlusEFakturaTools.getAddressFromString(mail);
            for (Object address : addresses) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)PlusEFakturaTools.getAddressFromString(address.toString()), (CharSequence)decodedMail)) continue;
                return false;
            }
        }
        return true;
    }

    public static String getMsgStatusTranslation(MsgStatus msgStatus) {
        switch (msgStatus) {
            case ANALYZING: {
                return "analyzing";
            }
            case NO_ACCEPTED_ATTACHMENT_EXTENSIONS: {
                return "no accepted attachment extensions defined";
            }
            case TEMPORARY_FILE_SAVE_ERROR: {
                return "error while saving temporary file";
            }
            case UNACCEPTED_ATTACHMENT_EXTENSION_FOUND: {
                return "unaccepted attachment extension found";
            }
            case UNKNOWN_MAIL_CONTENT: {
                return "unknown e-mail content";
            }
            case INDEXES_SAVE_ERROR: {
                return "error while saving indexes";
            }
            case CUSTOM_ANALYZING_INTERRUPTION: {
                return "custom analyzing interruption";
            }
            case NO_DEVICE_FOUND: {
                return "no device found for document class";
            }
            case ARCHIVE_ADDITION_ERROR: {
                return "error while adding to archive";
            }
            case INDEX_MAPPING_EXCEPTION: {
                return "index mapping exception";
            }
            case NO_SUPPLIER_ADDRESS: {
                return "no supplier address";
            }
            case NO_TEMPLATE_FOUND: {
                return "no template found";
            }
            case NO_TEMPLATE_PATH_FOUND: {
                return "no template path found";
            }
            case TEMPLATE_ERROR: {
                return "template error";
            }
            case NO_TEMPLATE_VERSION: {
                return "no template version";
            }
            case UNKNOWN_TEMPLATE_VERSION: {
                return "unknown template version";
            }
            case NO_MAPPING_FOUND: {
                return "no mapping found";
            }
        }
        return "no status";
    }

    public static String getMessageUID(Message message) {
        log.trace((Object)"***************** getMessageUID(Message) **********************");
        String sUid = "";
        Folder folder = null;
        try {
            folder = message.getFolder();
            if (folder instanceof POP3Folder) {
                POP3Folder pop3folder = (POP3Folder)folder;
                sUid = pop3folder.getUID(message);
            } else if (folder instanceof IMAPFolder) {
                IMAPFolder imapfolder = (IMAPFolder)folder;
                sUid = String.valueOf(imapfolder.getUID(message));
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return sUid;
    }

    public static String getFrom(Message message, AdditionalOptions additionalOptions) {
        String emailAddress = "";
        try {
            Address[] adrTab = message.getFrom();
            adrTab = StringUtils.equalsIgnoreCase((CharSequence)additionalOptions.getDetectForwarding(), (CharSequence)"TRUE") ? PlusEFakturaTools.getFromWithForwardingDetection(message) : message.getFrom();
            emailAddress = PlusEFakturaTools.getAddress(adrTab);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return emailAddress;
    }

    public static String getTo(Message message) {
        return PlusEFakturaTools.getRecipients(message, Message.RecipientType.TO);
    }

    public static String getCc(Message message) {
        return PlusEFakturaTools.getRecipients(message, Message.RecipientType.CC);
    }

    public static String getRecipients(Message message, Message.RecipientType recipientType) {
        String recipients = "";
        try {
            Address[] adrTab = message.getRecipients(recipientType);
            recipients = PlusEFakturaTools.getJoinedAddresses(adrTab);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return recipients;
    }

    private static String getAddress(Address[] adrTab) {
        Address oneAdr;
        String emailAddress = "";
        if (adrTab != null && adrTab.length > 0 && (oneAdr = adrTab[0]) != null) {
            emailAddress = oneAdr.toString();
            emailAddress = PlusEFakturaTools.getAddressFromString(emailAddress);
        }
        return emailAddress;
    }

    private static String getJoinedAddresses(Address[] addresses) {
        ArrayList<String> list = new ArrayList<String>();
        if (ArrayUtils.isNotEmpty((Object[])addresses)) {
            for (Address address : addresses) {
                list.add(PlusEFakturaTools.getAddressFromString(address.toString()));
            }
        }
        return StringUtils.join(list, (String)", ");
    }

    public static String getReceivedDate(Message message) {
        String receivedDate = "";
        try {
            Date date = message.getReceivedDate();
            if (date != null) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                receivedDate = dateFormat.format(date);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return receivedDate;
    }

    public static String getUniqueMessageId(Message message, AdditionalOptions additionalOptions) {
        log.trace((Object)"***************** getUniqueMessageId(Message, AdditionalOptions) **********************");
        String sMsgId = "";
        String sUserName = "";
        String sUid = "";
        try {
            URLName urlName = PlusEFakturaTools.getMailboxURLName(message.getFolder());
            if (urlName != null) {
                sUserName = urlName.getUsername();
            }
            sUid = additionalOptions.getUseSequenceAsMessageIdGenerator().equalsIgnoreCase("TRUE") ? String.valueOf(SequenceUtils.nextValue((String)"pm_efakt_mailid_seq")) : PlusEFakturaTools.getMessageUID(message);
            sMsgId = sUserName + sUid;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            sMsgId = "brak";
        }
        return sMsgId;
    }

    public static URLName getMailboxURLName(Folder folder) {
        log.trace((Object)"***************** getMailboxURLName() **********************");
        URLName urlName = null;
        try {
            Store store = folder.getStore();
            urlName = store.getURLName();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return urlName;
    }

    public static String getMessageContent(Message message) {
        log.trace((Object)"********** getMessageContent( message ) *************");
        String messageContent = "";
        try {
            List<Part> parts = PlusEFakturaTools.decomposePart((Part)message);
            messageContent = PlusEFakturaTools.getMessageContent(parts);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return messageContent;
    }

    public static List<Part> decomposePart(Part part) throws IOException, MessagingException {
        ArrayList<Part> parts = new ArrayList<Part>();
        Object content = PlusEFakturaTools.getPartContent(part);
        if (content instanceof Multipart) {
            Multipart multipart = (Multipart)content;
            int counter = 0;
            try {
                while (true) {
                    BodyPart subpart = multipart.getBodyPart(counter);
                    parts.addAll(PlusEFakturaTools.decomposePart((Part)subpart));
                    ++counter;
                }
            }
            catch (Exception exception) {}
        } else {
            parts.add(part);
        }
        return parts;
    }

    public static String getMessageContent(List<Part> parts) {
        if (CollectionUtils.isNotEmpty(parts)) {
            try {
                for (Part part : parts) {
                    String disposition = PlusEFakturaTools.getPartDisposition(part);
                    String contentTypeName = part.getContentType();
                    ContentType contentType = PlusEFakturaTools.getContentType(contentTypeName);
                    String baseType = contentType.getBaseType();
                    if (StringUtils.equals((CharSequence)disposition, (CharSequence)"attachment")) continue;
                    if (StringUtils.equals((CharSequence)baseType, (CharSequence)"text/plain")) {
                        Object content = PlusEFakturaTools.getPartContent(part);
                        return content != null ? content.toString() : "";
                    }
                    if (!StringUtils.equals((CharSequence)baseType, (CharSequence)"text/html")) continue;
                    Object content = PlusEFakturaTools.getPartContent(part);
                    String contentText = content != null ? content.toString() : "";
                    return PlusEFakturaTools.getTextFromHtml(contentText);
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return "";
    }

    public static String getTextFromHtml(String html) {
        String prettyPrinted = PlusEFakturaTools.cleanHtml(html, true, "br", "p");
        String text = PlusEFakturaTools.cleanHtml(prettyPrinted, false, new String[0]);
        return Parser.unescapeEntities((String)text, (boolean)false);
    }

    public static String cleanHtml(String html, boolean prettyPrint, String ... tags) {
        return Jsoup.clean((String)html, (String)"", (Safelist)Safelist.none().addTags(tags), (Document.OutputSettings)new Document.OutputSettings().prettyPrint(prettyPrint));
    }

    public static String getIndexIdForDocClass(String sClassName, String sIndex) {
        log.trace((Object)("********** getIndexIdForDocClass( sClassName=" + sClassName + ", sIndex=" + sIndex + " ) *************"));
        String id = "-1";
        try {
            DocumentClassService documentClassService = (DocumentClassService)SpringContext.getBean(DocumentClassService.class);
            DocumentClass documentClass = documentClassService.getDocumentClass(sClassName, new String[]{"indexes"});
            return PlusEFakturaTools.getIndexIdForDocClass(documentClass, sIndex);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return id;
        }
    }

    public static String getIndexIdForDocClass(DocumentClass documentClass, String sIndex) {
        log.trace((Object)("********** getIndexIdForDocClass(documentClass, sIndex=" + sIndex + " ) *************"));
        String id = "-1";
        try {
            Set indexes;
            if (documentClass != null && CollectionUtils.isNotEmpty((Collection)(indexes = documentClass.getIndexes()))) {
                for (DocumentClassIndex index : indexes) {
                    String indexName = index.getName();
                    if (indexName == null || !sIndex.equals(indexName)) continue;
                    return String.valueOf(index.getId());
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return id;
    }

    public static String verifyEmailContent(String emailContent) {
        if (emailContent.length() > EMAIL_CONTENT_MAX_LENGTH) {
            return emailContent.substring(0, EMAIL_CONTENT_MAX_LENGTH);
        }
        return emailContent;
    }

    public static String joinIndexValue(String[] tab) {
        StringBuilder buf = new StringBuilder();
        for (int i = 1; i < tab.length; ++i) {
            buf.append(tab[i]);
            if (i >= tab.length - 1) continue;
            buf.append(";");
        }
        return buf.toString();
    }

    public static String truncateIndexValue(String indexValue) {
        return StringUtils.truncate((String)indexValue, (int)4000);
    }

    public static void handleException(AdditionalOptions additionalOptions) throws IndexesMappingException {
        String indexesMappingException = additionalOptions.getIndexesMappingException();
        if (indexesMappingException.equalsIgnoreCase("STOP")) {
            throw new IndexesMappingException();
        }
    }

    public static void handleAttachmentService(AttachmentServiceException e, SeenAttachment seenAttachment, String mailboxFolder) {
        try {
            com.suncode.plugin.efaktura.model.attachment.Attachment attachmentService = e.getAttachmentService();
            switch (attachmentService.getActionType()) {
                case ADD_TO_DOCUMENT_CLASS: {
                    String docClassName = attachmentService.getActionValue();
                    log.info((Object)("Dodawanie zalacznika nie bedacego faktura do klasy dokumentow o nazwie " + docClassName));
                    clientLog.info((Object)("Dodawanie zalacznika nie bedacego faktura do klasy dokumentow o nazwie " + docClassName));
                    DocumentClassService documentClassService = (DocumentClassService)SpringContext.getBean(DocumentClassService.class);
                    DocumentClass documentClass = documentClassService.getDocumentClass(docClassName, new String[]{"indexes"});
                    if (documentClass != null) {
                        AdditionalOptions additionalOptions;
                        File file;
                        AddResult addResult = new AddResult();
                        InterfaceExecutor executor = new InterfaceExecutor();
                        Message message = e.getMail();
                        boolean shouldProcess = executor.executeShouldProcessNonInvoiceAttachment(message, file = e.getFile(), additionalOptions = e.getAdditionalOptions());
                        if (shouldProcess) {
                            HashSet<String> indexes = new HashSet<String>();
                            String emailIndex = additionalOptions.getEmailToIndexForNonInvoiceAttachment();
                            String toIndex = additionalOptions.getToToIndexForNonInvoiceAttachment();
                            String ccIndex = additionalOptions.getCcToIndexForNonInvoiceAttachment();
                            String dateIndex = additionalOptions.getDateToIndexForNonInvoiceAttachment();
                            String subjectIndex = additionalOptions.getSubjectToIndexForNonInvoiceAttachment();
                            String contentIndex = additionalOptions.getContentToIndexForNonInvoiceAttachment();
                            String attachmentNameIndex = additionalOptions.getNonInvoiceAttachmentNameToIndexForAttachment();
                            String extIndex = additionalOptions.getExtensionToIndexForNonInvoiceAttachment();
                            String msgIdIndex = additionalOptions.getMessageIdToIndexForNonInvoiceAttachment();
                            String mailboxIndex = additionalOptions.getMailboxToIndexForNonInvoiceAttachment();
                            String mailboxFolderIndex = additionalOptions.getMailboxFolderToIndexForNonInvoiceAttachment();
                            String emailSubject = PlusEFakturaTools.decodeText(message.getSubject(), false, false);
                            try {
                                Set<String> extraIndexes;
                                if (StringUtils.isNotBlank((CharSequence)emailIndex)) {
                                    String emailIndexId = PlusEFakturaTools.getIndexIdForDocClass(documentClass, emailIndex);
                                    if (!emailIndexId.equalsIgnoreCase("-1")) {
                                        String sender = PlusEFakturaTools.getFrom(message, additionalOptions);
                                        if (StringUtils.isBlank((CharSequence)sender)) {
                                            sender = "N/A";
                                        }
                                        indexes.add(emailIndexId + ";" + sender);
                                    } else {
                                        log.warn((Object)("Indeks o nazwie " + emailIndex + " nie istnieje w klasie dokumentow " + documentClass.getName() + ". Brak mozliwosci przypisania wartosci"));
                                        clientLog.warn((Object)("Indeks o nazwie " + emailIndex + " nie istnieje w klasie dokumentow " + documentClass.getName() + ". Brak mozliwosci przypisania wartosci"));
                                    }
                                }
                                if (StringUtils.isNotBlank((CharSequence)toIndex)) {
                                    String toIndexId = PlusEFakturaTools.getIndexIdForDocClass(documentClass, toIndex);
                                    if (!toIndexId.equalsIgnoreCase("-1")) {
                                        String to = PlusEFakturaTools.getTo(message);
                                        if (StringUtils.isBlank((CharSequence)to)) {
                                            to = "N/A";
                                        }
                                        indexes.add(toIndexId + ";" + to);
                                    } else {
                                        log.warn((Object)("Indeks o nazwie " + toIndex + " nie istnieje w klasie dokumentow " + documentClass.getName() + ". Brak mozliwosci przypisania wartosci"));
                                        clientLog.warn((Object)("Indeks o nazwie " + toIndex + " nie istnieje w klasie dokumentow " + documentClass.getName() + ". Brak mozliwosci przypisania wartosci"));
                                    }
                                }
                                if (StringUtils.isNotBlank((CharSequence)ccIndex)) {
                                    String ccIndexId = PlusEFakturaTools.getIndexIdForDocClass(documentClass, ccIndex);
                                    if (!ccIndexId.equalsIgnoreCase("-1")) {
                                        String cc = PlusEFakturaTools.getCc(message);
                                        if (StringUtils.isBlank((CharSequence)cc)) {
                                            cc = "N/A";
                                        }
                                        indexes.add(ccIndexId + ";" + cc);
                                    } else {
                                        log.warn((Object)("Indeks o nazwie " + ccIndex + " nie istnieje w klasie dokumentow " + documentClass.getName() + ". Brak mozliwosci przypisania wartosci"));
                                        clientLog.warn((Object)("Indeks o nazwie " + ccIndex + " nie istnieje w klasie dokumentow " + documentClass.getName() + ". Brak mozliwosci przypisania wartosci"));
                                    }
                                }
                                if (StringUtils.isNotBlank((CharSequence)dateIndex)) {
                                    String dateIndexId = PlusEFakturaTools.getIndexIdForDocClass(documentClass, dateIndex);
                                    if (!dateIndexId.equalsIgnoreCase("-1")) {
                                        Date newDate = message.getSentDate();
                                        if (newDate != null) {
                                            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                            indexes.add(dateIndexId + ";" + dateFormat.format(newDate));
                                        } else {
                                            log.warn((Object)"Nie udalo sie pobrac daty wiadomosci");
                                            clientLog.warn((Object)"Nie udalo sie pobrac daty wiadomosci");
                                        }
                                    } else {
                                        log.warn((Object)("Indeks o nazwie " + dateIndex + " nie istnieje w klasie dokumentow " + documentClass.getName() + ". Brak mozliwosci przypisania wartosci"));
                                        clientLog.warn((Object)("Indeks o nazwie " + dateIndex + " nie istnieje w klasie dokumentow " + documentClass.getName() + ". Brak mozliwosci przypisania wartosci"));
                                    }
                                }
                                if (StringUtils.isNotBlank((CharSequence)subjectIndex)) {
                                    String subjectIndexId = PlusEFakturaTools.getIndexIdForDocClass(documentClass, subjectIndex);
                                    if (!subjectIndexId.equalsIgnoreCase("-1")) {
                                        indexes.add(subjectIndexId + ";" + emailSubject);
                                    } else {
                                        log.warn((Object)("Indeks o nazwie " + subjectIndex + " nie istnieje w klasie dokumentow " + documentClass.getName() + ". Brak mozliwosci przypisania wartosci"));
                                        clientLog.warn((Object)("Indeks o nazwie " + subjectIndex + " nie istnieje w klasie dokumentow " + documentClass.getName() + ". Brak mozliwosci przypisania wartosci"));
                                    }
                                }
                                if (StringUtils.isNotBlank((CharSequence)contentIndex)) {
                                    String contentIndexId = PlusEFakturaTools.getIndexIdForDocClass(documentClass, contentIndex);
                                    if (!contentIndexId.equalsIgnoreCase("-1")) {
                                        String emailContent = PlusEFakturaTools.getMessageContent(message);
                                        indexes.add(contentIndexId + ";" + PlusEFakturaTools.verifyEmailContent(emailContent));
                                    } else {
                                        log.warn((Object)("Indeks o nazwie " + contentIndex + " nie istnieje w klasie dokumentow " + documentClass.getName() + ". Brak mozliwosci przypisania wartosci"));
                                        clientLog.warn((Object)("Indeks o nazwie " + contentIndex + " nie istnieje w klasie dokumentow " + documentClass.getName() + ". Brak mozliwosci przypisania wartosci"));
                                    }
                                }
                                if (StringUtils.isNotBlank((CharSequence)attachmentNameIndex)) {
                                    String attachmentNameIndexId = PlusEFakturaTools.getIndexIdForDocClass(documentClass, attachmentNameIndex);
                                    if (!attachmentNameIndexId.equalsIgnoreCase("-1")) {
                                        indexes.add(attachmentNameIndexId + ";" + file.getName());
                                    } else {
                                        log.warn((Object)("Indeks o nazwie " + attachmentNameIndex + " nie istnieje w klasie dokumentow " + documentClass.getName() + ". Brak mozliwosci przypisania wartosci"));
                                        clientLog.warn((Object)("Indeks o nazwie " + attachmentNameIndex + " nie istnieje w klasie dokumentow " + documentClass.getName() + ". Brak mozliwosci przypisania wartosci"));
                                    }
                                }
                                if (StringUtils.isNotBlank((CharSequence)extIndex)) {
                                    String extIndexId = PlusEFakturaTools.getIndexIdForDocClass(documentClass, extIndex);
                                    if (!extIndexId.equalsIgnoreCase("-1")) {
                                        String fileExtension = FilenameUtils.getExtension((String)file.getName());
                                        indexes.add(extIndexId + ";" + fileExtension.toLowerCase());
                                    } else {
                                        log.warn((Object)("Indeks o nazwie " + extIndex + " nie istnieje w klasie dokumentow " + documentClass.getName() + ". Brak mozliwosci przypisania wartosci"));
                                        clientLog.warn((Object)("Indeks o nazwie " + extIndex + " nie istnieje w klasie dokumentow " + documentClass.getName() + ". Brak mozliwosci przypisania wartosci"));
                                    }
                                }
                                if (StringUtils.isNotBlank((CharSequence)msgIdIndex)) {
                                    String msgIdIndexId = PlusEFakturaTools.getIndexIdForDocClass(documentClass, msgIdIndex);
                                    if (!msgIdIndexId.equalsIgnoreCase("-1")) {
                                        indexes.add(msgIdIndexId + ";" + additionalOptions.getCurrentMessageId());
                                    } else {
                                        log.warn((Object)("Indeks o nazwie " + msgIdIndex + " nie istnieje w klasie dokumentow " + documentClass.getName() + ". Brak mozliwosci przypisania wartosci"));
                                        clientLog.warn((Object)("Indeks o nazwie " + msgIdIndex + " nie istnieje w klasie dokumentow " + documentClass.getName() + ". Brak mozliwosci przypisania wartosci"));
                                    }
                                }
                                if (StringUtils.isNotBlank((CharSequence)mailboxIndex)) {
                                    String mailboxIndexId = PlusEFakturaTools.getIndexIdForDocClass(documentClass, mailboxIndex);
                                    if (!mailboxIndexId.equalsIgnoreCase("-1")) {
                                        indexes.add(mailboxIndexId + ";" + additionalOptions.getMailboxAddress());
                                    } else {
                                        log.warn((Object)("Indeks o nazwie " + mailboxIndex + " nie istnieje w klasie dokumentow " + documentClass.getName() + ". Brak mozliwosci przypisania wartosci"));
                                        clientLog.warn((Object)("Indeks o nazwie " + mailboxIndex + " nie istnieje w klasie dokumentow " + documentClass.getName() + ". Brak mozliwosci przypisania wartosci"));
                                    }
                                }
                                if (StringUtils.isNotBlank((CharSequence)mailboxFolderIndex)) {
                                    String mailboxFolderIndexId = PlusEFakturaTools.getIndexIdForDocClass(documentClass, mailboxFolderIndex);
                                    if (!mailboxFolderIndexId.equalsIgnoreCase("-1")) {
                                        indexes.add(mailboxFolderIndexId + ";" + mailboxFolder);
                                    } else {
                                        log.warn((Object)("Indeks o nazwie " + mailboxFolderIndex + " nie istnieje w klasie dokumentow " + documentClass.getName() + ". Brak mozliwosci przypisania wartosci"));
                                        clientLog.warn((Object)("Indeks o nazwie " + mailboxFolderIndex + " nie istnieje w klasie dokumentow " + documentClass.getName() + ". Brak mozliwosci przypisania wartosci"));
                                    }
                                }
                                if (PlusEFakturaTools.shouldResolveSubjectAsIndexesForNonInvoiceAttachment(additionalOptions)) {
                                    SubjectAsIndexesResolver subjectAsIndexesResolver = new SubjectAsIndexesResolver(additionalOptions.getSubjectAsIndexesDelimiterForNonInvoiceAttachment(), additionalOptions.getSubjectAsIndexesSequenceForNonInvoiceAttachment(), emailSubject, documentClass.getName(), additionalOptions);
                                    indexes.addAll(subjectAsIndexesResolver.resolve());
                                }
                                if ((extraIndexes = executor.executeSetIndexesForNonInvoiceAttachment(message, file, additionalOptions)) != null && extraIndexes.size() > 0) {
                                    indexes.addAll(extraIndexes);
                                }
                            }
                            catch (Exception exception) {
                                log.error((Object)exception.getMessage(), (Throwable)exception);
                            }
                            String fileId = AddAttachmentsToArchiveAction.addToArchive(String.valueOf(documentClass.getId()), file, indexes.toArray(), false, additionalOptions.getAdministrationUserLogin(), file.getName(), seenAttachment, additionalOptions, addResult);
                            if (fileId.compareToIgnoreCase("-1") != 0) {
                                log.warn((Object)("Poprawnie dodano plik do archiwum do klasy dokumentow o nazwie " + docClassName));
                                clientLog.warn((Object)("Poprawnie dodano plik do archiwum do klasy dokumentow o nazwie " + docClassName));
                            } else {
                                log.warn((Object)"Blad dodawania pliku do archiwum");
                                clientLog.warn((Object)"Blad dodawania pliku do archiwum");
                            }
                            AddAttachmentsToArchiveAction.controlTemporaryFileExistence(file, additionalOptions);
                            break;
                        }
                        log.warn((Object)"Odrzucenie dalszego przetwarzania zalacznika przez klase zewnetrzna");
                        break;
                    }
                    log.warn((Object)("Klasa dokumnetow " + docClassName + " nie istnieje w systemie PlusWorkflow"));
                    clientLog.warn((Object)("Klasa dokumnetow " + docClassName + " nie istnieje w systemie PlusWorkflow"));
                    break;
                }
            }
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    private static boolean shouldResolveSubjectAsIndexesForNonInvoiceAttachment(AdditionalOptions additionalOptions) {
        return StringUtils.equalsIgnoreCase((CharSequence)additionalOptions.getSubjectAsIndexesForNonInvoiceAttachment(), (CharSequence)"TRUE") && StringUtils.isNotBlank((CharSequence)additionalOptions.getSubjectAsIndexesDelimiterForNonInvoiceAttachment()) && StringUtils.isNotBlank((CharSequence)additionalOptions.getSubjectAsIndexesSequenceForNonInvoiceAttachment());
    }

    public static List<String> useRegexForIndexValue(String sText, String sRegex, int matchingNo) {
        log.trace((Object)("******************** useRegexForIndexValue(sText=" + sText + ", sRegex=" + sRegex + ") ********************"));
        ArrayList<String> results = new ArrayList<String>();
        try {
            log.info((Object)("Wykorzystanie wyrazenia regularnego " + sRegex + " dla lancucha znakowego " + sText));
            Pattern pattern = Pattern.compile(sRegex);
            Matcher matcher = pattern.matcher(sText);
            if (matchingNo == 0) {
                while (matcher.find()) {
                    String oneResult = matcher.group();
                    results.add(oneResult);
                    log.info((Object)("Znaleziona wartosc w przeszukiwanym lancuchu znakowym to " + oneResult));
                }
            } else {
                int counter = 0;
                while (matcher.find()) {
                    if (++counter != matchingNo) continue;
                    String oneResult = matcher.group();
                    results.add(oneResult);
                    log.info((Object)("Znaleziona wartosc w przeszukiwanym lancuchu znakowym to " + oneResult));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return results;
    }

    public static String getExtFromMIME(String sSubtype) {
        log.trace((Object)("************* getExtFromMIME(sSubtype=" + sSubtype + ") **************"));
        String sExt = "";
        try {
            if (StringUtils.isNotBlank((CharSequence)sSubtype)) {
                sSubtype = sSubtype.toLowerCase();
            }
            HashMap<String, String> getExt = new HashMap<String, String>();
            if (MIMETypesTable.length == ExtsTable.length) {
                for (int i = 0; i < MIMETypesTable.length; ++i) {
                    String[] helpTable = MIMETypesTable[i].split("/");
                    getExt.put(helpTable[1], ExtsTable[i]);
                }
                String extForSubtype = (String)getExt.get(sSubtype);
                if (StringUtils.isNotBlank((CharSequence)extForSubtype)) {
                    sExt = extForSubtype;
                }
            } else {
                log.warn((Object)"Niezgodnosc ilosci typow i rozszerzen w tabelach MIMETypesTable i ExtsTable");
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return sExt;
    }
}

