/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.util;

import com.suncode.plugin.efaktura.configuration.EfakturaSpringContext;
import com.suncode.plugin.efaktura.model.attachment.Attachment;
import com.suncode.plugin.efaktura.model.template.Template;
import com.suncode.plugin.efaktura.service.attachment.AttachmentService;
import com.suncode.plugin.efaktura.service.template.TemplateService;
import com.suncode.plugin.efaktura.service.xml.XmlAnalyzerService;
import com.suncode.plugin.efaktura.util.AddResult;
import com.suncode.plugin.efaktura.util.AdditionalOptions;
import com.suncode.plugin.efaktura.util.Constants;
import com.suncode.plugin.efaktura.util.EngineResult;
import com.suncode.plugin.efaktura.util.IndexElement;
import com.suncode.plugin.efaktura.util.MsgStatus;
import com.suncode.plugin.efaktura.util.PDFAnalyzer;
import com.suncode.plugin.efaktura.util.PlusEFakturaEngineResult;
import com.suncode.plugin.efaktura.util.PlusEFakturaTools;
import com.suncode.plugin.efaktura.util.TagElement;
import com.suncode.plugin.efaktura.util.TemplatePhraseLocation;
import com.suncode.plugin.efaktura.util.TemplateVersion;
import com.suncode.plugin.efaktura.util.exception.AttachmentServiceException;
import com.suncode.plugin.efaktura.util.exception.IndexesMappingException;
import com.suncode.plugin.efaktura.util.exception.PlusEFakturaException;
import com.suncode.plugin.efaktura.util.recordindex.RecordIndexResolverPDFTextStripper;
import com.suncode.plugin.efaktura.util.tableindex.TableIndexResolverPDFTextStripper;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.util.ServiceFactory;
import java.io.File;
import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.mail.Message;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.RandomAccessReadBufferedFile;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PlusEFakturaEngine {
    public static Logger log = Logger.getLogger(PlusEFakturaEngine.class);
    public static Logger clientLog = Logger.getLogger((String)"PlusEFakturaClientLog");

    public EngineResult runEngine(Message message, Set<String> indecies, File file, String archiveClass, String eInvoiceIndexId, String emailAddress, String mailboxEmail, String emailSubject, String emailContent, AdditionalOptions additionalOptions, AddResult addResult, boolean indexesFromSubject) throws IndexesMappingException, AttachmentServiceException {
        boolean isEInvoice;
        HashSet<String> EFakturaIndecies;
        EngineResult engineResult;
        block57: {
            log.trace((Object)("************** runEngine( message, indecies, file, archiveClass=" + archiveClass + ", eInvoiceIndexId=" + eInvoiceIndexId + ", emailAddress=" + emailAddress + ", mailboxEmail=" + mailboxEmail + ", emailSubject=" + emailSubject + ", emailContent, AdditionalOptions, AddResult, indexesFromSubject=" + indexesFromSubject + " ) **************"));
            engineResult = new EngineResult();
            EFakturaIndecies = new HashSet<String>();
            String sTemplatePath = "";
            String xmlFileContent = "";
            String pdfFileContent = "";
            Document xmlTemplate = null;
            IndexElement indexMap = new IndexElement();
            String indexElementName = "";
            isEInvoice = false;
            List<Attachment> attachmentServices = null;
            Attachment templateMismatchAttService = null;
            List<Template> templates = null;
            Template template = null;
            String attachmentName = "";
            AttachmentService attachmentService = EfakturaSpringContext.getBean(AttachmentService.class);
            TemplateService templateService = EfakturaSpringContext.getBean(TemplateService.class);
            XmlAnalyzerService xmlAnalyzerService = EfakturaSpringContext.getBean(XmlAnalyzerService.class);
            try {
                if (indecies != null && indecies.size() > 0) {
                    EFakturaIndecies.addAll(indecies);
                }
                if (StringUtils.isBlank((CharSequence)emailAddress)) {
                    addResult.setMsgStatus(MsgStatus.NO_SUPPLIER_ADDRESS);
                    throw new PlusEFakturaException("Brak adresata wiadomosci");
                }
                attachmentName = file.getName();
                attachmentServices = attachmentService.findAllByFromEmail(emailAddress);
                templates = templateService.findByEmails(emailAddress, mailboxEmail, true);
                if ((CollectionUtils.isNotEmpty(attachmentServices) || CollectionUtils.isNotEmpty(templates)) && (StringUtils.isBlank((CharSequence)(pdfFileContent = PDFAnalyzer.readPDFWithPdfBox_1_7_1(file))) || pdfFileContent.equals("\n") || pdfFileContent.equalsIgnoreCase(Constants.ENTER) || pdfFileContent.equalsIgnoreCase(" ") || pdfFileContent.equalsIgnoreCase(Constants.ENTER + " "))) {
                    log.warn((Object)"Nie udalo sie uzyskac zawartosci faktury");
                    clientLog.warn((Object)"Nie udalo sie uzyskac zawartosci faktury");
                    pdfFileContent = "";
                }
                if (CollectionUtils.isNotEmpty(attachmentServices)) {
                    log.info((Object)("Ilosc znalezionych obslug zalacznikow dla dostawcy i monitorowanej skrzynki: " + attachmentServices.size()));
                    String reducedContent = pdfFileContent.toLowerCase().replaceAll(Constants.ENTER, " ");
                    for (Attachment oneAttachmentService : attachmentServices) {
                        switch (oneAttachmentService.getDetectionType()) {
                            case PHRASE_IN_FILE_NAME: {
                                if (!attachmentName.toLowerCase().contains(oneAttachmentService.getDetectionValue().toLowerCase())) break;
                                throw new AttachmentServiceException(oneAttachmentService, message, file, additionalOptions);
                            }
                            case PHRASE_NOT_IN_FILE_NAME: {
                                if (attachmentName.toLowerCase().contains(oneAttachmentService.getDetectionValue().toLowerCase())) break;
                                throw new AttachmentServiceException(oneAttachmentService, message, file, additionalOptions);
                            }
                            case PHRASE_IN_CONTENT: {
                                if (!reducedContent.contains(oneAttachmentService.getDetectionValue().toLowerCase())) break;
                                throw new AttachmentServiceException(oneAttachmentService, message, file, additionalOptions);
                            }
                            case PHRASE_NOT_IN_CONTENT: {
                                if (reducedContent.contains(oneAttachmentService.getDetectionValue().toLowerCase())) break;
                                throw new AttachmentServiceException(oneAttachmentService, message, file, additionalOptions);
                            }
                            case TEMPLATE_MISMATCH: {
                                templateMismatchAttService = oneAttachmentService;
                                break;
                            }
                        }
                    }
                }
                log.info((Object)("Wyszukiwanie szablonow dla dostawcy '" + emailAddress + "' i monitorowanej skrzynki '" + mailboxEmail + "'"));
                if (CollectionUtils.isNotEmpty(templates)) {
                    log.info((Object)("Ilosc znalezionych szablonow dla dostawcy i monitorowanej skrzynki: " + templates.size()));
                    for (Template oneTemplate : templates) {
                        if (oneTemplate == null) continue;
                        TemplatePhraseLocation phraseLocation = oneTemplate.getTemplateDefinition().getPhraseLocation();
                        String phrase = oneTemplate.getTemplateDefinition().getPhrase();
                        if (phraseLocation.equals((Object)TemplatePhraseLocation.UNKNOWN)) {
                            log.info((Object)"Wykorzystanie szablonu nadrzednego");
                            template = oneTemplate;
                            break;
                        }
                        if (StringUtils.isBlank((CharSequence)phrase)) continue;
                        log.info((Object)("Weryfikowanie kryteriow szablonu. Poszukiwana fraza: " + phrase));
                        if (phraseLocation.equals((Object)TemplatePhraseLocation.SUBJECT)) {
                            log.info((Object)"Sprawdzanie tematu wiadomosci");
                            if (!PlusEFakturaEngine.isPhraseInContent(emailSubject, phrase)) continue;
                            log.info((Object)("Znaleziono fraze " + phrase + " w temacie wiadomosci"));
                            template = oneTemplate;
                            break;
                        }
                        if (phraseLocation.equals((Object)TemplatePhraseLocation.CONTENT)) {
                            log.info((Object)"Sprawdzanie zawartosci wiadomosci");
                            if (!PlusEFakturaEngine.isPhraseInContent(emailContent, phrase)) continue;
                            log.info((Object)("Znaleziono fraze " + phrase + " w zawartosci wiadomosci"));
                            template = oneTemplate;
                            break;
                        }
                        if (phraseLocation.equals((Object)TemplatePhraseLocation.FILE_NAME)) {
                            log.info((Object)"Sprawdzanie nazwy zalacznika");
                            if (!PlusEFakturaEngine.isPhraseInContent(attachmentName, phrase)) continue;
                            log.info((Object)("Znaleziono fraze " + phrase + " w nazwie zalacznika"));
                            template = oneTemplate;
                            break;
                        }
                        if (!phraseLocation.equals((Object)TemplatePhraseLocation.ATTACHMENT)) continue;
                        log.info((Object)"Sprawdzanie zawartosci zalacznika");
                        if (!PlusEFakturaEngine.isPhraseInContent(pdfFileContent, phrase)) continue;
                        log.info((Object)("Znaleziono fraze " + phrase + " w zawartosci zalacznika"));
                        template = oneTemplate;
                        break;
                    }
                }
                if (template == null) {
                    addResult.setMsgStatus(MsgStatus.NO_TEMPLATE_FOUND);
                    throw new PlusEFakturaException("Nie istnieje szablon dla dostawcy o adresie " + emailAddress + " spelniajacy kryteria");
                }
                log.info((Object)("Wykorzystanie szablonu o identyfikatorze " + template.getId()));
                long fileId = template.getTemplateDefinition().getFileId();
                FileService fileService = ServiceFactory.getFileService();
                WfFile wfFile = fileService.getFile(Long.valueOf(fileId), new String[0]);
                if (wfFile == null || StringUtils.isBlank((CharSequence)wfFile.getFullPath())) {
                    addResult.setMsgStatus(MsgStatus.NO_TEMPLATE_PATH_FOUND);
                    throw new PlusEFakturaException("Brak sciezki do szablonu o identyfikatorze " + template.getId() + " dla dostawcy o adresie e-mail " + emailAddress);
                }
                sTemplatePath = wfFile.getFullPath();
                xmlFileContent = xmlAnalyzerService.convertXMLFileToStringFromFilePath(sTemplatePath);
                xmlTemplate = xmlAnalyzerService.convertStringToXMLFile(xmlFileContent);
                if (xmlTemplate == null) {
                    addResult.setMsgStatus(MsgStatus.TEMPLATE_ERROR);
                    throw new PlusEFakturaException("Nie udalo sie pobrac szablonu XML faktur dla dostawcy o adresie e-mail" + emailAddress);
                }
                xmlTemplate.getDocumentElement().normalize();
                Element root = xmlTemplate.getDocumentElement();
                String rootName = root.getNodeName();
                if (!rootName.equals("PlusEFakturaTemplate")) {
                    addResult.setMsgStatus(MsgStatus.TEMPLATE_ERROR);
                    throw new PlusEFakturaException("Szablon nie jest szablonem modulu Plus E-faktura. Wstrzymano mapowanie indeksow z zawartosci pliku pdf");
                }
                String version = root.getAttribute("version");
                if (StringUtils.isBlank((CharSequence)version)) {
                    addResult.setMsgStatus(MsgStatus.NO_TEMPLATE_VERSION);
                    throw new PlusEFakturaException("Brak wersji szablonu. Wstrzymano mapowanie indeksow z zawartosci pliku pdf");
                }
                switch (TemplateVersion.getTemplateVersionByName(version)) {
                    case PDFBOX_0_7_3: {
                        log.info((Object)"Szablon w wersji 1.0");
                        pdfFileContent = PDFAnalyzer.readPDFWithPdfBox_0_7_3(file);
                        break;
                    }
                    case PDFBOX_1_7_1: {
                        log.info((Object)"Szablon w wersji 2.0");
                        break;
                    }
                    default: {
                        addResult.setMsgStatus(MsgStatus.UNKNOWN_TEMPLATE_VERSION);
                        throw new PlusEFakturaException("Nieznana wersja szablonu. Wstrzymano mapowanie indeksow z zawartosci pliku pdf");
                    }
                }
                engineResult.setAttachmentContent(pdfFileContent);
                try {
                    try {
                        indexMap = this.buildIndexMap(xmlTemplate);
                    }
                    catch (PlusEFakturaException e) {
                        log.warn((Object)e.getMessage());
                        clientLog.warn((Object)e.getMessage());
                        if (templateMismatchAttService != null) {
                            throw new AttachmentServiceException(templateMismatchAttService, message, file, additionalOptions);
                        }
                        PlusEFakturaTools.handleException(additionalOptions);
                    }
                    catch (Exception e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                        if (templateMismatchAttService != null) {
                            throw new AttachmentServiceException(templateMismatchAttService, message, file, additionalOptions);
                        }
                        PlusEFakturaTools.handleException(additionalOptions);
                    }
                }
                catch (AttachmentServiceException e) {
                    throw e;
                }
                catch (Exception e) {
                    addResult.setMsgStatus(MsgStatus.TEMPLATE_ERROR);
                    log.error((Object)e.getMessage());
                    throw new PlusEFakturaException("Blad podczas parsowania szablonu faktury dla dostawcy o adresie " + emailAddress);
                }
                if (indexMap.getAll() == null || indexMap.getAll().size() <= 0) {
                    addResult.setMsgStatus(MsgStatus.NO_MAPPING_FOUND);
                    throw new PlusEFakturaException("Nie wykryto zadnego mapowania indeksow z faktury pdf. Sprawdz szablon");
                }
                isEInvoice = true;
                log.info((Object)"Proba mapowania indeksow z zawartosci pliku pdf");
                try {
                    Set<PlusEFakturaEngineResult> results = this.solve(indexMap, file, pdfFileContent, addResult, engineResult, templateMismatchAttService, message, additionalOptions);
                    for (PlusEFakturaEngineResult oneResult : results) {
                        String thisIndexId = PlusEFakturaTools.getIndexIdForDocClass(archiveClass, oneResult.getName());
                        if (!thisIndexId.equalsIgnoreCase("-1")) {
                            EFakturaIndecies.add(thisIndexId + ";" + oneResult.getValue());
                            log.info((Object)("Mapowanie indeksu " + oneResult.getName() + " na podstawie szablonu z zawartosci pliku pdf zakonczone powodzeniem"));
                            engineResult.setElectronicInvoice(true);
                            continue;
                        }
                        log.warn((Object)("Indeks o nazwie " + oneResult.getName() + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                    }
                }
                catch (PlusEFakturaException e) {
                    log.warn((Object)e.getMessage());
                    clientLog.warn((Object)e.getMessage());
                    addResult.setMsgStatus(MsgStatus.INDEX_MAPPING_EXCEPTION);
                    addResult.addUnmappedIndex(indexElementName);
                    if (templateMismatchAttService != null) {
                        throw new AttachmentServiceException(templateMismatchAttService, message, file, additionalOptions);
                    }
                    PlusEFakturaTools.handleException(additionalOptions);
                    engineResult.setElectronicInvoice(false);
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    addResult.setMsgStatus(MsgStatus.INDEX_MAPPING_EXCEPTION);
                    addResult.addUnmappedIndex(indexElementName);
                    if (templateMismatchAttService != null) {
                        throw new AttachmentServiceException(templateMismatchAttService, message, file, additionalOptions);
                    }
                    PlusEFakturaTools.handleException(additionalOptions);
                    engineResult.setElectronicInvoice(false);
                }
            }
            catch (PlusEFakturaException e) {
                log.warn((Object)e.getMessage());
                clientLog.warn((Object)e.getMessage());
                if (templateMismatchAttService != null) {
                    throw new AttachmentServiceException(templateMismatchAttService, message, file, additionalOptions);
                }
                if (!indexesFromSubject) {
                    PlusEFakturaTools.handleException(additionalOptions);
                }
            }
            catch (AttachmentServiceException e) {
                throw e;
            }
            catch (IndexesMappingException e) {
                throw e;
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                if (templateMismatchAttService != null) {
                    throw new AttachmentServiceException(templateMismatchAttService, message, file, additionalOptions);
                }
                if (indexesFromSubject) break block57;
                PlusEFakturaTools.handleException(additionalOptions);
            }
        }
        try {
            if (!eInvoiceIndexId.equalsIgnoreCase("-1")) {
                if (isEInvoice) {
                    EFakturaIndecies.add(eInvoiceIndexId + ";TAK");
                } else {
                    EFakturaIndecies.add(eInvoiceIndexId + ";NIE");
                }
            } else {
                log.warn((Object)("Indeks o nazwie Faktura elektroniczna nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
        }
        engineResult.setIndexes(EFakturaIndecies);
        return engineResult;
    }

    /*
     * Unable to fully structure code
     */
    public IndexElement buildIndexMap(Document xmlTemplate) throws PlusEFakturaException {
        indexMap = new IndexElement();
        indexElementName = "";
        type = "";
        value = "";
        location = "";
        lines = -1;
        spaces = -1;
        words = 0;
        lastvalue = "";
        repeat = false;
        eliminateDuplication = false;
        startRow = -1;
        startColumn = -1;
        endRow = -1;
        endColumn = -1;
        regex = "";
        matchingNo = 0;
        fixedValue = "";
        xStartPos = new Float(0.0f).floatValue();
        xStopPos = new Float(0.0f).floatValue();
        mergedLines = 0;
        tableEnd = "";
        recordFormatAction = "";
        formatAction = "";
        format1 = "";
        format2 = "";
        format3 = "";
        wordsUsed = true;
        lastvalueUsed = true;
        indexList = xmlTemplate.getElementsByTagName("Index");
        for (i = 0; i < indexList.getLength(); ++i) {
            indexElementName = "";
            type = "";
            value = "";
            location = "";
            lines = -1;
            spaces = -1;
            words = 0;
            lastvalue = "";
            repeat = false;
            eliminateDuplication = false;
            startRow = -1;
            startColumn = -1;
            endRow = -1;
            endColumn = -1;
            regex = "";
            matchingNo = 0;
            fixedValue = "";
            xStartPos = new Float(0.0f).floatValue();
            xStopPos = new Float(0.0f).floatValue();
            mergedLines = 0;
            tableEnd = "";
            recordFormatAction = "";
            formatAction = "";
            format1 = "";
            format2 = "";
            format3 = "";
            oneTag = new TagElement();
            oneIndex = indexList.item(i);
            if (oneIndex.getNodeType() != 1) continue;
            indexElem = (Element)oneIndex;
            indexElementName = indexElem.getAttribute("name");
            if (StringUtils.isBlank((CharSequence)indexElementName)) {
                throw new PlusEFakturaException("Brak nazwy dla indeksu numer " + (i + 1));
            }
            tagElem = null;
            try {
                tagList = indexElem.getElementsByTagName("Tag");
                tagElem = (Element)tagList.item(0);
            }
            catch (Exception e) {
                throw new PlusEFakturaException("Brak tagu <Tag> w definicji szablonu dla indeksu o nazwie " + indexElementName);
            }
            type = tagElem.getAttribute("type");
            if (StringUtils.isBlank((CharSequence)type)) {
                throw new PlusEFakturaException("Brak okreslonego typu tagu <Tag> dla indeksu o nazwie " + indexElementName);
            }
            if (!(type.equalsIgnoreCase("Fixed") || type.equalsIgnoreCase("Movable") || type.equalsIgnoreCase("Value") || type.equalsIgnoreCase("TableIndex") || type.equalsIgnoreCase("RecordIndex"))) {
                throw new PlusEFakturaException("W szablonie dla indeksu " + indexElementName + " w atrybucie type dozwolone sa tylko wartosci Fixed, Movable, Value, TableIndex i RecordIndex");
            }
            if (type.equalsIgnoreCase("Value")) {
                try {
                    fixedValueList = tagElem.getElementsByTagName("FixedValue");
                    fixedValueElem = (Element)fixedValueList.item(0);
                    fixedValueValue = fixedValueElem.getChildNodes();
                    if (fixedValueValue == null || fixedValueValue.getLength() <= 0 || (fixedValue = fixedValueValue.item(0).getNodeValue()) != null) ** GOTO lbl475
                    fixedValue = "";
                }
                catch (Exception e) {
                    throw new PlusEFakturaException("Element FixedValue dla indeksu " + indexElementName + " nie istnieje");
                }
            } else {
                if (type.equalsIgnoreCase("Fixed")) {
                    try {
                        startRowList = tagElem.getElementsByTagName("StartRow");
                        startRowElem = (Element)startRowList.item(0);
                        startRowValue = startRowElem.getChildNodes();
                        startRow = Integer.parseInt(startRowValue.item(0).getNodeValue());
                    }
                    catch (NumberFormatException e) {
                        throw new PlusEFakturaException("Element StartRow dla indeksu " + indexElementName + " musi byc wartoscia liczbowa");
                    }
                    catch (Exception e) {
                        throw new PlusEFakturaException("Element StartRow dla indeksu " + indexElementName + " nie istnieje lub nie posiada wartosci");
                    }
                    if (startRow <= 0) {
                        throw new PlusEFakturaException("Element StartRow dla indeksu " + indexElementName + " posiada zabroniona wartosc niedodatnia");
                    }
                    try {
                        startColumnList = tagElem.getElementsByTagName("StartColumn");
                        startColumnElem = (Element)startColumnList.item(0);
                        startColumnValue = startColumnElem.getChildNodes();
                        startColumn = Integer.parseInt(startColumnValue.item(0).getNodeValue());
                    }
                    catch (NumberFormatException e) {
                        throw new PlusEFakturaException("Element StartColumn dla indeksu " + indexElementName + " musi byc wartoscia liczbowa");
                    }
                    catch (Exception e) {
                        throw new PlusEFakturaException("Element StartColumn dla indeksu " + indexElementName + " nie istnieje lub nie posiada wartosci");
                    }
                    if (startColumn <= 0) {
                        throw new PlusEFakturaException("Element StartColumn dla indeksu " + indexElementName + " posiada zabroniona wartosc niedodatnia");
                    }
                    try {
                        endRowList = tagElem.getElementsByTagName("EndRow");
                        endRowElem = (Element)endRowList.item(0);
                        endRowValue = endRowElem.getChildNodes();
                        endRow = Integer.parseInt(endRowValue.item(0).getNodeValue());
                    }
                    catch (NumberFormatException e) {
                        throw new PlusEFakturaException("Element EndRow dla indeksu " + indexElementName + " musi byc wartoscia liczbowa");
                    }
                    catch (Exception e) {
                        throw new PlusEFakturaException("Element EndRow dla indeksu " + indexElementName + " nie istnieje lub nie posiada wartosci");
                    }
                    if (endRow <= 0) {
                        throw new PlusEFakturaException("Element EndRow dla indeksu " + indexElementName + " posiada zabroniona wartosc niedodatnia");
                    }
                    try {
                        endColumnList = tagElem.getElementsByTagName("EndColumn");
                        endColumnElem = (Element)endColumnList.item(0);
                        endColumnValue = endColumnElem.getChildNodes();
                        endColumn = Integer.parseInt(endColumnValue.item(0).getNodeValue());
                    }
                    catch (NumberFormatException e) {
                        throw new PlusEFakturaException("Element EndColumn dla indeksu " + indexElementName + " musi byc wartoscia liczbowa");
                    }
                    catch (Exception e) {
                        throw new PlusEFakturaException("Element EndColumn dla indeksu " + indexElementName + " nie istnieje lub nie posiada wartosci");
                    }
                    if (endColumn < 0) {
                        throw new PlusEFakturaException("Element EndColumn dla indeksu " + indexElementName + " posiada zabroniona wartosc ujemna");
                    }
                    if (startRow > endRow) {
                        throw new PlusEFakturaException("Element StartRow posiada wieksza wartosc od elementu EndRow dla indeksu " + indexElementName);
                    }
                    if (startRow == endRow && startColumn >= endColumn) {
                        throw new PlusEFakturaException("Element StartColumn posiada wartosc niemniejsza od elementu EndColumn (niedozwolone w przypadku identycznych wartosci elementow StartRow i EndRow) dla indeksu " + indexElementName);
                    }
                } else if (type.equalsIgnoreCase("Movable")) {
                    try {
                        valueList = tagElem.getElementsByTagName("Value");
                        valueElem = (Element)valueList.item(0);
                        valueValue = valueElem.getChildNodes();
                        value = valueValue.item(0).getNodeValue();
                    }
                    catch (Exception e) {
                        throw new PlusEFakturaException("Element Value dla indeksu " + indexElementName + " nie istnieje lub nie posiada wartosci");
                    }
                    if (StringUtils.isBlank((CharSequence)value)) {
                        throw new PlusEFakturaException("Element Value dla indeksu " + indexElementName + " nie posiada wartosci");
                    }
                    try {
                        locationList = tagElem.getElementsByTagName("Location");
                        locationElem = (Element)locationList.item(0);
                        locationValue = locationElem.getChildNodes();
                        location = locationValue.item(0).getNodeValue();
                    }
                    catch (Exception e) {
                        throw new PlusEFakturaException("Element Location dla indeksu " + indexElementName + " nie istnieje lub nie posiada wartosci");
                    }
                    if (location == null || !location.equalsIgnoreCase("After") && !location.equalsIgnoreCase("Before")) {
                        throw new PlusEFakturaException("W szablonie w elemencie Location dla indeksu " + indexElementName + " dozwolone sa tylko wartosci After i Before");
                    }
                    try {
                        linesList = tagElem.getElementsByTagName("Lines");
                        linesElem = (Element)linesList.item(0);
                        linesValue = linesElem.getChildNodes();
                        lines = Integer.parseInt(linesValue.item(0).getNodeValue());
                    }
                    catch (NumberFormatException e) {
                        throw new PlusEFakturaException("Element Lines dla indeksu " + indexElementName + " musi byc wartoscia liczbowa");
                    }
                    catch (Exception e) {
                        throw new PlusEFakturaException("Element Lines dla indeksu " + indexElementName + " nie istnieje lub nie posiada wartosci");
                    }
                    try {
                        spacesList = tagElem.getElementsByTagName("Spaces");
                        spacesElem = (Element)spacesList.item(0);
                        spacesValue = spacesElem.getChildNodes();
                        spaces = Integer.parseInt(spacesValue.item(0).getNodeValue());
                    }
                    catch (NumberFormatException e) {
                        throw new PlusEFakturaException("Element Spaces dla indeksu " + indexElementName + " musi byc wartoscia liczbowa");
                    }
                    catch (Exception e) {
                        throw new PlusEFakturaException("Element Spaces dla indeksu " + indexElementName + " nie istnieje lub nie posiada wartosci");
                    }
                    if (lines < 0 || spaces < 0) {
                        throw new PlusEFakturaException("Wartosci elementow Lines i Words dla indeksu " + indexElementName + " nie maja oczekiwanych wartosci nieujemnych");
                    }
                    wordsList = tagElem.getElementsByTagName("Words");
                    wordsElem = (Element)wordsList.item(0);
                    wordsValue = wordsElem.getChildNodes();
                    try {
                        words = Integer.parseInt(wordsValue.item(0).getNodeValue());
                        wordsUsed = true;
                    }
                    catch (Exception e) {
                        wordsUsed = false;
                    }
                    if (wordsUsed && words < 1) {
                        throw new PlusEFakturaException("Wartosc elementu Words dla indeksu " + indexElementName + " ma zabroniona wartosc mniejsza od 1");
                    }
                    try {
                        lastvalueList = tagElem.getElementsByTagName("LastValue");
                        lastvalueElem = (Element)lastvalueList.item(0);
                        lastvalueValue = lastvalueElem.getChildNodes();
                        lastvalue = lastvalueValue.item(0).getNodeValue();
                        lastvalueUsed = !StringUtils.isBlank((CharSequence)lastvalue);
                    }
                    catch (Exception e) {
                        lastvalueUsed = false;
                    }
                    if (lastvalueUsed && wordsUsed) {
                        throw new PlusEFakturaException("W szablonie dla indeksu " + indexElementName + " okreslono jednoczesnie elementy Words i LastValue. Wymagane jest okreslenie tylko jednego z nich");
                    }
                    if (!lastvalueUsed && !wordsUsed) {
                        throw new PlusEFakturaException("W szablonie dla indeksu " + indexElementName + " nie okreslono ani elementu Words ani LastValue. Wymagane jest okreslenie tylko jednego z nich");
                    }
                    repeatStringValue = "";
                    try {
                        repeatList = tagElem.getElementsByTagName("Repeat");
                        repeatElem = (Element)repeatList.item(0);
                        repeatValue = repeatElem.getChildNodes();
                        repeatStringValue = repeatValue.item(0).getNodeValue();
                    }
                    catch (Exception e) {
                        repeatStringValue = "False";
                    }
                    if (repeatStringValue == null || !repeatStringValue.equalsIgnoreCase("True") && !repeatStringValue.equalsIgnoreCase("False")) {
                        throw new PlusEFakturaException("W szablonie w elemencie Repeat dla indeksu " + indexElementName + " dozwolone sa tylko wartosci True i False.");
                    }
                    repeat = Boolean.parseBoolean(repeatStringValue);
                    eliminateDuplicationStringValue = "";
                    try {
                        eliminateDuplicationList = tagElem.getElementsByTagName("EliminateDuplication");
                        eliminateDuplicationElem = (Element)eliminateDuplicationList.item(0);
                        eliminateDuplicationValue = eliminateDuplicationElem.getChildNodes();
                        eliminateDuplicationStringValue = eliminateDuplicationValue.item(0).getNodeValue();
                    }
                    catch (Exception e) {
                        eliminateDuplicationStringValue = "False";
                    }
                    if (eliminateDuplicationStringValue == null || !eliminateDuplicationStringValue.equalsIgnoreCase("True") && !eliminateDuplicationStringValue.equalsIgnoreCase("False")) {
                        throw new PlusEFakturaException("W szablonie w elemencie EliminateDuplication dla indeksu " + indexElementName + " dozwolone sa tylko wartosci True i False.");
                    }
                    eliminateDuplication = Boolean.parseBoolean(eliminateDuplicationStringValue);
                } else if (type.equalsIgnoreCase("TableIndex")) {
                    try {
                        valueList = tagElem.getElementsByTagName("Value");
                        valueElem = (Element)valueList.item(0);
                        valueValue = valueElem.getChildNodes();
                        value = valueValue.item(0).getNodeValue();
                    }
                    catch (Exception e) {
                        throw new PlusEFakturaException("Element Value dla indeksu " + indexElementName + " nie istnieje lub nie posiada wartosci");
                    }
                    if (StringUtils.isBlank((CharSequence)value)) {
                        throw new PlusEFakturaException("Element Value dla indeksu " + indexElementName + " nie posiada wartosci");
                    }
                    try {
                        lastValueList = tagElem.getElementsByTagName("LastValue");
                        lastValueElem = (Element)lastValueList.item(0);
                        lastValueValue = lastValueElem.getChildNodes();
                        lastvalue = lastValueValue.item(0).getNodeValue();
                    }
                    catch (Exception e) {
                        throw new PlusEFakturaException("Element LastValue dla indeksu " + indexElementName + " nie istnieje lub nie posiada wartosci");
                    }
                    if (StringUtils.isBlank((CharSequence)lastvalue)) {
                        throw new PlusEFakturaException("Element LastValue dla indeksu " + indexElementName + " nie posiada wartosci");
                    }
                    try {
                        xStartPosList = tagElem.getElementsByTagName("XStartPos");
                        xStartPosElem = (Element)xStartPosList.item(0);
                        xStartPosValue = xStartPosElem.getChildNodes();
                        xStartPos = Float.parseFloat(xStartPosValue.item(0).getNodeValue().replaceAll(",", "."));
                    }
                    catch (NumberFormatException e) {
                        throw new PlusEFakturaException("Element XStartPos dla indeksu " + indexElementName + " musi byc wartoscia liczbowa");
                    }
                    catch (Exception e) {
                        throw new PlusEFakturaException("Element XStartPos dla indeksu " + indexElementName + " nie istnieje lub nie posiada wartosci");
                    }
                    try {
                        xStopPosList = tagElem.getElementsByTagName("XStopPos");
                        xStopPosElem = (Element)xStopPosList.item(0);
                        xStopPosValue = xStopPosElem.getChildNodes();
                        xStopPos = Float.parseFloat(xStopPosValue.item(0).getNodeValue().replaceAll(",", "."));
                    }
                    catch (NumberFormatException e) {
                        throw new PlusEFakturaException("Element XStopPos dla indeksu " + indexElementName + " musi byc wartoscia liczbowa");
                    }
                    catch (Exception e) {
                        throw new PlusEFakturaException("Element XStopPos dla indeksu " + indexElementName + " nie istnieje lub nie posiada wartosci");
                    }
                    if (xStartPos < 0.0f || xStopPos < 0.0f) {
                        throw new PlusEFakturaException("Wartosci elementow XStartPos i XStopPos dla indeksu o nazwie " + indexElementName + " nie maja oczekiwanych wartosci nieujemnych");
                    }
                    if (xStopPos <= xStartPos) {
                        throw new PlusEFakturaException("Element XStartPo_ posiada wieksza wartosc od elementu XStopPos dla indeksu o nazwie " + indexElementName);
                    }
                    try {
                        mergedLinesList = tagElem.getElementsByTagName("MergedLines");
                        mergedLinesElem = (Element)mergedLinesList.item(0);
                        mergedLinesValue = mergedLinesElem.getChildNodes();
                        mergedLines = Integer.parseInt(mergedLinesValue.item(0).getNodeValue());
                    }
                    catch (NumberFormatException e) {
                        throw new PlusEFakturaException("Element MergedLines dla indeksu " + indexElementName + " musi byc wartoscia liczbowa");
                    }
                    catch (Exception e) {
                        throw new PlusEFakturaException("Element MergedLines dla indeksu " + indexElementName + " nie istnieje lub nie posiada wartosci");
                    }
                    if (mergedLines < 0) {
                        throw new PlusEFakturaException("Element MergedLines dla indeksu o nazwie " + indexElementName + " posiada zabroniona wartosc ujemna");
                    }
                    eliminateDuplicationStringValue = "";
                    try {
                        eliminateDuplicationList = tagElem.getElementsByTagName("EliminateDuplication");
                        eliminateDuplicationElem = (Element)eliminateDuplicationList.item(0);
                        eliminateDuplicationValue = eliminateDuplicationElem.getChildNodes();
                        eliminateDuplicationStringValue = eliminateDuplicationValue.item(0).getNodeValue();
                    }
                    catch (Exception e) {
                        eliminateDuplicationStringValue = "False";
                    }
                    if (eliminateDuplicationStringValue == null || !eliminateDuplicationStringValue.equalsIgnoreCase("True") && !eliminateDuplicationStringValue.equalsIgnoreCase("False")) {
                        throw new PlusEFakturaException("W szablonie w elemencie EliminateDuplication dla indeksu " + indexElementName + " dozwolone sa tylko wartosci True i False.");
                    }
                    eliminateDuplication = Boolean.parseBoolean(eliminateDuplicationStringValue);
                } else if (type.equalsIgnoreCase("RecordIndex")) {
                    try {
                        valueList = tagElem.getElementsByTagName("Value");
                        valueElem = (Element)valueList.item(0);
                        valueValue = valueElem.getChildNodes();
                        value = valueValue.item(0).getNodeValue();
                    }
                    catch (Exception e) {
                        throw new PlusEFakturaException("Element Value dla indeksu " + indexElementName + " nie istnieje lub nie posiada wartosci");
                    }
                    if (StringUtils.isBlank((CharSequence)value)) {
                        throw new PlusEFakturaException("Element Value dla indeksu " + indexElementName + " nie posiada wartosci");
                    }
                    try {
                        lastValueList = tagElem.getElementsByTagName("LastValue");
                        lastValueElem = (Element)lastValueList.item(0);
                        lastValueValue = lastValueElem.getChildNodes();
                        lastvalue = lastValueValue.item(0).getNodeValue();
                    }
                    catch (Exception e) {
                        throw new PlusEFakturaException("Element LastValue dla indeksu " + indexElementName + " nie istnieje lub nie posiada wartosci");
                    }
                    if (StringUtils.isBlank((CharSequence)lastvalue)) {
                        throw new PlusEFakturaException("Element LastValue dla indeksu " + indexElementName + " nie posiada wartosci");
                    }
                    try {
                        tableEndList = tagElem.getElementsByTagName("TableEnd");
                        tableEndElem = (Element)tableEndList.item(0);
                        tableEndValue = tableEndElem.getChildNodes();
                        tableEnd = tableEndValue.item(0).getNodeValue();
                    }
                    catch (Exception e) {
                        throw new PlusEFakturaException("Element TableEnd dla indeksu " + indexElementName + " nie istnieje lub nie posiada wartosci");
                    }
                    if (StringUtils.isBlank((CharSequence)tableEnd)) {
                        throw new PlusEFakturaException("Element TableEnd dla indeksu " + indexElementName + " nie posiada wartosci");
                    }
                    try {
                        xStartPosList = tagElem.getElementsByTagName("XStartPos");
                        xStartPosElem = (Element)xStartPosList.item(0);
                        xStartPosValue = xStartPosElem.getChildNodes();
                        xStartPos = Float.parseFloat(xStartPosValue.item(0).getNodeValue().replaceAll(",", "."));
                    }
                    catch (NumberFormatException e) {
                        throw new PlusEFakturaException("Element XStartPos dla indeksu " + indexElementName + " musi byc wartoscia liczbowa");
                    }
                    catch (Exception e) {
                        throw new PlusEFakturaException("Element XStartPos dla indeksu " + indexElementName + " nie istnieje lub nie posiada wartosci");
                    }
                    try {
                        xStopPosList = tagElem.getElementsByTagName("XStopPos");
                        xStopPosElem = (Element)xStopPosList.item(0);
                        xStopPosValue = xStopPosElem.getChildNodes();
                        xStopPos = Float.parseFloat(xStopPosValue.item(0).getNodeValue().replaceAll(",", "."));
                    }
                    catch (NumberFormatException e) {
                        throw new PlusEFakturaException("Element XStopPos dla indeksu " + indexElementName + " musi byc wartoscia liczbowa");
                    }
                    catch (Exception e) {
                        throw new PlusEFakturaException("Element XStopPos dla indeksu " + indexElementName + " nie istnieje lub nie posiada wartosci");
                    }
                    if (xStartPos < 0.0f || xStopPos < 0.0f) {
                        throw new PlusEFakturaException("Wartosci elementow XStartPos i XStopPos dla indeksu o nazwie " + indexElementName + " nie maja oczekiwanych wartosci nieujemnych");
                    }
                    if (xStopPos <= xStartPos) {
                        throw new PlusEFakturaException("Element XStartPo_ posiada wieksza wartosc od elementu XStopPos dla indeksu o nazwie " + indexElementName);
                    }
                    try {
                        recordFormatActionList = tagElem.getElementsByTagName("RecordFormatAction");
                        recordFormatActionElem = (Element)recordFormatActionList.item(0);
                        recordFormatActionValue = recordFormatActionElem.getChildNodes();
                        recordFormatAction = recordFormatActionValue.item(0).getNodeValue();
                    }
                    catch (Exception e) {
                        throw new PlusEFakturaException("Element RecordFormatAction dla indeksu " + indexElementName + " nie istnieje lub nie posiada wartosci");
                    }
                    if (StringUtils.isBlank((CharSequence)recordFormatAction)) {
                        throw new PlusEFakturaException("Element RecordFormatAction dla indeksu " + indexElementName + " nie posiada wartosci");
                    }
                }
                try {
                    regexList = tagElem.getElementsByTagName("Regex");
                    regexElem = (Element)regexList.item(0);
                    regexValue = regexElem.getChildNodes();
                    regex = regexValue.item(0).getNodeValue();
                }
                catch (Exception e) {
                    regex = "";
                }
                if (StringUtils.isNotBlank((CharSequence)regex)) {
                    try {
                        Pattern.compile(regex);
                    }
                    catch (PatternSyntaxException e) {
                        throw new PlusEFakturaException("W szablonie dla indeksu " + indexElementName + " niepoprawnie okreslono wyrazenie regularne w polu Regex");
                    }
                    sMatchingNo = "";
                    try {
                        matchingNoList = tagElem.getElementsByTagName("MatchingNo");
                        matchingNoElem = (Element)matchingNoList.item(0);
                        matchingNoValue = matchingNoElem.getChildNodes();
                        sMatchingNo = matchingNoValue.item(0).getNodeValue();
                    }
                    catch (Exception e) {
                        sMatchingNo = "";
                    }
                    try {
                        if (StringUtils.isBlank((CharSequence)sMatchingNo)) {
                            throw new PlusEFakturaException("W szablonie dla indeksu " + indexElementName + " nie okreslono pola MatchingNo, ktore jest obowiazkowe w przypadku podania pola Regex");
                        }
                        matchingNo = Integer.valueOf(sMatchingNo);
                        if (matchingNo < 0) {
                            throw new PlusEFakturaException("Wartosc elementu MatchingNo dla indeksu " + indexElementName + " ma zabroniona ujemna wartosc");
                        }
                    }
                    catch (NumberFormatException e) {
                        throw new PlusEFakturaException("Element MantchingNo dla indeksu o nazwie  " + indexElementName + " musi byc wartoscia liczbowa");
                    }
                }
                formatActionList = null;
                formatActionElem = null;
                try {
                    formatActionList = tagElem.getElementsByTagName("FormatAction");
                    formatActionElem = (Element)formatActionList.item(0);
                    formatActionValue = formatActionElem.getChildNodes();
                    formatAction = formatActionValue.item(0).getNodeValue();
                }
                catch (Exception e) {
                    formatAction = "";
                }
                if (StringUtils.isNotBlank((CharSequence)formatAction) && formatActionElem != null && !formatAction.equalsIgnoreCase("Text as amount")) {
                    if (formatAction.equalsIgnoreCase("Date format")) {
                        format1 = formatActionElem.getAttribute("fromDate");
                        format2 = formatActionElem.getAttribute("toDate");
                        format3 = formatActionElem.getAttribute("language");
                        if (StringUtils.isBlank((CharSequence)format1)) {
                            throw new PlusEFakturaException("Brak atrybutu fromDate dla wybranego formatowania dla indeksu o nazwie " + indexElementName);
                        }
                        try {
                            new SimpleDateFormat(format1);
                        }
                        catch (IllegalArgumentException e) {
                            throw new PlusEFakturaException("Niedozwolony format daty w atrybucie fromDate dla wybranego formatowania dla indeksu o nazwie " + indexElementName);
                        }
                        if (StringUtils.isBlank((CharSequence)format2)) {
                            throw new PlusEFakturaException("Brak atrybutu toDate dla wybranego formatowania dla indeksu o nazwie " + indexElementName);
                        }
                        try {
                            new SimpleDateFormat(format2);
                        }
                        catch (IllegalArgumentException e) {
                            throw new PlusEFakturaException("Niedozwolony format daty w atrybucie toDate dla wybranego formatowania dla indeksu o nazwie " + indexElementName);
                        }
                    }
                    if (formatAction.equalsIgnoreCase("Add days")) {
                        format1 = formatActionElem.getAttribute("addDaysTo");
                        format2 = formatActionElem.getAttribute("fromDate");
                        format3 = formatActionElem.getAttribute("toDate");
                        if (StringUtils.isBlank((CharSequence)format1)) {
                            throw new PlusEFakturaException("Brak atrybutu addDaysTo dla wybranego formatowania dla indeksu o nazwie " + indexElementName);
                        }
                        if (StringUtils.isBlank((CharSequence)format2)) {
                            throw new PlusEFakturaException("Brak atrybutu fromDate dla wybranego formatowania dla indeksu o nazwie " + indexElementName);
                        }
                        try {
                            new SimpleDateFormat(format2);
                        }
                        catch (IllegalArgumentException e) {
                            throw new PlusEFakturaException("Niedozwolony format daty w atrybucie dateFormat dla wybranego formatowania dla indeksu o nazwie " + indexElementName);
                        }
                        if (StringUtils.isNotBlank((CharSequence)format3)) {
                            try {
                                new SimpleDateFormat(format3);
                            }
                            catch (IllegalArgumentException e) {
                                throw new PlusEFakturaException("Niedozwolony format daty w atrybucie toDate dla wybranego formatowania dla indeksu o nazwie " + indexElementName);
                            }
                        }
                    } else if (formatAction.equalsIgnoreCase("Remove chars")) {
                        format1 = formatActionElem.getAttribute("chars");
                        if (StringUtils.isEmpty((CharSequence)format1)) {
                            throw new PlusEFakturaException("Brak atrybutu chars dla wybranego formatowania dla indeksu o nazwie " + indexElementName);
                        }
                    } else if (formatAction.equalsIgnoreCase("Remove string")) {
                        format1 = formatActionElem.getAttribute("string");
                        if (StringUtils.isEmpty((CharSequence)format1)) {
                            throw new PlusEFakturaException("Brak atrybutu string dla wybranego formatowania dla indeksu o nazwie " + indexElementName);
                        }
                    } else if (formatAction.equalsIgnoreCase("Add prefix") || formatAction.equalsIgnoreCase("Remove prefix")) {
                        format1 = formatActionElem.getAttribute("prefix");
                        if (StringUtils.isEmpty((CharSequence)format1)) {
                            throw new PlusEFakturaException("Brak atrybutu prefix dla wybranego formatowania dla indeksu o nazwie " + indexElementName);
                        }
                    } else if (formatAction.equalsIgnoreCase("Add postfix") || formatAction.equalsIgnoreCase("Remove postfix")) {
                        format1 = formatActionElem.getAttribute("postfix");
                        if (StringUtils.isEmpty((CharSequence)format1)) {
                            throw new PlusEFakturaException("Brak atrybutu postfix dla wybranego formatowania dla indeksu o nazwie " + indexElementName);
                        }
                    } else {
                        throw new PlusEFakturaException("Nieznane formatowanie w tagu FormatAction dla indeksu o nazwie " + indexElementName);
                    }
                }
            }
lbl475:
            // 11 sources

            oneTag.setType(type);
            oneTag.setValue(value);
            oneTag.setLocation(location);
            oneTag.setLines(lines);
            oneTag.setSpaces(spaces);
            oneTag.setWords(words);
            oneTag.setLastvalue(lastvalue);
            oneTag.setRepeat(repeat);
            oneTag.setEliminateDuplication(eliminateDuplication);
            oneTag.setStartRow(startRow);
            oneTag.setStartColumn(startColumn);
            oneTag.setEndRow(endRow);
            oneTag.setEndColumn(endColumn);
            oneTag.setRegex(regex);
            oneTag.setMatchingNo(matchingNo);
            oneTag.setFixedValue(fixedValue);
            oneTag.setXStartPos(xStartPos);
            oneTag.setXStopPos(xStopPos);
            oneTag.setMergedLines(mergedLines);
            oneTag.setTableEnd(tableEnd);
            oneTag.setRecordFormatAction(recordFormatAction);
            oneTag.setFormatAction(formatAction);
            oneTag.setFormat1(format1);
            oneTag.setFormat2(format2);
            oneTag.setFormat3(format3);
            indexMap.setOneTag(indexElementName, oneTag);
        }
        return indexMap;
    }

    public Set<PlusEFakturaEngineResult> solve(IndexElement indexElement, File pdfFile, String pdfFileContent, AddResult addResult, EngineResult engineResult, Attachment templateMismatchAttService, Message message, AdditionalOptions additionalOptions) throws PlusEFakturaException, IndexesMappingException, AttachmentServiceException {
        HashSet<PlusEFakturaEngineResult> results = new HashSet<PlusEFakturaEngineResult>();
        for (String indexName : indexElement.getAll().keySet()) {
            try {
                String indexValue = this.findIndexValueFromTemplate(indexElement, pdfFile, pdfFileContent, indexName);
                results.add(new PlusEFakturaEngineResult(indexName, indexValue));
            }
            catch (PlusEFakturaException e) {
                log.warn((Object)e.getMessage());
                clientLog.warn((Object)e.getMessage());
                addResult.setMsgStatus(MsgStatus.INDEX_MAPPING_EXCEPTION);
                addResult.addUnmappedIndex(indexName);
                if (templateMismatchAttService != null) {
                    throw new AttachmentServiceException(templateMismatchAttService, message, pdfFile, additionalOptions);
                }
                PlusEFakturaTools.handleException(additionalOptions);
                engineResult.setElectronicInvoice(false);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                addResult.setMsgStatus(MsgStatus.INDEX_MAPPING_EXCEPTION);
                addResult.addUnmappedIndex(indexName);
                if (templateMismatchAttService != null) {
                    throw new AttachmentServiceException(templateMismatchAttService, message, pdfFile, additionalOptions);
                }
                PlusEFakturaTools.handleException(additionalOptions);
                engineResult.setElectronicInvoice(false);
            }
        }
        return results;
    }

    private String findIndexValueFromTemplate(IndexElement indexMap, File pdfFile, String pdfFileContent, String indexElementName) throws PlusEFakturaException {
        String thisIndexValue = "";
        TagElement oneTag = indexMap.getOneTag(indexElementName);
        if (oneTag == null) {
            throw new PlusEFakturaException("Brak definicji mapowania indeksu o nazwie " + indexElementName + " w szablonie");
        }
        String type = oneTag.getType();
        String value = oneTag.getValue();
        String location = oneTag.getLocation();
        String lastvalue = oneTag.getLastvalue();
        boolean repeat = oneTag.isRepeat();
        boolean eliminateDuplication = oneTag.isEliminateDuplication();
        int startColumn = oneTag.getStartColumn();
        int endRow = oneTag.getEndRow();
        int endColumn = oneTag.getEndColumn();
        String fixedValue = oneTag.getFixedValue();
        RandomAccessReadBufferedFile read = null;
        PDFParser parser = null;
        COSDocument cosDoc = null;
        PDDocument pdDoc = null;
        if (type.equalsIgnoreCase("Value")) {
            log.info((Object)("Proba mapowania stalej wartosci " + fixedValue + " dla indeksu " + indexElementName));
            thisIndexValue = fixedValue;
        } else {
            List<String> storage = new ArrayList<String>();
            if (type.equalsIgnoreCase("Fixed")) {
                int fromPos = 0;
                int toPos = 0;
                int enterPos = 0;
                for (int startRow = oneTag.getStartRow(); startRow > 1; --startRow) {
                    enterPos = pdfFileContent.indexOf(Constants.ENTER, fromPos);
                    if (enterPos == -1) {
                        throw new PlusEFakturaException("Przekroczono zakres pliku. Sprawdz pole StartRow dla indeksu " + indexElementName + " w definicji szablonu");
                    }
                    fromPos = enterPos + Constants.ENTER.length();
                }
                enterPos = pdfFileContent.indexOf(Constants.ENTER, fromPos);
                if (enterPos == -1) {
                    enterPos = pdfFileContent.length();
                }
                if (enterPos - fromPos < startColumn) {
                    throw new PlusEFakturaException("Przekroczono zakres linii wyznaczonej za pomoca StartRow. Sprawdz wartosc pola StartColumn dla indeksu " + indexElementName);
                }
                fromPos = fromPos + startColumn - 1;
                enterPos = 0;
                while (endRow > 1) {
                    enterPos = pdfFileContent.indexOf(Constants.ENTER, toPos);
                    if (enterPos == -1) {
                        throw new PlusEFakturaException("Przekroczono zakres pliku. Sprawdz pole EndRow dla indeksu " + indexElementName + " w definicji szablonu");
                    }
                    toPos = enterPos + Constants.ENTER.length();
                    --endRow;
                }
                enterPos = pdfFileContent.indexOf(Constants.ENTER, toPos);
                if (enterPos == -1) {
                    enterPos = pdfFileContent.length();
                    if (toPos + endColumn > enterPos) {
                        throw new PlusEFakturaException("Przekroczono zakres pliku. Sprawdz wartosc pola EndColumn dla indeksu " + indexElementName);
                    }
                } else if (enterPos - toPos < endColumn) {
                    throw new PlusEFakturaException("Przekroczono zakres linii wyznaczonej za pomoca EndRow. Sprawdz wartosc pola EndColumn dla indeksu " + indexElementName);
                }
                if (fromPos < 0 || (toPos += endColumn) < 0 || fromPos >= toPos) {
                    throw new PlusEFakturaException("Blad podczas wyznaczania wartosci indeksu, nie mozna poprawnie okreslic miejsc rozpoczecia i zakonczenia pobierania wartosci. Sprawdz w szablonie definicje mapowania dla indeksu " + indexElementName);
                }
                storage.add(pdfFileContent.substring(fromPos, toPos));
            } else if (type.equalsIgnoreCase("Movable")) {
                String tempValue = "";
                int tagPos = -1;
                int valueLength = 0;
                if (value.compareTo("@SOF@") == 0) {
                    tagPos = 0;
                } else if (value.compareTo("@EOF@") == 0) {
                    tagPos = pdfFileContent.length();
                } else {
                    tagPos = pdfFileContent.indexOf(value);
                    valueLength = value.length();
                }
                if (tagPos == -1) {
                    throw new PlusEFakturaException("Faktura pdf nie zawiera tagu o wartosci " + value + ". Indeks o nazwie " + indexElementName + " nie bedzie mapowany");
                }
                do {
                    int nextWordPos;
                    int endValuePos;
                    int spacePos;
                    int securityPos;
                    int enterPos;
                    int lines;
                    int valuePos;
                    tempValue = "";
                    int spaces = oneTag.getSpaces();
                    int words = oneTag.getWords();
                    if (location.equalsIgnoreCase("After")) {
                        valuePos = tagPos + valueLength;
                        for (lines = oneTag.getLines(); lines > 0; --lines) {
                            enterPos = pdfFileContent.indexOf(Constants.ENTER, valuePos);
                            if (enterPos == -1) {
                                throw new PlusEFakturaException("Przekroczono zakres pliku. Sprawdz pole Lines dla indeksu " + indexElementName + " w definicji szablonu");
                            }
                            valuePos = enterPos + Constants.ENTER.length();
                        }
                        securityPos = pdfFileContent.indexOf(Constants.ENTER, valuePos);
                        if (securityPos == -1) {
                            securityPos = pdfFileContent.length();
                        }
                        while (spaces > 0) {
                            do {
                                if ((spacePos = pdfFileContent.indexOf(" ", valuePos)) != -1 && spacePos <= securityPos) continue;
                                throw new PlusEFakturaException("Ilosc spacji powoduje przejscie do kolejnej linii. Sprawdz pole Spaces indeksu " + indexElementName + " w definicji szablonu");
                            } while ((valuePos = spacePos + " ".length()) < securityPos && pdfFileContent.substring(valuePos, valuePos + 1).equalsIgnoreCase(" "));
                            --spaces;
                        }
                        endValuePos = valuePos;
                        if (StringUtils.isBlank((CharSequence)lastvalue)) {
                            securityPos = pdfFileContent.indexOf(Constants.ENTER, valuePos);
                            if (securityPos == -1) {
                                securityPos = pdfFileContent.length();
                            }
                            while (words > 0) {
                                boolean reachedEOF = false;
                                nextWordPos = pdfFileContent.indexOf(" ", endValuePos);
                                if (nextWordPos == -1 && reachedEOF) {
                                    throw new PlusEFakturaException("Przekroczono zakres pliku. Sprawdz pole Words indeksu " + indexElementName + " w definicji szablonu");
                                }
                                if (nextWordPos == -1 && !reachedEOF) {
                                    reachedEOF = true;
                                    nextWordPos = pdfFileContent.length();
                                }
                                if (nextWordPos > securityPos) {
                                    endValuePos = securityPos + Constants.ENTER.length();
                                    if ((securityPos = pdfFileContent.indexOf(Constants.ENTER, endValuePos)) == -1) {
                                        securityPos = pdfFileContent.length();
                                    }
                                } else {
                                    endValuePos = !reachedEOF ? nextWordPos + " ".length() : nextWordPos;
                                }
                                --words;
                            }
                        } else if (lastvalue.compareTo("@EOF@") == 0) {
                            endValuePos = pdfFileContent.length();
                        } else if (lastvalue.compareTo("@EOL@") == 0) {
                            endValuePos = pdfFileContent.indexOf(Constants.ENTER, valuePos);
                            if (endValuePos == -1) {
                                endValuePos = pdfFileContent.length();
                            }
                        } else {
                            endValuePos = pdfFileContent.indexOf(lastvalue, valuePos);
                            if (endValuePos == -1) {
                                throw new PlusEFakturaException("Nie znaleziono tagu " + lastvalue + " od tagu " + value + " do konca pliku dla indeksu o nazwie " + indexElementName);
                            }
                        }
                        if (valuePos != -1 && endValuePos > valuePos) {
                            tempValue = pdfFileContent.substring(valuePos, endValuePos);
                        }
                    } else if (location.equalsIgnoreCase("Before")) {
                        valuePos = tagPos;
                        while (lines > 0) {
                            enterPos = pdfFileContent.lastIndexOf(Constants.ENTER, valuePos - 1);
                            if (enterPos == -1) {
                                throw new PlusEFakturaException("Przekroczono zakres pliku. Sprawdz pole Lines dla indeksu " + indexElementName + " w definicji szablonu");
                            }
                            valuePos = enterPos;
                            --lines;
                        }
                        securityPos = pdfFileContent.lastIndexOf(Constants.ENTER, valuePos - 1);
                        if (securityPos == -1) {
                            securityPos = 0;
                        }
                        while (spaces > 0) {
                            do {
                                if ((spacePos = pdfFileContent.lastIndexOf(" ", valuePos - 1)) != -1 && spacePos >= securityPos) continue;
                                throw new PlusEFakturaException("Ilosc spacji powoduje przejscie do kolejnej linii. Sprawdz pole Spaces indeksu " + indexElementName + " w definicji szablonu");
                            } while ((valuePos = spacePos) > securityPos && pdfFileContent.substring(valuePos - 1, valuePos).equalsIgnoreCase(" "));
                            --spaces;
                        }
                        endValuePos = valuePos;
                        if (StringUtils.isBlank((CharSequence)lastvalue)) {
                            securityPos = pdfFileContent.lastIndexOf(Constants.ENTER, valuePos - 1);
                            if (securityPos == -1) {
                                securityPos = 0;
                            }
                            while (words > 0) {
                                boolean reachedSOF = false;
                                nextWordPos = pdfFileContent.lastIndexOf(" ", endValuePos - 1);
                                if (nextWordPos == -1 && reachedSOF) {
                                    throw new PlusEFakturaException("Przekroczono zakres pliku. Sprawdz pole Words indeksu " + indexElementName + " w definicji szablonu");
                                }
                                if (nextWordPos == -1 && !reachedSOF) {
                                    reachedSOF = true;
                                    nextWordPos = 0;
                                }
                                if (nextWordPos < securityPos) {
                                    endValuePos = securityPos + Constants.ENTER.length();
                                    if ((securityPos = pdfFileContent.lastIndexOf(Constants.ENTER, endValuePos - Constants.ENTER.length() - 1)) == -1) {
                                        securityPos = 0;
                                    }
                                } else {
                                    endValuePos = nextWordPos;
                                }
                                --words;
                            }
                        } else if (lastvalue.compareTo("@EOF@") == 0) {
                            endValuePos = 0;
                        } else if (lastvalue.compareTo("@EOL@") == 0) {
                            endValuePos = pdfFileContent.lastIndexOf(Constants.ENTER, valuePos - 1);
                            if (endValuePos == -1) {
                                endValuePos = 0;
                            }
                        } else {
                            endValuePos = pdfFileContent.lastIndexOf(lastvalue, valuePos);
                            if (endValuePos == -1) {
                                throw new PlusEFakturaException("Nie znaleziono tagu " + lastvalue + " od tagu " + value + " do poczatku pliku dla indeksu o nazwie " + indexElementName);
                            }
                            endValuePos += lastvalue.length();
                        }
                        if (valuePos != -1 && endValuePos != -1) {
                            tempValue = pdfFileContent.substring(endValuePos, valuePos);
                        }
                    }
                    storage.add(tempValue);
                } while (repeat && (tagPos = pdfFileContent.indexOf(value, tagPos + 1)) != -1);
            } else {
                if (type.equalsIgnoreCase("TableIndex")) {
                    try {
                        if (pdDoc == null) {
                            read = new RandomAccessReadBufferedFile(pdfFile);
                            parser = new PDFParser((RandomAccessRead)read);
                            cosDoc = parser.parse().getDocument();
                            pdDoc = new PDDocument(cosDoc);
                        }
                        TableIndexResolverPDFTextStripper pdfStripper = new TableIndexResolverPDFTextStripper(oneTag);
                        storage = pdfStripper.getTableIndexValues(pdDoc);
                    }
                    catch (Exception e) {
                        throw new PlusEFakturaException("Nie znaleziono wartosci indeksu " + indexElementName + ". Sprawdz definicje szablonu");
                    }
                }
                if (type.equalsIgnoreCase("RecordIndex")) {
                    try {
                        if (pdDoc == null) {
                            read = new RandomAccessReadBufferedFile(pdfFile);
                            parser = new PDFParser((RandomAccessRead)read);
                            cosDoc = parser.parse().getDocument();
                            pdDoc = new PDDocument(cosDoc);
                        }
                        RecordIndexResolverPDFTextStripper pdfStripper = new RecordIndexResolverPDFTextStripper(oneTag);
                        storage = pdfStripper.getRecordIndexValues(pdDoc);
                    }
                    catch (Exception e) {
                        throw new PlusEFakturaException("Nie znaleziono wartosci indeksu " + indexElementName + ". Sprawdz definicje szablonu");
                    }
                }
            }
            storage = this.userRegexAndFormatForAll(storage, indexMap, indexElementName, pdfFile, pdfFileContent);
            thisIndexValue = this.verifyDuplication(storage, eliminateDuplication);
        }
        if (StringUtils.isBlank((CharSequence)thisIndexValue)) {
            throw new PlusEFakturaException("Nie znaleziono wartosci indeksu " + indexElementName + ". Sprawdz definicje szablonu");
        }
        return thisIndexValue;
    }

    private String verifyDuplication(List<String> storage, boolean eliminateDuplication) {
        String result = new String();
        for (String value : storage) {
            if (eliminateDuplication && (!eliminateDuplication || result.contains(value))) continue;
            result = result.concat(value).concat(";");
        }
        if (result.endsWith(";")) {
            result = result.substring(0, result.length() - ";".length());
        }
        return result;
    }

    private List<String> userRegexAndFormatForAll(List<String> storage, IndexElement indexMap, String indexElementName, File pdfFile, String pdfFileContent) throws PlusEFakturaException {
        ArrayList<String> result = new ArrayList<String>();
        for (String oneIndexValue : storage) {
            String afterRegexUse = this.useRegexAndFormatForOne(oneIndexValue.trim(), indexMap, indexElementName, pdfFile, pdfFileContent);
            if (!StringUtils.isNotBlank((CharSequence)afterRegexUse)) continue;
            result.add(afterRegexUse);
        }
        return result;
    }

    private String useRegexAndFormatForOne(String thisIndexValue, IndexElement indexMap, String indexElementName, File pdfFile, String pdfFileContent) throws PlusEFakturaException {
        TagElement oneTag = indexMap.getOneTag(indexElementName);
        String regex = oneTag.getRegex();
        int matchingNo = oneTag.getMatchingNo();
        String formatAction = oneTag.getFormatAction();
        String format1 = oneTag.getFormat1();
        String format2 = oneTag.getFormat2();
        String format3 = oneTag.getFormat3();
        if (StringUtils.isBlank((CharSequence)(thisIndexValue = this.processString(thisIndexValue)))) {
            throw new PlusEFakturaException("Nie znaleziono wartosci indeksu " + indexElementName + ". Sprawdz definicje szablonu");
        }
        if (StringUtils.isNotBlank((CharSequence)regex)) {
            boolean ignoreEmpty = false;
            String type = oneTag.getType();
            if (type.equalsIgnoreCase("TableIndex") || type.equalsIgnoreCase("Movable") && oneTag.isRepeat()) {
                ignoreEmpty = true;
            }
            List<String> subValues = PlusEFakturaTools.useRegexForIndexValue(thisIndexValue, regex, matchingNo);
            if (!ignoreEmpty && subValues.isEmpty()) {
                throw new PlusEFakturaException("Po zastosowaniu wyrazenia regularnego nie uzyskano wartosci indeksu o nazwie " + indexElementName + ". Sprawdz definicje szablonu.");
            }
            String result = "";
            for (String subValue : subValues) {
                result = result + this.formatIndexValue(subValue, indexMap, indexElementName, pdfFile, pdfFileContent, formatAction, format1, format2, format3) + ";";
            }
            if (result.endsWith(";")) {
                result = result.substring(0, result.length() - 1);
            }
            return result;
        }
        return this.formatIndexValue(thisIndexValue, indexMap, indexElementName, pdfFile, pdfFileContent, formatAction, format1, format2, format3);
    }

    private String formatIndexValue(String thisIndexValue, IndexElement indexMap, String indexElementName, File pdfFile, String pdfFileContent, String formatAction, String format1, String format2, String format3) throws PlusEFakturaException {
        if (StringUtils.isNotBlank((CharSequence)formatAction) && StringUtils.isNotBlank((CharSequence)thisIndexValue)) {
            if (formatAction.equalsIgnoreCase("Text as amount")) {
                thisIndexValue = thisIndexValue.replaceAll("[\\\\]", "");
                thisIndexValue = thisIndexValue.replaceAll("[ ]", "");
                thisIndexValue = thisIndexValue.replaceAll("[,]", ".");
                int lastDotPos = thisIndexValue.lastIndexOf(".");
                int dotPos = thisIndexValue.indexOf(".", 0);
                while (dotPos != -1 && dotPos != lastDotPos) {
                    thisIndexValue = thisIndexValue.replaceFirst("[.]", "");
                    dotPos = thisIndexValue.indexOf(".", dotPos);
                    lastDotPos = thisIndexValue.lastIndexOf(".");
                }
                try {
                    Float.parseFloat(thisIndexValue);
                }
                catch (NumberFormatException e) {
                    throw new PlusEFakturaException("B\u0142\u0105d formatowania tekstu jako kwoty dla indeksu " + indexElementName + ". Uzyskany tekst nie jest warto\u015bci\u0105 zmiennoprzecinkow\u0105. Sprawd\u017a definicj\u0119 szablonu.");
                }
            } else if (formatAction.equalsIgnoreCase("Date format")) {
                try {
                    Date tempDate = PlusEFakturaEngine.convertStringToDate(thisIndexValue, format1, format3);
                    SimpleDateFormat sdf = new SimpleDateFormat(format2);
                    thisIndexValue = sdf.format(tempDate);
                }
                catch (Exception e) {
                    throw new PlusEFakturaException("B\u0142\u0105d formatowania daty dla indeksu o nazwie " + indexElementName + ". Sprawd\u017a definicj\u0119 szablonu.");
                }
            } else if (formatAction.equalsIgnoreCase("Add days")) {
                try {
                    int iNoOfDays = Integer.parseInt(thisIndexValue);
                    String dateForAddDays = this.findIndexValueFromTemplate(indexMap, pdfFile, pdfFileContent, format1);
                    SimpleDateFormat sdf = new SimpleDateFormat(format2);
                    Date tempDate = sdf.parse(dateForAddDays);
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(tempDate);
                    calendar.add(5, iNoOfDays);
                    tempDate = calendar.getTime();
                    if (StringUtils.isNotBlank((CharSequence)format3)) {
                        sdf = new SimpleDateFormat(format3);
                    }
                    thisIndexValue = sdf.format(tempDate);
                }
                catch (NumberFormatException e) {
                    throw new PlusEFakturaException("Pobrana z faktury ilo\u015b\u0107 dni nie jest warto\u015bci\u0105 liczbow\u0105 dla indeksu o nazwie " + indexElementName + ". Sprawd\u017a definicj\u0119 szablonu.");
                }
                catch (Exception e) {
                    throw new PlusEFakturaException("B\u0142\u0105d podczas dodawania dni dla indeksu o nazwie " + indexElementName + ". . Sprawd\u017a definicj\u0119 szablonu.");
                }
            } else if (formatAction.equalsIgnoreCase("Remove chars")) {
                StringBuilder result = null;
                StringCharacterIterator iterator = null;
                for (int z = 0; z < format1.length(); ++z) {
                    char charToRemove = format1.charAt(z);
                    result = new StringBuilder();
                    iterator = new StringCharacterIterator(thisIndexValue);
                    char character = iterator.current();
                    while (character != '\uffff') {
                        if (character == charToRemove) {
                            result.append("");
                        } else {
                            result.append(character);
                        }
                        character = iterator.next();
                    }
                    thisIndexValue = result.toString();
                }
            } else if (formatAction.equalsIgnoreCase("Remove string")) {
                thisIndexValue = thisIndexValue.replaceAll(format1, "");
            } else if (formatAction.equalsIgnoreCase("Add prefix")) {
                thisIndexValue = format1 + thisIndexValue;
            } else if (formatAction.equalsIgnoreCase("Remove prefix")) {
                if (thisIndexValue.toLowerCase().startsWith(format1.toLowerCase())) {
                    thisIndexValue = thisIndexValue.substring(format1.length(), thisIndexValue.length());
                }
            } else if (formatAction.equalsIgnoreCase("Add postfix")) {
                thisIndexValue = thisIndexValue + format1;
            } else if (formatAction.equalsIgnoreCase("Remove postfix") && thisIndexValue.toLowerCase().endsWith(format1.toLowerCase())) {
                thisIndexValue = thisIndexValue.substring(0, thisIndexValue.length() - format1.length());
            }
            if (StringUtils.isBlank((CharSequence)thisIndexValue)) {
                throw new PlusEFakturaException("Po zastosowaniu formatowania nie uzyskano warto\u015bci indeksu o nazwie " + indexElementName + ". . Sprawd\u017a definicj\u0119 szablonu.");
            }
        }
        return thisIndexValue;
    }

    private String processString(String string) {
        try {
            if (StringUtils.isNotBlank((CharSequence)string)) {
                string = string.replaceAll("\n", " ");
                string = string.replaceAll("\r", " ");
                string = string.replaceAll("  ", " ");
                if ((string = string.trim()).endsWith(",") || string.endsWith(";")) {
                    string = string.substring(0, string.length() - 1);
                }
                if (string.startsWith(",") || string.startsWith(";") || string.startsWith(".")) {
                    string = string.substring(1, string.length());
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return string;
    }

    private static Date convertStringToDate(String thisIndexValue, String format1, String format3) throws Exception {
        if (format1.compareTo("dd MMM yyyy") == 0 || format1.compareTo("dd-MMM-yyyy") == 0) {
            char literal = ' ';
            if (format1.contains("-")) {
                literal = '-';
            }
            DateTimeFormatterBuilder dtfb = new DateTimeFormatterBuilder();
            dtfb = dtfb.appendDayOfMonth(2);
            dtfb = dtfb.appendLiteral(literal);
            dtfb = dtfb.appendMonthOfYearShortText();
            dtfb = dtfb.appendLiteral(literal);
            dtfb = dtfb.appendYear(4, 4);
            Locale locale = PlusEFakturaEngine.getLocale(format3);
            DateTimeFormatter dtf = dtfb.toFormatter().withLocale(locale);
            return dtf.parseLocalDate(thisIndexValue).toDateTimeAtStartOfDay().toDate();
        }
        if (format1.compareTo("dd MMM yy") == 0 || format1.compareTo("dd-MMM-yy") == 0) {
            char literal = ' ';
            if (format1.contains("-")) {
                literal = '-';
            }
            DateTimeFormatterBuilder dtfb = new DateTimeFormatterBuilder();
            dtfb = dtfb.appendDayOfMonth(2);
            dtfb = dtfb.appendLiteral(literal);
            dtfb = dtfb.appendMonthOfYearShortText();
            dtfb = dtfb.appendLiteral(literal);
            dtfb = dtfb.appendTwoDigitYear(2025);
            Locale locale = PlusEFakturaEngine.getLocale(format3);
            DateTimeFormatter dtf = dtfb.toFormatter().withLocale(locale);
            return dtf.parseLocalDate(thisIndexValue).toDateTimeAtStartOfDay().toDate();
        }
        SimpleDateFormat sdf = PlusEFakturaEngine.getDateFormat(format1, format3);
        return sdf.parse(thisIndexValue);
    }

    private static SimpleDateFormat getDateFormat(String format, String language) {
        if (StringUtils.isNotBlank((CharSequence)language)) {
            Locale locale = new Locale(language);
            return new SimpleDateFormat(format, locale);
        }
        return new SimpleDateFormat(format);
    }

    private static Locale getLocale(String format3) {
        if (StringUtils.isNotBlank((CharSequence)format3)) {
            return new Locale(format3);
        }
        return Locale.US;
    }

    private static boolean isPhraseInContent(String content, String phrase) {
        try {
            Pattern pattern = Pattern.compile(phrase, 2);
            Matcher matcher = pattern.matcher(content);
            return matcher.find();
        }
        catch (PatternSyntaxException exception) {
            return content.toLowerCase().contains(phrase.toLowerCase());
        }
    }
}

