/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.util;

import com.suncode.plugin.efaktura.util.AdditionalOptions;
import com.suncode.plugin.efaktura.util.ForwardConfig;
import com.suncode.plugin.efaktura.util.OAuth2ConnectionHelper;
import com.suncode.plugin.efaktura.util.PlusEFakturaTools;
import com.suncode.plugin.efaktura.util.Workaround;
import com.suncode.pwfl.administration.email.oauth.connection.ConnectionRefreshException;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class ForwardEmailAction {
    public static Logger log = Logger.getLogger(ForwardEmailAction.class);
    public static Logger clientLog = Logger.getLogger((String)"PlusEFakturaClientLog");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean sendMail(String supplierEmail, String sEmail, Message message, ForwardConfig forwardConfig, String sTitlePostfix, AdditionalOptions additionalOptions) {
        boolean bSent;
        block14: {
            log.trace((Object)("*************** sendMail(supplierEmail=" + supplierEmail + ", sEmail=" + sEmail + ", Message, ForwardConfig, sTitlePostfix=" + sTitlePostfix + ", additionalOptions) ***************"));
            bSent = false;
            Session session = null;
            FileOutputStream debugOutputStream = null;
            PrintStream debugPrintStream = null;
            try {
                final String sUsername = forwardConfig.getUsername();
                final String sPassword = ForwardEmailAction.getPassword(forwardConfig.getPassword(), forwardConfig.getOAuth());
                String sHost = forwardConfig.getHost();
                String sOutgoingPort = forwardConfig.getOutgoingPort();
                String sAuth = forwardConfig.getAuth();
                log.info((Object)"---> Parametry konfiguracyjne forward'u");
                log.info((Object)("Adres dostawcy: " + supplierEmail));
                log.info((Object)("Adres odbiorcy: " + sEmail));
                log.info((Object)("Adres nadawcy: " + sUsername));
                log.info((Object)("Adres serwera pocztowego: " + sHost));
                log.info((Object)("Port poczty wychodzacej: " + sOutgoingPort));
                log.info((Object)("Autentykacja: " + sAuth));
                System.setProperty("mail.mime.multipart.ignoreexistingboundaryparameter", "true");
                Properties props = new Properties();
                props.put("mail.transport.protocol", "smtp");
                props.put("mail.host", sHost);
                props.put("mail.smtp.host", sHost);
                props.put("mail.port", sOutgoingPort);
                props.put("mail.smtp.port", sOutgoingPort);
                props.put("mail.socketFactory.port", sOutgoingPort);
                props.put("mail.smtp.socketFactory.port", sOutgoingPort);
                props.put("mail.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                props.put("mail.debug", "true");
                props.put("mail.starttls.enable", forwardConfig.getStartTls());
                props.put("mail.ssl.enable", forwardConfig.getSsl());
                props.put("mail.smtp.starttls.enable", forwardConfig.getStartTls());
                props.put("mail.smtp.ssl.enable", forwardConfig.getSsl());
                if (sAuth.equalsIgnoreCase("FALSE")) {
                    session = Session.getInstance((Properties)props, null);
                } else {
                    props.put("mail.user", sUsername);
                    props.put("mail.password", sPassword);
                    props.put("mail.auth", "true");
                    props.put("mail.smtp.auth", "true");
                    if (StringUtils.equalsIgnoreCase((CharSequence)forwardConfig.getOAuth(), (CharSequence)"TRUE")) {
                        props.put("mail.smtp.auth.mechanisms", "XOAUTH2");
                    }
                    session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

                        public PasswordAuthentication getPasswordAuthentication() {
                            return new PasswordAuthentication(sUsername, sPassword);
                        }
                    });
                }
                if (StringUtils.isNotBlank((CharSequence)forwardConfig.getDebugOutput())) {
                    debugOutputStream = new FileOutputStream(forwardConfig.getDebugOutput());
                    debugPrintStream = new PrintStream(debugOutputStream);
                    session.setDebug(true);
                    session.setDebugOut(debugPrintStream);
                } else {
                    session.setDebug(false);
                }
                MimeMessage forward = new MimeMessage(session);
                forward.setSubject("Fwd: " + PlusEFakturaTools.decodeText(message.getSubject(), false, false) + sTitlePostfix);
                forward.setFrom((Address)new InternetAddress(sUsername));
                forward.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(sEmail));
                long time = new Date().getTime();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String sDate = sdf.format(new Date(time));
                Date sentDate = sdf.parse(sDate);
                forward.setSentDate(sentDate);
                DataHandler dataHandler = message.getDataHandler();
                String contentType = dataHandler.getContentType();
                contentType = contentType.replaceAll("(\\t|\\r|\\n| )", "");
                StringBuilder newContentType = new StringBuilder();
                boolean boundaryFound = false;
                for (String oneConentType : contentType.split(";")) {
                    if (!oneConentType.startsWith("boundary")) {
                        newContentType.append(oneConentType);
                        newContentType.append(";");
                        continue;
                    }
                    if (boundaryFound) continue;
                    newContentType.append(oneConentType);
                    newContentType.append(";");
                    boundaryFound = true;
                }
                ByteArrayDataSource dataSource = null;
                try {
                    dataSource = new ByteArrayDataSource(dataHandler.getInputStream(), newContentType.toString());
                }
                catch (ArrayIndexOutOfBoundsException exception) {
                    Workaround.imapMessageNumberOutOfBounds(additionalOptions.getFolder());
                    dataSource = new ByteArrayDataSource(dataHandler.getInputStream(), newContentType.toString());
                }
                Multipart multipart = ForwardEmailAction.createMultipart((DataSource)dataSource);
                forward.setContent(multipart);
                Transport.send((Message)forward);
                log.info((Object)("Wiadomosc odeslana na adres " + sEmail));
                clientLog.info((Object)("Wiadomosc odeslana na adres " + sEmail));
                bSent = true;
                IOUtils.closeQuietly((Closeable)debugPrintStream);
            }
            catch (Exception exception) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
                break block14;
            }
            finally {
                IOUtils.closeQuietly(debugPrintStream);
                IOUtils.closeQuietly(debugOutputStream);
            }
            IOUtils.closeQuietly((Closeable)debugOutputStream);
        }
        return bSent;
    }

    private static Multipart createMultipart(DataSource dataSource) throws MessagingException {
        try {
            return new MimeMultipart(dataSource);
        }
        catch (Exception exception) {
            DataHandler newDataHandler = new DataHandler(dataSource);
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            messageBodyPart.setDataHandler(newDataHandler);
            MimeMultipart multipart = new MimeMultipart();
            multipart.addBodyPart((BodyPart)messageBodyPart);
            return multipart;
        }
    }

    public static boolean sendLicenseNotification(String sEmail, final String sUsername, String sPassword, String sOutgoingPort, String sHost, String sSubject, String sMessageContent, String sAuth, String oAuth, String sStartTls, String sSSL) {
        log.trace((Object)("************ sendLicenseNotification(sEmail=" + sEmail + ", sUsername=" + sUsername + ", sPassword, sOutgoingPort=" + sOutgoingPort + ", sHost=" + sHost + ", sSubject, sMessageContent, sAuth=" + sAuth + ") ************"));
        boolean bSent = false;
        Session session = null;
        try {
            Properties props = new Properties();
            props.put("mail.transport.protocol", "smtp");
            props.put("mail.host", sHost);
            props.put("mail.smtp.host", sHost);
            props.put("mail.port", sOutgoingPort);
            props.put("mail.smtp.port", sOutgoingPort);
            props.put("mail.socketFactory.port", sOutgoingPort);
            props.put("mail.smtp.socketFactory.port", sOutgoingPort);
            props.put("mail.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            props.put("mail.debug", "true");
            if (sAuth.equalsIgnoreCase("FALSE")) {
                session = Session.getInstance((Properties)props, null);
            } else {
                final String password = ForwardEmailAction.getPassword(sPassword, oAuth);
                props.put("mail.user", sUsername);
                props.put("mail.password", password);
                props.put("mail.starttls.enable", sStartTls);
                props.put("mail.ssl.enable", sSSL);
                props.put("mail.smtp.ssl.enable", sSSL);
                props.put("mail.smtp.auth", "true");
                if (oAuth.equalsIgnoreCase("TRUE")) {
                    props.put("mail.smtp.auth.mechanisms", "XOAUTH2");
                }
                session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

                    public PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(sUsername, password);
                    }
                });
            }
            session.setDebug(false);
            MimeMessage forward = new MimeMessage(session);
            forward.setSubject(sSubject);
            forward.setFrom((Address)new InternetAddress(sUsername));
            forward.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(sEmail));
            long time = new Date().getTime();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String sDate = sdf.format(new Date(time));
            Date sentDate = sdf.parse(sDate);
            forward.setSentDate(sentDate);
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            messageBodyPart.setText(sMessageContent);
            MimeMultipart multipart = new MimeMultipart();
            multipart.addBodyPart((BodyPart)messageBodyPart);
            forward.setContent((Multipart)multipart);
            Transport.send((Message)forward);
            log.info((Object)("Informacja o wygasaniu licencji odeslana na adres " + sEmail));
            clientLog.info((Object)("Informacja o wygasaniu licencji odeslana na adres " + sEmail));
            bSent = true;
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
        }
        return bSent;
    }

    private static String getPassword(String password, String oAuth) throws ConnectionRefreshException {
        if (StringUtils.equalsIgnoreCase((CharSequence)oAuth, (CharSequence)"TRUE")) {
            return OAuth2ConnectionHelper.getActiveAccessToken(Long.parseLong(password));
        }
        return password;
    }
}

