/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.service.editopdf;

import com.suncode.plugin.efaktura.dao.editopdf.EdiToPdfDao;
import com.suncode.plugin.efaktura.editopdf.EdiToPdfConverter;
import com.suncode.plugin.efaktura.model.editopdf.EdiToPdf;
import com.suncode.plugin.efaktura.util.DocxToPdfConverterType;
import com.suncode.plugin.efaktura.util.EdiType;
import com.suncode.plugin.efaktura.util.Validator;
import com.suncode.plugin.efaktura.web.rest.configuration.EdiToPdfEntryDto;
import com.suncode.plugin.efaktura.web.support.dto.EdiToPdfConvertInvoiceDto;
import com.suncode.plugin.efaktura.web.support.dto.EdiToPdfDto;
import com.suncode.plugin.efaktura.web.support.dto.EdiToPdfEmailDto;
import com.suncode.plugin.efaktura.web.support.dto.ManagementDto;
import com.suncode.plugin.efaktura.web.support.dto.TemplateDownloadDto;
import com.suncode.plugin.efaktura.web.support.dto.TranslationDto;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.util.ServiceFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

@Service
public class EdiToPdfService {
    @Autowired
    private EdiToPdfDao ediToPdfDao;
    @Autowired
    private EdiToPdfConverter ediToPdfConverter;

    public TranslationDto getTranslations() {
        HashMap<String, String> translations = new HashMap<String, String>();
        translations.put("no_supplier_emails", "Podaj adresy email dostawc\u00f3w.");
        translations.put("warning", "Uwaga");
        translations.put("edi_to_pdf_manager", "Konwersja edi na pdf");
        translations.put("conversions", "Konwersje");
        translations.put("available_conversions", "Dost\u0119pne konwersje");
        translations.put("supplier_email", "Email dostawcy");
        translations.put("edi_file_type", "Typ pliku edi");
        translations.put("create", "Dodaj");
        translations.put("update", "Zmie\u0144");
        translations.put("remove", "Usu\u0144");
        translations.put("success", "Sukces");
        translations.put("error", "B\u0142\u0105d");
        translations.put("template", "Szablon");
        translations.put("choose", "Wybierz");
        translations.put("choose_file", "Wybierz plik");
        translations.put("chosen_file_is_not_docx", "Wybrany plik nie jest plikiem docx");
        translations.put("template_doc_class", "Klasa dokument\u00f3w szablonu");
        translations.put("choose_doc_class", "Wybierz klas\u0119 dokument\u00f3w");
        translations.put("convert_invoice", "Konwertuj faktur\u0119");
        translations.put("choose_conversion", "Wybierz konwersj\u0119");
        translations.put("invoices_converter", "Konwerter faktur");
        translations.put("invoice", "Faktura");
        translations.put("chosen_file_is_not_edi", "Wybrany plik nie jest plikiem edi");
        translations.put("convert", "Konwertuj");
        translations.put("download_template", "Pobierz szablon");
        translations.put("template_to_pdf_converter_type", "Typ konwertera szablonu do pdf");
        TranslationDto dto = new TranslationDto();
        dto.setTranslations(translations);
        return dto;
    }

    @Transactional(readOnly=true)
    public CountedResult<EdiToPdfEntryDto> getEdiToPdfConverters(Integer start, Integer limit, String sortBy, SortDirection sortDirection) {
        List data = this.ediToPdfDao.findAll(start, limit, sortBy, sortDirection).stream().map(ediToPdf -> EdiToPdfEntryDto.builder().id(ediToPdf.getId()).emailFrom(ediToPdf.getEmailFrom()).ediType(ediToPdf.getEdiType()).docxToPdfConverterType(DocxToPdfConverterType.getByName(ediToPdf.getDocxToPdfConverterType())).build()).collect(Collectors.toList());
        long total = this.ediToPdfDao.countAll();
        return new CountedResult(total, data);
    }

    @Transactional(readOnly=true)
    public List<EdiToPdfEmailDto> read(String fromEmails) {
        String[] fromEmailsTab;
        ArrayList<EdiToPdfEmailDto> ediToPdfEmailDtos = new ArrayList<EdiToPdfEmailDto>();
        for (String fromEmail : fromEmailsTab = fromEmails.split(";")) {
            EdiToPdfEmailDto ediToPdfEmailDto = new EdiToPdfEmailDto();
            ediToPdfEmailDto.setFromEmail(fromEmail);
            ediToPdfEmailDto.setText(fromEmail);
            ediToPdfEmailDto.setIcon("style/img/fam/email.png");
            ediToPdfEmailDto.setIsEmail(true);
            Optional<EdiToPdf> ediToPdfOpt = this.ediToPdfDao.findByFromEmail(fromEmail);
            if (ediToPdfOpt.isPresent()) {
                EdiToPdf ediToPdf = ediToPdfOpt.get();
                EdiToPdfDto ediToPdfDto = new EdiToPdfDto();
                ediToPdfDto.setFromEmail(fromEmail);
                ediToPdfDto.setDocxToPdfConverterType(ediToPdf.getDocxToPdfConverterType());
                ediToPdfDto.setEdiType(ediToPdf.getEdiType().getName());
                ediToPdfDto.setConversionId(ediToPdf.getId());
                ediToPdfDto.setText("Id: " + ediToPdf.getId());
                ediToPdfDto.setIcon("style/img/fam/page_white_acrobat.png");
                ediToPdfDto.setIsConversion(true);
                ediToPdfDto.setLeaf(true);
                ArrayList<EdiToPdfDto> ediToPdfDtos = new ArrayList<EdiToPdfDto>();
                ediToPdfDtos.add(ediToPdfDto);
                ediToPdfEmailDto.setLeaf(false);
                ediToPdfEmailDto.setExpanded(true);
                ediToPdfEmailDto.setChildren(ediToPdfDtos);
            } else {
                ediToPdfEmailDto.setLeaf(true);
                ediToPdfEmailDto.setExpanded(false);
                ediToPdfEmailDto.setChildren(new ArrayList<EdiToPdfDto>());
            }
            ediToPdfEmailDtos.add(ediToPdfEmailDto);
        }
        return ediToPdfEmailDtos;
    }

    @Transactional
    public ManagementDto create(String userId, EdiToPdfDto ediToPdfDto) {
        if (!Validator.isValidEmail(ediToPdfDto.getFromEmail())) {
            return this.buildManagementFailure("Niepoprawny format adresu email: " + ediToPdfDto.getFromEmail());
        }
        Optional<EdiToPdf> ediToPdfOpt = this.ediToPdfDao.findByFromEmail(ediToPdfDto.getFromEmail());
        if (ediToPdfOpt.isPresent()) {
            return this.buildManagementFailure("Dostawca posiada ju\u017c konwersj\u0119.");
        }
        try {
            DocumentClassService documentClassService = ServiceFactory.getDocumentClassService();
            DocumentClass documentClass = documentClassService.getDocumentClass(ediToPdfDto.getDocumentClassName(), new String[0]);
            CommonsMultipartFile template = ediToPdfDto.getTemplate();
            String fileName = template.getFileItem().getName();
            WfDocument document = this.saveTemplate(userId, template, documentClass, fileName);
            EdiToPdf ediToPdf = new EdiToPdf();
            ediToPdf.setEmailFrom(ediToPdfDto.getFromEmail());
            ediToPdf.setEdiType(EdiType.getByName(ediToPdfDto.getEdiType()));
            ediToPdf.setTemplatePath(document.getFile().getFullPath());
            ediToPdf.setDocxToPdfConverterType(ediToPdfDto.getDocxToPdfConverterType());
            ediToPdf.setFileName(fileName);
            this.ediToPdfDao.save(ediToPdf);
            return this.buildManagementSuccess("Poprawnie dodano konwersj\u0119.");
        }
        catch (IOException exception) {
            return this.buildManagementFailure(exception.getMessage());
        }
    }

    @Transactional
    public ManagementDto update(String userId, EdiToPdfDto ediToPdfDto) {
        if (!Validator.isValidEmail(ediToPdfDto.getFromEmail())) {
            return this.buildManagementFailure("Niepoprawny format adresu email: " + ediToPdfDto.getFromEmail());
        }
        try {
            EdiToPdf ediToPdf = (EdiToPdf)this.ediToPdfDao.get(ediToPdfDto.getConversionId());
            DocumentClassService documentClassService = ServiceFactory.getDocumentClassService();
            DocumentClass documentClass = documentClassService.getDocumentClass(ediToPdfDto.getDocumentClassName(), new String[0]);
            CommonsMultipartFile template = ediToPdfDto.getTemplate();
            String fileName = template.getFileItem().getName();
            WfDocument document = this.saveTemplate(userId, template, documentClass, fileName);
            ediToPdf.setEmailFrom(ediToPdfDto.getFromEmail());
            ediToPdf.setEdiType(EdiType.getByName(ediToPdfDto.getEdiType()));
            ediToPdf.setTemplatePath(document.getFile().getFullPath());
            ediToPdf.setDocxToPdfConverterType(ediToPdfDto.getDocxToPdfConverterType());
            ediToPdf.setFileName(fileName);
            this.ediToPdfDao.update(ediToPdf);
            return this.buildManagementSuccess("Poprawnie zmieniono konwersj\u0119.");
        }
        catch (IOException exception) {
            return this.buildManagementFailure(exception.getMessage());
        }
    }

    private WfDocument saveTemplate(String userId, CommonsMultipartFile template, DocumentClass documentClass, String fileName) throws IOException {
        DocumentService documentService = ServiceFactory.getDocumentService();
        DocumentDefinition documentDefinition = new DocumentDefinition();
        documentDefinition.setDocumentClassId(documentClass.getId());
        documentDefinition.setFileName(fileName);
        documentDefinition.setDescription(fileName);
        documentDefinition.setUserName(userId);
        documentDefinition.setInputStream(template.getInputStream());
        documentDefinition.setIndexes(new HashMap());
        documentDefinition.setSaveAsNewVersion(false);
        return documentService.addDocument(documentDefinition);
    }

    @Transactional
    public ManagementDto remove(Long id) {
        EdiToPdf ediToPdf = (EdiToPdf)this.ediToPdfDao.get(id);
        this.ediToPdfDao.delete(ediToPdf);
        return this.buildManagementSuccess("Poprawnie usuni\u0119to konwersj\u0119.");
    }

    private ManagementDto buildManagementFailure(String message) {
        ManagementDto dto = new ManagementDto();
        dto.setActionPerformed(false);
        dto.setSuccess(true);
        dto.setMessage(message);
        return dto;
    }

    private ManagementDto buildManagementSuccess(String message) {
        ManagementDto dto = new ManagementDto();
        dto.setActionPerformed(true);
        dto.setSuccess(true);
        dto.setMessage(message);
        return dto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(readOnly=true)
    public TemplateDownloadDto download(long conversionId) throws IOException {
        TemplateDownloadDto templateDownloadDto;
        EdiToPdf ediToPdf = (EdiToPdf)this.ediToPdfDao.get(Long.valueOf(conversionId));
        File file = new File(ediToPdf.getTemplatePath());
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            TemplateDownloadDto dto = new TemplateDownloadDto();
            dto.setBytes(IOUtils.toByteArray((InputStream)inputStream));
            dto.setFileName(this.getTemplateFileName(ediToPdf, file));
            templateDownloadDto = dto;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return templateDownloadDto;
    }

    private String getTemplateFileName(EdiToPdf ediToPdf, File file) {
        if (StringUtils.isNotBlank((CharSequence)ediToPdf.getFileName())) {
            return ediToPdf.getFileName();
        }
        return file.getName();
    }

    @Transactional(readOnly=true)
    public byte[] convertInvoice(EdiToPdfConvertInvoiceDto ediToPdfConvertInvoiceDto) {
        EdiToPdf ediToPdf = (EdiToPdf)this.ediToPdfDao.get(ediToPdfConvertInvoiceDto.getConversionId());
        try {
            byte[] fileBytes = IOUtils.toByteArray((InputStream)ediToPdfConvertInvoiceDto.getInvoice().getInputStream());
            return this.ediToPdfConverter.convert(fileBytes, ediToPdf);
        }
        catch (IOException exception) {
            return new byte[0];
        }
    }

    @Transactional(readOnly=true)
    public Optional<EdiToPdf> findByFromEmail(String fromEmail) {
        return this.ediToPdfDao.findByFromEmail(fromEmail);
    }
}

