/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.scheduledtask;

import com.suncode.plugin.efaktura.util.PDFAnalyzer;
import com.suncode.plugin.efaktura.util.PlusEFakturaTools;
import com.suncode.plugin.efaktura.util.exception.PlusEFakturaException;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

@ScheduledTask
public class ConvertInvoiceTask {
    public static Logger log = Logger.getLogger(ConvertInvoiceTask.class);

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("efaktura-convert-invoice-scheduled-task")).name("efaktura.scheduled-task.convert-invoice.name")).description("efaktura.scheduled-task.convert-invoice.description")).parameter().id("pdfFilePath").name("efaktura.scheduled-task.convert-invoice.parameters.pdf-file-path.name").type((Type)Types.STRING).create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(@Param String pdfFilePath) {
        log.info((Object)("**************** convertInvoice(pdfFilePath=" + pdfFilePath + ") *****************"));
        long startTime = new Date().getTime();
        String sTxtName = "";
        String sPdfName = "";
        String sPdfNameWithpoutExt = "";
        String sTxtPath = "";
        String sParsedText = null;
        String sPathWithoutName = "";
        File pdfFile = null;
        File txtFile = null;
        FileOutputStream fos = null;
        boolean fosClosed = false;
        try {
            if (StringUtils.isBlank((CharSequence)pdfFilePath)) {
                throw new PlusEFakturaException("Brak podanej sciezko do pliku pdf");
            }
            if (!pdfFilePath.toLowerCase().endsWith("pdf") && !pdfFilePath.toLowerCase().endsWith("sig")) {
                throw new PlusEFakturaException("Sciezka nie odnosi sie do pliku pdf");
            }
            pdfFile = new File(pdfFilePath = PlusEFakturaTools.convertBackslashesToSlashes(pdfFilePath));
            if (!pdfFile.exists()) {
                throw new PlusEFakturaException("Nie istnieje plik o lokalizacji " + pdfFilePath);
            }
            sPdfName = pdfFile.getName();
            if (StringUtils.isBlank((CharSequence)sPdfName)) {
                throw new PlusEFakturaException("Brak nazwy pliku pdf");
            }
            int lastSlashPos = pdfFilePath.lastIndexOf("/");
            sPathWithoutName = pdfFilePath.substring(0, lastSlashPos + 1);
            if (StringUtils.isBlank((CharSequence)sPathWithoutName)) {
                throw new PlusEFakturaException("Nie udalo sie poprawnie uzyskac sciezki dla pliku txt");
            }
            if (!sPathWithoutName.endsWith("/")) {
                sPathWithoutName = sPathWithoutName + "/";
            }
            if (StringUtils.isBlank((CharSequence)(sParsedText = PDFAnalyzer.readPDFWithPdfBox_1_7_1(pdfFile))) || sParsedText.equalsIgnoreCase("\n") || sParsedText.equalsIgnoreCase("\r\n") || sParsedText.equalsIgnoreCase(" ")) {
                throw new PlusEFakturaException("Nie udalo sie uzyskac zawartosci pliku pdf. Plik txt nie bedzie tworzony");
            }
            log.info((Object)("Poprawnie pobrano zawartosc tekstowa pliku pdf z lokalizacji " + pdfFilePath));
            int lastDotPos = sPdfName.lastIndexOf(".");
            sPdfNameWithpoutExt = sPdfName.substring(0, lastDotPos);
            sTxtName = sPdfNameWithpoutExt + ".txt";
            sTxtPath = sPathWithoutName + sTxtName;
            txtFile = new File(sTxtPath);
            boolean txtFileCreated = txtFile.createNewFile();
            if (!txtFileCreated || !txtFile.exists()) {
                throw new PlusEFakturaException("Nie udalo sie utworzyc pliku txt w lokalizacji " + sTxtPath + ". Sprawdz, czy plik juz istnieje");
            }
            log.info((Object)("Udalo sie utworzyc plik txt w lokalizacji " + sTxtPath));
            fos = new FileOutputStream(sTxtPath);
            fos.write(sParsedText.getBytes());
            log.info((Object)("Plik pdf z lokalizacji " + pdfFilePath + " przekonwertowany do pliku txt w lokalizacji " + sTxtPath));
        }
        catch (PlusEFakturaException e) {
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            try {
                if (fos != null && txtFile != null) {
                    fos.close();
                    fosClosed = true;
                    txtFile.delete();
                    log.info((Object)("Usunieto niepoprawnie utworzony plik txt z lokalizaci " + sTxtPath));
                }
            }
            catch (Exception e2) {
                log.error((Object)e2.getMessage(), (Throwable)e2);
            }
        }
        finally {
            try {
                if (fos != null && !fosClosed) {
                    fos.close();
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        long stopTime = new Date().getTime();
        log.info((Object)("Czas konwertowania faktury z pdf do txt: " + PlusEFakturaTools.formatDuration(stopTime - startTime)));
    }
}

