/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.scheduledtask;

import com.suncode.plugin.efaktura.scheduledtask.SaveTemplateDocumentClassScheduledTask;
import com.suncode.plugin.efaktura.util.PlusEFakturaTools;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.mail.BodyPart;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import org.apache.log4j.Logger;
import org.apache.poi.util.IOUtils;

@ScheduledTask
public class CheckEmlScheduledTask {
    public static Logger log = Logger.getLogger(SaveTemplateDocumentClassScheduledTask.class);
    public static Logger clientLog = Logger.getLogger((String)"PlusEFakturaClientLog");

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("efaktura-check-eml-scheduled-task")).name("efaktura.scheduled-task.check-eml.name")).description("efaktura.scheduled-task.check-eml.description")).parameter().id("emlPath").name("efaktura.scheduled-task.check-eml.parameters.eml-path.name").type((Type)Types.STRING).create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(@Param String emlPath) {
        FileInputStream inputStream;
        long startTime;
        block13: {
            startTime = new Date().getTime();
            inputStream = null;
            try {
                inputStream = new FileInputStream(emlPath);
                MimeMessage message = new MimeMessage(null, (InputStream)inputStream);
                Object object = PlusEFakturaTools.getPartContent((Part)message);
                if (object instanceof Multipart) {
                    ArrayList<Part> attachmentParts = new ArrayList<Part>();
                    Multipart multipart = (Multipart)object;
                    int multipartCounter = 0;
                    int attachmentsToInvestigate = 0;
                    try {
                        while (true) {
                            BodyPart partFromMultipart;
                            List<Part> partDecomposition;
                            if ((partDecomposition = PlusEFakturaTools.deepPartSearch((Part)(partFromMultipart = multipart.getBodyPart(multipartCounter)))) != null && partDecomposition.size() > 0) {
                                for (Part part : partDecomposition) {
                                    String disposition = PlusEFakturaTools.getPartDisposition(part);
                                    if (disposition != null) {
                                        if (disposition.equalsIgnoreCase("attachment")) {
                                            attachmentParts.add(part);
                                            ++attachmentsToInvestigate;
                                            continue;
                                        }
                                        if (!disposition.equalsIgnoreCase("inline") || PlusEFakturaTools.getPartFileName(part) == null) continue;
                                        attachmentParts.add(part);
                                        ++attachmentsToInvestigate;
                                        continue;
                                    }
                                    if (PlusEFakturaTools.getPartFileName(part) == null) continue;
                                    attachmentParts.add(part);
                                    ++attachmentsToInvestigate;
                                }
                            }
                            ++multipartCounter;
                        }
                    }
                    catch (Throwable t) {
                        log.info((Object)("Ilosc zalacznikow: " + attachmentsToInvestigate));
                        for (Part part : attachmentParts) {
                            String name = PlusEFakturaTools.getPartFileName(part);
                            log.error((Object)("Nazwa zalacznika: " + name));
                        }
                        break block13;
                    }
                }
                log.warn((Object)"Wiadomosc eml nie jest typu Multipart");
            }
            catch (Exception exception) {
                try {
                    log.error((Object)exception.getMessage(), (Throwable)exception);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((Closeable)inputStream);
            }
        }
        IOUtils.closeQuietly((Closeable)inputStream);
        long stopTime = new Date().getTime();
        log.info((Object)("Czas sprawdzania wiadomosci eml: " + PlusEFakturaTools.formatDuration(stopTime - startTime)));
    }
}

