/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.docxtopdf;

import com.suncode.plugin.efaktura.docxtopdf.DocxToPdfConverter;
import com.suncode.plugin.efaktura.util.ClassLoaderUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.docx4j.Docx4J;
import org.docx4j.convert.out.FOSettings;
import org.docx4j.fonts.BestMatchingMapper;
import org.docx4j.fonts.Mapper;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.springframework.stereotype.Component;

@Component(value="docx4jDocxToPdfConverter")
public class Docx4jDocxToPdfConverterImpl
implements DocxToPdfConverter {
    public static Logger log = Logger.getLogger(Docx4jDocxToPdfConverterImpl.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] convert(WordprocessingMLPackage template) {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            BestMatchingMapper fontMapper = new BestMatchingMapper();
            template.setFontMapper((Mapper)fontMapper);
            FOSettings settings = this.buildConversionSettings(template);
            ClassLoaderUtils.doInContextClassLoader(() -> Docx4J.toFO((FOSettings)settings, (OutputStream)outputStream, (int)1));
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    private FOSettings buildConversionSettings(WordprocessingMLPackage template) {
        FOSettings settings = Docx4J.createFOSettings();
        settings.setWmlPackage((OpcPackage)template);
        return settings;
    }
}

