/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.dao.template;

import com.plusmpm.database.hibernate.HibernateUtil;
import com.suncode.plugin.efaktura.dao.EfakturaHibernateEditableDao;
import com.suncode.plugin.efaktura.dao.template.TemplateDao;
import com.suncode.plugin.efaktura.model.template.OldTemplate;
import com.suncode.plugin.efaktura.model.template.Template;
import com.suncode.plugin.efaktura.util.TemplateFilter;
import com.suncode.pwfl.search.CountedResult;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;
import org.hibernate.jdbc.ReturningWork;
import org.springframework.stereotype.Repository;

@Repository
public class TemplateDaoImpl
extends EfakturaHibernateEditableDao<Template, Long>
implements TemplateDao {
    private static final String OLD_TEMPLATE_TABLE_NAME = "pm_plusefaktura_templates";
    private static final String FIND_ALL_OLD_TEMPLATES_QUERY = "select email, receivingemail, phrase, phraselocation, priority, fileid from pm_plusefaktura_templates";
    private static final String AT = "@";
    private static final String DOMAIN_MATCH = "*";

    @Override
    public Optional<Template> find(TemplateFilter filter) {
        DetachedCriteria criteria = this.buildCriteriaForOne(filter);
        return Optional.ofNullable(this.findOne(criteria));
    }

    private DetachedCriteria buildCriteriaForOne(TemplateFilter filter) {
        DetachedCriteria criteria = DetachedCriteria.forClass(Template.class);
        if (CollectionUtils.isNotEmpty(filter.getEmailsFrom())) {
            criteria.createAlias("emailsFrom", "ef");
            Disjunction disjunction = Restrictions.disjunction();
            filter.getEmailsFrom().forEach(e -> disjunction.add((Criterion)Restrictions.eq((String)"ef.emailFrom", (Object)e).ignoreCase()));
            criteria.add((Criterion)disjunction);
        }
        if (StringUtils.isNotEmpty((CharSequence)filter.getEmailTo())) {
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"emailTo", (Object)filter.getEmailTo()).ignoreCase(), (Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"emailTo", (Object)""), (Criterion)Restrictions.isNull((String)"emailTo"))));
        }
        if (StringUtils.isNotEmpty((CharSequence)filter.getPhrase())) {
            criteria.add((Criterion)Restrictions.eq((String)"templateDefinition.phrase", (Object)filter.getPhrase()).ignoreCase());
        } else {
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"templateDefinition.phrase", (Object)""), (Criterion)Restrictions.isNull((String)"templateDefinition.phrase")));
        }
        if (filter.getPhraseLocation() != null) {
            criteria.add((Criterion)Restrictions.eq((String)"templateDefinition.phraseLocation", (Object)((Object)filter.getPhraseLocation())));
        }
        if (filter.getPriority() != null) {
            criteria.add((Criterion)Restrictions.eq((String)"templateDefinition.priority", (Object)filter.getPriority()));
        }
        if (filter.getFileId() != null) {
            criteria.add((Criterion)Restrictions.eq((String)"templateDefinition.fileId", (Object)filter.getFileId()));
        } else {
            criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.isNotNull((String)"templateDefinition.fileId"), (Criterion)Restrictions.ne((String)"templateDefinition.fileId", (Object)-1L)));
        }
        return criteria;
    }

    @Override
    public CountedResult<Template> findAll(TemplateFilter filter, Integer start, Integer limit) {
        DetachedCriteria searchCriteria = this.buildCriteriaForAll(filter, true);
        List templates = this.findByCriteria(searchCriteria, start, limit);
        DetachedCriteria countCriteria = this.buildCriteriaForAll(filter, false);
        long count = this.distinctCountByCriteria(countCriteria);
        return new CountedResult(count, templates);
    }

    private long distinctCountByCriteria(DetachedCriteria dc) {
        dc.setProjection((Projection)Projections.countDistinct((String)"id"));
        return (Long)dc.getExecutableCriteria(this.getSession()).uniqueResult();
    }

    private DetachedCriteria buildCriteriaForAll(TemplateFilter filter, boolean withOrder) {
        DetachedCriteria criteria = DetachedCriteria.forClass(Template.class);
        criteria.createAlias("emailsFrom", "ef");
        if (CollectionUtils.isNotEmpty(filter.getEmailsFrom())) {
            Disjunction disjunction = Restrictions.disjunction();
            filter.getEmailsFrom().forEach(e -> disjunction.add(Restrictions.ilike((String)"ef.emailFrom", (Object)("%" + e + "%"))));
            criteria.add((Criterion)disjunction);
        }
        if (StringUtils.isNotEmpty((CharSequence)filter.getEmailTo())) {
            criteria.add(Restrictions.ilike((String)"emailTo", (Object)("%" + filter.getEmailTo() + "%")));
        }
        if (StringUtils.isNotEmpty((CharSequence)filter.getPhrase())) {
            criteria.add(Restrictions.ilike((String)"templateDefinition.phrase", (Object)("%" + filter.getPhrase() + "%")));
        }
        if (filter.getPhraseLocation() != null) {
            criteria.add((Criterion)Restrictions.eq((String)"templateDefinition.phraseLocation", (Object)((Object)filter.getPhraseLocation())));
        }
        if (filter.getPriority() != null) {
            criteria.add((Criterion)Restrictions.eq((String)"templateDefinition.priority", (Object)filter.getPriority()));
        }
        if (filter.getFileId() != null) {
            criteria.add((Criterion)Restrictions.eq((String)"templateDefinition.fileId", (Object)filter.getFileId()));
        }
        if (withOrder && StringUtils.isNotBlank((CharSequence)filter.getSortBy())) {
            switch (filter.getSortDirection()) {
                case ASC: {
                    criteria.addOrder(Property.forName((String)this.translateSortBy(filter.getSortBy())).asc());
                    break;
                }
                case DESC: {
                    criteria.addOrder(Property.forName((String)this.translateSortBy(filter.getSortBy())).desc());
                    break;
                }
            }
        }
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        return criteria;
    }

    private String translateSortBy(String sortBy) {
        switch (sortBy) {
            case "template_id": {
                return "id";
            }
            case "emails_from": {
                return "ef.emailFrom";
            }
            case "email_to": {
                return "emailTo";
            }
            case "phrase": {
                return "templateDefinition.phrase";
            }
            case "phrase_location": {
                return "templateDefinition.phraseLocation";
            }
            case "priority": {
                return "templateDefinition.priority";
            }
        }
        return "id";
    }

    @Override
    public List<Template> findByEmails(String emailFrom, String emailTo, boolean domainMatch) {
        DetachedCriteria criteria = DetachedCriteria.forClass(Template.class);
        criteria.createAlias("emailsFrom", "ef");
        if (domainMatch) {
            criteria.add(TemplateDaoImpl.buildEmailFromWithDomainCriterion(emailFrom));
        } else {
            criteria.add((Criterion)Restrictions.eq((String)"ef.emailFrom", (Object)emailFrom).ignoreCase());
        }
        if (StringUtils.isNotBlank((CharSequence)emailTo)) {
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"emailTo", (Object)emailTo).ignoreCase(), (Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"emailTo", (Object)""), (Criterion)Restrictions.isNull((String)"emailTo"))));
        }
        criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.isNotNull((String)"templateDefinition.fileId"), (Criterion)Restrictions.ne((String)"templateDefinition.fileId", (Object)-1L)));
        criteria.addOrder(Property.forName((String)"templateDefinition.priority").asc());
        return this.findByCriteria(criteria);
    }

    private static Criterion buildEmailFromWithDomainCriterion(String emailFrom) {
        String domainEmailFrom = "*@" + StringUtils.substringAfter((String)emailFrom, (String)AT);
        return Restrictions.or((Criterion)Restrictions.eq((String)"ef.emailFrom", (Object)emailFrom).ignoreCase(), (Criterion)Restrictions.eq((String)"ef.emailFrom", (Object)domainEmailFrom).ignoreCase());
    }

    @Override
    public Optional<Template> findByEmailsWithoutFile(String emailFrom, String emailTo) {
        DetachedCriteria criteria = DetachedCriteria.forClass(Template.class);
        criteria.createAlias("emailsFrom", "ef").add((Criterion)Restrictions.eq((String)"ef.emailFrom", (Object)emailFrom).ignoreCase());
        if (StringUtils.isNotBlank((CharSequence)emailTo)) {
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"emailTo", (Object)emailTo).ignoreCase(), (Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"emailTo", (Object)""), (Criterion)Restrictions.isNull((String)"emailTo"))));
        }
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"templateDefinition.fileId"), (Criterion)Restrictions.eq((String)"templateDefinition.fileId", (Object)-1L)));
        return Optional.ofNullable(this.findOne(criteria));
    }

    @Override
    public boolean exists(String emailFrom, String emailTo) {
        DetachedCriteria criteria = DetachedCriteria.forClass(Template.class);
        criteria.createAlias("emailsFrom", "ef").add(TemplateDaoImpl.buildEmailFromWithDomainCriterion(emailFrom));
        if (StringUtils.isNotBlank((CharSequence)emailTo)) {
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"emailTo", (Object)emailTo).ignoreCase(), (Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"emailTo", (Object)""), (Criterion)Restrictions.isNull((String)"emailTo"))));
        }
        List templates = this.findByCriteria(criteria);
        return CollectionUtils.isNotEmpty((Collection)templates);
    }

    @Override
    public List<OldTemplate> findAllOldTemplates() {
        if (this.doesOldTableExist()) {
            return (List)this.getSession().doReturningWork((ReturningWork)new ReturningWork<List<OldTemplate>>(){

                public List<OldTemplate> execute(Connection connection) throws SQLException {
                    PreparedStatement statement = connection.prepareStatement(TemplateDaoImpl.FIND_ALL_OLD_TEMPLATES_QUERY);
                    ResultSet resultSet = statement.executeQuery();
                    ArrayList<OldTemplate> oldTemplates = new ArrayList<OldTemplate>();
                    while (resultSet.next()) {
                        oldTemplates.add(TemplateDaoImpl.this.buildOldTemplate(resultSet));
                    }
                    return oldTemplates;
                }
            });
        }
        return new ArrayList<OldTemplate>();
    }

    private boolean doesOldTableExist() {
        return HibernateUtil.tableExists((String)OLD_TEMPLATE_TABLE_NAME);
    }

    private OldTemplate buildOldTemplate(ResultSet resultSet) throws SQLException {
        OldTemplate oldTemplate = new OldTemplate();
        oldTemplate.setEmail(resultSet.getString(1));
        oldTemplate.setReceivingEmail(resultSet.getString(2));
        oldTemplate.setPhrase(resultSet.getString(3));
        oldTemplate.setPhraseLocation(resultSet.getString(4));
        oldTemplate.setPriority(resultSet.getInt(5));
        oldTemplate.setFileId(resultSet.getLong(6));
        return oldTemplate;
    }
}

