/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.dao.editopdf;

import com.plusmpm.database.hibernate.HibernateUtil;
import com.suncode.plugin.efaktura.dao.EfakturaHibernateEditableDao;
import com.suncode.plugin.efaktura.dao.editopdf.EdiToPdfDao;
import com.suncode.plugin.efaktura.model.editopdf.EdiToPdf;
import com.suncode.plugin.efaktura.model.editopdf.OldEdiToPdf;
import com.suncode.pwfl.search.SortDirection;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.jdbc.ReturningWork;
import org.springframework.stereotype.Repository;

@Repository
public class EdiToPdfDaoImpl
extends EfakturaHibernateEditableDao<EdiToPdf, Long>
implements EdiToPdfDao {
    private static final String OLD_EDI_TO_PDF_TABLE_NAME = "pm_plusefaktura_editopdf";
    private static final String FIND_ALL_OLD_EDI_TO_PDFS_QUERY = "select fromemail, editype, templatepath, docxtopdfconvertertype, filename from pm_plusefaktura_editopdf";

    @Override
    public List<EdiToPdf> findAll(Integer start, Integer limit, String sortBy, SortDirection sortDirection) {
        DetachedCriteria criteria = DetachedCriteria.forClass(EdiToPdf.class);
        criteria.addOrder(sortDirection == SortDirection.ASC ? Order.asc((String)sortBy) : Order.desc((String)sortBy));
        return this.findByCriteria(criteria, start, limit);
    }

    @Override
    public Optional<EdiToPdf> findByFromEmail(String fromEmail) {
        DetachedCriteria criteria = DetachedCriteria.forClass(EdiToPdf.class);
        criteria.add((Criterion)Restrictions.eq((String)"emailFrom", (Object)fromEmail));
        return Optional.ofNullable(this.findOne(criteria));
    }

    @Override
    public List<OldEdiToPdf> findAllOldEdiToPdfs() {
        if (this.doesOldTableExist()) {
            return (List)this.getSession().doReturningWork((ReturningWork)new ReturningWork<List<OldEdiToPdf>>(){

                public List<OldEdiToPdf> execute(Connection connection) throws SQLException {
                    PreparedStatement statement = connection.prepareStatement(EdiToPdfDaoImpl.FIND_ALL_OLD_EDI_TO_PDFS_QUERY);
                    ResultSet resultSet = statement.executeQuery();
                    ArrayList<OldEdiToPdf> oldEdiToPdfs = new ArrayList<OldEdiToPdf>();
                    while (resultSet.next()) {
                        oldEdiToPdfs.add(EdiToPdfDaoImpl.this.buildOldEdiToPdf(resultSet));
                    }
                    return oldEdiToPdfs;
                }
            });
        }
        return new ArrayList<OldEdiToPdf>();
    }

    private boolean doesOldTableExist() {
        return HibernateUtil.tableExists((String)OLD_EDI_TO_PDF_TABLE_NAME);
    }

    private OldEdiToPdf buildOldEdiToPdf(ResultSet resultSet) throws SQLException {
        OldEdiToPdf oldEdiToPdf = new OldEdiToPdf();
        oldEdiToPdf.setFromEmail(resultSet.getString(1));
        oldEdiToPdf.setEdiType(resultSet.getString(2));
        oldEdiToPdf.setTemplatePath(resultSet.getString(3));
        oldEdiToPdf.setDocxToPdfConverterType(resultSet.getString(4));
        oldEdiToPdf.setFileName(resultSet.getString(5));
        return oldEdiToPdf;
    }
}

