/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.util.recordindex;

import com.suncode.plugin.efaktura.util.recordindex.PdfTableRecord;
import com.suncode.plugin.efaktura.util.recordindex.PdfTableRecordProcessor;
import com.suncode.plugin.efaktura.util.recordindex.RecordFormatAction;
import java.math.BigDecimal;

public class PdfTableRecordProcessorImpl
implements PdfTableRecordProcessor {
    @Override
    public String process(PdfTableRecord record, String recordFormatAction) {
        switch (RecordFormatAction.getByName(recordFormatAction)) {
            case ADD_LINES: {
                return this.addLines(record);
            }
            case MAX_VALUE: {
                return this.maxValue(record);
            }
            case MIN_VALUE: {
                return this.minValue(record);
            }
        }
        return this.joinLines(record);
    }

    private String addLines(PdfTableRecord record) {
        double result = new Double(0.0);
        for (String line : record) {
            try {
                String number = line.replaceAll(",", ".").replaceAll(" ", "");
                result = this.add(result, new BigDecimal(number).doubleValue());
            }
            catch (Exception exception) {}
        }
        return String.valueOf(result);
    }

    private double add(double element1, double element2) {
        return BigDecimal.valueOf(element1).add(BigDecimal.valueOf(element2)).doubleValue();
    }

    private String maxValue(PdfTableRecord record) {
        double result = Double.MIN_VALUE;
        for (String line : record) {
            try {
                double number = Double.valueOf(line.replaceAll(",", ".").replaceAll(" ", ""));
                if (!(number > result)) continue;
                result = number;
            }
            catch (Exception exception) {}
        }
        return String.valueOf(result);
    }

    private String minValue(PdfTableRecord record) {
        double result = Double.MAX_VALUE;
        for (String line : record) {
            try {
                double number = Double.valueOf(line.replaceAll(",", ".").replaceAll(" ", ""));
                if (!(number < result)) continue;
                result = number;
            }
            catch (Exception exception) {}
        }
        return String.valueOf(result);
    }

    private String joinLines(PdfTableRecord record) {
        StringBuilder result = new StringBuilder();
        int counter = 1;
        for (String line : record) {
            result.append(line);
            if (counter < record.size()) {
                result.append(" ");
            }
            ++counter;
        }
        return result.toString();
    }
}

