/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.util.emailtopdf;

import com.suncode.plugin.efaktura.util.AdditionalOptions;
import com.suncode.plugin.efaktura.util.Workaround;
import com.suncode.plugin.efaktura.util.emailtopdf.EmailPart;
import com.suncode.plugin.efaktura.util.emailtopdf.HtmlPartExtractor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.w3c.tidy.Tidy;

public class HtmlPartExtractorImpl
implements HtmlPartExtractor {
    private static final String FONT_TAG = "font";
    private static final String PARAGRAPH_TAG = "p";
    private static final String STYLE_ATTRIBUTE_NAME = "style";

    @Override
    public String extract(EmailPart part, AdditionalOptions additionalOptions) throws IOException {
        String html = this.getRawHtml(part, additionalOptions);
        html = this.convertStyles(html);
        html = this.tidy(html);
        return html;
    }

    private String getRawHtml(EmailPart part, AdditionalOptions additionalOptions) throws IOException {
        byte[] bytes = null;
        try {
            bytes = IOUtils.toByteArray((InputStream)part.getInputStream());
        }
        catch (ArrayIndexOutOfBoundsException exception) {
            Workaround.imapMessageNumberOutOfBounds(additionalOptions.getFolder());
            bytes = IOUtils.toByteArray((InputStream)part.getInputStream());
        }
        return new String(bytes, "UTF-8");
    }

    private String convertStyles(String html) {
        Document document = Jsoup.parse((String)html);
        for (Element fontTag : document.getElementsByTag(FONT_TAG)) {
            Element parent = this.getOrCreateParent(fontTag, PARAGRAPH_TAG);
            this.rewriteElementStyleAttribute(fontTag, parent);
        }
        return document.html();
    }

    private Element getOrCreateParent(Element element, String tagName) {
        for (Element parent : element.parents()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)parent.tagName(), (CharSequence)tagName)) continue;
            return parent;
        }
        String newElementHtml = this.buildNewElementHtml(tagName);
        return element.wrap(newElementHtml);
    }

    private String buildNewElementHtml(String tagName) {
        StringBuilder html = new StringBuilder();
        html.append("<");
        html.append(tagName);
        html.append(">");
        html.append("</");
        html.append(tagName);
        html.append(">");
        return html.toString();
    }

    private void rewriteElementStyleAttribute(Element from, Element to) {
        ArrayList<String> style = new ArrayList<String>();
        for (Attribute attribute : from.attributes()) {
            style.add(this.buildStyleProperty(attribute));
        }
        this.setElementAttribute(to, STYLE_ATTRIBUTE_NAME, StringUtils.join(style, (String)""));
    }

    private String buildStyleProperty(Attribute attribute) {
        StringBuilder property = new StringBuilder();
        property.append(attribute.getKey());
        property.append(": ");
        property.append(attribute.getValue());
        property.append(";");
        return property.toString();
    }

    private void setElementAttribute(Element element, String attributeName, String attributeValue) {
        String initialStyle = element.attr(attributeName);
        if (StringUtils.isBlank((CharSequence)initialStyle)) {
            element.attr(attributeName, attributeValue);
        } else {
            element.attr(attributeName, this.buildAttributeValue(initialStyle, attributeValue));
        }
    }

    private String buildAttributeValue(String initialValue, String newValue) {
        StringBuilder value = new StringBuilder();
        value.append(initialValue);
        value.append(" ");
        value.append(newValue);
        return value.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String tidy(String html) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = IOUtils.toInputStream((String)html, (String)"UTF-8");
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            Tidy tidy = this.buildTidy();
            tidy.parse(inputStream, (OutputStream)outputStream);
            byte[] bytes = outputStream.toByteArray();
            String string = new String(bytes, Charset.forName("UTF-8"));
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    private Tidy buildTidy() {
        Tidy tidy = new Tidy();
        tidy.setXHTML(true);
        tidy.setShowWarnings(false);
        tidy.setInputEncoding(StandardCharsets.UTF_8.name());
        tidy.setOutputEncoding(StandardCharsets.UTF_8.name());
        tidy.setConfigurationFromProps(this.buildTidyProperties());
        return tidy;
    }

    private Properties buildTidyProperties() {
        Properties properties = new Properties();
        properties.setProperty("new-blocklevel-tags", "article aside bdi details dialog figcaption figure footer header hgroup main mark menuitem meter nav progress rp rt ruby section summary time wbr o:p");
        return properties;
    }
}

