/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.util;

public class ClassLoaderUtils {
    public static <E extends Throwable> void doInContextClassLoader(Action<E> action) throws E {
        ClassLoader prevContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ClassLoaderUtils.class.getClassLoader());
            action.perform();
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevContextClassLoader);
        }
    }

    public static <R, E extends Throwable> R doInContextClassLoader(ActionWithResult<R, E> action) throws E {
        ClassLoader prevContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ClassLoaderUtils.class.getClassLoader());
            R r = action.perform();
            return r;
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevContextClassLoader);
        }
    }

    public static interface ActionWithResult<R, E extends Throwable> {
        public R perform() throws E;
    }

    public static interface Action<E extends Throwable> {
        public void perform() throws E;
    }
}

