/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.util;

import com.suncode.plugin.efaktura.util.AddAttachmentsToArchiveAction;
import com.suncode.plugin.efaktura.util.AddResult;
import com.suncode.plugin.efaktura.util.AdditionalOptions;
import com.suncode.plugin.efaktura.util.PlusEFakturaTools;
import com.suncode.plugin.efaktura.util.SubjectAsIndexesResolver;
import com.suncode.plugin.efaktura.util.emailtopdf.EmailToPdfConverterImpl;
import com.suncode.plugin.efaktura.util.exception.PlusEFakturaException;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import javax.mail.Message;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class AddMailAsPdfToArchiveAction {
    public static Logger log = Logger.getLogger(AddMailAsPdfToArchiveAction.class);
    public static Logger clientLog = Logger.getLogger((String)"PlusEFakturaClientLog");

    public static void addMailAsPdf(Message message, Message messageFromMailbox, String msgId, String mailboxFolder, AdditionalOptions additionalOptions, String archiveClass) {
        log.trace((Object)("******************** addMailAsPdf(Message, Message, msgId=" + msgId + ", mailboxFolder=" + mailboxFolder + ", AdditionalOptions, archiveClass=" + archiveClass + ") ********************"));
        File file = null;
        String fileId = "";
        AddResult addResult = new AddResult();
        HashSet<String> indexes = new HashSet<String>();
        try {
            log.info((Object)("Dodawanie wiadomosci jako pdf do archiwum do klasy dokumentow " + archiveClass));
            clientLog.info((Object)("Dodawanie wiadomosci jako pdf do archiwum do klasy dokumentow " + archiveClass));
            String emailIndex = additionalOptions.getEmailToIndexForMailAsPdf();
            String dateIndex = additionalOptions.getDateToIndexForMailAsPdf();
            String subjectIndex = additionalOptions.getSubjectToIndexForMailAsPdf();
            String contentIndex = additionalOptions.getContentToIndexForMailAsPdf();
            String toIndex = additionalOptions.getToToIndexForMailAsPdf();
            String ccIndex = additionalOptions.getCcToIndexForMailAsPdf();
            String msgIdIndex = additionalOptions.getMessageIdToIndexForMailAsPdf();
            String mailboxIndex = additionalOptions.getMailboxToIndexForMailAsPdf();
            String mailboxFolderIndex = additionalOptions.getMailboxFolderToIndexForMailAsPdf();
            String emailAddress = "";
            Object[] addresses = message.getFrom();
            if (ArrayUtils.isNotEmpty((Object[])addresses)) {
                emailAddress = addresses[0].toString();
            }
            try {
                if (StringUtils.isNotBlank((CharSequence)emailIndex)) {
                    String emailIndexId = PlusEFakturaTools.getIndexIdForDocClass(archiveClass, emailIndex);
                    if (!emailIndexId.equalsIgnoreCase("-1")) {
                        String sender = (String)StringUtils.defaultIfEmpty((CharSequence)PlusEFakturaTools.getAddressFromString(emailAddress), (CharSequence)"N/A");
                        indexes.add(emailIndexId + ";" + sender);
                    } else {
                        log.warn((Object)("Indeks o nazwie " + emailIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                        clientLog.warn((Object)("Indeks o nazwie " + emailIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)dateIndex)) {
                    String dateIndexId = PlusEFakturaTools.getIndexIdForDocClass(archiveClass, dateIndex);
                    if (!dateIndexId.equalsIgnoreCase("-1")) {
                        Date newDate = message.getSentDate();
                        if (newDate != null) {
                            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            indexes.add(dateIndexId + ";" + dateFormat.format(newDate));
                        } else {
                            log.warn((Object)"Nie udalo sie pobrac daty wiadomosci");
                            clientLog.warn((Object)"Nie udalo sie pobrac daty wiadomosci");
                        }
                    } else {
                        log.warn((Object)("Indeks o nazwie " + dateIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                        clientLog.warn((Object)("Indeks o nazwie " + dateIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)subjectIndex)) {
                    String subjectIndexId = PlusEFakturaTools.getIndexIdForDocClass(archiveClass, subjectIndex);
                    if (!subjectIndexId.equalsIgnoreCase("-1")) {
                        String subject = PlusEFakturaTools.decodeText(message.getSubject(), false, false);
                        indexes.add(subjectIndexId + ";" + subject);
                    } else {
                        log.warn((Object)("Indeks o nazwie " + subjectIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                        clientLog.warn((Object)("Indeks o nazwie " + subjectIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)contentIndex)) {
                    String contentIndexId = PlusEFakturaTools.getIndexIdForDocClass(archiveClass, contentIndex);
                    if (!contentIndexId.equalsIgnoreCase("-1")) {
                        String content = PlusEFakturaTools.getMessageContent(message);
                        indexes.add(contentIndexId + ";" + PlusEFakturaTools.verifyEmailContent(content));
                    } else {
                        log.warn((Object)("Indeks o nazwie " + contentIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                        clientLog.warn((Object)("Indeks o nazwie " + contentIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)toIndex)) {
                    String toIndexId = PlusEFakturaTools.getIndexIdForDocClass(archiveClass, toIndex);
                    if (!toIndexId.equalsIgnoreCase("-1")) {
                        String to = (String)StringUtils.defaultIfEmpty((CharSequence)PlusEFakturaTools.getTo(message), (CharSequence)"N/A");
                        indexes.add(toIndexId + ";" + to);
                    } else {
                        log.warn((Object)("Indeks o nazwie " + toIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                        clientLog.warn((Object)("Indeks o nazwie " + toIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)ccIndex)) {
                    String ccIndexId = PlusEFakturaTools.getIndexIdForDocClass(archiveClass, ccIndex);
                    if (!ccIndexId.equalsIgnoreCase("-1")) {
                        String cc = (String)StringUtils.defaultIfEmpty((CharSequence)PlusEFakturaTools.getCc(message), (CharSequence)"N/A");
                        indexes.add(ccIndexId + ";" + cc);
                    } else {
                        log.warn((Object)("Indeks o nazwie " + ccIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                        clientLog.warn((Object)("Indeks o nazwie " + ccIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)msgIdIndex)) {
                    String msgIdIndexId = PlusEFakturaTools.getIndexIdForDocClass(archiveClass, msgIdIndex);
                    if (!msgIdIndexId.equalsIgnoreCase("-1")) {
                        indexes.add(msgIdIndexId + ";" + msgId);
                    } else {
                        log.warn((Object)("Indeks o nazwie " + msgIdIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                        clientLog.warn((Object)("Indeks o nazwie " + msgIdIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)mailboxIndex)) {
                    String mailboxIndexId = PlusEFakturaTools.getIndexIdForDocClass(archiveClass, mailboxIndex);
                    if (!mailboxIndexId.equalsIgnoreCase("-1")) {
                        indexes.add(mailboxIndexId + ";" + additionalOptions.getMailboxAddress());
                    } else {
                        log.warn((Object)("Indeks o nazwie " + mailboxIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                        clientLog.warn((Object)("Indeks o nazwie " + mailboxIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)mailboxFolderIndex)) {
                    String mailboxFolderIndexId = PlusEFakturaTools.getIndexIdForDocClass(archiveClass, mailboxFolderIndex);
                    if (!mailboxFolderIndexId.equalsIgnoreCase("-1")) {
                        indexes.add(mailboxFolderIndexId + ";" + mailboxFolder);
                    } else {
                        log.warn((Object)("Indeks o nazwie " + mailboxFolderIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                        clientLog.warn((Object)("Indeks o nazwie " + mailboxFolderIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                    }
                }
                if (AddMailAsPdfToArchiveAction.shouldResolveSubjectAsIndexes(additionalOptions)) {
                    String emailSubject = PlusEFakturaTools.decodeText(message.getSubject(), false, false);
                    SubjectAsIndexesResolver subjectAsIndexesResolver = new SubjectAsIndexesResolver(additionalOptions.getSubjectAsIndexesDelimiterForMailAsPdf(), additionalOptions.getSubjectAsIndexesSequenceForMailAsPdf(), emailSubject, archiveClass, additionalOptions);
                    indexes.addAll(subjectAsIndexesResolver.resolve());
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            file = AddMailAsPdfToArchiveAction.convertMailToPdf(message, additionalOptions);
            if (file == null || !file.exists()) {
                throw new PlusEFakturaException("Brak pliku tymczasowego. Wstrzymano dodawanie pliku wiadomosci jako pdf do archiwum");
            }
            fileId = AddAttachmentsToArchiveAction.preparationsForAdding(messageFromMailbox, file, indexes, archiveClass, file.getName(), null, additionalOptions, addResult);
            if (!fileId.equalsIgnoreCase("-1") && !fileId.equalsIgnoreCase("-2")) {
                log.info((Object)("Zapis wiadomosci jako pdf do klasy dokumentow " + archiveClass + " zakonczony powodzeniem"));
                clientLog.info((Object)("Zapis wiadomosci jako pdf do klasy dokumentow " + archiveClass + " zakonczony powodzeniem"));
            } else {
                log.warn((Object)("Zapis wiadomosci jako pdf do klasy dokumentow " + archiveClass + " zakonczony niepowodzeniem. Status bledu: " + addResult.getMsgStatus()));
                clientLog.warn((Object)("Zapis wiadomosci jako pdf do klasy dokumentow " + archiveClass + " zakonczony niepowodzeniem. Status bledu: " + addResult.getMsgStatus()));
            }
        }
        catch (PlusEFakturaException e) {
            log.warn((Object)e.getMessage());
            clientLog.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static File convertMailToPdf(Message message, AdditionalOptions additionalOptions) {
        EmailToPdfConverterImpl converter = new EmailToPdfConverterImpl();
        return converter.convert(message, additionalOptions);
    }

    private static boolean shouldResolveSubjectAsIndexes(AdditionalOptions additionalOptions) {
        return StringUtils.equalsIgnoreCase((CharSequence)additionalOptions.getSubjectAsIndexesForMailAsPdf(), (CharSequence)"TRUE") && StringUtils.isNotBlank((CharSequence)additionalOptions.getSubjectAsIndexesDelimiterForMailAsPdf()) && StringUtils.isNotBlank((CharSequence)additionalOptions.getSubjectAsIndexesSequenceForMailAsPdf());
    }
}

