/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.util;

import com.suncode.plugin.efaktura.util.AddAttachmentsToArchiveAction;
import com.suncode.plugin.efaktura.util.AddResult;
import com.suncode.plugin.efaktura.util.AdditionalOptions;
import com.suncode.plugin.efaktura.util.PlusEFakturaTools;
import com.suncode.plugin.efaktura.util.SubjectAsIndexesResolver;
import com.suncode.plugin.efaktura.util.Workaround;
import com.suncode.plugin.efaktura.util.exception.PlusEFakturaException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import javax.mail.Message;
import javax.mail.internet.MimeUtility;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class AddEmlToArchiveAction {
    public static Logger log = Logger.getLogger(AddEmlToArchiveAction.class);
    public static Logger clientLog = Logger.getLogger((String)"PlusEFakturaClientLog");

    public static void addEml(Message message, Message messageFromMailbox, String msgId, String mailboxFolder, AdditionalOptions additionalOptions, String archiveClass) throws Exception {
        log.trace((Object)("******************** AddEml(Message, Message, msgId=" + msgId + ", mailboxFolder=" + mailboxFolder + ", AdditionalOptions, archiveClass=" + archiveClass + ") ********************"));
        String nameOfTheFile = "";
        String archiveFileName = "";
        String subject = "";
        String sExt = "eml";
        File emlFile = null;
        String fileId = "";
        AddResult addResult = new AddResult();
        HashSet<String> indexesMail = new HashSet<String>();
        log.info((Object)("Dodawanie pliku eml do archiwum do klasy dokumentow " + archiveClass));
        clientLog.info((Object)("Dodawanie pliku eml do archiwum do klasy dokumentow " + archiveClass));
        String emailIndex = additionalOptions.getEmailToIndexForMail();
        String toIndex = additionalOptions.getToToIndexForMail();
        String ccIndex = additionalOptions.getCcToIndexForMail();
        String dateIndex = additionalOptions.getDateToIndexForMail();
        String subjectIndex = additionalOptions.getSubjectToIndexForMail();
        String contentIndex = additionalOptions.getContentToIndexForMail();
        String fileNameIndex = additionalOptions.getFileNameToIndexForMail();
        String extIndex = additionalOptions.getExtensionToIndexForMail();
        String msgIdIndex = additionalOptions.getMessageIdToIndexForMail();
        String mailboxIndex = additionalOptions.getMailboxToIndexForMail();
        String mailboxFolderIndex = additionalOptions.getMailboxFolderToIndexForMail();
        String emailAddress = PlusEFakturaTools.getFrom(message, additionalOptions);
        subject = PlusEFakturaTools.decodeText(message.getSubject(), false, false);
        if (StringUtils.isBlank((CharSequence)subject)) {
            SecureRandom random = new SecureRandom();
            long n = random.nextLong();
            n = n == Long.MIN_VALUE ? 0L : Math.abs(n);
            subject = String.valueOf(n);
        }
        nameOfTheFile = RandomStringUtils.randomAlphanumeric((int)32) + "." + sExt;
        archiveFileName = AddEmlToArchiveAction.clearFileName(subject + "." + sExt);
        try {
            if (StringUtils.isNotBlank((CharSequence)emailIndex)) {
                String emailIndexId = PlusEFakturaTools.getIndexIdForDocClass(archiveClass, emailIndex);
                if (!emailIndexId.equalsIgnoreCase("-1")) {
                    String sender = emailAddress;
                    if (StringUtils.isBlank((CharSequence)sender)) {
                        sender = "N/A";
                    }
                    indexesMail.add(emailIndexId + ";" + sender);
                } else {
                    log.warn((Object)("Indeks o nazwie " + emailIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                    clientLog.warn((Object)("Indeks o nazwie " + emailIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)toIndex)) {
                String toIndexId = PlusEFakturaTools.getIndexIdForDocClass(archiveClass, toIndex);
                if (!toIndexId.equalsIgnoreCase("-1")) {
                    String to = PlusEFakturaTools.getTo(message);
                    if (StringUtils.isBlank((CharSequence)to)) {
                        to = "N/A";
                    }
                    indexesMail.add(toIndexId + ";" + to);
                } else {
                    log.warn((Object)("Indeks o nazwie " + toIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                    clientLog.warn((Object)("Indeks o nazwie " + toIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)ccIndex)) {
                String ccIndexId = PlusEFakturaTools.getIndexIdForDocClass(archiveClass, ccIndex);
                if (!ccIndexId.equalsIgnoreCase("-1")) {
                    String cc = PlusEFakturaTools.getCc(message);
                    if (StringUtils.isBlank((CharSequence)cc)) {
                        cc = "N/A";
                    }
                    indexesMail.add(ccIndexId + ";" + cc);
                } else {
                    log.warn((Object)("Indeks o nazwie " + ccIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                    clientLog.warn((Object)("Indeks o nazwie " + ccIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)dateIndex)) {
                String dateIndexId = PlusEFakturaTools.getIndexIdForDocClass(archiveClass, dateIndex);
                if (!dateIndexId.equalsIgnoreCase("-1")) {
                    Date newDate = message.getSentDate();
                    if (newDate != null) {
                        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        indexesMail.add(dateIndexId + ";" + dateFormat.format(newDate));
                    } else {
                        log.warn((Object)"Nie udalo sie pobrac daty wiadomosci");
                        clientLog.warn((Object)"Nie udalo sie pobrac daty wiadomosci");
                    }
                } else {
                    log.warn((Object)("Indeks o nazwie " + dateIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                    clientLog.warn((Object)("Indeks o nazwie " + dateIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)subjectIndex)) {
                String subjectIndexId = PlusEFakturaTools.getIndexIdForDocClass(archiveClass, subjectIndex);
                if (!subjectIndexId.equalsIgnoreCase("-1")) {
                    indexesMail.add(subjectIndexId + ";" + subject);
                } else {
                    log.warn((Object)("Indeks o nazwie " + subjectIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                    clientLog.warn((Object)("Indeks o nazwie " + subjectIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)contentIndex)) {
                String contentIndexId = PlusEFakturaTools.getIndexIdForDocClass(archiveClass, contentIndex);
                if (!contentIndexId.equalsIgnoreCase("-1")) {
                    String emailContent = PlusEFakturaTools.getMessageContent(message);
                    indexesMail.add(contentIndexId + ";" + PlusEFakturaTools.verifyEmailContent(emailContent));
                } else {
                    log.warn((Object)("Indeks o nazwie " + contentIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                    clientLog.warn((Object)("Indeks o nazwie " + contentIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)extIndex)) {
                String extIndexId = PlusEFakturaTools.getIndexIdForDocClass(archiveClass, extIndex);
                if (!extIndexId.equalsIgnoreCase("-1")) {
                    indexesMail.add(extIndexId + ";" + sExt);
                } else {
                    log.warn((Object)("Indeks o nazwie " + extIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                    clientLog.warn((Object)("Indeks o nazwie " + extIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)msgIdIndex)) {
                String msgIdIndexId = PlusEFakturaTools.getIndexIdForDocClass(archiveClass, msgIdIndex);
                if (!msgIdIndexId.equalsIgnoreCase("-1")) {
                    indexesMail.add(msgIdIndexId + ";" + msgId);
                } else {
                    log.warn((Object)("Indeks o nazwie " + msgIdIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                    clientLog.warn((Object)("Indeks o nazwie " + msgIdIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)mailboxIndex)) {
                String mailboxIndexId = PlusEFakturaTools.getIndexIdForDocClass(archiveClass, mailboxIndex);
                if (!mailboxIndexId.equalsIgnoreCase("-1")) {
                    indexesMail.add(mailboxIndexId + ";" + additionalOptions.getMailboxAddress());
                } else {
                    log.warn((Object)("Indeks o nazwie " + mailboxIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                    clientLog.warn((Object)("Indeks o nazwie " + mailboxIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)mailboxFolderIndex)) {
                String mailboxFolderIndexId = PlusEFakturaTools.getIndexIdForDocClass(archiveClass, mailboxFolderIndex);
                if (!mailboxFolderIndexId.equalsIgnoreCase("-1")) {
                    indexesMail.add(mailboxFolderIndexId + ";" + mailboxFolder);
                } else {
                    log.warn((Object)("Indeks o nazwie " + mailboxFolderIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                    clientLog.warn((Object)("Indeks o nazwie " + mailboxFolderIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                }
            }
            if (AddEmlToArchiveAction.shouldResolveSubjectAsIndexes(additionalOptions)) {
                SubjectAsIndexesResolver subjectAsIndexesResolver = new SubjectAsIndexesResolver(additionalOptions.getSubjectAsIndexesDelimiterForMail(), additionalOptions.getSubjectAsIndexesSequenceForMail(), subject, archiveClass, additionalOptions);
                indexesMail.addAll(subjectAsIndexesResolver.resolve());
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        emlFile = AddEmlToArchiveAction.save(message, nameOfTheFile, additionalOptions);
        if (emlFile == null || !emlFile.exists()) {
            throw new PlusEFakturaException("Brak pliku tymczasowego. Wstrzymano dodawanie pliku eml do archiwum");
        }
        try {
            if (StringUtils.isNotBlank((CharSequence)fileNameIndex)) {
                String attachmentNameIndexId = PlusEFakturaTools.getIndexIdForDocClass(archiveClass, fileNameIndex);
                if (!attachmentNameIndexId.equalsIgnoreCase("-1")) {
                    indexesMail.add(attachmentNameIndexId + ";" + emlFile.getName());
                } else {
                    log.warn((Object)("Indeks o nazwie " + fileNameIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                    clientLog.warn((Object)("Indeks o nazwie " + fileNameIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        fileId = AddAttachmentsToArchiveAction.preparationsForAdding(messageFromMailbox, emlFile, indexesMail, archiveClass, archiveFileName, null, additionalOptions, addResult);
        if (!fileId.equalsIgnoreCase("-1") && !fileId.equalsIgnoreCase("-2")) {
            log.info((Object)("Zapis pliku eml do klasy dokumentow " + archiveClass + " zakonczony powodzeniem"));
            clientLog.info((Object)("Zapis pliku eml do klasy dokumentow " + archiveClass + " zakonczony powodzeniem"));
        } else {
            log.warn((Object)("Zapis pliku eml do klasy dokumentow " + archiveClass + " zakonczony niepowodzeniem. Status bledu: " + addResult.getMsgStatus()));
            clientLog.warn((Object)("Zapis pliku eml do klasy dokumentow " + archiveClass + " zakonczony niepowodzeniem. Status bledu: " + addResult.getMsgStatus()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static File save(Message message, String fileName, AdditionalOptions additionalOptions) {
        block23: {
            log.trace((Object)("******************** Save(Message, fileName=" + fileName + ", AdditionalOptions) ********************"));
            String sFullDirPath = "";
            File emlFile = null;
            OutputStream out = null;
            try {
                boolean bTempFileCreated;
                if (!StringUtils.isNotBlank((CharSequence)fileName)) break block23;
                fileName = AddEmlToArchiveAction.clearFileName(fileName);
                sFullDirPath = additionalOptions.getDirPathForTempFile();
                if (!(sFullDirPath = PlusEFakturaTools.convertBackslashesToSlashes(sFullDirPath)).endsWith("/")) {
                    sFullDirPath = sFullDirPath + "/";
                }
                sFullDirPath = sFullDirPath + fileName;
                log.info((Object)("Sciezka do pliku tymczasowego: " + sFullDirPath));
                emlFile = new File(sFullDirPath);
                if (emlFile.exists()) {
                    emlFile.delete();
                }
                if (!(bTempFileCreated = emlFile.createNewFile()) || !emlFile.exists()) {
                    throw new PlusEFakturaException("Nie utworzono pliku tymczasowego dla pliku eml " + fileName);
                }
                out = new FileOutputStream(emlFile);
                try {
                    message.writeTo(out);
                }
                catch (ArrayIndexOutOfBoundsException exception) {
                    Workaround.imapMessageNumberOutOfBounds(additionalOptions.getFolder());
                    message.writeTo(out);
                }
                File file = emlFile;
                return file;
            }
            catch (PlusEFakturaException e) {
                log.warn((Object)e.getMessage());
                clientLog.warn((Object)e.getMessage());
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    if (out != null) {
                        out.flush();
                        out.close();
                    }
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return null;
    }

    private static String clearFileName(String fileName) throws Exception {
        fileName = PlusEFakturaTools.convertBackslashesToSlashes(fileName);
        fileName = fileName.replaceAll("[/]", "_");
        fileName = fileName.replaceAll(":", "_");
        fileName = fileName.replaceAll("[*]", "_");
        fileName = fileName.replaceAll("[?]", "_");
        fileName = fileName.replaceAll("<", "_");
        fileName = fileName.replaceAll(">", "_");
        fileName = fileName.replaceAll("[|]", "_");
        fileName = fileName.replaceAll("\"", "_");
        fileName = fileName.replaceAll("\t", " ");
        fileName = fileName.replaceAll("\n", " ");
        fileName = fileName.replaceAll("\r", "");
        fileName = fileName.replaceAll("[^\\x00-\\x7F]", "");
        fileName = fileName.replaceAll("[\\p{Cntrl}&&[^\r\n\t]]", "");
        fileName = fileName.replaceAll("\\p{C}", "");
        return MimeUtility.decodeText((String)fileName);
    }

    private static boolean shouldResolveSubjectAsIndexes(AdditionalOptions additionalOptions) {
        return StringUtils.equalsIgnoreCase((CharSequence)additionalOptions.getSubjectAsIndexesForMail(), (CharSequence)"TRUE") && StringUtils.isNotBlank((CharSequence)additionalOptions.getSubjectAsIndexesDelimiterForMail()) && StringUtils.isNotBlank((CharSequence)additionalOptions.getSubjectAsIndexesSequenceForMail());
    }
}

