/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.service.template;

import com.suncode.plugin.efaktura.dao.template.TemplateDao;
import com.suncode.plugin.efaktura.i18n.TranslatorService;
import com.suncode.plugin.efaktura.model.template.Template;
import com.suncode.plugin.efaktura.util.TemplateFilter;
import com.suncode.plugin.efaktura.util.TemplatePhraseLocation;
import com.suncode.plugin.efaktura.util.Validator;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TemplateValidator {
    @Autowired
    private TemplateDao templateDao;
    @Autowired
    private TranslatorService translatorService;

    public void validateAdd(List<String> emailsFrom, String emailTo, String phrase, TemplatePhraseLocation phraseLocation, Integer priority) {
        if (!Validator.hasEmails(emailsFrom)) {
            throw new IllegalArgumentException(this.translatorService.translateMessage("efaktura.validator.add-template.error-message.no-supplier-email"));
        }
        if (!Validator.hasNoDuplications(emailsFrom)) {
            throw new IllegalArgumentException(this.translatorService.translateMessage("efaktura.validator.add-template.error-message.email-duplication"));
        }
        emailsFrom.forEach(e -> {
            if (!Validator.isValidEmail(e)) {
                throw new IllegalArgumentException(this.translatorService.translateMessage("efaktura.validator.add-template.error-message.wrong-email-format") + ": " + e);
            }
        });
        if (StringUtils.isNotBlank((CharSequence)emailTo) && !Validator.isValidEmail(emailTo)) {
            throw new IllegalArgumentException(this.translatorService.translateMessage("efaktura.validator.add-template.error-message.wrong-email-format") + ": " + emailTo);
        }
        if (!Validator.isPhraseValid(phrase, phraseLocation)) {
            throw new IllegalArgumentException(this.translatorService.translateMessage("efaktura.validator.add-template.error-message.invalid-phrase"));
        }
        Optional<Template> templateOpt = this.templateDao.find(TemplateFilter.builder().emailsFrom(emailsFrom).emailTo(emailTo).phrase(phrase).phraseLocation(phraseLocation).build());
        if (templateOpt.isPresent()) {
            throw new IllegalArgumentException(this.translatorService.translateMessage("efaktura.validator.add-template.error-message.template-exists"));
        }
        emailsFrom.forEach(e -> {
            List<Template> templates = this.templateDao.findByEmails((String)e, emailTo, false);
            boolean has = templates.stream().filter(t -> t.getTemplateDefinition().getPriority().intValue() == priority.intValue()).findFirst().isPresent();
            if (has) {
                throw new IllegalArgumentException(this.translatorService.translateMessage("efaktura.validator.add-template.error-message.email-address") + ": " + e + ". " + this.translatorService.translateMessage("efaktura.validator.add-template.error-message.template-with-priority-exists"));
            }
        });
    }

    public void validateSimpleAdd(List<String> emailsFrom, String emailTo) {
        if (!Validator.hasEmails(emailsFrom)) {
            throw new IllegalArgumentException(this.translatorService.translateMessage("efaktura.validator.add-template.error-message.no-supplier-email"));
        }
        if (!Validator.hasNoDuplications(emailsFrom)) {
            throw new IllegalArgumentException(this.translatorService.translateMessage("efaktura.validator.add-template.error-message.email-duplication"));
        }
        emailsFrom.forEach(e -> {
            if (!Validator.isValidEmail(e)) {
                throw new IllegalArgumentException(this.translatorService.translateMessage("efaktura.validator.add-template.error-message.wrong-email-format") + ": " + e);
            }
        });
        if (StringUtils.isNotBlank((CharSequence)emailTo) && !Validator.isValidEmail(emailTo)) {
            throw new IllegalArgumentException(this.translatorService.translateMessage("efaktura.validator.add-template.error-message.wrong-email-format") + ": " + emailTo);
        }
        Optional<Template> templateOpt = this.templateDao.find(TemplateFilter.builder().emailsFrom(emailsFrom).emailTo(emailTo).phrase(null).phraseLocation(null).fileId(-1L).build());
        if (templateOpt.isPresent()) {
            throw new IllegalArgumentException(this.translatorService.translateMessage("efaktura.validator.add-template.error-message.template-exists"));
        }
        emailsFrom.forEach(e -> {
            List<Template> templates = this.templateDao.findByEmails((String)e, emailTo, false);
            boolean has = templates.stream().filter(t -> t.getTemplateDefinition().getPriority() == 1).findFirst().isPresent();
            if (has) {
                throw new IllegalArgumentException(this.translatorService.translateMessage("efaktura.validator.add-template.error-message.email-address") + ": " + e + ". " + this.translatorService.translateMessage("efaktura.validator.add-template.error-message.template-with-priority-exists"));
            }
        });
    }

    public void validateUpdate(Long id, List<String> emailsFrom, String emailTo, String phrase, TemplatePhraseLocation phraseLocation) {
        if (id == null) {
            throw new IllegalArgumentException(this.translatorService.translateMessage("efaktura.validator.update-template.no-template-selected"));
        }
        if (!Validator.hasEmails(emailsFrom)) {
            throw new IllegalArgumentException(this.translatorService.translateMessage("efaktura.validator.update-template.error-message.no-supplier-email"));
        }
        if (!Validator.hasNoDuplications(emailsFrom)) {
            throw new IllegalArgumentException(this.translatorService.translateMessage("efaktura.validator.update-template.error-message.email-duplication"));
        }
        emailsFrom.forEach(e -> {
            if (!Validator.isValidEmail(e)) {
                throw new IllegalArgumentException(this.translatorService.translateMessage("efaktura.validator.update-template.error-message.wrong-email-format") + ": " + e);
            }
        });
        if (StringUtils.isNotBlank((CharSequence)emailTo) && !Validator.isValidEmail(emailTo)) {
            throw new IllegalArgumentException(this.translatorService.translateMessage("efaktura.validator.update-template.error-message.wrong-email-format") + ": " + emailTo);
        }
        if (!Validator.isPhraseValid(phrase, phraseLocation)) {
            throw new IllegalArgumentException(this.translatorService.translateMessage("efaktura.validator.update-template.error-message.invalid-phrase"));
        }
        Template template = (Template)this.templateDao.get(id);
        if (template == null) {
            throw new IllegalArgumentException(this.translatorService.translateMessage("efaktura.validator.update-template.template-does-not-exist"));
        }
        Optional<Template> templateOpt = this.templateDao.find(TemplateFilter.builder().emailsFrom(emailsFrom).emailTo(emailTo).phrase(phrase).phraseLocation(phraseLocation).build());
        if (templateOpt.isPresent() && templateOpt.get().getId() != id) {
            throw new IllegalArgumentException(this.translatorService.translateMessage("efaktura.validator.update-template.error-message.template-exists"));
        }
    }

    public void validateSimpleUpdate(Long id, List<String> emailsFrom, String emailTo) {
        if (id == null) {
            throw new IllegalArgumentException(this.translatorService.translateMessage("efaktura.validator.update-template.no-template-selected"));
        }
        if (!Validator.hasEmails(emailsFrom)) {
            throw new IllegalArgumentException(this.translatorService.translateMessage("efaktura.validator.update-template.error-message.no-supplier-email"));
        }
        if (!Validator.hasNoDuplications(emailsFrom)) {
            throw new IllegalArgumentException(this.translatorService.translateMessage("efaktura.validator.update-template.error-message.email-duplication"));
        }
        emailsFrom.forEach(e -> {
            if (!Validator.isValidEmail(e)) {
                throw new IllegalArgumentException(this.translatorService.translateMessage("efaktura.validator.update-template.error-message.wrong-email-format") + ": " + e);
            }
        });
        if (StringUtils.isNotBlank((CharSequence)emailTo) && !Validator.isValidEmail(emailTo)) {
            throw new IllegalArgumentException(this.translatorService.translateMessage("efaktura.validator.update-template.error-message.wrong-email-format") + ": " + emailTo);
        }
        Template template = (Template)this.templateDao.get(id);
        if (template == null) {
            throw new IllegalArgumentException(this.translatorService.translateMessage("efaktura.validator.update-template.template-does-not-exist"));
        }
        Optional<Template> templateOpt = this.templateDao.find(TemplateFilter.builder().emailsFrom(emailsFrom).emailTo(emailTo).phrase(null).phraseLocation(null).fileId(-1L).build());
        if (templateOpt.isPresent() && templateOpt.get().getId() != id) {
            throw new IllegalArgumentException(this.translatorService.translateMessage("efaktura.validator.update-template.error-message.template-exists"));
        }
    }
}

