/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.service.migration;

import com.suncode.plugin.efaktura.dao.EfakturaEditableDao;
import com.suncode.plugin.efaktura.dao.attachment.AttachmentDao;
import com.suncode.plugin.efaktura.dao.editopdf.EdiToPdfDao;
import com.suncode.plugin.efaktura.dao.license.LicenseDao;
import com.suncode.plugin.efaktura.dao.migration.MigrationDao;
import com.suncode.plugin.efaktura.dao.report.ReportDao;
import com.suncode.plugin.efaktura.dao.seenmail.SeenMailDao;
import com.suncode.plugin.efaktura.dao.template.TemplateDao;
import com.suncode.plugin.efaktura.model.attachment.Attachment;
import com.suncode.plugin.efaktura.model.attachment.OldAttachment;
import com.suncode.plugin.efaktura.model.editopdf.EdiToPdf;
import com.suncode.plugin.efaktura.model.editopdf.OldEdiToPdf;
import com.suncode.plugin.efaktura.model.license.License;
import com.suncode.plugin.efaktura.model.license.OldLicense;
import com.suncode.plugin.efaktura.model.migration.Migration;
import com.suncode.plugin.efaktura.model.report.OldReport;
import com.suncode.plugin.efaktura.model.report.Report;
import com.suncode.plugin.efaktura.model.seenmail.OldSeenMail;
import com.suncode.plugin.efaktura.model.seenmail.SeenMail;
import com.suncode.plugin.efaktura.model.template.OldTemplate;
import com.suncode.plugin.efaktura.model.template.Template;
import com.suncode.plugin.efaktura.util.MigrationType;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MigrationService {
    private static final Integer BATCH_SIZE = 20;
    @Autowired
    private MigrationDao migrationDao;
    @Autowired
    private AttachmentDao attachmentDao;
    @Autowired
    private EdiToPdfDao ediToPdfDao;
    @Autowired
    private LicenseDao licenseDao;
    @Autowired
    private ReportDao reportDao;
    @Autowired
    private SeenMailDao seenMailDao;
    @Autowired
    private TemplateDao templateDao;

    @Transactional
    public boolean shouldMigrateAttachments() {
        return this.shouldMigrate(MigrationType.ATTACHMENT);
    }

    @Transactional
    public void migrateAttachments() {
        List<OldAttachment> oldAttachments = this.attachmentDao.findAllOldAttachments();
        if (CollectionUtils.isNotEmpty(oldAttachments)) {
            List attachments = oldAttachments.stream().map(Attachment::fromOldAttachment).collect(Collectors.toList());
            this.saveInBatch(attachments, this.attachmentDao);
        }
        this.saveMigration(MigrationType.ATTACHMENT);
    }

    @Transactional
    public boolean shouldMigrateEdiToPdfs() {
        return this.shouldMigrate(MigrationType.EDI_TO_PDF);
    }

    @Transactional
    public void migrateEdiToPdfs() {
        List<OldEdiToPdf> oldEdiToPdfs = this.ediToPdfDao.findAllOldEdiToPdfs();
        if (CollectionUtils.isNotEmpty(oldEdiToPdfs)) {
            List ediToPdfs = oldEdiToPdfs.stream().map(EdiToPdf::fromOldEdiToPdf).collect(Collectors.toList());
            this.saveInBatch(ediToPdfs, this.ediToPdfDao);
        }
        this.saveMigration(MigrationType.EDI_TO_PDF);
    }

    @Transactional
    public boolean shouldMigrateLicense() {
        return this.shouldMigrate(MigrationType.LICENSE);
    }

    @Transactional
    public void migrateLicense() {
        List<OldLicense> oldLicenses = this.licenseDao.findAllOldLicenses();
        if (CollectionUtils.isNotEmpty(oldLicenses)) {
            List licenses = oldLicenses.stream().map(License::fromOldLicense).collect(Collectors.toList());
            this.saveInBatch(licenses, this.licenseDao);
        }
        this.saveMigration(MigrationType.LICENSE);
    }

    @Transactional
    public boolean shouldMigrateReports() {
        return this.shouldMigrate(MigrationType.REPORT);
    }

    @Transactional
    public void migrateReports() {
        List<OldReport> oldReports = this.reportDao.findAllOldReports();
        if (CollectionUtils.isNotEmpty(oldReports)) {
            List reports = oldReports.stream().map(Report::fromOldReport).collect(Collectors.toList());
            this.saveInBatch(reports, this.reportDao);
        }
        this.saveMigration(MigrationType.REPORT);
    }

    @Transactional
    public boolean shouldMigrateSeenMails() {
        return this.shouldMigrate(MigrationType.SEEN_MAIL);
    }

    @Transactional
    public void migrateSeenMails() {
        List<OldSeenMail> oldSeenMails = this.seenMailDao.findAllOldSeenMails();
        if (CollectionUtils.isNotEmpty(oldSeenMails)) {
            List seenMails = oldSeenMails.stream().map(SeenMail::fromOldSeenMail).collect(Collectors.toList());
            this.saveInBatch(seenMails, this.seenMailDao);
        }
        this.saveMigration(MigrationType.SEEN_MAIL);
    }

    @Transactional
    public boolean shouldMigrateTemplates() {
        return this.shouldMigrate(MigrationType.TEMPLATE);
    }

    @Transactional
    public void migrateTemplates() {
        List<OldTemplate> oldTemplates = this.templateDao.findAllOldTemplates();
        if (CollectionUtils.isNotEmpty(oldTemplates)) {
            List templates = oldTemplates.stream().map(Template::fromOldTemplate).collect(Collectors.toList());
            this.saveInBatch(templates, this.templateDao);
        }
        this.saveMigration(MigrationType.TEMPLATE);
    }

    private boolean shouldMigrate(MigrationType migrationType) {
        return !this.migrationDao.findByType(migrationType).isPresent();
    }

    private <T> void saveInBatch(List<T> entities, EfakturaEditableDao<T, Long> dao) {
        int counter = 1;
        for (T entity : entities) {
            dao.save(entity);
            if (counter % BATCH_SIZE == 0) {
                dao.flush();
            }
            ++counter;
        }
    }

    private void saveMigration(MigrationType migrationType) {
        Migration migration = new Migration();
        migration.setMigrationType(migrationType);
        this.migrationDao.save(migration);
    }
}

