/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.service.attachment;

import com.suncode.plugin.efaktura.dao.attachment.AttachmentDao;
import com.suncode.plugin.efaktura.model.attachment.Attachment;
import com.suncode.plugin.efaktura.util.AttachmentActionType;
import com.suncode.plugin.efaktura.util.AttachmentDetectionType;
import com.suncode.plugin.efaktura.util.Validator;
import com.suncode.plugin.efaktura.web.rest.configuration.AttachmentVueDto;
import com.suncode.plugin.efaktura.web.support.dto.AttachmentDto;
import com.suncode.plugin.efaktura.web.support.dto.AttachmentEmailDto;
import com.suncode.plugin.efaktura.web.support.dto.ManagementDto;
import com.suncode.plugin.efaktura.web.support.dto.TranslationDto;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AttachmentService {
    @Autowired
    private AttachmentDao attachmentDao;

    public TranslationDto getTranslations() {
        HashMap<String, String> translations = new HashMap<String, String>();
        translations.put("no_supplier_emails", "Podaj adresy email dostawc\u00f3w");
        translations.put("attachments_manager", "Obs\u0142uga za\u0142\u0105cznik\u00f3w");
        translations.put("ignore", "Ignoruj");
        translations.put("add_to_doc_class", "Dodaj do klasy dokument\u00f3w");
        translations.put("supplier_email", "Email dostawcy");
        translations.put("detection", "Detekcja");
        translations.put("template_mismatch", "Niedopasowanie szablonu");
        translations.put("action_type", "Rodzaj akcji");
        translations.put("create", "Dodaj");
        translations.put("update", "Zmie\u0144");
        translations.put("remove", "Usu\u0144");
        translations.put("error", "B\u0142\u0105d");
        translations.put("warning", "Uwaga");
        translations.put("success", "Sukces");
        translations.put("services", "Obs\u0142ugi");
        translations.put("available_services", "Dost\u0119pne obs\u0142ugi");
        translations.put("phrase_in_filename", "Fraza w nazwie pliku");
        translations.put("phrase_not_in_filename", "Brak frazy w nazwie pliku");
        translations.put("phrase_in_content", "Fraza w zawarto\u015bci");
        translations.put("phrase_not_in_content", "Brak frazy w zawarto\u015bci");
        translations.put("phrase", "Fraza");
        translations.put("doc_class", "Klasa dokument\u00f3w");
        TranslationDto dto = new TranslationDto();
        dto.setTranslations(translations);
        return dto;
    }

    @Transactional(readOnly=true)
    public CountedResult<AttachmentVueDto> getAttachments(Integer start, Integer limit, String sortBy, SortDirection sortDirection) {
        List data = this.attachmentDao.findAll(start, limit, sortBy, sortDirection).stream().map(entity -> AttachmentVueDto.builder().id(entity.getId()).emailFrom(entity.getEmailFrom()).detectionType(entity.getDetectionType()).detectionValue(entity.getDetectionValue()).actionType(entity.getActionType()).actionValue(entity.getActionValue()).build()).collect(Collectors.toList());
        long total = this.attachmentDao.countAll();
        return new CountedResult(total, data);
    }

    @Transactional(readOnly=true)
    public List<AttachmentEmailDto> read(String fromEmails) {
        String[] fromEmailsTab;
        ArrayList<AttachmentEmailDto> attachmentEmailDtos = new ArrayList<AttachmentEmailDto>();
        for (String fromEmail : fromEmailsTab = fromEmails.split(";")) {
            AttachmentEmailDto attachmentEmailDto = new AttachmentEmailDto();
            attachmentEmailDto.setFromEmail(fromEmail);
            attachmentEmailDto.setText(fromEmail);
            attachmentEmailDto.setIcon("style/img/fam/email.png");
            attachmentEmailDto.setIsEmail(true);
            List<Attachment> attachments = this.attachmentDao.findAllByFromEmail(fromEmail);
            if (CollectionUtils.isNotEmpty(attachments)) {
                attachmentEmailDto.setLeaf(false);
                attachmentEmailDto.setExpanded(true);
                ArrayList<AttachmentDto> attachmentDtos = new ArrayList<AttachmentDto>();
                for (Attachment attachment : attachments) {
                    AttachmentDto attachmentDto = new AttachmentDto();
                    attachmentDto.setFromEmail(fromEmail);
                    attachmentDto.setDetectionType(attachment.getDetectionType().getName());
                    attachmentDto.setDetectionValue(attachment.getDetectionValue());
                    attachmentDto.setActionType(attachment.getActionType().getName());
                    attachmentDto.setActionValue(attachment.getActionValue());
                    attachmentDto.setActionId(attachment.getId());
                    attachmentDto.setText("Id: " + attachment.getId());
                    attachmentDto.setIcon("style/img/fam/page_white.png");
                    attachmentDto.setIsService(true);
                    attachmentDto.setLeaf(true);
                    attachmentDtos.add(attachmentDto);
                }
                attachmentEmailDto.setChildren(attachmentDtos);
            } else {
                attachmentEmailDto.setLeaf(true);
                attachmentEmailDto.setExpanded(false);
                attachmentEmailDto.setChildren(new ArrayList<AttachmentDto>());
            }
            attachmentEmailDtos.add(attachmentEmailDto);
        }
        return attachmentEmailDtos;
    }

    @Transactional
    public ManagementDto create(AttachmentDto attachmentDto) {
        if (!Validator.isValidEmail(attachmentDto.getFromEmail())) {
            return this.buildManagementFailure("Niepoprawny format adresu email: " + attachmentDto.getFromEmail());
        }
        if (StringUtils.isBlank((CharSequence)attachmentDto.getDetectionTypeValue())) {
            return this.buildManagementFailure("Okre\u015bl detekcj\u0119 za\u0142\u0105cznika.");
        }
        if (!Validator.isAttachmentDetectionValid(attachmentDto.getDetectionTypeValue(), attachmentDto.getDetectionValueValue())) {
            return this.buildManagementFailure("Dla wybranej detekcji za\u0142\u0105cznika okre\u015bl fraz\u0119.");
        }
        if (StringUtils.isBlank((CharSequence)attachmentDto.getActionTypeValue())) {
            return this.buildManagementFailure("Okre\u015bl akcj\u0119 dla zal\u0142\u0105cznika.");
        }
        if (!Validator.isAttachmentActionValid(attachmentDto.getActionTypeValue(), attachmentDto.getActionValueValue())) {
            return this.buildManagementFailure("Dla wybranej akcji dla za\u0142\u0105cznika okre\u015bl klas\u0119 dokument\u00f3w.");
        }
        Optional<Attachment> attachmentOpt = this.attachmentDao.findByParameters(attachmentDto.getFromEmail(), attachmentDto.getDetectionTypeValue(), attachmentDto.getDetectionValueValue());
        if (attachmentOpt.isPresent()) {
            return this.buildManagementFailure("Obs\u0142uga za\u0142acznika o podanej definicji ju\u017c istnieje.");
        }
        Attachment attachment = new Attachment();
        attachment.setEmailFrom(attachmentDto.getFromEmail());
        attachment.setDetectionType(AttachmentDetectionType.getByName(attachmentDto.getDetectionTypeValue()));
        attachment.setDetectionValue(attachmentDto.getDetectionValueValue());
        attachment.setActionType(AttachmentActionType.getByName(attachmentDto.getActionTypeValue()));
        attachment.setActionValue(attachmentDto.getActionValueValue());
        this.attachmentDao.save(attachment);
        return this.buildManagementSuccess("Poprawnie dodano obs\u0142ug\u0119 za\u0142\u0105cznika.");
    }

    @Transactional
    public ManagementDto update(AttachmentDto attachmentDto) {
        if (!Validator.isValidEmail(attachmentDto.getFromEmail())) {
            return this.buildManagementFailure("Niepoprawny format adresu email: " + attachmentDto.getFromEmail());
        }
        if (StringUtils.isBlank((CharSequence)attachmentDto.getDetectionTypeValue())) {
            return this.buildManagementFailure("Okre\u015bl detekcj\u0119 za\u0142\u0105cznika.");
        }
        if (!Validator.isAttachmentDetectionValid(attachmentDto.getDetectionTypeValue(), attachmentDto.getDetectionValueValue())) {
            return this.buildManagementFailure("Dla wybranej detekcji za\u0142\u0105cznika okre\u015bl fraz\u0119.");
        }
        if (StringUtils.isBlank((CharSequence)attachmentDto.getActionTypeValue())) {
            return this.buildManagementFailure("Okre\u015bl akcj\u0119 dla zal\u0142\u0105cznika.");
        }
        if (!Validator.isAttachmentActionValid(attachmentDto.getActionTypeValue(), attachmentDto.getActionValueValue())) {
            return this.buildManagementFailure("Dla wybranej akcji dla za\u0142\u0105cznika okre\u015bl klas\u0119 dokument\u00f3w.");
        }
        Attachment attachment = (Attachment)this.attachmentDao.get(attachmentDto.getActionId());
        Optional<Attachment> attachmentOpt = this.attachmentDao.findByParameters(attachmentDto.getFromEmail(), attachmentDto.getDetectionTypeValue(), attachmentDto.getDetectionValueValue());
        if (attachmentOpt.isPresent() && !attachmentOpt.get().getId().equals(attachment.getId())) {
            return this.buildManagementFailure("Obs\u0142uga za\u0142acznika o podanej definicji ju\u017c istnieje.");
        }
        attachment.setEmailFrom(attachmentDto.getFromEmail());
        attachment.setDetectionType(AttachmentDetectionType.getByName(attachmentDto.getDetectionTypeValue()));
        attachment.setDetectionValue(attachmentDto.getDetectionValueValue());
        attachment.setActionType(AttachmentActionType.getByName(attachmentDto.getActionTypeValue()));
        attachment.setActionValue(attachmentDto.getActionValueValue());
        this.attachmentDao.update(attachment);
        return this.buildManagementSuccess("Poprawnie zmieniono obs\u0142ug\u0119 za\u0142\u0105cznika.");
    }

    @Transactional
    public ManagementDto remove(Long id) {
        Attachment attachment = (Attachment)this.attachmentDao.get(id);
        this.attachmentDao.delete(attachment);
        return this.buildManagementSuccess("Poprawnie usuni\u0119to obs\u0142ug\u0119 za\u0142\u0105cznika.");
    }

    private ManagementDto buildManagementFailure(String message) {
        ManagementDto dto = new ManagementDto();
        dto.setActionPerformed(false);
        dto.setSuccess(true);
        dto.setMessage(message);
        return dto;
    }

    private ManagementDto buildManagementSuccess(String message) {
        ManagementDto dto = new ManagementDto();
        dto.setActionPerformed(true);
        dto.setSuccess(true);
        dto.setMessage(message);
        return dto;
    }

    @Transactional(readOnly=true)
    public List<Attachment> findAllByFromEmail(String fromEmail) {
        return this.attachmentDao.findAllByFromEmail(fromEmail);
    }
}

