/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.scheduledtask;

import com.suncode.plugin.efaktura.service.license.LicenseService;
import com.suncode.plugin.efaktura.util.PlusEFakturaTools;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.component.annotation.Define;
import java.util.Date;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@ScheduledTask
public class RenewLicenseScheduledTask {
    public static Logger log = Logger.getLogger(RenewLicenseScheduledTask.class);
    public static Logger clientLog = Logger.getLogger((String)"PlusEFakturaClientLog");
    @Autowired
    private LicenseService licenseService;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("efaktura-renew-license-scheduled-task")).name("efaktura.scheduled-task.renew-license.name")).description("efaktura.scheduled-task.renew-license.description");
    }

    public void execute() {
        log.info((Object)"************ renewLicense() ************");
        clientLog.info((Object)"Proces weryfikacji i odnawiania licencji rozpoczety");
        long startTime = new Date().getTime();
        try {
            this.licenseService.renew();
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
        }
        long stopTime = new Date().getTime();
        String durationTime = PlusEFakturaTools.formatDuration(stopTime - startTime);
        log.info((Object)("Czas trwania procesu odnawiania licencji modulu Plus E-faktura: " + durationTime));
        clientLog.info((Object)("Czas trwania procesu odnawiania licencji modulu Plus E-faktura: " + durationTime));
        clientLog.info((Object)"Proces weryfikacji i odnawiania licencji zakonczony");
    }
}

