/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.util;

import com.suncode.plugin.efaktura.configuration.EfakturaSpringContext;
import com.suncode.plugin.efaktura.service.template.TemplateService;
import com.suncode.plugin.efaktura.util.AdditionalOptions;
import com.suncode.plugin.efaktura.util.FilteredMessages;
import com.suncode.plugin.efaktura.util.PlusEFakturaTools;
import java.util.ArrayList;
import java.util.List;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class CheckSupplierAction {
    public static Logger log = Logger.getLogger(CheckSupplierAction.class);
    public static Logger clientLog = Logger.getLogger((String)"PlusEFakturaClientLog");

    public static FilteredMessages filterBySupplierEmail(String sEmail, List<Message> messages, AdditionalOptions additionalOptions) {
        log.trace((Object)("************ filterBySupplierEmail(sEmail=" + sEmail + ", messages, AdditionalOptions) ************"));
        FilteredMessages result = new FilteredMessages();
        try {
            if (CollectionUtils.isNotEmpty(messages)) {
                String sCheckSupplier = additionalOptions.getCheckSupplier();
                if (StringUtils.isNotBlank((CharSequence)sCheckSupplier) && sCheckSupplier.equalsIgnoreCase("TRUE")) {
                    log.info((Object)("Filtrowanie odebranych wiadomosci po adresie email dostawcy. Ilosc wiadomosci przed filtrowaniem: " + messages.size()));
                    clientLog.info((Object)("Filtrowanie odebranych wiadomosci po adresie email dostawcy. Ilosc wiadomosci przed filtrowaniem: " + messages.size()));
                    log.info((Object)"Laczenie sie z wewnetrzna baza danych w celu filtracji wiadomosci");
                    result = CheckSupplierAction.filtering(sEmail, messages, additionalOptions);
                } else {
                    result.setSupported(messages);
                }
            }
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
        }
        return result;
    }

    private static boolean executeCheckSupplierQuery(String sSupplierEmail, String sEmail) {
        log.trace((Object)("************ executeCheckSupplierQuery(sSupplierEmail=" + sSupplierEmail + ", sEmail=" + sEmail + ") ************"));
        boolean bResult = false;
        try {
            log.info((Object)("Weryfikacja adresu e-mail dostawcy. Skrzynka monitorowana: " + sEmail + ", adres dostawcy: " + sSupplierEmail));
            TemplateService templateService = EfakturaSpringContext.getBean(TemplateService.class);
            bResult = templateService.isSupplierSupported(sSupplierEmail, sEmail);
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
        }
        return bResult;
    }

    private static FilteredMessages filtering(String sEmail, List<Message> messages, AdditionalOptions additionalOptions) {
        log.trace((Object)("************ filtering(sEmail=" + sEmail + ", messages) ************"));
        FilteredMessages result = new FilteredMessages();
        ArrayList<Message> listOfAcceptedMessages = new ArrayList<Message>();
        ArrayList<Message> listOfUnsupportedMessages = new ArrayList<Message>();
        log.info((Object)"Filtrowanie wiadomosci");
        for (Message message : messages) {
            try {
                boolean supplierFound = false;
                Address[] addresses = CheckSupplierAction.getAddresses(message, additionalOptions);
                if (addresses == null || addresses.length == 0) {
                    log.info((Object)"Nie udalo sie uzyskac adresu e-mail dostawcy");
                    listOfUnsupportedMessages.add(message);
                    continue;
                }
                for (Address address : addresses) {
                    if (address == null) {
                        log.info((Object)"Pusty adres e-mail dostawcy");
                        listOfUnsupportedMessages.add(message);
                        continue;
                    }
                    String supplierEmail = address.toString();
                    supplierEmail = PlusEFakturaTools.decodeText(supplierEmail, false, true);
                    if ((supplierEmail = PlusEFakturaTools.getAddressFromString(supplierEmail)) == null) {
                        log.info((Object)"Pusty adres e-mail dostawcy");
                        listOfUnsupportedMessages.add(message);
                        continue;
                    }
                    supplierFound = CheckSupplierAction.executeCheckSupplierQuery(supplierEmail, sEmail);
                    if (supplierFound) {
                        log.info((Object)("Akceptowany adres e-mail dostawcy. Skrzynka monitorowana: " + sEmail + ", adres dostawcy: " + supplierEmail));
                        listOfAcceptedMessages.add(message);
                        break;
                    }
                    log.info((Object)("Nieakceptowany adres e-mail dostawcy. Skrzynka monitorowana: " + sEmail + ", adres dostawcy: " + supplierEmail));
                }
                if (supplierFound) continue;
                listOfUnsupportedMessages.add(message);
            }
            catch (Exception exception) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
                listOfUnsupportedMessages.add(message);
            }
        }
        result.setSupported(listOfAcceptedMessages);
        result.setUnsupported(listOfUnsupportedMessages);
        return result;
    }

    private static Address[] getAddresses(Message message, AdditionalOptions additionalOptions) throws MessagingException {
        if (StringUtils.equalsIgnoreCase((CharSequence)additionalOptions.getDetectForwarding(), (CharSequence)"TRUE")) {
            return PlusEFakturaTools.getFromWithForwardingDetection(message);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)additionalOptions.getSwapEmailsForTemplateRetrieval(), (CharSequence)"TRUE")) {
            return message.getRecipients(Message.RecipientType.TO);
        }
        return message.getFrom();
    }
}

