/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.util;

import com.suncode.plugin.efaktura.util.AddResult;
import com.suncode.plugin.efaktura.util.AttachmentPart;
import com.suncode.plugin.efaktura.util.MsgStatus;
import com.suncode.plugin.efaktura.util.PlusEFakturaTools;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Part;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.ini4j.Ini;

public class AddAttachmentsToFileSystemAction {
    public static Logger log = Logger.getLogger(AddAttachmentsToFileSystemAction.class);
    public static Logger clientLog = Logger.getLogger((String)"PlusEFakturaClientLog");

    public static AddResult addAttachmentsToFileSystem(Ini configFile, Message message, String msgId) {
        log.trace((Object)("******************** AddAttachmentsToFileSystem(Ini, Message, msgId=" + msgId + ") ********************"));
        AddResult addResult = new AddResult();
        log.info((Object)"Zapis zalacznikow w systemie plikow");
        clientLog.info((Object)"Zapis zalacznikow w systemie plikow");
        try {
            String acceptableExts = configFile.get((Object)"AddAttachmentsToFileSystemAction", (Object)"AcceptableExts");
            String ignoredExts = configFile.get((Object)"AddAttachmentsToFileSystemAction", (Object)"IgnoredExts");
            Object o = PlusEFakturaTools.getPartContent((Part)message);
            if (o instanceof Multipart) {
                List<AttachmentPart> attachmentParts = PlusEFakturaTools.getAttachmentParts((Multipart)o);
                int noOfAttachment = 1;
                for (AttachmentPart attachmentPart : attachmentParts) {
                    String nameOfTheFile = msgId + "_" + attachmentPart.getFileName();
                    try {
                        int i;
                        if (nameOfTheFile == null) continue;
                        log.info((Object)(" - Zalacznik numer " + noOfAttachment));
                        clientLog.info((Object)(" - Zalacznik numer " + noOfAttachment));
                        ++noOfAttachment;
                        nameOfTheFile = nameOfTheFile.trim();
                        log.info((Object)("Nazwa pliku w zalaczniku: " + nameOfTheFile));
                        if (acceptableExts == null) {
                            log.warn((Object)"Brak definicji akceptowanych rozszerzen plikow w pliku konfiguracyjnym  modulu Plus E-faktura");
                            clientLog.warn((Object)"Brak definicji akceptowanych rozszerzen plikow w pliku konfiguracyjnym  modulu Plus E-faktura");
                            addResult.setMsgStatus(MsgStatus.NO_ACCEPTED_ATTACHMENT_EXTENSIONS);
                            continue;
                        }
                        boolean extAccepted = false;
                        boolean extIgnored = false;
                        String createdExt = "";
                        String[] extsTable = acceptableExts.split(";");
                        String[] ignoredExtsTable = ignoredExts.split(";");
                        int lastDot = nameOfTheFile.lastIndexOf(".");
                        if (lastDot != -1) {
                            createdExt = nameOfTheFile.substring(lastDot + 1, nameOfTheFile.length());
                        }
                        for (i = 0; i < extsTable.length; ++i) {
                            if (!PlusEFakturaTools.shouldProcessExtension(createdExt, extsTable[i])) continue;
                            extAccepted = true;
                            if (createdExt.equalsIgnoreCase(extsTable[i])) break;
                            createdExt = extsTable[i].toLowerCase();
                            nameOfTheFile = nameOfTheFile.substring(0, lastDot) + "." + createdExt;
                            break;
                        }
                        if (ignoredExtsTable.length > 0) {
                            for (i = 0; i < ignoredExtsTable.length; ++i) {
                                if (StringUtils.isBlank((CharSequence)ignoredExtsTable[i]) || extAccepted && (!extAccepted || ignoredExtsTable[i].equalsIgnoreCase("*")) || !PlusEFakturaTools.shouldProcessExtension(createdExt, ignoredExtsTable[i])) continue;
                                extIgnored = true;
                                break;
                            }
                        }
                        if (extIgnored) {
                            log.info((Object)("Rozszerzenie " + createdExt + " jest ignorowane przez modul Plus E-faktura"));
                            clientLog.info((Object)("Rozszerzenie " + createdExt + " jest ignorowane przez modul Plus E-faktura"));
                            continue;
                        }
                        if (extAccepted) {
                            log.info((Object)("Jest to akceptowany zalacznik o rozszerzeniu " + createdExt.toLowerCase() + ". Przygotowanie do dodania do systemu plikow"));
                            clientLog.info((Object)("Jest to akceptowany zalacznik o rozszerzeniu " + createdExt.toLowerCase() + ". Przygotowanie do dodania do systemu plikow"));
                            String location = configFile.get((Object)"AddAttachmentsToFileSystemAction", (Object)"Location");
                            File destination = new File(location + "/" + AddAttachmentsToFileSystemAction.convertFileName(nameOfTheFile));
                            FileUtils.copyInputStreamToFile((InputStream)attachmentPart.getInputStream(), (File)destination);
                            addResult.addDoc("1", nameOfTheFile);
                            log.info((Object)("Zapisano zalacznik w systemie plikow w lokalizacji " + destination.getAbsolutePath()));
                            clientLog.info((Object)("Zapisano zalacznik w systemie plikow w lokalizacji " + destination.getAbsolutePath()));
                            continue;
                        }
                        log.info((Object)("Rozszerzenie " + createdExt + " nie jest akceptowane przez modul Plus E-faktura"));
                        clientLog.info((Object)("Rozszerzenie " + createdExt + " nie jest akceptowane przez modul Plus E-faktura"));
                        addResult.addDoc("-2", nameOfTheFile);
                        addResult.setMsgStatus(MsgStatus.UNACCEPTED_ATTACHMENT_EXTENSION_FOUND);
                    }
                    catch (Exception e) {
                        addResult.addDoc("-1", nameOfTheFile);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return addResult;
    }

    private static String convertFileName(String fileName) {
        fileName = fileName.replaceAll("[/]", "_");
        fileName = fileName.replaceAll(":", "_");
        fileName = fileName.replaceAll("[*]", "_");
        fileName = fileName.replaceAll("[?]", "_");
        fileName = fileName.replaceAll("<", "_");
        fileName = fileName.replaceAll(">", "_");
        fileName = fileName.replaceAll("[|]", "_");
        fileName = fileName.replaceAll("\"", "_");
        fileName = fileName.replaceAll("\t", " ");
        fileName = fileName.replaceAll("\n", " ");
        fileName = fileName.replaceAll("\r", "");
        fileName = fileName.replaceAll("[^\\x00-\\x7F]", "");
        fileName = fileName.replaceAll("[\\p{Cntrl}&&[^\r\n\t]]", "");
        fileName = fileName.replaceAll("\\p{C}", "");
        return fileName;
    }
}

