/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.scheduledtask;

import com.suncode.plugin.efaktura.model.license.License;
import com.suncode.plugin.efaktura.service.license.LicenseService;
import com.suncode.plugin.efaktura.util.PlusEFakturaTools;
import com.suncode.plugin.efaktura.util.exception.LicenseException;
import com.suncode.plugin.efaktura.util.exception.PlusEFakturaException;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import java.io.File;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@ScheduledTask
public class AddLicenseScheduledTask {
    public static Logger log = Logger.getLogger(AddLicenseScheduledTask.class);
    public static Logger clientLog = Logger.getLogger((String)"PlusEFakturaClientLog");
    @Autowired
    private LicenseService licenseService;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("efaktura-add-license-scheduled-task")).name("efaktura.scheduled-task.add-license.name")).description("efaktura.scheduled-task.add-license.description")).parameter().id("xmlFilePath").name("efaktura.scheduled-task.add-license.parameters.xml-file-path.name").type((Type)Types.STRING).create()).parameter().id("zipFilePath").name("efaktura.scheduled-task.add-license.parameters.zip-file-path.name").type((Type)Types.STRING).create();
    }

    public void execute(@Param String xmlFilePath, @Param String zipFilePath) {
        long startTime;
        block14: {
            log.info((Object)("************ addLicense(xmlFilePath=" + xmlFilePath + ", zipFilePath=" + zipFilePath + ") ************"));
            startTime = new Date().getTime();
            File inFile = null;
            File outFile = null;
            String xmlFileName = "";
            boolean licenseFound = false;
            License license = null;
            try {
                if (StringUtils.isBlank((CharSequence)xmlFilePath) || StringUtils.isBlank((CharSequence)zipFilePath)) {
                    throw new PlusEFakturaException("Wartosci zadania zaplanowanego maja niepoprawne wartosci - sa puste");
                }
                if (xmlFilePath.equalsIgnoreCase("ustaw parametr") || zipFilePath.equalsIgnoreCase("ustaw parametr")) {
                    throw new PlusEFakturaException("Ustaw parametry zadania zaplanowanego");
                }
                xmlFilePath = PlusEFakturaTools.convertBackslashesToSlashes(xmlFilePath);
                zipFilePath = PlusEFakturaTools.convertBackslashesToSlashes(zipFilePath);
                inFile = new File(xmlFilePath);
                if (inFile == null || !inFile.exists()) {
                    throw new PlusEFakturaException("Plik licencyjny modulu Plus E-faktura nie istnieje w lokalizacji " + xmlFilePath);
                }
                xmlFileName = inFile.getName();
                if (StringUtils.isBlank((CharSequence)xmlFileName)) {
                    throw new PlusEFakturaException("Brak nazwy pliku XML w lokzalizacji " + xmlFilePath);
                }
                int lastDotPos = inFile.getName().lastIndexOf(".");
                String ext = xmlFileName.substring(lastDotPos + 1, xmlFileName.length());
                if (ext == null || !ext.equalsIgnoreCase("xml")) {
                    throw new PlusEFakturaException("Plik licencyjny nie ma wymaganego rozszerzenia .xml");
                }
                lastDotPos = zipFilePath.lastIndexOf(".");
                ext = zipFilePath.substring(lastDotPos + 1, zipFilePath.length());
                if (ext == null || !ext.equalsIgnoreCase("zip")) {
                    throw new PlusEFakturaException("Plik docelowy nie posiada wymaganego rozszerzenia .zip");
                }
                this.licenseService.validateWhenAdding(xmlFilePath);
                outFile = new File(zipFilePath);
                if (outFile.exists()) {
                    throw new PlusEFakturaException("Archiwum zip z plikiem licencyjnym istnieje juz w lokalizacji " + zipFilePath);
                }
                licenseFound = this.licenseService.get().isPresent();
                if (licenseFound) {
                    throw new PlusEFakturaException("Modul Plus E-faktura posiada juz wgrana licencje");
                }
                this.licenseService.zip(inFile, outFile);
                if (!outFile.exists()) {
                    throw new PlusEFakturaException("Archiwum zip z plikiem licencyjnym nie zostalo poprawnie utworzone w lokzalizacji " + zipFilePath);
                }
                log.info((Object)("Utworzono zaszyfrowany plik licencyjny w lokalizacji " + zipFilePath));
                license = new License();
                license.setPath(zipFilePath);
                license.setDateOfAddition(Calendar.getInstance().getTime());
                license.setChecksum(PlusEFakturaTools.getSHA1Checksum(zipFilePath));
                this.licenseService.add(license);
                log.info((Object)"Dodano sciezke do licencji w bazie danych");
                if (inFile == null || !inFile.exists()) break block14;
                boolean xmlDeleted = inFile.delete();
                if (xmlDeleted) {
                    log.info((Object)("Plik licencyjny xml z lokalizacji " + xmlFilePath + " usuniety poprawnie"));
                    break block14;
                }
                throw new PlusEFakturaException("Uwaga! Plik licencyjny xml z lokalizacji " + xmlFilePath + " nie zostal usuniety. Usun go recznie");
            }
            catch (PlusEFakturaException exception) {
                log.warn((Object)exception.getMessage());
            }
            catch (LicenseException exception) {
                log.warn((Object)exception.getMessage());
            }
            catch (Exception exception) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
        long stopTime = new Date().getTime();
        log.info((Object)("Czas trwania procesu ustawiania licencji modulu Plus E-faktura: " + PlusEFakturaTools.formatDuration(stopTime - startTime)));
    }
}

