/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.model.attachment;

import com.suncode.plugin.efaktura.model.attachment.OldAttachment;
import com.suncode.plugin.efaktura.util.AttachmentActionType;
import com.suncode.plugin.efaktura.util.AttachmentDetectionType;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Type;

@Entity
@Table(name="pm_efaktura_attachment", uniqueConstraints={@UniqueConstraint(columnNames={"email_from", "detection_type", "detection_value"})})
@SequenceGenerator(name="efaktura_attachment", sequenceName="pm_efaktura_attachment_id")
public class Attachment
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="efaktura_attachment")
    private Long id;
    @Column(name="email_from")
    private String emailFrom;
    @Column(name="detection_type")
    @Type(type="com.suncode.plugin.efaktura.model.attachment.DetectionTypeEnum")
    private AttachmentDetectionType detectionType;
    @Column(name="detection_value")
    private String detectionValue;
    @Column(name="action_type")
    @Type(type="com.suncode.plugin.efaktura.model.attachment.ActionTypeEnum")
    private AttachmentActionType actionType;
    @Column(name="action_value")
    private String actionValue;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getEmailFrom() {
        return this.emailFrom;
    }

    public void setEmailFrom(String emailFrom) {
        this.emailFrom = emailFrom;
    }

    public AttachmentDetectionType getDetectionType() {
        return this.detectionType;
    }

    public void setDetectionType(AttachmentDetectionType detectionType) {
        this.detectionType = detectionType;
    }

    public String getDetectionValue() {
        return this.detectionValue;
    }

    public void setDetectionValue(String detectionValue) {
        this.detectionValue = detectionValue;
    }

    public AttachmentActionType getActionType() {
        return this.actionType;
    }

    public void setActionType(AttachmentActionType actionType) {
        this.actionType = actionType;
    }

    public String getActionValue() {
        return this.actionValue;
    }

    public void setActionValue(String actionValue) {
        this.actionValue = actionValue;
    }

    public static Attachment fromOldAttachment(OldAttachment oldAttachment) {
        Attachment attachment = new Attachment();
        attachment.setEmailFrom(oldAttachment.getFromEmail());
        attachment.setDetectionType(AttachmentDetectionType.getByName(oldAttachment.getDetectionType()));
        attachment.setDetectionValue(oldAttachment.getDetectionValue());
        attachment.setActionType(AttachmentActionType.getByName(oldAttachment.getActionType()));
        attachment.setActionValue(oldAttachment.getActionValue());
        return attachment;
    }
}

