/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.editopdf;

import com.suncode.plugin.efaktura.docxtopdf.DocxTemplateToPdfConverter;
import com.suncode.plugin.efaktura.docxtopdf.VariablesPreparator;
import com.suncode.plugin.efaktura.editopdf.EdiCoordinates;
import com.suncode.plugin.efaktura.editopdf.EdiCoordinatesBuilder;
import com.suncode.plugin.efaktura.editopdf.EdiToSegmentsParser;
import com.suncode.plugin.efaktura.editopdf.Segments;
import com.suncode.plugin.efaktura.editopdf.TextFromDocx;
import com.suncode.plugin.efaktura.model.editopdf.EdiToPdf;
import com.suncode.plugin.efaktura.util.AdditionalOptions;
import com.suncode.plugin.efaktura.util.PlusEFakturaTools;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.docx4j.jaxb.Context;
import org.docx4j.jaxb.XPathBinderAssociationIsPartialException;
import org.docx4j.model.datastorage.migration.VariablePrepare;
import org.docx4j.model.structure.HeaderFooterPolicy;
import org.docx4j.model.structure.SectionWrapper;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.JaxbXmlPartXPathAware;
import org.docx4j.openpackaging.parts.WordprocessingML.FooterPart;
import org.docx4j.openpackaging.parts.WordprocessingML.HeaderPart;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.wml.Br;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.R;
import org.docx4j.wml.RPr;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.Tc;
import org.docx4j.wml.Text;
import org.docx4j.wml.Tr;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class EdiToPdfConverter {
    public static Logger log = Logger.getLogger(EdiToPdfConverter.class);
    private static final ObjectFactory OBJECT_FACTORY = Context.getWmlObjectFactory();
    private static final String TABLE_REGEX = "//w:tbl";
    private static final String TABLE_TEXT_REGEX = "[$][{]table:(header|details|summary):\\w+([(](\\w*|[*])[)])*:\\d+(:\\w+[(].*[)])*[}]";
    private static final String TEXT_PREFIX = "${";
    private static final String TEXT_POSTFIX = "}";
    private static final String VALUE_NODE_XPATH = "//w:r[w:t[contains(text(),'${value:') and contains(text(),'}')]]";
    private static final String VALUE_TEXT_REGEX = "[$][{]value:(header|details|summary):\\w+([(](\\w*|[*])[)])*:\\d+(:\\d+)?(:\\w+[(].*[)])*[}]";
    private static final String FILE_EXTENSION = "pdf";
    @Autowired
    private VariablesPreparator variablesPreparator;
    @Autowired
    @Qualifier(value="unEdifactD96AEdiToSegmentsParser")
    private EdiToSegmentsParser unEdifactD96AEdiToSegmentsParser;
    @Autowired
    private EdiCoordinatesBuilder ediCoordinatesBuilder;
    @Autowired
    private DocxTemplateToPdfConverter docxTemplateToPdfConverter;

    public File convert(byte[] fileBytes, EdiToPdf ediToPdf, AdditionalOptions additionalOptions) {
        try {
            WordprocessingMLPackage template = this.getDocxTemplate(ediToPdf);
            Segments segments = this.parseEdiToSegments(fileBytes, ediToPdf);
            this.fillTables(segments, template);
            HashMap<String, String> mappings = this.buildValueMappings(segments, template);
            return this.convertTemplateToPdf(ediToPdf, template, mappings, additionalOptions);
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    public byte[] convert(byte[] fileBytes, EdiToPdf ediToPdf) {
        try {
            WordprocessingMLPackage template = this.getDocxTemplate(ediToPdf);
            Segments segments = this.parseEdiToSegments(fileBytes, ediToPdf);
            this.fillTables(segments, template);
            HashMap<String, String> mappings = this.buildValueMappings(segments, template);
            return this.convertTemplateToPdf(ediToPdf, template, mappings);
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    private WordprocessingMLPackage getDocxTemplate(EdiToPdf ediToPdf) throws Exception {
        String templatePath = ediToPdf.getTemplatePath();
        File templateFile = new File(templatePath);
        if (templateFile.exists()) {
            return this.getTemplate(templateFile);
        }
        return null;
    }

    private WordprocessingMLPackage getTemplate(File templateFile) throws Exception {
        WordprocessingMLPackage template = WordprocessingMLPackage.load((File)templateFile);
        this.prepareVariables((JaxbXmlPartXPathAware)template.getMainDocumentPart());
        VariablePrepare.prepare((WordprocessingMLPackage)template);
        return template;
    }

    private <T> void prepareVariables(JaxbXmlPartXPathAware<T> element) {
        this.variablesPreparator.prepare(element);
    }

    private Segments parseEdiToSegments(byte[] fileBytes, EdiToPdf ediToPdf) {
        switch (ediToPdf.getEdiType()) {
            case UN_EDIFACT_D96A: {
                return this.parseUnEdifactD92AEdiToSegments(fileBytes);
            }
        }
        throw new IllegalArgumentException("Nieznany typ pliku EDI");
    }

    private Segments parseUnEdifactD92AEdiToSegments(byte[] fileBytes) {
        return this.unEdifactD96AEdiToSegmentsParser.parse(fileBytes);
    }

    private void fillTables(Segments segments, WordprocessingMLPackage template) throws XPathBinderAssociationIsPartialException, JAXBException {
        List<Tbl> tables = this.getTables(template);
        if (CollectionUtils.isNotEmpty(tables)) {
            for (Tbl table : tables) {
                this.fillTable(segments, table);
            }
        }
    }

    private List<Tbl> getTables(WordprocessingMLPackage template) throws XPathBinderAssociationIsPartialException, JAXBException {
        ArrayList<Tbl> tables = new ArrayList<Tbl>();
        List<Object> nodes = this.getNodes(template, TABLE_REGEX);
        if (CollectionUtils.isNotEmpty(nodes)) {
            for (Object node : nodes) {
                if (!this.isTableElement(node)) continue;
                tables.add(this.getTableElement(node));
            }
        }
        return tables;
    }

    private List<Object> getNodes(WordprocessingMLPackage template, String regex) throws XPathBinderAssociationIsPartialException, JAXBException {
        ArrayList<Object> nodes = new ArrayList<Object>();
        nodes.addAll(this.getNodesFromMainPart(template, regex));
        nodes.addAll(this.getNodesFromHeadersAndFooters(template, regex));
        return nodes;
    }

    private List<Object> getNodesFromMainPart(WordprocessingMLPackage template, String regex) throws XPathBinderAssociationIsPartialException, JAXBException {
        MainDocumentPart documentPart = template.getMainDocumentPart();
        return documentPart.getJAXBNodesViaXPath(regex, false);
    }

    private List<Object> getNodesFromHeadersAndFooters(WordprocessingMLPackage template, String regex) throws XPathBinderAssociationIsPartialException, JAXBException {
        ArrayList<Object> nodes = new ArrayList<Object>();
        List sectionWrappers = template.getDocumentModel().getSections();
        if (CollectionUtils.isNotEmpty((Collection)sectionWrappers)) {
            for (SectionWrapper sectionWrapper : sectionWrappers) {
                nodes.addAll(this.getNodesFromHeadersAndFooters(sectionWrapper, regex));
            }
        }
        return nodes;
    }

    private List<Object> getNodesFromHeadersAndFooters(SectionWrapper sectionWrapper, String regex) throws XPathBinderAssociationIsPartialException, JAXBException {
        ArrayList<Object> nodes = new ArrayList<Object>();
        HeaderFooterPolicy headerFooterPolicy = sectionWrapper.getHeaderFooterPolicy();
        if (headerFooterPolicy != null) {
            HeaderPart defaultHeader = headerFooterPolicy.getDefaultHeader();
            FooterPart defaultFooter = headerFooterPolicy.getDefaultFooter();
            HeaderPart evenHeader = headerFooterPolicy.getEvenHeader();
            FooterPart evenFooter = headerFooterPolicy.getEvenFooter();
            HeaderPart firstHeader = headerFooterPolicy.getFirstHeader();
            FooterPart firstFooter = headerFooterPolicy.getFirstFooter();
            if (defaultHeader != null) {
                this.prepareVariables((JaxbXmlPartXPathAware)defaultHeader);
                nodes.addAll(defaultHeader.getJAXBNodesViaXPath(regex, false));
            }
            if (defaultFooter != null) {
                this.prepareVariables((JaxbXmlPartXPathAware)defaultFooter);
                nodes.addAll(defaultFooter.getJAXBNodesViaXPath(regex, false));
            }
            if (evenHeader != null) {
                this.prepareVariables((JaxbXmlPartXPathAware)evenHeader);
                nodes.addAll(evenHeader.getJAXBNodesViaXPath(regex, false));
            }
            if (evenFooter != null) {
                this.prepareVariables((JaxbXmlPartXPathAware)evenFooter);
                nodes.addAll(evenFooter.getJAXBNodesViaXPath(regex, false));
            }
            if (firstHeader != null) {
                this.prepareVariables((JaxbXmlPartXPathAware)firstHeader);
                nodes.addAll(firstHeader.getJAXBNodesViaXPath(regex, false));
            }
            if (firstFooter != null) {
                this.prepareVariables((JaxbXmlPartXPathAware)firstFooter);
                nodes.addAll(firstFooter.getJAXBNodesViaXPath(regex, false));
            }
        }
        return nodes;
    }

    private boolean isTableElement(Object element) {
        return element instanceof JAXBElement && ((JAXBElement)element).getValue() instanceof Tbl;
    }

    private Tbl getTableElement(Object node) {
        JAXBElement jaxbElement = (JAXBElement)node;
        return (Tbl)jaxbElement.getValue();
    }

    private void fillTable(Segments segments, Tbl table) {
        List<Tr> rows = this.getTableRows(table);
        int currentRow = 0;
        for (Tr row : rows) {
            List<Tc> cells = this.getRowCells(row);
            Map<Tc, List<P>> columnParagraphs = this.buildColumnParagraphs(segments, cells);
            for (int index = 0; index < this.getNoOfNewRows(columnParagraphs); ++index) {
                if (index == 0) {
                    this.fillCurrentRow(columnParagraphs, cells, index);
                    continue;
                }
                Tr newRow = this.buildNewTableRow(columnParagraphs, row, cells, index);
                table.getContent().add(++currentRow, newRow);
            }
            ++currentRow;
        }
    }

    private List<Tr> getTableRows(Tbl table) {
        ArrayList<Tr> rows = new ArrayList<Tr>();
        List content = table.getContent();
        if (CollectionUtils.isNotEmpty((Collection)content)) {
            for (Object node : content) {
                if (!(node instanceof Tr)) continue;
                rows.add((Tr)node);
            }
        }
        return rows;
    }

    private List<Tc> getRowCells(Tr row) {
        ArrayList<Tc> cells = new ArrayList<Tc>();
        List content = row.getContent();
        if (CollectionUtils.isNotEmpty((Collection)content)) {
            for (Object node : content) {
                if (!this.isCellElement(node)) continue;
                cells.add(this.getCellElement(node));
            }
        }
        return cells;
    }

    private boolean isCellElement(Object element) {
        return element instanceof JAXBElement && ((JAXBElement)element).getValue() instanceof Tc;
    }

    private Tc getCellElement(Object node) {
        JAXBElement jaxbElement = (JAXBElement)node;
        return (Tc)jaxbElement.getValue();
    }

    private Map<Tc, List<P>> buildColumnParagraphs(Segments segments, List<Tc> cells) {
        HashMap<Tc, List<P>> columnValues = new HashMap<Tc, List<P>>();
        for (Tc cell : cells) {
            List contents = cell.getContent();
            List<TextFromDocx> textsFromDocx = this.getTextsFromDocx(contents, null, null, false);
            if (!this.shouldBuildColumnParagraphs(textsFromDocx)) continue;
            List<P> paragraphs = new ArrayList<P>();
            for (TextFromDocx textFromDocx : textsFromDocx) {
                String textValue = StringUtils.defaultString((String)textFromDocx.getTextValue());
                PPr paragraphProperties = textFromDocx.getParagraphProperties();
                RPr runProperties = textFromDocx.getRunProperties();
                Matcher matcher = this.buildMatcher(textValue, TABLE_TEXT_REGEX);
                int lastIndex = 0;
                while (matcher.find()) {
                    String firstPart = StringUtils.substring((String)textValue, (int)lastIndex, (int)matcher.start());
                    String coordinates = this.buildCoordinates(matcher);
                    EdiCoordinates ediCoordinates = this.buildEdiCoordinates(coordinates);
                    List<String> subvalues = segments.getValues(ediCoordinates);
                    if (StringUtils.isNotEmpty((CharSequence)firstPart)) {
                        subvalues = this.mergeListWithValue(subvalues, firstPart);
                    }
                    paragraphs = this.mergeValuesToParagraphs(paragraphs, subvalues, paragraphProperties, runProperties);
                    lastIndex = matcher.end();
                }
                String lastPart = StringUtils.substring((String)textValue, (int)lastIndex);
                if (!StringUtils.isNotEmpty((CharSequence)lastPart)) continue;
                paragraphs = this.mergeValueToParagraphs(paragraphs, lastPart, paragraphProperties, runProperties);
            }
            columnValues.put(cell, paragraphs);
        }
        return columnValues;
    }

    private boolean shouldBuildColumnParagraphs(List<TextFromDocx> textsFromDocx) {
        boolean shouldBuild = false;
        for (TextFromDocx textFromDocx : textsFromDocx) {
            String textValue = StringUtils.defaultString((String)textFromDocx.getTextValue());
            Matcher matcher = this.buildMatcher(textValue, TABLE_TEXT_REGEX);
            if (!matcher.find()) continue;
            shouldBuild = true;
            break;
        }
        return shouldBuild;
    }

    private Matcher buildMatcher(String value, String regex) {
        Pattern pattern = Pattern.compile(regex);
        return pattern.matcher(value);
    }

    private String buildCoordinates(Matcher matcher) {
        String group = matcher.group();
        return StringUtils.substringBetween((String)group, (String)TEXT_PREFIX, (String)TEXT_POSTFIX);
    }

    private EdiCoordinates buildEdiCoordinates(String coordinates) {
        return this.ediCoordinatesBuilder.build(coordinates);
    }

    private List<String> mergeListWithValue(List<String> list, String value) {
        if (CollectionUtils.isNotEmpty(list)) {
            for (int counter = 0; counter < CollectionUtils.size(list); ++counter) {
                String listValue = list.get(counter);
                String mergedValue = this.buildMergedValue(value, listValue);
                list.set(counter, mergedValue);
            }
        }
        return list;
    }

    private String buildMergedValue(String prevValue, String currValue) {
        StringBuilder value = new StringBuilder();
        value.append(prevValue);
        value.append(currValue);
        return value.toString();
    }

    private List<P> mergeValueToParagraphs(List<P> paragraphs, String value, PPr paragraphProperties, RPr runProperties) {
        if (this.isNotTableTextToSkip(value)) {
            if (CollectionUtils.isNotEmpty(paragraphs)) {
                for (int counter = 0; counter < CollectionUtils.size(paragraphs); ++counter) {
                    P paragraph = paragraphs.get(counter);
                    paragraph = this.addRunToParagraph(paragraph, value, runProperties);
                    paragraphs.set(counter, paragraph);
                }
            } else {
                P paragraph = this.buildParagraph(value, paragraphProperties, runProperties);
                paragraphs.add(paragraph);
            }
        } else {
            for (int counter = 0; counter < CollectionUtils.size(paragraphs); ++counter) {
                P paragraph = paragraphs.get(counter);
                paragraph = this.removeNewLineFromLastPosition(paragraph);
                paragraphs.set(counter, paragraph);
            }
        }
        return paragraphs;
    }

    private P addRunToParagraph(P paragraph, String value, RPr runProperties) {
        R run = this.buildRun(value, runProperties);
        paragraph.getContent().add(run);
        return paragraph;
    }

    private boolean isNotTableTextToSkip(String value) {
        return !StringUtils.equals((CharSequence)value, (CharSequence)"@EDI_TO_PDF_TABLE_TEXT_TO_SKIP@");
    }

    private List<P> mergeValuesToParagraphs(List<P> paragraphs, List<String> values, PPr paragraphProperties, RPr runProperties) {
        if (CollectionUtils.isNotEmpty(values)) {
            int counter = 0;
            for (String value : values) {
                P paragraph;
                if (this.isNotTableTextToSkip(value)) {
                    if (CollectionUtils.size(paragraphs) > counter) {
                        paragraph = paragraphs.get(counter);
                        paragraph = this.addRunToParagraph(paragraph, value, runProperties);
                        paragraphs.set(counter, paragraph);
                    } else {
                        paragraph = this.buildParagraph(value, paragraphProperties, runProperties);
                        paragraphs.add(paragraph);
                    }
                } else if (CollectionUtils.size(paragraphs) > counter) {
                    paragraph = paragraphs.get(counter);
                    paragraph = this.removeNewLineFromLastPosition(paragraph);
                    paragraphs.set(counter, paragraph);
                }
                ++counter;
            }
        }
        return paragraphs;
    }

    private P removeNewLineFromLastPosition(P paragraph) {
        List paragraphContent = paragraph.getContent();
        try {
            R run = (R)paragraph.getContent().get(paragraphContent.size() - 1);
            List runContent = run.getContent();
            Object object = runContent.get(runContent.size() - 1);
            if (object instanceof Br) {
                paragraphContent.remove(run);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return paragraph;
    }

    private int getNoOfNewRows(Map<Tc, List<P>> columnParagraphs) {
        int no = 0;
        for (List<P> paragraphs : columnParagraphs.values()) {
            int size = CollectionUtils.size(paragraphs);
            if (size <= no) continue;
            no = size;
        }
        return no;
    }

    private void fillCurrentRow(Map<Tc, List<P>> columnParagraphs, List<Tc> cells, int index) {
        for (Tc cell : cells) {
            List<P> paragraphs = columnParagraphs.get(cell);
            if (!CollectionUtils.isNotEmpty(paragraphs)) continue;
            P paragraph = this.getParagraphFromParagraphs(paragraphs, index);
            cell.getContent().clear();
            cell.getContent().add(paragraph);
        }
    }

    private P getParagraphFromParagraphs(List<P> paragraphs, int index) {
        if (CollectionUtils.size(paragraphs) > index) {
            return paragraphs.get(index);
        }
        return this.buildParagraph("");
    }

    private P buildParagraph(String value) {
        return this.buildParagraph(value, OBJECT_FACTORY.createPPr(), OBJECT_FACTORY.createRPr());
    }

    private P buildParagraph(String value, PPr paragraphProperties, RPr runProperties) {
        R run = this.buildRun(value, runProperties);
        P paragraph = OBJECT_FACTORY.createP();
        paragraph.setPPr(paragraphProperties);
        paragraph.getContent().add(run);
        return paragraph;
    }

    private R buildRun(String value, RPr runProperties) {
        R run = OBJECT_FACTORY.createR();
        run.setRPr(runProperties);
        if (this.isNewLineText(value)) {
            run.getContent().add(OBJECT_FACTORY.createBr());
        } else {
            Text text = this.buildText(value);
            run.getContent().add(text);
        }
        return run;
    }

    private boolean isNewLineText(String value) {
        return StringUtils.equals((CharSequence)value, (CharSequence)"\n");
    }

    private Text buildText(String value) {
        Text text = OBJECT_FACTORY.createText();
        text.setValue(value);
        text.setSpace("preserve");
        return text;
    }

    private Tr buildNewTableRow(Map<Tc, List<P>> columnParagraphs, Tr row, List<Tc> cells, int index) {
        Tr newRow = OBJECT_FACTORY.createTr();
        newRow.setTrPr(row.getTrPr());
        for (Tc cell : cells) {
            Tc newCell = this.buildNewTableCell(columnParagraphs, cell, index);
            newRow.getContent().add(newCell);
        }
        return newRow;
    }

    private Tc buildNewTableCell(Map<Tc, List<P>> columnParagraphs, Tc cell, int index) {
        Tc newCell = OBJECT_FACTORY.createTc();
        newCell.setTcPr(cell.getTcPr());
        List<P> paragraphs = columnParagraphs.get(cell);
        if (CollectionUtils.isNotEmpty(paragraphs)) {
            P paragraph = this.getParagraphFromParagraphs(paragraphs, index);
            newCell.getContent().add(paragraph);
        } else {
            P paragraph = this.buildParagraph("");
            newCell.getContent().add(paragraph);
        }
        return newCell;
    }

    private HashMap<String, String> buildValueMappings(Segments segments, WordprocessingMLPackage template) throws XPathBinderAssociationIsPartialException, JAXBException {
        HashMap<String, String> mappings = new HashMap<String, String>();
        List<Object> nodes = this.getNodes(template, VALUE_NODE_XPATH);
        List<TextFromDocx> textsFromDocx = this.getTextsFromDocx(nodes, null, null, false);
        for (TextFromDocx textFromDocx : textsFromDocx) {
            String textValue = StringUtils.defaultString((String)textFromDocx.getTextValue());
            Matcher matcher = this.buildMatcher(textValue, VALUE_TEXT_REGEX);
            while (matcher.find()) {
                String coordinates = this.buildCoordinates(matcher);
                EdiCoordinates ediCoordinates = this.buildEdiCoordinates(coordinates);
                String value = segments.getValue(ediCoordinates);
                mappings.put(coordinates, value);
            }
        }
        return mappings;
    }

    private List<TextFromDocx> getTextsFromDocx(List<Object> nodes, PPr paragraphProperties, RPr runProperties, boolean paragraphAlreadyDetected) {
        ArrayList<TextFromDocx> textsFromDocx = new ArrayList<TextFromDocx>();
        if (CollectionUtils.isNotEmpty(nodes)) {
            for (Object node : nodes) {
                if (node instanceof ContentAccessor) {
                    if (node instanceof P) {
                        if (paragraphAlreadyDetected) {
                            textsFromDocx.add(this.getNewLineTextFromDocx(paragraphProperties, runProperties));
                        }
                        paragraphProperties = ((P)node).getPPr();
                        paragraphAlreadyDetected = true;
                    } else if (node instanceof R) {
                        runProperties = ((R)node).getRPr();
                    }
                    List content = ((ContentAccessor)node).getContent();
                    textsFromDocx.addAll(this.getTextsFromDocx(content, paragraphProperties, runProperties, paragraphAlreadyDetected));
                    continue;
                }
                if (!this.isTextElement(node)) continue;
                textsFromDocx.add(this.getTextFromDocx(node, paragraphProperties, runProperties));
            }
        }
        return textsFromDocx;
    }

    private boolean isTextElement(Object element) {
        return element instanceof JAXBElement && ((JAXBElement)element).getValue() instanceof Text;
    }

    private TextFromDocx getTextFromDocx(Object node, PPr paragraphProperties, RPr runProperties) {
        JAXBElement jaxbElement = (JAXBElement)node;
        Text text = (Text)jaxbElement.getValue();
        return this.getTextFromDocx(text.getValue(), paragraphProperties, runProperties);
    }

    private TextFromDocx getTextFromDocx(String stringValue, PPr paragraphProperties, RPr runProperties) {
        TextFromDocx textFromDocx = new TextFromDocx();
        textFromDocx.setTextValue(stringValue);
        textFromDocx.setParagraphProperties(paragraphProperties);
        textFromDocx.setRunProperties(runProperties);
        return textFromDocx;
    }

    private TextFromDocx getNewLineTextFromDocx(PPr paragraphProperties, RPr runProperties) {
        return this.getTextFromDocx("\n", paragraphProperties, runProperties);
    }

    private File convertTemplateToPdf(EdiToPdf ediToPdf, WordprocessingMLPackage template, HashMap<String, String> mappings, AdditionalOptions additionalOptions) throws Exception {
        byte[] bytes = this.convertTemplateToPdf(ediToPdf, template, mappings);
        return PlusEFakturaTools.saveBytesToFile(additionalOptions.getDirPathForTempFile(), FILE_EXTENSION, bytes);
    }

    private byte[] convertTemplateToPdf(EdiToPdf ediToPdf, WordprocessingMLPackage template, HashMap<String, String> mappings) {
        return this.docxTemplateToPdfConverter.convert(template, mappings, ediToPdf.getDocxToPdfConverterType());
    }
}

