/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.util.emailtopdf;

import com.suncode.plugin.efaktura.util.PlusEFakturaTools;
import com.suncode.plugin.efaktura.util.emailtopdf.EmailPart;
import com.suncode.plugin.efaktura.util.emailtopdf.EmailPartBuilder;
import java.io.IOException;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.ContentType;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class EmailPartBuilderImpl
implements EmailPartBuilder {
    private static final String CONTENT_ID_HEADER_NAME = "Content-ID";

    @Override
    public EmailPart build(Part part) throws MessagingException, IOException {
        EmailPart emailPart = new EmailPart();
        emailPart.setContentId(this.buildContentId(part));
        emailPart.setContentType(this.buildContentType(part));
        emailPart.setDisposition(PlusEFakturaTools.getPartDisposition(part));
        emailPart.setInputStream(part.getInputStream());
        return emailPart;
    }

    private String buildContentId(Part part) throws MessagingException {
        Object[] headers = part.getHeader(CONTENT_ID_HEADER_NAME);
        if (ArrayUtils.isNotEmpty((Object[])headers)) {
            return StringUtils.substringBetween((String)headers[0], (String)"<", (String)">");
        }
        return "";
    }

    private String buildContentType(Part part) throws MessagingException {
        String contentTypeName = part.getContentType();
        ContentType contentType = PlusEFakturaTools.getContentType(contentTypeName);
        return contentType.getBaseType();
    }
}

