/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.util;

import com.plusmpm.database.DBManagement;
import com.plusmpm.database.IndexTable;
import com.plusmpm.database.hibernate.HibernateUtil;
import com.plusmpm.util.documents.DocumentEventTypes;
import com.suncode.plugin.efaktura.configuration.EfakturaSpringContext;
import com.suncode.plugin.efaktura.editopdf.EdiToPdfConverter;
import com.suncode.plugin.efaktura.model.editopdf.EdiToPdf;
import com.suncode.plugin.efaktura.model.license.License;
import com.suncode.plugin.efaktura.model.seenattachment.SeenAttachment;
import com.suncode.plugin.efaktura.service.editopdf.EdiToPdfService;
import com.suncode.plugin.efaktura.service.license.LicenseService;
import com.suncode.plugin.efaktura.service.seenattachment.SeenAttachmentService;
import com.suncode.plugin.efaktura.util.AddResult;
import com.suncode.plugin.efaktura.util.AdditionalOptions;
import com.suncode.plugin.efaktura.util.AttachmentPart;
import com.suncode.plugin.efaktura.util.EngineResult;
import com.suncode.plugin.efaktura.util.InterfaceExecutor;
import com.suncode.plugin.efaktura.util.MsgStatus;
import com.suncode.plugin.efaktura.util.PlusEFakturaEngine;
import com.suncode.plugin.efaktura.util.PlusEFakturaTools;
import com.suncode.plugin.efaktura.util.SubjectAsIndexesResolver;
import com.suncode.plugin.efaktura.util.TemporaryFile;
import com.suncode.plugin.efaktura.util.Workaround;
import com.suncode.plugin.efaktura.util.exception.AttachmentServiceException;
import com.suncode.plugin.efaktura.util.exception.IndexesMappingException;
import com.suncode.plugin.efaktura.util.exception.LicenseException;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassActionService;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import com.suncode.pwfl.util.CoreServiceFactory;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.util.SpringContext;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeUtility;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfservice.UserGroupAdministration;
import org.ini4j.Ini;

public class AddAttachmentsToArchiveAction {
    public static Logger log = Logger.getLogger(AddAttachmentsToArchiveAction.class);
    public static Logger clientLog = Logger.getLogger((String)"PlusEFakturaClientLog");

    public static AddResult addAttachmentsToArchive(Ini configFile, String mailboxEmail, Message message, Message messageFromMailbox, String messageUid, String msgId, String mailboxFolder, Date dateOfRead, AdditionalOptions additionalOptions, License license, int limitSize) throws LicenseException, IndexesMappingException, IOException {
        AddResult addResult;
        block198: {
            log.trace((Object)("******************** AddAttachmentsToArchive(Ini, mailboxEmail=" + mailboxEmail + ", Message, Message, messageUid=" + messageUid + ", msgId=" + msgId + ", mailboxFolder=" + mailboxFolder + ", dateOfRead, AdditionalOptions, license, limitSize=" + limitSize + ") ********************"));
            addResult = new AddResult();
            int noOfInvoices = -1;
            try {
                String archiveClass = "";
                String emailIndex = additionalOptions.getEmailToIndexForAttachment();
                String toIndex = additionalOptions.getToToIndexForAttachment();
                String ccIndex = additionalOptions.getCcToIndexForAttachment();
                String dateIndex = additionalOptions.getDateToIndexForAttachment();
                String subjectIndex = additionalOptions.getSubjectToIndexForAttachment();
                String contentIndex = additionalOptions.getContentToIndexForAttachment();
                String attachmentNameIndex = additionalOptions.getAttachmentNameToIndexForAttachment();
                String attachmentContentIndex = additionalOptions.getAttachmentContentToIndexForAttachment();
                String extIndex = additionalOptions.getExtensionToIndexForAttachment();
                String msgIdIndex = additionalOptions.getMessageIdToIndexForAttachment();
                String mailboxIndex = additionalOptions.getMailboxToIndexForAttachment();
                String mailboxFolderIndex = additionalOptions.getMailboxFolderToIndexForAttachment();
                String eInvoiceIndexId = "-1";
                String licensePath = license.getPath();
                additionalOptions.setLastAttachmentInMail(false);
                additionalOptions.setCurrentMessageId(msgId);
                String emailAddress = AddAttachmentsToArchiveAction.getEmailAddress(message, additionalOptions);
                String emailSubject = PlusEFakturaTools.decodeText(message.getSubject(), false, false);
                String emailContent = PlusEFakturaTools.getMessageContent(message);
                HashSet<String> indexesMail = new HashSet<String>();
                String acceptableExts = additionalOptions.getAcceptableExts();
                String ignoredExts = additionalOptions.getIgnoredExts();
                LicenseService licenseService = EfakturaSpringContext.getBean(LicenseService.class);
                SeenAttachmentService seenAttachmentService = EfakturaSpringContext.getBean(SeenAttachmentService.class);
                try {
                    File file = null;
                    Object o = PlusEFakturaTools.getPartContent((Part)message);
                    boolean indexesFromSubject = false;
                    if (o instanceof Multipart) {
                        List<AttachmentPart> attachmentParts = PlusEFakturaTools.getAttachmentParts((Multipart)o);
                        log.info((Object)("Ilosc zalacznikow do sprawdzenia: " + attachmentParts.size()));
                        noOfInvoices = licenseService.getNoOfInvoices(licensePath);
                        if (limitSize != 0 && (noOfInvoices < -1 || limitSize - noOfInvoices < attachmentParts.size())) {
                            throw new LicenseException("UWAGA!!! Analiza tej wiadomosci spowoduje przekroczenie miesiecznego limitu " + limitSize + " faktur. Praca modulu Plus E-faktura zostanie przerwana. Skontaktuj sie z dostawca PlusWorkflow w celu wykupienia dodatkowej licencji.");
                        }
                        log.info((Object)"To jest Multipart Message. Szukanie zalacznikow o podanych rozszerzeniach");
                        int noOfAttachment = 1;
                        log.info((Object)"Analizowanie poszczegolnych partow wiadomosci");
                        for (AttachmentPart attachmentPart : attachmentParts) {
                            Object fileMd5;
                            try {
                                String nameOfTheFile = attachmentPart.getFileName();
                                if (nameOfTheFile != null) {
                                    int i;
                                    log.info((Object)(" - Zalacznik numer " + String.valueOf(noOfAttachment)));
                                    clientLog.info((Object)(" - Zalacznik numer " + String.valueOf(noOfAttachment)));
                                    if (noOfAttachment == attachmentParts.size()) {
                                        additionalOptions.setLastAttachmentInMail(true);
                                    }
                                    ++noOfAttachment;
                                    indexesMail = new HashSet();
                                    nameOfTheFile = nameOfTheFile.trim();
                                    byte[] fileBytes = AddAttachmentsToArchiveAction.readBytesFromStream(attachmentPart.getInputStream(), additionalOptions);
                                    fileMd5 = DigestUtils.md5Hex((byte[])fileBytes);
                                    log.info((Object)("Nazwa pliku w zalaczniku: " + nameOfTheFile));
                                    if (acceptableExts == null) {
                                        log.warn((Object)"Brak definicji akceptowanych rozszerzen plikow w pliku konfiguracyjnym modulu Plus E-faktura");
                                        clientLog.warn((Object)"Brak definicji akceptowanych rozszerzen plikow w pliku konfiguracyjnym modulu Plus E-faktura");
                                        addResult.setMsgStatus(MsgStatus.NO_ACCEPTED_ATTACHMENT_EXTENSIONS);
                                        continue;
                                    }
                                    if (StringUtils.equals((CharSequence)additionalOptions.getCheckSeenAttachmentsGlobally(), (CharSequence)"TRUE")) {
                                        if (seenAttachmentService.wasSeen(mailboxEmail, nameOfTheFile, (String)fileMd5)) {
                                            log.info((Object)("Zalacznik o nazwie " + nameOfTheFile + " byl juz analizowany w przeszlosci"));
                                            clientLog.info((Object)("Zalacznik o nazwie " + nameOfTheFile + " byl juz analizowany w przeszlosci"));
                                            continue;
                                        }
                                    } else if (seenAttachmentService.wasSeen(mailboxEmail, msgId, nameOfTheFile, (String)fileMd5)) {
                                        log.info((Object)("Zalacznik o nazwie " + nameOfTheFile + " byl juz analizowany dla tej wiadomosci"));
                                        clientLog.info((Object)("Zalacznik o nazwie " + nameOfTheFile + " byl juz analizowany dla tej wiadomosci"));
                                        continue;
                                    }
                                    boolean extAccepted = false;
                                    boolean extIgnored = false;
                                    String createdExt = "";
                                    String[] extsTable = acceptableExts.split(";");
                                    String[] ignoredExtsTable = ignoredExts.split(";");
                                    int lastDot = nameOfTheFile.lastIndexOf(".");
                                    if (lastDot != -1) {
                                        createdExt = nameOfTheFile.substring(lastDot + 1, nameOfTheFile.length());
                                    }
                                    for (i = 0; i < extsTable.length; ++i) {
                                        if (!PlusEFakturaTools.shouldProcessExtension(createdExt, extsTable[i])) continue;
                                        extAccepted = true;
                                        if (!createdExt.equalsIgnoreCase(extsTable[i])) {
                                            createdExt = extsTable[i].toLowerCase();
                                            nameOfTheFile = nameOfTheFile.substring(0, lastDot) + "." + createdExt;
                                        }
                                        archiveClass = AddAttachmentsToArchiveAction.getDocumentClassNameForAttachment(configFile, createdExt, additionalOptions);
                                        break;
                                    }
                                    if (ignoredExtsTable.length > 0) {
                                        for (i = 0; i < ignoredExtsTable.length; ++i) {
                                            if (StringUtils.isBlank((CharSequence)ignoredExtsTable[i]) || extAccepted && (!extAccepted || ignoredExtsTable[i].equalsIgnoreCase("*")) || !PlusEFakturaTools.shouldProcessExtension(createdExt, ignoredExtsTable[i])) continue;
                                            extIgnored = true;
                                            break;
                                        }
                                    }
                                    SeenAttachment seenAttachment = AddAttachmentsToArchiveAction.buildSeenAttachment(mailboxEmail, msgId, nameOfTheFile, (String)fileMd5, dateOfRead);
                                    if (extIgnored) {
                                        log.info((Object)("Rozszerzenie " + createdExt + " jest ignorowane przez modul Plus E-faktura"));
                                        clientLog.info((Object)("Rozszerzenie " + createdExt + " jest ignorowane przez modul Plus E-faktura"));
                                        seenAttachmentService.add(seenAttachment);
                                        continue;
                                    }
                                    if (extAccepted) {
                                        log.info((Object)("Jest to akceptowany zalacznik o rozszerzeniu " + createdExt.toLowerCase() + ". Przygotowanie do dodania do archiwum"));
                                        clientLog.info((Object)("Jest to akceptowany zalacznik o rozszerzeniu " + createdExt.toLowerCase() + ". Przygotowanie do dodania do archiwum"));
                                        String newlyAddedFileId = "";
                                        boolean electronicInvoice = false;
                                        TemporaryFile temporaryFile = AddAttachmentsToArchiveAction.createTemporaryFile(createdExt, emailAddress, nameOfTheFile, fileBytes, additionalOptions);
                                        file = temporaryFile.getFile();
                                        createdExt = temporaryFile.getExtension();
                                        if (file != null && file.exists()) {
                                            try {
                                                if (StringUtils.isNotBlank((CharSequence)emailIndex)) {
                                                    String emailIndexId = PlusEFakturaTools.getIndexIdForDocClass(archiveClass, emailIndex);
                                                    if (!emailIndexId.equalsIgnoreCase("-1")) {
                                                        String sender = emailAddress;
                                                        if (StringUtils.isBlank((CharSequence)sender)) {
                                                            sender = "N/A";
                                                        }
                                                        indexesMail.add(emailIndexId + ";" + sender);
                                                    } else {
                                                        log.warn((Object)("Indeks o nazwie " + emailIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                                                        clientLog.warn((Object)("Indeks o nazwie " + emailIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                                                    }
                                                }
                                                if (StringUtils.isNotBlank((CharSequence)toIndex)) {
                                                    String toIndexId = PlusEFakturaTools.getIndexIdForDocClass(archiveClass, toIndex);
                                                    if (!toIndexId.equalsIgnoreCase("-1")) {
                                                        String to = PlusEFakturaTools.getTo(message);
                                                        if (StringUtils.isBlank((CharSequence)to)) {
                                                            to = "N/A";
                                                        }
                                                        indexesMail.add(toIndexId + ";" + to);
                                                    } else {
                                                        log.warn((Object)("Indeks o nazwie " + toIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                                                        clientLog.warn((Object)("Indeks o nazwie " + toIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                                                    }
                                                }
                                                if (StringUtils.isNotBlank((CharSequence)ccIndex)) {
                                                    String ccIndexId = PlusEFakturaTools.getIndexIdForDocClass(archiveClass, ccIndex);
                                                    if (!ccIndexId.equalsIgnoreCase("-1")) {
                                                        String cc = PlusEFakturaTools.getCc(message);
                                                        if (StringUtils.isBlank((CharSequence)cc)) {
                                                            cc = "N/A";
                                                        }
                                                        indexesMail.add(ccIndexId + ";" + cc);
                                                    } else {
                                                        log.warn((Object)("Indeks o nazwie " + ccIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                                                        clientLog.warn((Object)("Indeks o nazwie " + ccIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                                                    }
                                                }
                                                if (StringUtils.isNotBlank((CharSequence)dateIndex)) {
                                                    String dateIndexId = PlusEFakturaTools.getIndexIdForDocClass(archiveClass, dateIndex);
                                                    if (!dateIndexId.equalsIgnoreCase("-1")) {
                                                        Date newDate = message.getSentDate();
                                                        if (newDate != null) {
                                                            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                                            indexesMail.add(dateIndexId + ";" + dateFormat.format(newDate));
                                                        } else {
                                                            log.warn((Object)"Nie udalo sie pobrac daty wiadomosci");
                                                            clientLog.warn((Object)"Nie udalo sie pobrac daty wiadomosci");
                                                        }
                                                    } else {
                                                        log.warn((Object)("Indeks o nazwie " + dateIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                                                        clientLog.warn((Object)("Indeks o nazwie " + dateIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                                                    }
                                                }
                                                if (StringUtils.isNotBlank((CharSequence)subjectIndex)) {
                                                    String subjectIndexId = PlusEFakturaTools.getIndexIdForDocClass(archiveClass, subjectIndex);
                                                    if (!subjectIndexId.equalsIgnoreCase("-1")) {
                                                        indexesMail.add(subjectIndexId + ";" + emailSubject);
                                                    } else {
                                                        log.warn((Object)("Indeks o nazwie " + subjectIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                                                        clientLog.warn((Object)("Indeks o nazwie " + subjectIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                                                    }
                                                }
                                                if (StringUtils.isNotBlank((CharSequence)contentIndex)) {
                                                    String contentIndexId = PlusEFakturaTools.getIndexIdForDocClass(archiveClass, contentIndex);
                                                    if (!contentIndexId.equalsIgnoreCase("-1")) {
                                                        indexesMail.add(contentIndexId + ";" + PlusEFakturaTools.verifyEmailContent(emailContent));
                                                    } else {
                                                        log.warn((Object)("Indeks o nazwie " + contentIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                                                        clientLog.warn((Object)("Indeks o nazwie " + contentIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                                                    }
                                                }
                                                if (StringUtils.isNotBlank((CharSequence)extIndex)) {
                                                    String extIndexId = PlusEFakturaTools.getIndexIdForDocClass(archiveClass, extIndex);
                                                    if (!extIndexId.equalsIgnoreCase("-1")) {
                                                        indexesMail.add(extIndexId + ";" + createdExt.toLowerCase());
                                                    } else {
                                                        log.warn((Object)("Indeks o nazwie " + extIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                                                        clientLog.warn((Object)("Indeks o nazwie " + extIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                                                    }
                                                }
                                                if (StringUtils.isNotBlank((CharSequence)msgIdIndex)) {
                                                    String msgIdIndexId = PlusEFakturaTools.getIndexIdForDocClass(archiveClass, msgIdIndex);
                                                    if (!msgIdIndexId.equalsIgnoreCase("-1")) {
                                                        indexesMail.add(msgIdIndexId + ";" + msgId);
                                                    } else {
                                                        log.warn((Object)("Indeks o nazwie " + msgIdIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                                                        clientLog.warn((Object)("Indeks o nazwie " + msgIdIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                                                    }
                                                }
                                                if (StringUtils.isNotBlank((CharSequence)mailboxIndex)) {
                                                    String mailboxIndexId = PlusEFakturaTools.getIndexIdForDocClass(archiveClass, mailboxIndex);
                                                    if (!mailboxIndexId.equalsIgnoreCase("-1")) {
                                                        indexesMail.add(mailboxIndexId + ";" + additionalOptions.getMailboxAddress());
                                                    } else {
                                                        log.warn((Object)("Indeks o nazwie " + mailboxIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                                                        clientLog.warn((Object)("Indeks o nazwie " + mailboxIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                                                    }
                                                }
                                                if (StringUtils.isNotBlank((CharSequence)mailboxFolderIndex)) {
                                                    String mailboxFolderIndexId = PlusEFakturaTools.getIndexIdForDocClass(archiveClass, mailboxFolderIndex);
                                                    if (!mailboxFolderIndexId.equalsIgnoreCase("-1")) {
                                                        indexesMail.add(mailboxFolderIndexId + ";" + mailboxFolder);
                                                    } else {
                                                        log.warn((Object)("Indeks o nazwie " + mailboxFolderIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                                                        clientLog.warn((Object)("Indeks o nazwie " + mailboxFolderIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                                                    }
                                                }
                                                if (AddAttachmentsToArchiveAction.shouldResolveSubjectAsIndexes(additionalOptions)) {
                                                    SubjectAsIndexesResolver subjectAsIndexesResolver = new SubjectAsIndexesResolver(additionalOptions.getSubjectAsIndexesDelimiterForAttachment(), additionalOptions.getSubjectAsIndexesSequenceForAttachment(), emailSubject, archiveClass, additionalOptions);
                                                    indexesMail.addAll(subjectAsIndexesResolver.resolve());
                                                    indexesFromSubject = true;
                                                }
                                            }
                                            catch (Exception e) {
                                                log.error((Object)e.getMessage(), (Throwable)e);
                                            }
                                            try {
                                                if (StringUtils.isNotBlank((CharSequence)attachmentNameIndex)) {
                                                    String attachmentNameIndexId = PlusEFakturaTools.getIndexIdForDocClass(archiveClass, attachmentNameIndex);
                                                    if (!attachmentNameIndexId.equalsIgnoreCase("-1")) {
                                                        indexesMail.add(attachmentNameIndexId + ";" + file.getName());
                                                    } else {
                                                        log.warn((Object)("Indeks o nazwie " + attachmentNameIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                                                        clientLog.warn((Object)("Indeks o nazwie " + attachmentNameIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                                                    }
                                                }
                                                eInvoiceIndexId = PlusEFakturaTools.getIndexIdForDocClass(archiveClass, "Faktura elektroniczna");
                                                if (createdExt.equalsIgnoreCase("pdf") || createdExt.equalsIgnoreCase("sig")) {
                                                    PlusEFakturaEngine plusEFakturaEngine = new PlusEFakturaEngine();
                                                    EngineResult engineResult = plusEFakturaEngine.runEngine(message, indexesMail, file, archiveClass, eInvoiceIndexId, emailAddress, mailboxEmail, emailSubject, emailContent, additionalOptions, addResult, indexesFromSubject);
                                                    Set<String> EFakturaEngineResult = engineResult.getIndexes();
                                                    electronicInvoice = engineResult.isElectronicInvoice();
                                                    if (EFakturaEngineResult != null && EFakturaEngineResult.size() > 0) {
                                                        indexesMail.addAll(EFakturaEngineResult);
                                                    }
                                                    if (StringUtils.isNotBlank((CharSequence)attachmentContentIndex)) {
                                                        String attachmentContentIndexId = PlusEFakturaTools.getIndexIdForDocClass(archiveClass, attachmentContentIndex);
                                                        if (!attachmentContentIndexId.equalsIgnoreCase("-1")) {
                                                            indexesMail.add(attachmentContentIndexId + ";" + engineResult.getAttachmentContent());
                                                        } else {
                                                            log.warn((Object)("Indeks o nazwie " + attachmentContentIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                                                            clientLog.warn((Object)("Indeks o nazwie " + attachmentContentIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                                                        }
                                                    }
                                                } else if (!(eInvoiceIndexId.equalsIgnoreCase("-1") || createdExt.equalsIgnoreCase("pdf") || createdExt.equalsIgnoreCase("sig"))) {
                                                    indexesMail.add(eInvoiceIndexId + ";NIE");
                                                }
                                            }
                                            catch (AttachmentServiceException e) {
                                                throw e;
                                            }
                                            catch (IndexesMappingException e) {
                                                throw e;
                                            }
                                            catch (Exception e) {
                                                log.error((Object)e.getMessage(), (Throwable)e);
                                            }
                                            newlyAddedFileId = AddAttachmentsToArchiveAction.preparationsForAdding(messageFromMailbox, file, indexesMail, archiveClass, file.getName(), seenAttachment, additionalOptions, addResult);
                                        } else {
                                            newlyAddedFileId = "-1";
                                            addResult.setMsgStatus(MsgStatus.TEMPORARY_FILE_SAVE_ERROR);
                                            log.warn((Object)"Nie udalo sie utworzyc pliku tymczasowego. Dodawanie zalacznika do archiwum wstrzymane");
                                            clientLog.warn((Object)"Nie udalo sie utworzyc pliku tymczasowego. Dodawanie zalacznika do archiwum wstrzymane");
                                        }
                                        addResult.addDoc(newlyAddedFileId, nameOfTheFile);
                                        if (!StringUtils.isNotBlank((CharSequence)newlyAddedFileId) || newlyAddedFileId.equalsIgnoreCase("-1") || newlyAddedFileId.equalsIgnoreCase("-2") || !electronicInvoice || limitSize == 0) continue;
                                        licenseService.incrementNoOfInvoices(licensePath);
                                        licenseService.updateChecksumForLicense(license);
                                        continue;
                                    }
                                    log.info((Object)("Rozszerzenie " + createdExt + " nie jest akceptowane przez modul Plus E-faktura"));
                                    clientLog.info((Object)("Rozszerzenie " + createdExt + " nie jest akceptowane przez modul Plus E-faktura"));
                                    addResult.addDoc("-2", nameOfTheFile);
                                    addResult.setMsgStatus(MsgStatus.UNACCEPTED_ATTACHMENT_EXTENSION_FOUND);
                                    continue;
                                }
                                log.info((Object)"Part bez zalacznika");
                            }
                            catch (LicenseException e) {
                                throw e;
                            }
                            catch (AttachmentServiceException e) {
                                log.info((Object)"Detekcja zalacznika zamiast faktury");
                                clientLog.info((Object)"Detekcja zalacznika zamiast faktury");
                                addResult.clearMsgStatus();
                                addResult.incrementNonIncoives();
                                FileInputStream is = new FileInputStream(e.getFile());
                                fileMd5 = null;
                                try {
                                    String fileMd52 = DigestUtils.md5Hex((InputStream)is);
                                    SeenAttachment seenAttachment = AddAttachmentsToArchiveAction.buildSeenAttachment(mailboxEmail, msgId, e.getFile().getName(), fileMd52, dateOfRead);
                                    PlusEFakturaTools.handleAttachmentService(e, seenAttachment, mailboxFolder);
                                }
                                catch (Throwable fileMd52) {
                                    fileMd5 = fileMd52;
                                    throw fileMd52;
                                }
                                finally {
                                    if (is == null) continue;
                                    if (fileMd5 != null) {
                                        try {
                                            ((InputStream)is).close();
                                        }
                                        catch (Throwable fileMd52) {
                                            ((Throwable)fileMd5).addSuppressed(fileMd52);
                                        }
                                        continue;
                                    }
                                    ((InputStream)is).close();
                                }
                            }
                            catch (IndexesMappingException e) {
                                throw e;
                            }
                            catch (Exception exc) {
                                log.error((Object)exc.getMessage(), (Throwable)exc);
                            }
                        }
                        break block198;
                    }
                    log.info((Object)"Wiadomosc nie jest typu Multipart. Analizowanie zawartosci");
                    archiveClass = additionalOptions.getDocClassName();
                    String sType = message.getContentType();
                    String[] extsTable = acceptableExts.split(";");
                    String[] ignoredExtsTable = ignoredExts.split(";");
                    if (StringUtils.isNotBlank((CharSequence)sType)) {
                        int j;
                        int i;
                        String contentTypeName = message.getContentType();
                        ContentType contentType = PlusEFakturaTools.getContentType(contentTypeName);
                        String baseType = contentType.getBaseType();
                        String sSubtype = contentType.getSubType();
                        String[] extsForSubtype = PlusEFakturaTools.getExtFromMIME(sSubtype).split(";");
                        boolean finishExtsTableLoop = false;
                        boolean bExtFound = false;
                        boolean bExtIgnored = false;
                        if (ignoredExtsTable.length > 0) {
                            finishExtsTableLoop = false;
                            for (i = 0; i < ignoredExtsTable.length; ++i) {
                                for (j = 0; j < extsForSubtype.length; ++j) {
                                    if (!PlusEFakturaTools.shouldProcessExtension(extsForSubtype[j], ignoredExtsTable[i])) continue;
                                    bExtIgnored = true;
                                    finishExtsTableLoop = true;
                                    break;
                                }
                                if (finishExtsTableLoop) break;
                            }
                        }
                        for (i = 0; i < extsTable.length; ++i) {
                            for (j = 0; j < extsForSubtype.length; ++j) {
                                if (!PlusEFakturaTools.shouldProcessExtension(extsForSubtype[j], extsTable[i]) && !baseType.equalsIgnoreCase("text/plain")) continue;
                                bExtFound = true;
                                ArrayList<String> nameOfTheFileList = new ArrayList<String>();
                                ArrayList<InputStream> isList = new ArrayList<InputStream>();
                                if (baseType.equalsIgnoreCase("text/plain")) {
                                    String oneAttachment;
                                    String messageTextContent = (String)PlusEFakturaTools.getPartContent((Part)message);
                                    if (StringUtils.isBlank((CharSequence)messageTextContent)) continue;
                                    String begin666 = "begin 666";
                                    String end = "end";
                                    String percentPDF = "%PDF";
                                    String percentsEOF = "%%EOF";
                                    String enter = System.getProperty("line.separator");
                                    String carriageReturn = "\r";
                                    int iIndexOfBegin666 = messageTextContent.indexOf(begin666, 0);
                                    int iIndexOfEnd = messageTextContent.indexOf(end, 0);
                                    int iIndexOfPercentPDF = messageTextContent.indexOf(percentPDF, 0);
                                    int iIndexOfPercentsEOF = messageTextContent.indexOf(percentsEOF, 0);
                                    int noOfAttachment = 1;
                                    if (iIndexOfBegin666 != -1 && iIndexOfEnd != -1) {
                                        log.info((Object)"Wykryto wiadomosc zawierajaca zalacznik/zalaczniki zakodowane w UUENCODE. Analizowanie kolejnych zalacznikow");
                                        clientLog.info((Object)"Wykryto wiadomosc zawierajaca zalacznik/zalaczniki zakodowane w UUENCODE. Analizowanie kolejnych zalacznikow");
                                        while (iIndexOfBegin666 != -1 && iIndexOfEnd != -1) {
                                            log.info((Object)(" - Zalacznik numer " + String.valueOf(noOfAttachment)));
                                            clientLog.info((Object)(" - Zalacznik numer " + String.valueOf(noOfAttachment)));
                                            oneAttachment = messageTextContent.substring(iIndexOfBegin666, iIndexOfEnd + end.length());
                                            String nameOfTheFile = oneAttachment.substring(begin666.length(), oneAttachment.length());
                                            int iIndexOfEnter = nameOfTheFile.indexOf(enter);
                                            if (nameOfTheFile.compareTo("") == 0 || iIndexOfEnter == -1) {
                                                iIndexOfBegin666 = messageTextContent.indexOf(begin666, iIndexOfEnd + end.length());
                                                iIndexOfEnd = messageTextContent.indexOf(end, iIndexOfEnd + end.length());
                                                continue;
                                            }
                                            int iIndexOfLastDot = (nameOfTheFile = nameOfTheFile.substring(0, iIndexOfEnter)).lastIndexOf(".");
                                            if (iIndexOfLastDot == -1) {
                                                iIndexOfBegin666 = messageTextContent.indexOf(begin666, iIndexOfEnd + end.length());
                                                iIndexOfEnd = messageTextContent.indexOf(end, iIndexOfEnd + end.length());
                                                continue;
                                            }
                                            String foundFileExt = nameOfTheFile.substring(iIndexOfLastDot + 1, nameOfTheFile.length());
                                            if (foundFileExt.endsWith(carriageReturn)) {
                                                foundFileExt = foundFileExt.substring(0, foundFileExt.length() - carriageReturn.length());
                                            }
                                            if (!foundFileExt.equalsIgnoreCase(extsTable[i])) {
                                                iIndexOfBegin666 = messageTextContent.indexOf(begin666, iIndexOfEnd + end.length());
                                                iIndexOfEnd = messageTextContent.indexOf(end, iIndexOfEnd + end.length());
                                                continue;
                                            }
                                            nameOfTheFile = nameOfTheFile.trim();
                                            byte[] b = oneAttachment.getBytes();
                                            ByteArrayInputStream bais = new ByteArrayInputStream(b);
                                            InputStream is = MimeUtility.decode((InputStream)bais, (String)"uuencode");
                                            bais.close();
                                            nameOfTheFileList.add(nameOfTheFile);
                                            isList.add(is);
                                            iIndexOfBegin666 = messageTextContent.indexOf(begin666, iIndexOfEnd + end.length());
                                            iIndexOfEnd = messageTextContent.indexOf(end, iIndexOfEnd + end.length());
                                        }
                                    } else if (iIndexOfPercentPDF != -1 && iIndexOfPercentsEOF != -1) {
                                        log.info((Object)"Wykryto wiadomosc zawierajaca zalacznik/zalaczniki pdf. Analizowanie kolejnych zalacznikow");
                                        clientLog.info((Object)"Wykryto wiadomosc zawierajaca zalacznik/zalaczniki pdf. Analizowanie kolejnych zalacznikow");
                                        while (iIndexOfPercentPDF != -1 && iIndexOfPercentsEOF != -1) {
                                            log.info((Object)(" - Zalacznik numer " + String.valueOf(noOfAttachment)));
                                            clientLog.info((Object)(" - Zalacznik numer " + String.valueOf(noOfAttachment)));
                                            oneAttachment = messageTextContent.substring(iIndexOfPercentPDF, iIndexOfPercentsEOF + percentsEOF.length());
                                            byte[] b = oneAttachment.getBytes("UTF-8");
                                            ByteArrayInputStream bais = new ByteArrayInputStream(b);
                                            nameOfTheFileList.add("");
                                            isList.add(bais);
                                            iIndexOfPercentPDF = messageTextContent.indexOf(percentPDF, iIndexOfPercentsEOF + percentsEOF.length());
                                            iIndexOfPercentsEOF = messageTextContent.indexOf(percentsEOF, iIndexOfPercentsEOF + percentsEOF.length());
                                        }
                                    }
                                } else {
                                    String nameOfTheFile = contentType.getParameter("Name");
                                    InputStream is = message.getInputStream();
                                    nameOfTheFileList.add(nameOfTheFile);
                                    isList.add(is);
                                }
                                for (int q = 0; q < nameOfTheFileList.size(); ++q) {
                                    if (q == nameOfTheFileList.size() - 1) {
                                        additionalOptions.setLastAttachmentInMail(true);
                                    }
                                    String nameOfTheFile = (String)nameOfTheFileList.get(q);
                                    InputStream is = (InputStream)isList.get(q);
                                    if (StringUtils.isBlank((CharSequence)nameOfTheFile)) {
                                        SecureRandom random = new SecureRandom();
                                        long n = random.nextLong();
                                        n = n == Long.MIN_VALUE ? 0L : Math.abs(n);
                                        String randomNumber = String.valueOf(n);
                                        String addedExt = extsTable[i].toLowerCase();
                                        nameOfTheFile = "zalacznik" + randomNumber + "." + addedExt;
                                    } else if (nameOfTheFile.split("[.]").length == 1) {
                                        String addedExt = extsTable[i].toLowerCase();
                                        nameOfTheFile = nameOfTheFile + "." + addedExt;
                                    }
                                    nameOfTheFile = PlusEFakturaTools.decodeText(nameOfTheFile, true, true);
                                    log.info((Object)("Nazwa pliku w zalaczniku: " + nameOfTheFile));
                                    int lastDot = nameOfTheFile.lastIndexOf(".");
                                    String createdExt = nameOfTheFile.substring(lastDot + 1, nameOfTheFile.length());
                                    if (!createdExt.equalsIgnoreCase(extsTable[i])) {
                                        createdExt = extsTable[i].toLowerCase();
                                        nameOfTheFile = nameOfTheFile.substring(0, lastDot) + "." + createdExt;
                                    }
                                    archiveClass = AddAttachmentsToArchiveAction.getDocumentClassNameForAttachment(configFile, createdExt, additionalOptions);
                                    byte[] fileBytes = IOUtils.toByteArray((InputStream)is);
                                    TemporaryFile temporaryFile = AddAttachmentsToArchiveAction.createTemporaryFile(createdExt, emailAddress, nameOfTheFile, fileBytes, additionalOptions);
                                    file = temporaryFile.getFile();
                                    createdExt = temporaryFile.getExtension();
                                    if (file != null && file.exists()) {
                                        try {
                                            if (StringUtils.isNotBlank((CharSequence)emailIndex)) {
                                                String emailIndexId = PlusEFakturaTools.getIndexIdForDocClass(archiveClass, emailIndex);
                                                if (!emailIndexId.equalsIgnoreCase("-1")) {
                                                    String sender = emailAddress;
                                                    if (StringUtils.isBlank((CharSequence)sender)) {
                                                        sender = "N/A";
                                                    }
                                                    indexesMail.add(emailIndexId + ";" + sender);
                                                } else {
                                                    log.warn((Object)("Indeks o nazwie " + emailIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                                                    clientLog.warn((Object)("Indeks o nazwie " + emailIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                                                }
                                            }
                                            if (StringUtils.isNotBlank((CharSequence)toIndex)) {
                                                String toIndexId = PlusEFakturaTools.getIndexIdForDocClass(archiveClass, toIndex);
                                                if (!toIndexId.equalsIgnoreCase("-1")) {
                                                    String to = PlusEFakturaTools.getTo(message);
                                                    if (StringUtils.isBlank((CharSequence)to)) {
                                                        to = "N/A";
                                                    }
                                                    indexesMail.add(toIndexId + ";" + to);
                                                } else {
                                                    log.warn((Object)("Indeks o nazwie " + toIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                                                    clientLog.warn((Object)("Indeks o nazwie " + toIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                                                }
                                            }
                                            if (StringUtils.isNotBlank((CharSequence)ccIndex)) {
                                                String ccIndexId = PlusEFakturaTools.getIndexIdForDocClass(archiveClass, ccIndex);
                                                if (!ccIndexId.equalsIgnoreCase("-1")) {
                                                    String cc = PlusEFakturaTools.getCc(message);
                                                    if (StringUtils.isBlank((CharSequence)cc)) {
                                                        cc = "N/A";
                                                    }
                                                    indexesMail.add(ccIndexId + ";" + cc);
                                                } else {
                                                    log.warn((Object)("Indeks o nazwie " + ccIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                                                    clientLog.warn((Object)("Indeks o nazwie " + ccIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                                                }
                                            }
                                            if (StringUtils.isNotBlank((CharSequence)dateIndex)) {
                                                String dateIndexId = PlusEFakturaTools.getIndexIdForDocClass(archiveClass, dateIndex);
                                                if (!dateIndexId.equalsIgnoreCase("-1")) {
                                                    Date newDate = message.getSentDate();
                                                    if (newDate != null) {
                                                        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                                        indexesMail.add(dateIndexId + ";" + dateFormat.format(newDate));
                                                    } else {
                                                        log.warn((Object)"Nie udalo sie pobrac daty wiadomosci");
                                                        clientLog.warn((Object)"Nie udalo sie pobrac daty wiadomosci");
                                                    }
                                                } else {
                                                    log.warn((Object)("Indeks o nazwie " + dateIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                                                    clientLog.warn((Object)("Indeks o nazwie " + dateIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                                                }
                                            }
                                            if (StringUtils.isNotBlank((CharSequence)subjectIndex)) {
                                                String subjectIndexId = PlusEFakturaTools.getIndexIdForDocClass(archiveClass, subjectIndex);
                                                if (!subjectIndexId.equalsIgnoreCase("-1")) {
                                                    indexesMail.add(subjectIndexId + ";" + emailSubject);
                                                } else {
                                                    log.warn((Object)("Indeks o nazwie " + subjectIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                                                    clientLog.warn((Object)("Indeks o nazwie " + subjectIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                                                }
                                            }
                                            if (StringUtils.isNotBlank((CharSequence)contentIndex)) {
                                                String contentIndexId = PlusEFakturaTools.getIndexIdForDocClass(archiveClass, contentIndex);
                                                if (!contentIndexId.equalsIgnoreCase("-1")) {
                                                    indexesMail.add(contentIndexId + ";" + PlusEFakturaTools.verifyEmailContent(emailContent));
                                                } else {
                                                    log.warn((Object)("Indeks o nazwie " + contentIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                                                    clientLog.warn((Object)("Indeks o nazwie " + contentIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                                                }
                                            }
                                            if (StringUtils.isNotBlank((CharSequence)extIndex)) {
                                                String extIndexId = PlusEFakturaTools.getIndexIdForDocClass(archiveClass, extIndex);
                                                if (!extIndexId.equalsIgnoreCase("-1")) {
                                                    indexesMail.add(extIndexId + ";" + createdExt.toLowerCase());
                                                } else {
                                                    log.warn((Object)("Indeks o nazwie " + extIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                                                    clientLog.warn((Object)("Indeks o nazwie " + extIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                                                }
                                            }
                                            if (StringUtils.isNotBlank((CharSequence)msgIdIndex)) {
                                                String msgIdIndexId = PlusEFakturaTools.getIndexIdForDocClass(archiveClass, msgIdIndex);
                                                if (!msgIdIndexId.equalsIgnoreCase("-1")) {
                                                    indexesMail.add(msgIdIndexId + ";" + msgId);
                                                } else {
                                                    log.warn((Object)("Indeks o nazwie " + msgIdIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                                                    clientLog.warn((Object)("Indeks o nazwie " + msgIdIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                                                }
                                            }
                                            if (StringUtils.isNotBlank((CharSequence)mailboxIndex)) {
                                                String mailboxIndexId = PlusEFakturaTools.getIndexIdForDocClass(archiveClass, mailboxIndex);
                                                if (!mailboxIndexId.equalsIgnoreCase("-1")) {
                                                    indexesMail.add(mailboxIndexId + ";" + additionalOptions.getMailboxAddress());
                                                } else {
                                                    log.warn((Object)("Indeks o nazwie " + mailboxIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                                                    clientLog.warn((Object)("Indeks o nazwie " + mailboxIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                                                }
                                            }
                                            if (StringUtils.isNotBlank((CharSequence)mailboxFolderIndex)) {
                                                String mailboxFolderIndexId = PlusEFakturaTools.getIndexIdForDocClass(archiveClass, mailboxFolderIndex);
                                                if (!mailboxFolderIndexId.equalsIgnoreCase("-1")) {
                                                    indexesMail.add(mailboxFolderIndexId + ";" + mailboxFolder);
                                                } else {
                                                    log.warn((Object)("Indeks o nazwie " + mailboxFolderIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                                                    clientLog.warn((Object)("Indeks o nazwie " + mailboxFolderIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                                                }
                                            }
                                            if (AddAttachmentsToArchiveAction.shouldResolveSubjectAsIndexes(additionalOptions)) {
                                                SubjectAsIndexesResolver subjectAsIndexesResolver = new SubjectAsIndexesResolver(additionalOptions.getSubjectAsIndexesDelimiterForAttachment(), additionalOptions.getSubjectAsIndexesSequenceForAttachment(), emailSubject, archiveClass, additionalOptions);
                                                indexesMail.addAll(subjectAsIndexesResolver.resolve());
                                                indexesFromSubject = true;
                                            }
                                        }
                                        catch (Exception e) {
                                            log.error((Object)e.getMessage(), (Throwable)e);
                                        }
                                        boolean electronicInvoice = false;
                                        try {
                                            if (StringUtils.isNotBlank((CharSequence)attachmentNameIndex)) {
                                                String attachmentNameIndexId = PlusEFakturaTools.getIndexIdForDocClass(archiveClass, attachmentNameIndex);
                                                if (!attachmentNameIndexId.equalsIgnoreCase("-1")) {
                                                    indexesMail.add(attachmentNameIndexId + ";" + file.getName());
                                                } else {
                                                    log.warn((Object)("Indeks o nazwie " + attachmentNameIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                                                    clientLog.warn((Object)("Indeks o nazwie " + attachmentNameIndex + " nie istnieje w klasie dokumentow " + archiveClass + ". Brak mozliwosci przypisania wartosci"));
                                                }
                                            }
                                            eInvoiceIndexId = PlusEFakturaTools.getIndexIdForDocClass(archiveClass, "Faktura elektroniczna");
                                            if (createdExt.equalsIgnoreCase("pdf") || createdExt.equalsIgnoreCase("sig")) {
                                                PlusEFakturaEngine plusEFakturaEngine = new PlusEFakturaEngine();
                                                EngineResult engineResult = plusEFakturaEngine.runEngine(message, indexesMail, file, archiveClass, eInvoiceIndexId, emailAddress, mailboxEmail, emailSubject, emailContent, additionalOptions, addResult, indexesFromSubject);
                                                Set<String> EFakturaEngineResult = engineResult.getIndexes();
                                                electronicInvoice = engineResult.isElectronicInvoice();
                                                if (EFakturaEngineResult != null && EFakturaEngineResult.size() > 0) {
                                                    indexesMail.addAll(EFakturaEngineResult);
                                                }
                                            } else if (!(eInvoiceIndexId.equalsIgnoreCase("-1") || createdExt.equalsIgnoreCase("pdf") || createdExt.equalsIgnoreCase("sig"))) {
                                                indexesMail.add(eInvoiceIndexId + ";NIE");
                                            }
                                        }
                                        catch (AttachmentServiceException e) {
                                            throw e;
                                        }
                                        catch (IndexesMappingException e) {
                                            throw e;
                                        }
                                        catch (Exception e) {
                                            log.error((Object)e.getMessage(), (Throwable)e);
                                        }
                                        SeenAttachment seenAttachment = null;
                                        try (FileInputStream fis = new FileInputStream(file);){
                                            String fileMd5 = DigestUtils.md5Hex((InputStream)is);
                                            seenAttachment = AddAttachmentsToArchiveAction.buildSeenAttachment(mailboxEmail, msgId, nameOfTheFile, fileMd5, dateOfRead);
                                        }
                                        String newlyAddedFileId = AddAttachmentsToArchiveAction.preparationsForAdding(messageFromMailbox, file, indexesMail, archiveClass, file.getName(), seenAttachment, additionalOptions, addResult);
                                        addResult.addDoc(newlyAddedFileId, nameOfTheFile);
                                        if (!StringUtils.isNotBlank((CharSequence)newlyAddedFileId) || newlyAddedFileId.equalsIgnoreCase("-1") || newlyAddedFileId.equalsIgnoreCase("-2") || !electronicInvoice || limitSize == 0) continue;
                                        noOfInvoices = licenseService.getNoOfInvoices(licensePath);
                                        if (noOfInvoices < -1 || limitSize <= noOfInvoices) {
                                            throw new LicenseException("UWAGA!!! Przekroczono miesieczny limit " + limitSize + " faktur. Skontaktuj sie z dostawca PlusWorkflow w celu wykupienia dodatkowej licencji.");
                                        }
                                        licenseService.incrementNoOfInvoices(licensePath);
                                        licenseService.updateChecksumForLicense(license);
                                        continue;
                                    }
                                    log.warn((Object)"Nie udalo sie utworzyc pliku tymczasowego. Dodawanie zalacznika do archiwum wstrzymane");
                                    clientLog.warn((Object)"Nie udalo sie utworzyc pliku tymczasowego. Dodawanie zalacznika do archiwum wstrzymane");
                                    addResult.addDoc("-1", nameOfTheFile);
                                    addResult.setMsgStatus(MsgStatus.TEMPORARY_FILE_SAVE_ERROR);
                                }
                                finishExtsTableLoop = true;
                                break;
                            }
                            if (finishExtsTableLoop) break;
                        }
                        if (!bExtFound) {
                            if (bExtIgnored) {
                                log.info((Object)("Rozszerzenia dla typu zawartosci " + baseType + " jest ignorowane przez modul Plus E-faktura"));
                                clientLog.info((Object)("Rozszerzenia dla typu zawartosci " + baseType + " jest ignorowane przez modul Plus E-faktura"));
                            } else {
                                log.info((Object)("Rozszerzenia dla typu zawartosci " + baseType + " nie sa akceptowane przez modul Plus E-faktura"));
                                clientLog.info((Object)("Rozszerzenia dla typu zawartosci " + baseType + " nie sa akceptowane przez modul Plus E-faktura"));
                                addResult.addDoc("-2", "n/a");
                                addResult.setMsgStatus(MsgStatus.UNACCEPTED_ATTACHMENT_EXTENSION_FOUND);
                            }
                        }
                        break block198;
                    }
                    log.info((Object)"Nieznany typ ContentType. Dodawania zalacznika z maila wstrzymane");
                    clientLog.info((Object)"Nieznany typ ContentType. Dodawania zalacznika z maila wstrzymane");
                    addResult.setMsgStatus(MsgStatus.UNKNOWN_MAIL_CONTENT);
                }
                catch (LicenseException e) {
                    throw e;
                }
                catch (AttachmentServiceException e) {
                    log.info((Object)"Detekcja zalacznika zamiast faktury");
                    clientLog.info((Object)"Detekcja zalacznika zamiast faktury");
                    addResult.clearMsgStatus();
                    addResult.incrementNonIncoives();
                    try (FileInputStream is = new FileInputStream(e.getFile());){
                        String fileMd5 = DigestUtils.md5Hex((InputStream)is);
                        SeenAttachment seenAttachment = AddAttachmentsToArchiveAction.buildSeenAttachment(mailboxEmail, msgId, e.getFile().getName(), fileMd5, dateOfRead);
                        PlusEFakturaTools.handleAttachmentService(e, seenAttachment, mailboxFolder);
                    }
                }
                catch (IndexesMappingException e) {
                    throw e;
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            catch (LicenseException e) {
                throw e;
            }
            catch (IndexesMappingException e) {
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return addResult;
    }

    public static String preparationsForAdding(Message message, File file, Set<String> indexesMail, String archiveClass, String archiveFileName, SeenAttachment seenAttachment, AdditionalOptions additionalOptions, AddResult addResult) throws IndexesMappingException {
        log.trace((Object)("******************** PreparationsForAdding(Message, File, Set<String>, archiveClass=" + archiveClass + ", seenAttachment, AdditionalOptions, AddResult) ********************"));
        String newlyAddedFileId = "-1";
        UserGroupAdministration uga = Shark.getInstance().getAdminInterface().getUserGroupAdministration();
        try {
            InterfaceExecutor executor = new InterfaceExecutor();
            String continueAdding = executor.executeAnalyzeMailContent(message, indexesMail, file, additionalOptions);
            Set<String> allIndexes = executor.executeSetMoreIndexesForFile(message, indexesMail, file, additionalOptions);
            if (continueAdding != null && continueAdding.compareToIgnoreCase("true") == 0) {
                String administrationLogin = additionalOptions.getAdministrationUserLogin();
                try {
                    if (StringUtils.isBlank((CharSequence)administrationLogin) || !uga.doesUserExist(administrationLogin)) {
                        administrationLogin = "admin";
                    }
                }
                catch (BaseException baseException) {
                    log.warn((Object)("User with username: " + administrationLogin + " does not exist"));
                    administrationLogin = "admin";
                }
                boolean addFileAsNewVer = true;
                if (file.getName().endsWith("eml") || file.getName().endsWith("EML")) {
                    if (additionalOptions.getAddFileAsNewVerForMail().compareToIgnoreCase("TRUE") != 0) {
                        addFileAsNewVer = false;
                    }
                } else if (additionalOptions.getAddFileAsNewVerForAttachment().compareToIgnoreCase("TRUE") != 0) {
                    addFileAsNewVer = false;
                }
                DocumentClassService documentClassService = (DocumentClassService)SpringContext.getBean(DocumentClassService.class);
                DocumentClass documentClass = documentClassService.getDocumentClass(archiveClass, new String[0]);
                String archiveClassId = documentClass.getId().toString();
                newlyAddedFileId = AddAttachmentsToArchiveAction.addToArchive(archiveClassId, file, allIndexes.toArray(), addFileAsNewVer, administrationLogin, archiveFileName, seenAttachment, additionalOptions, addResult);
            } else {
                newlyAddedFileId = "-2";
                addResult.setMsgStatus(MsgStatus.CUSTOM_ANALYZING_INTERRUPTION);
            }
            AddAttachmentsToArchiveAction.controlTemporaryFileExistence(file, additionalOptions);
        }
        catch (IndexesMappingException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return newlyAddedFileId;
    }

    public static void controlTemporaryFileExistence(File file, AdditionalOptions additionalOptions) {
        try {
            log.info((Object)("Weryfikacja istnienia pliku tymczasowego: " + file.getAbsolutePath()));
            if (additionalOptions.getDeleteTemporaryFile() != null && additionalOptions.getDeleteTemporaryFile().compareToIgnoreCase("TRUE") == 0) {
                log.info((Object)("Proba usuniecia pliku tymczasowego: " + file.getAbsolutePath()));
                boolean bDeleted = file.delete();
                if (bDeleted) {
                    log.info((Object)"Plik tymczasowy usuniety");
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected static File save(String fileName, byte[] fileBytes, AdditionalOptions additionalOptions) {
        log.trace((Object)("******************** Save(fileName=" + fileName + ", InputStream, AdditionalOptions) ********************"));
        String sFullDirPath = "";
        try {
            if (fileName != null && fileBytes != null && fileBytes.length > 0) {
                fileName = PlusEFakturaTools.convertBackslashesToSlashes(fileName);
                fileName = fileName.replaceAll("[/]", "_");
                fileName = fileName.replaceAll(":", "_");
                fileName = fileName.replaceAll("[*]", "_");
                fileName = fileName.replaceAll("[?]", "_");
                fileName = fileName.replaceAll("<", "_");
                fileName = fileName.replaceAll(">", "_");
                fileName = fileName.replaceAll("[|]", "_");
                fileName = fileName.replaceAll("\"", "_");
                fileName = fileName.replaceAll("\t", " ");
                fileName = fileName.replaceAll("\n", " ");
                fileName = fileName.replaceAll("\r", "");
                fileName = fileName.replaceAll("'", "_");
                fileName = MimeUtility.decodeText((String)fileName);
                sFullDirPath = additionalOptions.getDirPathForTempFile();
                if ((sFullDirPath = PlusEFakturaTools.convertBackslashesToSlashes(sFullDirPath)).endsWith("/")) {
                    sFullDirPath = sFullDirPath.substring(0, sFullDirPath.length() - 1);
                }
                log.info((Object)("Sciezka do pliku tymczasowego: " + sFullDirPath));
                String[] sExt = fileName.split("[.]");
                File uploadedDir = new File(sFullDirPath);
                if (sExt.length > 1) {
                    File uploadedFile = AddAttachmentsToArchiveAction.copyBitstreamToFile(uploadedDir, fileName, fileBytes, additionalOptions);
                    return uploadedFile;
                }
                log.info((Object)"Zalacznik o nieznanym rozszerzeniu");
                File uploadedFile = AddAttachmentsToArchiveAction.copyBitstreamToFile(uploadedDir, fileName, fileBytes, additionalOptions);
                return uploadedFile;
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File copyBitstreamToFile(File uploadedDir, String fileName, byte[] fileBytes, AdditionalOptions additionalOptions) {
        log.trace((Object)("******************** CopyBitstreamToFile(File, fileName=" + fileName + ", InputStream, AdditionalOptions) ********************"));
        FileOutputStream outputStream = null;
        try {
            File uploadedFile = null;
            try {
                uploadedFile = AddAttachmentsToArchiveAction.createUploadedFile(uploadedDir, fileName);
            }
            catch (IOException exception) {
                log.warn((Object)"Nie udalo sie utworzyc pliku tymczasowego, usuwanie znakow specjalnych z nazwy zalacznika");
                uploadedFile = AddAttachmentsToArchiveAction.createUploadedFile(uploadedDir, fileName.replaceAll("[^a-zA-Z0-9\\s_.]+", ""));
            }
            outputStream = new FileOutputStream(uploadedFile);
            IOUtils.write((byte[])fileBytes, (OutputStream)outputStream);
            log.info((Object)"Zapis pliku tymczasowego zakonczony powodzeniem");
            File file = uploadedFile;
            IOUtils.closeQuietly((OutputStream)outputStream);
            return file;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            File file = null;
            return file;
        }
        finally {
            IOUtils.closeQuietly(outputStream);
        }
    }

    private static File createUploadedFile(File uploadedDir, String fileName) throws IOException {
        log.trace((Object)("******************** createUploadedFile(File, fileName=" + fileName + ") ********************"));
        File uploadedFile = new File(uploadedDir + "/" + fileName);
        log.info((Object)("Sciezka utworzonego pliku tymczasowego: " + uploadedFile.toString()));
        if (uploadedFile.exists()) {
            uploadedFile.delete();
        }
        uploadedFile.createNewFile();
        return uploadedFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String addToArchive(String docClassId, File file, Object[] asIndexes, boolean asNewVersionIfPossible, String administrationLogin, String archiveFileName, SeenAttachment seenAttachment, AdditionalOptions additionalOptions, AddResult addResult) throws IndexesMappingException {
        log.trace((Object)("****************** SaveIndexesToAddedFile(docClassId=" + docClassId + ", File, Object[], asNewVersionIfPossible=" + String.valueOf(asNewVersionIfPossible) + ", administrationLogin, seenAttachment, AdditionalOptions, AddResult) ******************"));
        ArrayList<String> indexMappingsWithNames = new ArrayList<String>();
        try {
            String indexValue;
            String dbName = HibernateUtil.getDatabaseVendor().name();
            String[] asIndicies = new String[asIndexes.length];
            for (int i = 0; i < asIndicies.length; ++i) {
                asIndicies[i] = asIndexes[i].toString();
                log.info((Object)("Mapowanie indeksu [" + i + "]:" + asIndicies[i]));
            }
            DocumentClassService documentClassService = (DocumentClassService)SpringContext.getBean(DocumentClassService.class);
            DocumentClass documentClass = (DocumentClass)documentClassService.get((Serializable)Long.valueOf(docClassId));
            HashMap<Long, Object> indexes = new HashMap<Long, Object>();
            for (int i = 0; i < asIndicies.length; ++i) {
                String actualIndexName = "";
                try {
                    String indexName;
                    String sIndex = asIndicies[i];
                    String[] sSet = sIndex.split(";");
                    IndexTable index = DBManagement.getIndex((String)sSet[0]);
                    actualIndexName = indexName = index.getIndexName();
                    indexValue = AddAttachmentsToArchiveAction.buildIndexValue(sSet);
                    if (index.getIndexType().compareToIgnoreCase("integer") == 0) {
                        Long LValue = null;
                        if (sSet.length == 1) {
                            LValue = new Long(0L);
                            indexMappingsWithNames.add(indexName + ": " + String.valueOf(LValue));
                        } else {
                            LValue = new Long(indexValue);
                            indexMappingsWithNames.add(indexName + ": " + indexValue);
                        }
                        indexes.put(Long.valueOf(sSet[0]), LValue);
                        continue;
                    }
                    if (index.getIndexType().compareToIgnoreCase("float") == 0) {
                        Double dValue = null;
                        if (sSet.length == 1) {
                            dValue = new Double(0.0);
                            indexMappingsWithNames.add(indexName + ": " + String.valueOf(dValue));
                        } else {
                            String sVariableValue = indexValue.replaceAll("[\\\\]", "");
                            sVariableValue = sVariableValue.replaceAll("[ ]", "");
                            sVariableValue = sVariableValue.replaceAll("[,]", ".");
                            int lastDotPos = sVariableValue.lastIndexOf(".");
                            int dotPos = sVariableValue.indexOf(".", 0);
                            while (dotPos != -1 && dotPos != lastDotPos) {
                                sVariableValue = sVariableValue.replaceFirst("[.]", "");
                                dotPos = sVariableValue.indexOf(".", dotPos);
                                lastDotPos = sVariableValue.lastIndexOf(".");
                            }
                            dValue = new Double(sVariableValue);
                            indexMappingsWithNames.add(indexName + ": " + indexValue);
                        }
                        indexes.put(Long.valueOf(sSet[0]), dValue);
                        continue;
                    }
                    if (index.getIndexType().compareToIgnoreCase("date") == 0) {
                        Date DValue = null;
                        if (sSet.length == 1) {
                            DValue = new Date(0L);
                            indexMappingsWithNames.add(indexName + ": " + String.valueOf(DValue));
                        } else {
                            Date tempDate;
                            SimpleDateFormat formatter;
                            String sDate = indexValue;
                            sDate = sDate.replaceAll("[\\\\]", "/");
                            sDate = sDate.replaceAll("[-]", "/");
                            sDate = sDate.replaceAll("[\u2013]", "/");
                            sDate = sDate.replaceAll("[\u00ad]", "/");
                            if ((sDate = sDate.replaceAll("[.]", "/")).compareTo((formatter = new SimpleDateFormat("dd/MM/yyyy")).format(tempDate = formatter.parse(sDate))) == 0) {
                                formatter = new SimpleDateFormat("yyyy/MM/dd");
                                sDate = formatter.format(tempDate);
                            }
                            long time = Date.parse(sDate);
                            DValue = new Date(time);
                            indexMappingsWithNames.add(indexName + ": " + indexValue);
                        }
                        if (dbName.toLowerCase().contains("oracle")) {
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                            indexes.put(Long.valueOf(sSet[0]), sdf.format(DValue));
                            continue;
                        }
                        indexes.put(Long.valueOf(sSet[0]), DValue);
                        continue;
                    }
                    String sValue = PlusEFakturaTools.joinIndexValue(sSet);
                    sValue = PlusEFakturaTools.truncateIndexValue(sValue);
                    indexes.put(Long.valueOf(sSet[0]), sValue);
                    indexMappingsWithNames.add(indexName + ": " + sValue);
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    log.info((Object)("Blad w mapowaniu indeksu o nazwie " + actualIndexName));
                    addResult.setMsgStatus(MsgStatus.INDEX_MAPPING_EXCEPTION);
                    addResult.addUnmappedIndex(actualIndexName);
                    try {
                        PlusEFakturaTools.handleException(additionalOptions);
                        continue;
                    }
                    catch (IndexesMappingException ime) {
                        throw new IndexesMappingException();
                    }
                }
            }
            String docClassName = documentClass.getName();
            log.info((Object)"Zapisywanie dokumentu w nowej wersji lub zapis indeksow");
            try (FileInputStream inputStream = new FileInputStream(file);){
                DocumentService documentService = ServiceFactory.getDocumentService();
                DocumentDefinition definition = new DocumentDefinition();
                definition.setDocumentClassId(documentClass.getId());
                definition.setDescription(documentClass.getName());
                definition.setFileName(archiveFileName);
                definition.setUserName(administrationLogin);
                definition.setInputStream((InputStream)inputStream);
                definition.setIndexes(indexes);
                definition.setSaveAsNewVersion(asNewVersionIfPossible);
                WfDocument wfDocument = documentService.addDocument(definition);
                if (wfDocument == null) {
                    addResult.setMsgStatus(MsgStatus.INDEXES_SAVE_ERROR);
                    indexValue = "-1";
                    return indexValue;
                }
                try {
                    DocumentClassActionService documentClassActionService = CoreServiceFactory.getDocumentClassActionService();
                    documentClassActionService.executeArchiveActions(wfDocument, DocumentEventTypes.NEW_DOCUMENT_IN_ARCHIVE);
                }
                catch (Exception e) {
                    log.warn((Object)"Blad wykonania akcji na klasie dokumentow. Usuwanie dokumentu z archiwum");
                    documentService.deleteDocument(wfDocument);
                    throw e;
                }
                log.info((Object)("Dokument wraz z indeksami zapisany w archiwum w klasie dokumentow " + docClassName));
                log.info((Object)"INDEKSY:");
                clientLog.info((Object)("Dokument wraz z indeksami zapisany w archiwum w klasie dokumentow " + docClassName));
                clientLog.info((Object)"INDEKSY:");
                for (String oneMapping : indexMappingsWithNames) {
                    log.info((Object)oneMapping);
                    clientLog.info((Object)oneMapping);
                }
                if (seenAttachment != null) {
                    SeenAttachmentService seenAttachmentService = EfakturaSpringContext.getBean(SeenAttachmentService.class);
                    seenAttachmentService.add(seenAttachment);
                }
                String string = String.valueOf(wfDocument.getFile().getId());
                return string;
            }
        }
        catch (IndexesMappingException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            addResult.setMsgStatus(MsgStatus.INDEXES_SAVE_ERROR);
            return "-1";
        }
    }

    private static String buildIndexValue(String[] sSet) {
        ArrayList<String> values = new ArrayList<String>();
        if (sSet.length > 1) {
            for (int i = 1; i < sSet.length; ++i) {
                values.add(sSet[i]);
            }
        }
        return StringUtils.join(values, (String)";");
    }

    private static TemporaryFile createTemporaryFile(String createdExt, String emailAddress, String nameOfTheFile, byte[] fileBytes, AdditionalOptions additionalOptions) {
        EdiToPdfService ediToPdfService;
        Optional<EdiToPdf> ediToPdfOpt;
        if (createdExt.equalsIgnoreCase("edi") && (ediToPdfOpt = (ediToPdfService = EfakturaSpringContext.getBean(EdiToPdfService.class)).findByFromEmail(emailAddress)).isPresent()) {
            EdiToPdf ediToPdf = ediToPdfOpt.get();
            File file = AddAttachmentsToArchiveAction.convertEdiToPdf(fileBytes, ediToPdf, additionalOptions);
            return AddAttachmentsToArchiveAction.buildTemporaryFile(file, "pdf");
        }
        File file = AddAttachmentsToArchiveAction.save(nameOfTheFile, fileBytes, additionalOptions);
        return AddAttachmentsToArchiveAction.buildTemporaryFile(file, createdExt);
    }

    private static File convertEdiToPdf(byte[] fileBytes, EdiToPdf ediToPdf, AdditionalOptions additionalOptions) {
        EdiToPdfConverter ediToPdfConverter = EfakturaSpringContext.getBean(EdiToPdfConverter.class);
        return ediToPdfConverter.convert(fileBytes, ediToPdf, additionalOptions);
    }

    private static TemporaryFile buildTemporaryFile(File file, String extension) {
        TemporaryFile temporaryFile = new TemporaryFile();
        temporaryFile.setFile(file);
        temporaryFile.setExtension(extension);
        return temporaryFile;
    }

    private static String getDocumentClassNameForAttachment(Ini configFile, String fileExtension, AdditionalOptions additionalOptions) {
        String archiveClass = additionalOptions.getDocClassName();
        String differentDocClasses = additionalOptions.getDifferentDocClasses();
        if (StringUtils.isNotBlank((CharSequence)differentDocClasses) && differentDocClasses.equalsIgnoreCase("TRUE") && !fileExtension.equalsIgnoreCase("pdf")) {
            String otherDocClass = configFile.get((Object)"DifferentDocClasses", (Object)fileExtension.toUpperCase());
            if (StringUtils.isNotBlank((CharSequence)otherDocClass)) {
                DocumentClassService documentClassService = (DocumentClassService)SpringContext.getBean(DocumentClassService.class);
                DocumentClass otherDocClassEntity = documentClassService.getDocumentClass(otherDocClass, new String[0]);
                if (otherDocClassEntity != null) {
                    archiveClass = new String(otherDocClass);
                } else {
                    log.warn((Object)("Klasa dokumnetow " + otherDocClass + " nie istnieje w systemie PlusWorkflow. Uzycie klasy dokumentow dla plikow o rozszerzeniu pdf"));
                    clientLog.warn((Object)("Klasa dokumnetow " + otherDocClass + " nie istnieje w systemie PlusWorkflow. Uzycie klasy dokumentow dla plikow o rozszerzeniu pdf"));
                }
            } else {
                log.warn((Object)("Plik konfiguracyjny modulu Plus E-faktura nie okresla klasy dokumentow dla pliku o rozszerzeniu " + fileExtension + " w sekcji DifferentDocClasses. Uzycie klasy dokumentow dla plikow o rozszerzeniu pdf"));
                clientLog.warn((Object)("Plik konfiguracyjny modulu Plus E-faktura nie okresla klasy dokumentow dla pliku o rozszerzeniu " + fileExtension + " w sekcji DifferentDocClasses. Uzycie klasy dokumentow dla plikow o rozszerzeniu pdf"));
            }
        }
        return archiveClass;
    }

    private static String getEmailAddress(Message message, AdditionalOptions additionalOptions) {
        if (StringUtils.equalsIgnoreCase((CharSequence)additionalOptions.getSwapEmailsForTemplateRetrieval(), (CharSequence)"TRUE")) {
            return PlusEFakturaTools.getTo(message);
        }
        return PlusEFakturaTools.getFrom(message, additionalOptions);
    }

    private static boolean shouldResolveSubjectAsIndexes(AdditionalOptions additionalOptions) {
        return StringUtils.equalsIgnoreCase((CharSequence)additionalOptions.getSubjectAsIndexesForAttachment(), (CharSequence)"TRUE") && StringUtils.isNotBlank((CharSequence)additionalOptions.getSubjectAsIndexesDelimiterForAttachment()) && StringUtils.isNotBlank((CharSequence)additionalOptions.getSubjectAsIndexesSequenceForAttachment());
    }

    private static SeenAttachment buildSeenAttachment(String email, String messageUid, String fileName, String fileMd5, Date dateOfRead) {
        SeenAttachment seenAttachment = new SeenAttachment();
        seenAttachment.setEmail(email);
        seenAttachment.setMessageUid(messageUid);
        seenAttachment.setFileName(fileName);
        seenAttachment.setFileMd5(fileMd5);
        seenAttachment.setDateOfRead(dateOfRead);
        return seenAttachment;
    }

    private static byte[] readBytesFromStream(InputStream inputStream, AdditionalOptions additionalOptions) throws IOException {
        byte[] fileBytes = null;
        try {
            log.info((Object)"Rozpoczecie pobierania bajtow danych zalacznika");
            fileBytes = IOUtils.toByteArray((InputStream)inputStream);
            log.info((Object)"Zakonczenie pobierania bajtow danych zalacznika");
        }
        catch (ArrayIndexOutOfBoundsException exception) {
            Workaround.imapMessageNumberOutOfBounds(additionalOptions.getFolder());
            fileBytes = IOUtils.toByteArray((InputStream)inputStream);
            log.info((Object)"Zakonczenie pobierania bajtow danych zalacznika");
        }
        return fileBytes;
    }
}

