/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.web.rest;

import com.suncode.plugin.efaktura.service.editopdf.EdiToPdfService;
import com.suncode.plugin.efaktura.util.DocxToPdfConverterType;
import com.suncode.plugin.efaktura.util.EdiType;
import com.suncode.plugin.efaktura.web.rest.configuration.EdiToPdfEntryDto;
import com.suncode.plugin.efaktura.web.support.dto.EdiToPdfConvertInvoiceDto;
import com.suncode.plugin.efaktura.web.support.dto.EdiToPdfDto;
import com.suncode.plugin.efaktura.web.support.dto.EdiToPdfEmailDto;
import com.suncode.plugin.efaktura.web.support.dto.ManagementDto;
import com.suncode.plugin.efaktura.web.support.dto.TemplateDownloadDto;
import com.suncode.plugin.efaktura.web.support.dto.TranslationDto;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

@Controller
@RequestMapping(value={"/api/editopdf"})
public class EdiToPdfController {
    private static final String HTML_CONTENT_TYPE = "text/html";
    private static final String DOCX_CONTENT_TYPE = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
    private static final String PDF_CONTENT_TYPE = "application/pdf";
    @Autowired
    private EdiToPdfService ediToPdfService;

    @RequestMapping(value={"getTranslations"}, method={RequestMethod.GET})
    @ResponseBody
    public TranslationDto getTranslations() {
        return this.ediToPdfService.getTranslations();
    }

    @RequestMapping(value={"read"}, method={RequestMethod.GET})
    @ResponseBody
    public List<EdiToPdfEmailDto> read(@RequestParam String fromEmails) {
        return this.ediToPdfService.read(fromEmails);
    }

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<EdiToPdfEntryDto> getEdiToPdfConverters(@RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, @RequestParam(defaultValue="emailFrom") String sortBy, @RequestParam(defaultValue="ASC") SortDirection sortDirection) {
        return this.ediToPdfService.getEdiToPdfConverters(start, limit, sortBy, sortDirection);
    }

    @RequestMapping(value={"create"}, method={RequestMethod.POST})
    public ResponseEntity<ManagementDto> create(HttpServletRequest request, EdiToPdfDto ediToPdfDto) {
        String userId = (String)request.getSession(false).getAttribute("username");
        ManagementDto dto = this.ediToPdfService.create(userId, ediToPdfDto);
        return this.buildHtmlResponse(dto);
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public void create(HttpServletRequest request, EdiToPdfConversionFormDto formDto) {
        String userId = (String)request.getSession(false).getAttribute("username");
        EdiToPdfDto ediToPdfDto = new EdiToPdfDto();
        ediToPdfDto.setFromEmail(formDto.getEmailFrom());
        ediToPdfDto.setEdiType(formDto.getEdiType().getName());
        ediToPdfDto.setTemplate(formDto.getTemplateFile());
        ediToPdfDto.setDocxToPdfConverterType(formDto.getDocxToPdfConverterType().getName());
        ediToPdfDto.setDocumentClassName(formDto.getDocumentClassName());
        this.ediToPdfService.create(userId, ediToPdfDto);
    }

    @RequestMapping(value={"update"}, method={RequestMethod.POST})
    public ResponseEntity<ManagementDto> update(HttpServletRequest request, EdiToPdfDto ediToPdfDto) {
        String userId = (String)request.getSession(false).getAttribute("username");
        ManagementDto dto = this.ediToPdfService.update(userId, ediToPdfDto);
        return this.buildHtmlResponse(dto);
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.POST})
    @ResponseBody
    public void update(HttpServletRequest request, @PathVariable long id, EdiToPdfConversionFormDto formDto) {
        String userId = (String)request.getSession(false).getAttribute("username");
        EdiToPdfDto ediToPdfDto = new EdiToPdfDto();
        ediToPdfDto.setConversionId(id);
        ediToPdfDto.setFromEmail(formDto.getEmailFrom());
        ediToPdfDto.setEdiType(formDto.getEdiType().getName());
        ediToPdfDto.setTemplate(formDto.getTemplateFile());
        ediToPdfDto.setDocxToPdfConverterType(formDto.getDocxToPdfConverterType().getName());
        ediToPdfDto.setDocumentClassName(formDto.getDocumentClassName());
        this.ediToPdfService.update(userId, ediToPdfDto);
    }

    @RequestMapping(value={"delete/{conversionId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ManagementDto delete(@PathVariable Long conversionId) {
        return this.ediToPdfService.remove(conversionId);
    }

    @RequestMapping(value={"{conversionId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void deleteConversion(@PathVariable Long conversionId) {
        this.ediToPdfService.remove(conversionId);
    }

    @RequestMapping(value={"downloadTemplate/{conversionId}"}, method={RequestMethod.GET})
    public ResponseEntity<byte[]> downloadTemplate(@PathVariable long conversionId) throws IOException {
        TemplateDownloadDto dto = this.ediToPdfService.download(conversionId);
        byte[] bytes = dto.getBytes();
        HttpHeaders responseHeaders = this.buildHeaders(bytes, DOCX_CONTENT_TYPE, dto.getFileName());
        return new ResponseEntity((Object)bytes, (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    @RequestMapping(value={"convertInvoice"}, method={RequestMethod.POST})
    public ResponseEntity<byte[]> convertInvoice(EdiToPdfConvertInvoiceDto ediToPdfConvertInvoiceDto) throws IOException {
        byte[] bytes = this.ediToPdfService.convertInvoice(ediToPdfConvertInvoiceDto);
        HttpHeaders responseHeaders = this.buildHeaders(bytes, PDF_CONTENT_TYPE, this.buildConvertedInvoceFileName(ediToPdfConvertInvoiceDto.getInvoice()));
        return new ResponseEntity((Object)bytes, (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    private ResponseEntity<ManagementDto> buildHtmlResponse(ManagementDto dto) {
        HttpHeaders responseHeaders = this.buildHeaders(HTML_CONTENT_TYPE);
        return new ResponseEntity((Object)dto, (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    private HttpHeaders buildHeaders(String contentType) {
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.parseMediaType((String)contentType));
        return responseHeaders;
    }

    private String buildConvertedInvoceFileName(CommonsMultipartFile invoice) {
        StringBuilder fileName = new StringBuilder();
        fileName.append(FilenameUtils.getBaseName((String)invoice.getOriginalFilename()));
        fileName.append(".");
        fileName.append("pdf");
        return fileName.toString();
    }

    private HttpHeaders buildHeaders(byte[] bytes, String contentType, String filename) {
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.parseMediaType((String)contentType));
        responseHeaders.setContentLength((long)ArrayUtils.getLength((Object)bytes));
        responseHeaders.setContentDispositionFormData("attachment", filename);
        return responseHeaders;
    }

    public static class EdiToPdfConversionFormDto {
        private String emailFrom;
        private EdiType ediType;
        private CommonsMultipartFile templateFile;
        private DocxToPdfConverterType docxToPdfConverterType;
        private String documentClassName;

        public String getEmailFrom() {
            return this.emailFrom;
        }

        public EdiType getEdiType() {
            return this.ediType;
        }

        public CommonsMultipartFile getTemplateFile() {
            return this.templateFile;
        }

        public DocxToPdfConverterType getDocxToPdfConverterType() {
            return this.docxToPdfConverterType;
        }

        public String getDocumentClassName() {
            return this.documentClassName;
        }

        public void setEmailFrom(String emailFrom) {
            this.emailFrom = emailFrom;
        }

        public void setEdiType(EdiType ediType) {
            this.ediType = ediType;
        }

        public void setTemplateFile(CommonsMultipartFile templateFile) {
            this.templateFile = templateFile;
        }

        public void setDocxToPdfConverterType(DocxToPdfConverterType docxToPdfConverterType) {
            this.docxToPdfConverterType = docxToPdfConverterType;
        }

        public void setDocumentClassName(String documentClassName) {
            this.documentClassName = documentClassName;
        }

        public EdiToPdfConversionFormDto() {
        }

        @ConstructorProperties(value={"emailFrom", "ediType", "templateFile", "docxToPdfConverterType", "documentClassName"})
        public EdiToPdfConversionFormDto(String emailFrom, EdiType ediType, CommonsMultipartFile templateFile, DocxToPdfConverterType docxToPdfConverterType, String documentClassName) {
            this.emailFrom = emailFrom;
            this.ediType = ediType;
            this.templateFile = templateFile;
            this.docxToPdfConverterType = docxToPdfConverterType;
            this.documentClassName = documentClassName;
        }
    }
}

