/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.util.tableindex;

import com.suncode.plugin.efaktura.util.TagElement;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.text.TextPosition;

public class TableIndexResolverPDFTextStripper
extends PDFTextStripper {
    private String startPhrase;
    private String stopPhrase;
    private float xStart;
    private float xStop;
    private float yStart;
    private float yStop;
    private float currentYPos;
    private int mergedLines;
    private int currentlyMergedLines;
    private boolean linesAutodetection;
    private boolean eliminateDuplication;
    private StringBuffer lines;
    private List<String> storage;
    private List<LineText> lineTexts;
    private float yOffset = new Float(5.0f).floatValue();
    private boolean collectLetters;
    private boolean stopPhraseFound;

    public TableIndexResolverPDFTextStripper(TagElement oneTag) throws IOException {
        this.startPhrase = oneTag.getValue();
        this.stopPhrase = oneTag.getLastvalue();
        this.xStart = oneTag.getXStartPos();
        this.xStop = oneTag.getXStopPos();
        this.yStart = new Float(-1.0f).floatValue();
        this.yStop = new Float(-1.0f).floatValue();
        this.mergedLines = oneTag.getMergedLines();
        this.linesAutodetection = oneTag.getMergedLines() == 0;
        this.currentlyMergedLines = 0;
        this.eliminateDuplication = oneTag.isEliminateDuplication();
        this.lines = new StringBuffer("");
        this.storage = new ArrayList<String>();
        this.lineTexts = new ArrayList<LineText>();
        this.collectLetters = false;
        this.stopPhraseFound = false;
    }

    private void populateCharactersPositions(PDDocument pdDoc) throws IOException {
        this.document = pdDoc;
        this.output = new StringWriter();
        this.processPages(this.document.getDocumentCatalog().getPages());
    }

    protected void endPage(PDPage page) throws IOException {
        this.lineTexts = new ArrayList<LineText>();
        if (this.stopPhraseFound) {
            this.stopPhraseFound = false;
            this.collectLetters = false;
        }
        block0: for (List textPositions : this.getCharactersByArticle()) {
            StringBuffer pdfText = new StringBuffer("");
            for (TextPosition textPosition : textPositions) {
                pdfText.append(textPosition.getUnicode());
                if (pdfText.indexOf(this.startPhrase) != -1) {
                    pdfText = new StringBuffer("");
                    this.yStart = textPosition.getY();
                    this.collectLetters = true;
                    if (this.stopPhrase.equalsIgnoreCase("@EOP@")) {
                        this.yStop = 2.1474836E9f;
                        this.stopPhraseFound = true;
                        break block0;
                    }
                }
                if (this.yStart == -1.0f || pdfText.indexOf(this.stopPhrase) == -1) continue;
                this.yStop = textPosition.getY();
                this.stopPhraseFound = true;
                break block0;
            }
        }
        for (List textPositions : this.getCharactersByArticle()) {
            float yLinePos = -1.0f;
            this.currentlyMergedLines = 0;
            this.lines = new StringBuffer("");
            boolean bufferFlushed = true;
            for (TextPosition textPosition : textPositions) {
                float xPos = textPosition.getX();
                this.currentYPos = textPosition.getY();
                if (!bufferFlushed && yLinePos > -1.0f && this.currentYPos > yLinePos) {
                    this.appendLines();
                    bufferFlushed = true;
                }
                if (!this.collectLetters || !(this.currentYPos > this.yStart) || this.yStop != -1.0f && !(this.currentYPos < this.yStop) || !(xPos >= this.xStart) || !(xPos <= this.xStop)) continue;
                yLinePos = new Float(this.currentYPos).floatValue();
                this.lines.append(textPosition.getUnicode());
                bufferFlushed = false;
            }
            this.appendLines();
        }
        if (this.linesAutodetection) {
            this.executeLinesAutodetection();
        }
    }

    private void appendLines() {
        if (this.lines.toString().trim().length() > 0) {
            if (this.linesAutodetection) {
                LineText lineText = new LineText();
                lineText.setLineYPos(Float.valueOf(this.currentYPos));
                lineText.setText(this.lines.toString().trim());
                this.lineTexts.add(lineText);
                this.lines = new StringBuffer("");
            } else {
                ++this.currentlyMergedLines;
                if (this.mergedLines == this.currentlyMergedLines) {
                    this.collect();
                    this.currentlyMergedLines = 0;
                } else {
                    this.lines.append("@PCTMERGEDLINESSEPARATOR@");
                }
            }
        }
    }

    private void executeLinesAutodetection() {
        this.lines = new StringBuffer("");
        for (int i = 0; i < this.lineTexts.size(); ++i) {
            LineText lineText = this.lineTexts.get(i);
            if (i < 2) {
                this.lines.append(lineText.getText());
                this.lines.append("@PCTMERGEDLINESSEPARATOR@");
                continue;
            }
            LineText prevLineText = this.lineTexts.get(i - 1);
            LineText prevPrevLineText = this.lineTexts.get(i - 2);
            if (lineText.getLineYPos().floatValue() - prevLineText.getLineYPos().floatValue() > prevLineText.getLineYPos().floatValue() - prevPrevLineText.getLineYPos().floatValue() + this.yOffset) {
                this.collect();
            }
            this.lines.append(lineText.getText());
            this.lines.append("@PCTMERGEDLINESSEPARATOR@");
        }
        if (this.lines.length() > 0) {
            this.collect();
        }
    }

    private void collect() {
        String value = this.lines.toString().trim().replaceAll("@PCTMERGEDLINESSEPARATOR@", " ");
        if (!this.eliminateDuplication || this.eliminateDuplication && !this.storage.contains(value)) {
            this.storage.add(value);
        }
        this.lines = new StringBuffer("");
    }

    public List<String> getTableIndexValues(PDDocument pdDoc) throws IOException {
        this.populateCharactersPositions(pdDoc);
        return this.storage;
    }

    private class LineText {
        private Float lineYPos;
        private String text;

        private LineText() {
        }

        public Float getLineYPos() {
            return this.lineYPos;
        }

        public void setLineYPos(Float lineYPos) {
            this.lineYPos = lineYPos;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }
    }
}

