/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.service.xml;

import com.suncode.plugin.efaktura.util.ClassLoaderUtils;
import com.suncode.plugin.efaktura.util.exception.PlusEFakturaException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

@Service
public class XmlAnalyzerService {
    public static Logger log = Logger.getLogger(XmlAnalyzerService.class);

    public String convertXMLFileToStringFromFilePath(String filePath) {
        return ClassLoaderUtils.doInContextClassLoader(() -> {
            log.trace((Object)("********** convertXMLFileToStringFromFilePath(filePath=" + filePath + ") **********"));
            String xmlContent = null;
            Document doc = null;
            try {
                doc = this.getXmlFile(filePath);
                xmlContent = this.convertXMLFileToStringFromDocumentObject(doc);
            }
            catch (Exception exception) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
            }
            return xmlContent;
        });
    }

    public Document getXmlFile(String filePath) {
        Document doc = null;
        try {
            File file = new File(filePath);
            if (file == null || !file.exists()) {
                throw new PlusEFakturaException("Plik XML nie istnieje w podanej lokalizacji " + filePath);
            }
            doc = this.getXmlFile(file);
        }
        catch (PlusEFakturaException exception) {
            log.warn((Object)exception.getMessage());
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
        }
        return doc;
    }

    public Document getXmlFile(File file) {
        return ClassLoaderUtils.doInContextClassLoader(() -> {
            log.trace((Object)"********** getXMLFile(file) **********");
            Document doc = null;
            FileInputStream inputStream = null;
            InputStreamReader reader = null;
            InputSource inputSource = null;
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                inputStream = new FileInputStream(file);
                reader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                inputSource = new InputSource(reader);
                documentBuilderFactory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                doc = documentBuilderFactory.newDocumentBuilder().parse(inputSource);
            }
            catch (Exception exception) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Exception exception) {
                    log.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
            return doc;
        });
    }

    private String convertXMLFileToStringFromDocumentObject(Document doc) {
        log.trace((Object)"********** convertXMLFileToStringFromDocumentObject(Document) **********");
        String xmlContent = null;
        try {
            if (doc != null) {
                StringWriter stw = new StringWriter();
                Transformer serializer = TransformerFactory.newInstance().newTransformer();
                serializer.transform(new DOMSource(doc), new StreamResult(stw));
                if (stw != null) {
                    xmlContent = stw.toString();
                }
            }
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
        }
        return xmlContent;
    }

    public Document convertStringToXMLFile(String xmlContent) {
        return ClassLoaderUtils.doInContextClassLoader(() -> {
            log.trace((Object)"********** convertStringToXMLFile(xmlContent) **********");
            Document xmlFile = null;
            try {
                if (StringUtils.isBlank((CharSequence)xmlContent)) {
                    throw new PlusEFakturaException("Zawartosc pliku XML jest pusta lub zostala niepoprawnie pobrana");
                }
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                xmlFile = builder.parse(new InputSource(new StringReader(xmlContent)));
            }
            catch (PlusEFakturaException exception) {
                log.warn((Object)exception.getMessage());
            }
            catch (Exception exception) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
            }
            return xmlFile;
        });
    }

    public InputStream getInputStreamForDocumentObject(Document doc) {
        return ClassLoaderUtils.doInContextClassLoader(() -> {
            log.trace((Object)"********** getInputStreamForDocumentObject(Document doc) **********");
            ByteArrayInputStream inputStream = null;
            try {
                if (doc != null) {
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    DOMSource xmlSource = new DOMSource(doc);
                    StreamResult outputTarget = new StreamResult(outputStream);
                    TransformerFactory.newInstance().newTransformer().transform(xmlSource, outputTarget);
                    inputStream = new ByteArrayInputStream(outputStream.toByteArray());
                }
            }
            catch (Exception exception) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
            }
            return inputStream;
        });
    }

    public void saveXml(Document doc, String filePath) throws TransformerException {
        ClassLoaderUtils.doInContextClassLoader(() -> {
            log.trace((Object)("********** saveXML(Document doc, filePath" + filePath + ") **********"));
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "3");
            DOMSource source = new DOMSource(doc);
            File file = new File(filePath);
            StreamResult result = new StreamResult(file.getAbsolutePath());
            transformer.transform(source, result);
        });
    }
}

