/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.dao.report;

import com.plusmpm.database.hibernate.HibernateUtil;
import com.suncode.plugin.efaktura.dao.EfakturaHibernateEditableDao;
import com.suncode.plugin.efaktura.dao.report.ReportDao;
import com.suncode.plugin.efaktura.model.report.OldReport;
import com.suncode.plugin.efaktura.model.report.Report;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.jdbc.ReturningWork;
import org.springframework.stereotype.Repository;

@Repository
public class ReportDaoImpl
extends EfakturaHibernateEditableDao<Report, Long>
implements ReportDao {
    private static final String OLD_REPORT_TABLE_NAME = "pm_plusefaktura_reports";
    private static final String FIND_ALL_OLD_REPORTS_QUERY = "select supplier, emailid, dateofread, status, forwarded, deleted from pm_plusefaktura_reports";

    @Override
    public List<OldReport> findAllOldReports() {
        if (this.doesOldTableExist()) {
            return (List)this.getSession().doReturningWork((ReturningWork)new ReturningWork<List<OldReport>>(){

                public List<OldReport> execute(Connection connection) throws SQLException {
                    PreparedStatement statement = connection.prepareStatement(ReportDaoImpl.FIND_ALL_OLD_REPORTS_QUERY);
                    ResultSet resultSet = statement.executeQuery();
                    ArrayList<OldReport> oldReports = new ArrayList<OldReport>();
                    while (resultSet.next()) {
                        oldReports.add(ReportDaoImpl.this.buildOldReport(resultSet));
                    }
                    return oldReports;
                }
            });
        }
        return new ArrayList<OldReport>();
    }

    private boolean doesOldTableExist() {
        return HibernateUtil.tableExists((String)OLD_REPORT_TABLE_NAME);
    }

    private OldReport buildOldReport(ResultSet resultSet) throws SQLException {
        OldReport oldReport = new OldReport();
        oldReport.setSupplier(resultSet.getString(1));
        oldReport.setEmailId(resultSet.getString(2));
        oldReport.setDateOfRead(resultSet.getDate(3));
        oldReport.setStatus(resultSet.getString(4));
        oldReport.setForwarded(resultSet.getString(5));
        oldReport.setDeleted(resultSet.getString(6));
        return oldReport;
    }
}

