/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.client.processes.invoices.modules;

import com.plusmpm.CUF.util.extension.DynamicTableFunctions;
import com.suncode.plugin.pzmodule.api.dto.configuration.ConfigurationDto;
import com.suncode.plugin.pzmodule.api.info.SaveInfo;
import com.suncode.plugin.pzmodule.api.record.Record;
import com.suncode.plugin.pzmodule.api.result.CustomSaveResult;
import com.suncode.plugin.pzmodule.api.saver.record.CustomRecordSaver;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserFinder;
import com.suncode.pwfl.search.FilterOperator;
import com.suncode.pwfl.search.sql.SQLBuilder;
import com.suncode.pwfl.search.sql.SQLFilter;
import com.suncode.pwfl.search.sql.SQLFinder;
import com.suncode.pwfl.search.sql.SimpleSQLFilter;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.workflow.activity.ActivityService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.enhydra.shark.api.SharkTransaction;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class ClosePZModule
implements CustomRecordSaver {
    private static Logger log = Logger.getLogger(ClosePZModule.class);
    private static String[] sColIds = new String[]{"nr_ZD_Tabela", "nr_PZ_Tabela", "nr_mpk", "id_wiersza_pz", "opis", "lzs", "ilosc", "jm", "cena_jedn_waluta", "procent", "czastk_kwota_netto", "nr_zapasu", "wpisujacy_pozycje", "asortyment", "nr_PAK", "kod_przeznaczenia"};

    public CustomSaveResult save(SharkTransaction st, ConfigurationDto conf, SaveInfo info, List<Record> records) {
        log.debug((Object)"*** ClosePZModule ***");
        CustomSaveResult customSaveResult = new CustomSaveResult();
        customSaveResult.setSuccess(true);
        String activityId = info.getActivityId();
        String processId = info.getProcessId();
        List<Map<String, String>> dataToSaveInProcess = this.getSupplyData(records, processId, activityId);
        Map<String, Object> valuesToSave = this.convertToMap(dataToSaveInProcess);
        if (!activityId.contains("wyjasnienie_rozbieznosci") && !activityId.contains("akceptacja_ksiegowa_faktur_magazynowychuslugowych")) {
            String firstPurchaser = "";
            if (records.size() > 0) {
                firstPurchaser = records.get(0).getValue("tworca_zamowienia");
            }
            valuesToSave.putAll(this.getAssignmentsOfDivergence(firstPurchaser));
        }
        this.saveInProcess(valuesToSave, processId, activityId);
        return customSaveResult;
    }

    private void saveInProcess(Map<String, Object> dataToSave, String processId, String activityId) {
        log.debug((Object)"Zapisuj\u0119 dane z modu\u0142u PZ w activityContext");
        ActivityService activityService = ServiceFactory.getActivityService();
        Map mActivityContext = activityService.getActivityContext(processId, activityId);
        mActivityContext.putAll(dataToSave);
        activityService.setActivityContext(processId, activityId, mActivityContext);
    }

    private Map<String, Object> convertToMap(List<Map<String, String>> dataToSaveInProcess) {
        log.trace((Object)"Konwertuj\u0119 list\u0119 map na map\u0119");
        Map valuesToSave = DynamicTableFunctions.convertFromListOfMapsToMap(dataToSaveInProcess, (String[])sColIds);
        return valuesToSave;
    }

    private List<Map<String, String>> getSupplyData(List<Record> records, String processId, String activityId) {
        log.debug((Object)"Ustalam dane tabeli z pod\u0142\u0105czonymi PZ");
        ActivityService activityService = ServiceFactory.getActivityService();
        Map mActivityContext = activityService.getActivityContext(processId, activityId);
        double netAmount = (Double)mActivityContext.get("kwota_netto_waluta");
        String userid = (String)activityService.getAssignments(processId, activityId).get(0);
        String userNameAbreviation = this.getUserNameAbreviation(userid);
        if (StringUtils.isBlank((CharSequence)userNameAbreviation)) {
            userNameAbreviation = "";
        }
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        String sPartialNetAmount = "";
        double percent = 0.0;
        for (Map map : records) {
            sPartialNetAmount = (String)map.get("wartosc");
            percent = this.divide(this.multiply(Double.valueOf(sPartialNetAmount), 100.0, 2), netAmount, 2);
            HashMap<String, String> newRecord = new HashMap<String, String>();
            newRecord.put("nr_ZD_Tabela", (String)map.get("nr_zamowienia"));
            newRecord.put("nr_PZ_Tabela", (String)map.get("nr_pz_pu"));
            newRecord.put("opis", (String)map.get("nazwa_pozycji"));
            newRecord.put("lzs", (String)map.get("lzs"));
            newRecord.put("nr_mpk", (String)map.get("mpk"));
            newRecord.put("id_wiersza_pz", (String)map.get("id_wiersza_pz"));
            newRecord.put("ilosc", (String)map.get("ilosc"));
            newRecord.put("jm", (String)map.get("jednostka"));
            newRecord.put("cena_jedn_waluta", (String)map.get("cena_jednostkowa"));
            newRecord.put("czastk_kwota_netto", sPartialNetAmount);
            newRecord.put("procent", String.valueOf(percent));
            newRecord.put("nr_zapasu", (String)map.get("nr_zapasu"));
            if (StringUtils.isBlank((CharSequence)((CharSequence)map.get("wpisujacy_pozycje")))) {
                newRecord.put("wpisujacy_pozycje", userNameAbreviation);
            } else {
                newRecord.put("wpisujacy_pozycje", (String)map.get("wpisujacy_pozycje"));
            }
            newRecord.put("asortyment", "");
            newRecord.put("nr_PAK", "");
            newRecord.put("kod_przeznaczenia", "");
            result.add(newRecord);
        }
        List previousData = DynamicTableFunctions.convertFromMapToListOfMaps((Map)mActivityContext, (String[])sColIds);
        for (Map oneMap : previousData) {
            if (!StringUtils.isNotBlank((CharSequence)((CharSequence)oneMap.get("nr_zapasu"))) || ((String)oneMap.get("nr_zapasu")).compareToIgnoreCase("Koszty dodatkowe") != 0 && ((String)oneMap.get("nr_zapasu")).compareToIgnoreCase("Odchylenie") != 0) continue;
            sPartialNetAmount = (String)oneMap.get("czastk_kwota_netto");
            percent = this.divide(this.multiply(Double.valueOf(sPartialNetAmount), 100.0, 2), netAmount, 2);
            oneMap.put("czastk_kwota_netto", String.valueOf(sPartialNetAmount));
            result.add(oneMap);
        }
        return result;
    }

    private Map<String, Object> getAssignmentsOfDivergence(String purchaser) {
        log.debug((Object)("Ustalam osoby odpowiedzialne za wyja\u015bnienie i akceptacj\u0119 rozbie\u017cno\u015bci. Loginy pobierane s\u0105 na podstawie loginu osoby zamawiaj\u0105cej: " + purchaser));
        SQLFinder finder = FinderFactory.getSQLFinder();
        SQLBuilder builder = new SQLBuilder();
        builder = new SQLBuilder();
        builder.setQuery("select osoba_wyjasniajaca, osoba_zatwierdzajaca from pm_cust_przypisanie_rozbieznosci_pz");
        builder.addScalar("osoba_wyjasniajaca", (Type)StandardBasicTypes.STRING);
        builder.addScalar("osoba_zatwierdzajaca", (Type)StandardBasicTypes.STRING);
        builder.addFilter((SQLFilter)new SimpleSQLFilter("osoba_zamawiajaca", (Object)purchaser, FilterOperator.EQ));
        List data = finder.find(builder);
        data = finder.find(builder);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!data.isEmpty()) {
            map.put("osoba_wyjasniajaca_rozb", (String)((Map)data.get(0)).get("osoba_wyjasniajaca"));
            map.put("akceptujacy_rozbieznosc", (String)((Map)data.get(0)).get("osoba_zatwierdzajaca"));
        }
        return map;
    }

    private String getUserNameAbreviation(String userid) {
        log.debug((Object)("Ustalam inicja\u0142y u\u017cytkownika o loginie: " + userid));
        UserFinder userFinder = FinderFactory.getUserFinder();
        User user = userFinder.findByUserName(userid, new String[0]);
        StringBuilder sb = new StringBuilder();
        sb.append(user.getFirstName().substring(0, 1));
        sb.append(user.getLastName().substring(0, 1));
        sb.append(user.getLastName().substring(1, 2));
        sb.append(user.getLastName().substring(2, 3));
        return sb.toString().toUpperCase();
    }

    private double divide(double dDividend, double dDivisor, int iAccuracy) {
        return BigDecimal.valueOf(dDividend).setScale(iAccuracy).divide(BigDecimal.valueOf(dDivisor), 4).setScale(iAccuracy).doubleValue();
    }

    private double multiply(double dFactor1, double dFactor2, int iAccuracy) {
        return BigDecimal.valueOf(dFactor1).multiply(BigDecimal.valueOf(dFactor2)).setScale(iAccuracy, 4).doubleValue();
    }
}

