/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.client.processes.delegations.automatictasks;

import java.io.DataInputStream;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class DelegationTools {
    private static Logger log = Logger.getLogger(DelegationTools.class);
    private static Map<String, Map<String, String>> rates = new HashMap<String, Map<String, String>>();

    public static Double getCurrencyRateFromNbp(String currency, String currencyDate) {
        SimpleDateFormat workflowDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat nbpDateFormat = new SimpleDateFormat("dd-MM-yyyy");
        SimpleDateFormat nbpListDateFormat = new SimpleDateFormat("yyMMdd");
        Double kurs = null;
        if (currency.compareTo("PLN") != 0) {
            String currencyRate;
            Map<String, String> dailyRates = rates.get(currencyDate);
            if (dailyRates != null && (currencyRate = dailyRates.get(currency)) != null && currencyRate.compareTo("null") != 0) {
                log.debug((Object)("Kurs pobrany z mapy:" + currencyRate));
                kurs = Double.valueOf(currencyRate.replace(",", "."));
            }
            if (kurs == null) {
                ArrayList<String> lista_xml = new ArrayList<String>();
                try {
                    String thisLine;
                    String nbpCurrencyDate = nbpDateFormat.format(workflowDateFormat.parse(currencyDate));
                    URL u = new URL("https://static.nbp.pl/dane/kursy/xml/dir.txt");
                    log.debug((Object)u.toString());
                    DataInputStream theHTML = new DataInputStream(u.openStream());
                    while ((thisLine = theHTML.readLine()) != null) {
                        int test;
                        if (StringUtils.isBlank((CharSequence)thisLine.trim()) || (test = thisLine.substring(0, 1).compareTo("a")) != 0) continue;
                        lista_xml.add(thisLine);
                    }
                    log.debug((Object)"Zakonczenie pobierania listy XML z NBP");
                }
                catch (Exception e) {
                    log.error((Object)("B\u0142\u0105d podczas pobierania listy XML z NBP" + e.getMessage()), (Throwable)e);
                }
                HashMap data_waluta_kurs = new HashMap();
                if (lista_xml.size() != 0) {
                    try {
                        Object url = "https://static.nbp.pl/dane/kursy/xml/";
                        boolean nieznaleziono = true;
                        Calendar cal = Calendar.getInstance();
                        cal.setTime(workflowDateFormat.parse(currencyDate));
                        cal.add(5, -1);
                        String szukana_data = nbpListDateFormat.format(cal.getTime());
                        String data_ustalenia_kursu = workflowDateFormat.format(cal.getTime());
                        while (nieznaleziono) {
                            int a = lista_xml.size();
                            for (int i = 0; i < lista_xml.size(); ++i) {
                                if (((String)lista_xml.get(i)).toString().indexOf(szukana_data) != -1) {
                                    url = (String)url + (String)lista_xml.get(i) + ".xml";
                                    nieznaleziono = false;
                                    break;
                                }
                                if (i == lista_xml.size() - 1) break;
                            }
                            if (!nieznaleziono) break;
                            cal.add(5, -1);
                            szukana_data = nbpListDateFormat.format(cal.getTime());
                            log.debug((Object)("Szukana data w pliku NBP: " + szukana_data));
                            data_ustalenia_kursu = workflowDateFormat.format(cal.getTime());
                        }
                        if (!nieznaleziono) {
                            String kurs_sprzedazy = "";
                            String przelicznik = "";
                            try {
                                String thisLine;
                                URL u = new URL((String)url);
                                DataInputStream theHTML = new DataInputStream(u.openStream());
                                String szukana_linia = "<kod_waluty>" + currency + "</kod_waluty>";
                                while ((thisLine = theHTML.readLine()) != null) {
                                    if (thisLine.toString().indexOf("<przelicznik>") != -1) {
                                        przelicznik = thisLine.replace("</przelicznik>", "");
                                        przelicznik = przelicznik.replace("<przelicznik>", "");
                                        przelicznik = przelicznik.trim();
                                        przelicznik = przelicznik.replace(",", ".");
                                    }
                                    if (thisLine.toString().indexOf(szukana_linia) == -1) continue;
                                    thisLine = theHTML.readLine();
                                    kurs_sprzedazy = thisLine.replace("</kurs_sredni>", "");
                                    kurs_sprzedazy = kurs_sprzedazy.replace("<kurs_sredni>", "");
                                    kurs_sprzedazy = kurs_sprzedazy.trim();
                                    kurs_sprzedazy = kurs_sprzedazy.replace(",", ".");
                                    break;
                                }
                                if (kurs_sprzedazy.compareTo("") != 0 && przelicznik.compareTo("") != 0) {
                                    kurs = Double.valueOf(kurs_sprzedazy) / Double.valueOf(przelicznik);
                                }
                                log.debug((Object)("Zakonczenie pobierania kursu " + currency + " z dnia " + currencyDate + "(" + data_ustalenia_kursu + ")"));
                            }
                            catch (Exception e) {
                                log.error((Object)("B\u0142\u0105d podczas pobierania kursu " + currency + " z NBP"));
                            }
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
            try {
                Date dCurrentDate = new Date();
                Date dCurrencyDate = workflowDateFormat.parse(currencyDate);
                if (dCurrencyDate.getTime() <= dCurrentDate.getTime()) {
                    if (dailyRates == null) {
                        dailyRates = new HashMap<String, String>();
                    }
                    DecimalFormat formatter = new DecimalFormat("#.####");
                    if (kurs != null) {
                        dailyRates.put(currency, formatter.format(kurs));
                        rates.put(currencyDate, dailyRates);
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            kurs = 1.0;
        }
        return kurs;
    }

    public static String changeDoubleFormat4(String sIn) {
        if (!StringUtils.isBlank((CharSequence)sIn)) {
            DecimalFormat twoDForm = new DecimalFormat("# ###.##;-# ###.##");
            twoDForm.setMinimumFractionDigits(4);
            twoDForm.setGroupingUsed(true);
            twoDForm.setGroupingSize(3);
            DecimalFormatSymbols symbols = twoDForm.getDecimalFormatSymbols();
            symbols.setGroupingSeparator(' ');
            symbols.setDecimalSeparator('.');
            twoDForm.setDecimalFormatSymbols(symbols);
            String[] sAmount = ((String)sIn).split(";");
            sIn = "";
            for (String amount : sAmount) {
                double tmp;
                if (amount.compareToIgnoreCase("") != 0) {
                    tmp = Double.valueOf(amount);
                    sIn = (String)sIn + twoDForm.format(tmp) + ";";
                    continue;
                }
                tmp = 0.0;
                sIn = (String)sIn + twoDForm.format(tmp) + ";";
            }
            sIn = ((String)sIn).substring(0, ((String)sIn).length() - 1);
        }
        return sIn;
    }
}

