/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.setters;

import com.suncode.plugin.categories.Categories;
import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.structure.StructureService;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.workflow.form.variablesetter.VariableSetterDefinitionBuilder;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

@VariableSetter
public class FinalApproverSetter {
    public static Logger log = Logger.getLogger(FinalApproverSetter.class);
    private static final String FINAL_APPROVER_PREFIX = "zar";

    @Define
    public void definition(VariableSetterDefinitionBuilder builder) {
        ((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)builder.id("Final approver setter")).name("Ustawienie akceptuj\u0105cego ko\u0144cowo")).description("")).category(new Category[]{Categories.DTW})).parameter().id("userLogin").name("Login u\u017cytkownika").description("").type((Type)Types.STRING).create()).parameter().id("executingUsers").name("Realizuj\u0105cy").description("").type((Type)Types.STRING).create()).parameter().id("finalApprover").name("Akceptuj\u0105cy ko\u0144cowo").description("").type((Type)Types.VARIABLE).create();
    }

    public void set(@Param(value="userLogin") String userLogin, @Param(value="executingUsers") String executingUsers, @Param(value="finalApprover") Variable finalApprover) {
        String[] tExecuting = executingUsers.split(";", -1);
        String supervisor = FinalApproverSetter.getFinalSupervisor(userLogin, tExecuting);
        finalApprover.setValue((Object)supervisor);
    }

    private static String getFinalSupervisor(String userLogin, String[] executingUsers) {
        Set pos;
        String result = "";
        UserService us = ServiceFactory.getUserService();
        StructureService ss = ServiceFactory.getStructureService();
        for (String usr : executingUsers) {
            if (StringUtils.isBlank((CharSequence)usr) || userLogin.equalsIgnoreCase(usr)) continue;
            User user = us.getUser(usr, new String[]{"positions"});
            pos = user.getPositions();
            for (Position p : pos) {
                if (!p.getSymbol().toLowerCase().startsWith(FINAL_APPROVER_PREFIX)) continue;
                return result;
            }
        }
        User user = us.getUser(userLogin, new String[]{"positions"});
        pos = user.getPositions();
        Position supervisorPos = null;
        User supervisor = null;
        for (Position p : pos) {
            supervisorPos = ss.getPosition(p.getHigherPosition().getId(), new String[]{"user"});
        }
        if (supervisorPos != null && (supervisor = supervisorPos.getUser()) != null) {
            log.debug((Object)supervisorPos.getSymbol());
            result = supervisorPos.getSymbol().toLowerCase().startsWith(FINAL_APPROVER_PREFIX) ? supervisor.getUserName() : FinalApproverSetter.getFinalSupervisor(supervisor.getUserName(), executingUsers);
        }
        log.debug((Object)("Found final supervisor: " + result));
        return result;
    }
}

