/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.scheduletask;

import com.suncode.dbexplorer.DatabaseExplorer;
import com.suncode.dbexplorer.database.Database;
import com.suncode.dbexplorer.database.DatabaseSession;
import com.suncode.dbexplorer.database.Record;
import com.suncode.dbexplorer.database.SessionUnit;
import com.suncode.dbexplorer.database.query.Condition;
import com.suncode.dbexplorer.database.query.Conditions;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.search.sql.SQLBuilder;
import com.suncode.pwfl.search.sql.SQLFinder;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.activity.util.AcceptationDefinition;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;

@ScheduledTask
public class GetContractorNumberScheduledTask {
    public static Logger log = Logger.getLogger(GetContractorNumberScheduledTask.class);
    @Autowired
    DatabaseExplorer databaseExplorer;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("get-contractor-number")).name("get-contractor-number.name")).description("get-contractor-number.desc")).cancelable();
    }

    public void execute() throws Exception {
        final Database database = this.databaseExplorer.get("QUALIAC");
        database.withinSession((SessionUnit)new SessionUnit<Void>(){

            public Void doWork(DatabaseSession arg0) throws Exception {
                ActivityService activityService = ServiceFactory.getActivityService();
                String query = "select activities.id as activity_id, activities.processid as process_id from activities where process in (select objectid from processes where description = 'Proces zak\u0142adanie kontrahent\u00f3w') and activitydefinitionid = 'oczekiwanie_na_numer_kontrahenta_z_systemu_qualiac' and state in (select objectid from activitystates where keyvalue = 'open.running' OR keyvalue = 'open.not_running.not_started' OR keyvalue = 'open.not_running.suspended')";
                SQLFinder sqlFinder = FinderFactory.getSQLFinder();
                SQLBuilder builder = new SQLBuilder();
                builder.setQuery(query);
                builder.addScalar("activity_id", (Type)StandardBasicTypes.STRING);
                builder.addScalar("process_id", (Type)StandardBasicTypes.STRING);
                List data = sqlFinder.find(builder);
                for (Map oneActivity : data) {
                    Map activityContextMap = activityService.getActivityContext(oneActivity.get("process_id").toString(), oneActivity.get("activity_id").toString());
                    final String idWniosku = activityContextMap.get("id_wniosku").toString();
                    List records = (List)database.withinSession((SessionUnit)new SessionUnit<List<Record>>(){

                        public List<Record> doWork(DatabaseSession session) throws Exception {
                            Condition condition = Conditions.eq((String)"WNIOSEK", (Object)idWniosku);
                            return session.select().from("KOD_KONTRAHENTA").where(condition).list();
                        }
                    });
                    if (records.size() <= 0) continue;
                    String kod = ((Record)records.get(0)).get("KOD").toString();
                    log.debug((Object)("KOD: " + kod));
                    activityContextMap.put("nr_kontrahenta", kod);
                    String executor = "admin";
                    String actionName = "";
                    AcceptationDefinition acceptation = new AcceptationDefinition(oneActivity.get("process_id").toString(), oneActivity.get("activity_id").toString(), executor, actionName);
                    acceptation.setIgnoreOwnerShip(Boolean.valueOf(true));
                    acceptation.setContextMap(activityContextMap);
                    activityService.acceptActivity(acceptation);
                }
                return null;
            }
        });
    }
}

