/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.application;

import com.suncode.dbexplorer.DatabaseExplorer;
import com.suncode.dbexplorer.database.Database;
import com.suncode.dbexplorer.database.DatabaseSession;
import com.suncode.dbexplorer.database.Record;
import com.suncode.dbexplorer.database.SessionUnit;
import com.suncode.plugin.categories.Categories;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.database.sequence.SequenceService;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.process.Comment;
import com.suncode.pwfl.workflow.process.CommentService;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@Application
public class ExportDataPZK {
    public static Logger log = Logger.getLogger(ExportDataPZK.class);
    @Autowired
    DatabaseExplorer databaseExplorer;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("dss-pzk-export-data")).name("dss-pzk-export-data.name")).description("dss-pzk-export-data.desc")).category(new Category[]{Categories.CUSTOM_DSS})).icon((Icon)SilkIconPack.DATABASE)).parameter().id("dbName").name("dss-pzk-export-data.dbName.name").type((Type)Types.STRING).create()).parameter();
    }

    public void execute(ApplicationContext applicationContext, final ActivityContextMap activityContext, @Param String dbName) throws Exception {
        final HashMap rowOette = new HashMap();
        final HashMap rowOettd = new HashMap();
        final HashMap rowOetta = new HashMap();
        final HashMap rowOeatt = new HashMap();
        final Database database = this.databaseExplorer.get("QUALIAC");
        database.withinSession((SessionUnit)new SessionUnit<Void>(){

            public Void doWork(DatabaseSession session) throws Exception {
                Connection connection = null;
                try {
                    String kod_kraju;
                    connection = session.getConnection();
                    connection.setAutoCommit(false);
                    ActivityService activityService = ServiceFactory.getActivityService();
                    Map activityContextMap = activityService.getActivityContext(activityContext.getProcessId(), activityContext.getActivityId());
                    String typOperacji = activityContextMap.get("typ_operacji").toString();
                    String relacjaBiznesowa = activityContextMap.get("relacja_biznesowa").toString();
                    String rodzajPodmiotu = activityContextMap.get("rodzaj_podmiotu").toString();
                    log.debug((Object)("typ_operacji: " + typOperacji));
                    log.debug((Object)("relacja_biznesowa: " + relacjaBiznesowa));
                    String kod_kraju_nip = activityContextMap.get("kod_kraju_nip").toString();
                    String nr_kontrahenta = "";
                    if (typOperacji.compareTo("Nowy kontrahent") == 0) {
                        nr_kontrahenta = ExportDataPZK.this.getNewNumoette(database);
                    }
                    if (typOperacji.compareTo("Modyfikacja") == 0) {
                        nr_kontrahenta = activityContextMap.get("nr_kontrahenta").toString();
                    }
                    log.debug((Object)("-------NUMOETTE nr_kontrahenta: " + nr_kontrahenta));
                    Date actualDate = new Date();
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
                    String today = formatter.format(actualDate);
                    log.debug((Object)"-------OETTE - MPM.Dane_Kontrahenta");
                    rowOette.put("NOMOETTE", activityContextMap.get("nazwa_kontrahenta").toString());
                    rowOette.put("NUMOETTE", nr_kontrahenta);
                    rowOette.put("NOROETTE", activityContextMap.get("nazwa_skrocona").toString());
                    rowOette.put("ISOOETTE", kod_kraju_nip);
                    rowOette.put("CEEOETTE", activityContextMap.get("nip").toString());
                    String status = "A";
                    if (activityContextMap.containsKey("status") && !activityContextMap.get("status").toString().isEmpty()) {
                        status = activityContextMap.get("status").toString().compareToIgnoreCase("Bierny") == 0 ? "I" : "A";
                    }
                    rowOette.put("ETAOETTE", status);
                    String typ_rozrachunkowy = "";
                    if (activityContextMap.containsKey("typ_rozrachunkowy") && !StringUtils.isEmpty(activityContextMap.get("typ_rozrachunkowy"))) {
                        typ_rozrachunkowy = activityContextMap.get("typ_rozrachunkowy").toString();
                    } else if (relacjaBiznesowa.compareTo("Dostawca") == 0 && rodzajPodmiotu.compareTo("Zewn\u0119trzny") == 0) {
                        typ_rozrachunkowy = "D";
                    } else if (relacjaBiznesowa.compareTo("Dostawca") == 0 && rodzajPodmiotu.compareTo("Powi\u0105zany") == 0) {
                        typ_rozrachunkowy = "G";
                    } else if (relacjaBiznesowa.compareTo("Klient") == 0 && rodzajPodmiotu.compareTo("Zewn\u0119trzny") == 0) {
                        typ_rozrachunkowy = "K";
                    } else if (relacjaBiznesowa.compareTo("Klient") == 0 && rodzajPodmiotu.compareTo("Powi\u0105zany") == 0) {
                        typ_rozrachunkowy = "L";
                    } else if (relacjaBiznesowa.compareTo("Dostawca got\u00f3wkowy") == 0) {
                        typ_rozrachunkowy = "D";
                    } else if (relacjaBiznesowa.compareTo("Klient internetowy") == 0) {
                        typ_rozrachunkowy = "K";
                    } else if (relacjaBiznesowa.compareTo("Pracownik") == 0) {
                        typ_rozrachunkowy = "P";
                    }
                    rowOette.put("DEVOETTE", activityContextMap.get("waluta_fakturowania").toString());
                    rowOette.put("GESOETTE", activityContextMap.get("administrator").toString());
                    String ucroette = "WORKFLOW";
                    if (activityContextMap.containsKey("ucroette") && !activityContextMap.get("ucroette").toString().isEmpty()) {
                        ucroette = activityContextMap.get("ucroette").toString();
                    }
                    rowOette.put("UCROETTE", ucroette);
                    String dcroette = today;
                    if (activityContextMap.containsKey("dcroette") && !activityContextMap.get("dcroette").toString().isEmpty()) {
                        dcroette = activityContextMap.get("dcroette").toString();
                    }
                    rowOette.put("DCROETTE", dcroette);
                    rowOette.put("LI3OETTE", activityContextMap.get("kategoria_zakupowa").toString());
                    rowOette.put("IC2OETTE", activityContextMap.get("kod_klienta").toString());
                    rowOette.put("I11OETTE", activityContextMap.get("kod_grupy_klienckiej").toString());
                    rowOette.put("I19OETTE", activityContextMap.get("kod_branzy").toString());
                    rowOette.put("LI1OETTE", activityContextMap.get("kod_przewoznika").toString());
                    rowOette.put("ROLOETTE", "T");
                    rowOette.put("PR4OETTE", rodzajPodmiotu.compareToIgnoreCase("POWI\u0104ZANY") == 0 ? "D/G" : "");
                    rowOette.put("LANOETTE", activityContextMap.get("kraj").toString().compareToIgnoreCase("POLSKA") == 0 ? "PL" : "EN");
                    String pr1oette = "";
                    String ic3oette = "";
                    if (relacjaBiznesowa.compareTo("Klient") == 0) {
                        if (activityContextMap.containsKey("klasyfikacja_m2s")) {
                            rowOette.put("IC1OETTE", activityContextMap.get("klasyfikacja_m2s").toString());
                        }
                        if (activityContextMap.containsKey("kod_dynamics_crm")) {
                            rowOette.put("LI2OETTE", activityContextMap.get("kod_dynamics_crm").toString());
                        }
                    }
                    String string = kod_kraju = activityContextMap.get("kod_kraju").toString().compareTo("PL") == 0 ? "23" : "23W";
                    if (typOperacji.compareTo("Nowy kontrahent") == 0) {
                        rowOette.put("COLOETTE", typ_rozrachunkowy);
                        rowOette.put("RGMOETTE", activityContextMap.get("sposob_platnosci_kod").toString().toUpperCase());
                        rowOette.put("RGDOETTE", activityContextMap.get("termin_platnosci_kod").toString());
                        rowOette.put("RGJOETTE", String.valueOf(activityContextMap.get("termin_platnosci_liczba")));
                        rowOette.put("TVAOETTE", kod_kraju);
                        if (relacjaBiznesowa.compareTo("Pracownik") == 0) {
                            rowOette.put("COCOETTE", "K");
                            rowOette.put("RG2OETTE", "ELPRZ");
                            rowOette.put("RD2OETTE", "FA");
                            rowOette.put("RJ2OETTE", "30");
                            if (activityContextMap.containsKey("nr_ewidencyjny")) {
                                rowOette.put("SIGOETTE", activityContextMap.get("nr_ewidencyjny").toString());
                            }
                            rowOette.put("TV2OETTE", "23");
                        }
                        rowOette.put("G03OETTE", activityContextMap.get("id_wniosku").toString());
                        rowOette.put("G04OETTE", activityContextMap.get("wnioskujacy").toString().substring(0, activityContextMap.get("wnioskujacy").toString().length() < 20 ? activityContextMap.get("wnioskujacy").toString().length() : 20));
                        rowOette.put("TRTOETTE", "AA");
                        rowOette.put("TMSOETTE", 1);
                        if (relacjaBiznesowa.compareTo("Klient internetowy") == 0) {
                            rowOette.put("IC3OETTE", "INTERN");
                            ic3oette = "INTERN";
                        }
                        if (relacjaBiznesowa.compareTo("Dostawca got\u00f3wkowy") == 0) {
                            rowOette.put("PR1OETTE", "DOGOT");
                            pr1oette = "DOGOT";
                        }
                    }
                    String nr = "1";
                    if (activityContextMap.containsKey("nr_relacja_biznesowa") && !activityContextMap.get("nr_relacja_biznesowa").toString().isEmpty()) {
                        nr = activityContextMap.get("nr_relacja_biznesowa").toString();
                    }
                    if (typOperacji.compareTo("Modyfikacja") == 0) {
                        if (nr.equals("1")) {
                            rowOette.put("COLOETTE", typ_rozrachunkowy);
                            rowOette.put("RGMOETTE", activityContextMap.get("sposob_platnosci_kod").toString().toUpperCase());
                            rowOette.put("RGDOETTE", activityContextMap.get("termin_platnosci_kod").toString());
                            rowOette.put("RGJOETTE", String.valueOf(activityContextMap.get("termin_platnosci_liczba")));
                            rowOette.put("TVAOETTE", kod_kraju);
                        } else {
                            rowOette.put("COLOETTE", "");
                            rowOette.put("RGMOETTE", "");
                            rowOette.put("RGDOETTE", "");
                            rowOette.put("RGJOETTE", "");
                            rowOette.put("TVAOETTE", "");
                        }
                        if (nr.equals("2")) {
                            rowOette.put("COCOETTE", typ_rozrachunkowy);
                            rowOette.put("RG2OETTE", activityContextMap.get("sposob_platnosci_kod").toString().toUpperCase());
                            rowOette.put("RD2OETTE", activityContextMap.get("termin_platnosci_kod").toString());
                            rowOette.put("RJ2OETTE", String.valueOf(activityContextMap.get("termin_platnosci_liczba")));
                            rowOette.put("TV2OETTE", kod_kraju);
                        } else {
                            rowOette.put("COCOETTE", "");
                            rowOette.put("RG2OETTE", "");
                            rowOette.put("RD2OETTE", "");
                            rowOette.put("RJ2OETTE", "");
                            rowOette.put("TV2OETTE", "");
                        }
                        if (nr.equals("3")) {
                            rowOette.put("CO3OETTE", typ_rozrachunkowy);
                            rowOette.put("RG3OETTE", activityContextMap.get("sposob_platnosci_kod").toString().toUpperCase());
                            rowOette.put("RD3OETTE", activityContextMap.get("termin_platnosci_kod").toString());
                            rowOette.put("RJ3OETTE", String.valueOf(activityContextMap.get("termin_platnosci_liczba")));
                            rowOette.put("TV3OETTE", kod_kraju);
                        } else {
                            rowOette.put("CO3OETTE", "");
                            rowOette.put("RG3OETTE", "");
                            rowOette.put("RD3OETTE", "");
                            rowOette.put("RJ3OETTE", "");
                            rowOette.put("TV3OETTE", "");
                        }
                        if (nr.equals("4")) {
                            rowOette.put("CO4OETTE", typ_rozrachunkowy);
                            rowOette.put("RG4OETTE", activityContextMap.get("sposob_platnosci_kod").toString().toUpperCase());
                            rowOette.put("RD4OETTE", activityContextMap.get("termin_platnosci_kod").toString());
                            rowOette.put("RJ4OETTE", String.valueOf(activityContextMap.get("termin_platnosci_liczba")));
                            rowOette.put("TV4OETTE", kod_kraju);
                        } else {
                            rowOette.put("CO4OETTE", "");
                            rowOette.put("RG4OETTE", "");
                            rowOette.put("RD4OETTE", "");
                            rowOette.put("RJ4OETTE", "");
                            rowOette.put("TV4OETTE", "");
                        }
                        if (nr.equals("5")) {
                            rowOette.put("CO5OETTE", typ_rozrachunkowy);
                            rowOette.put("RG5OETTE", activityContextMap.get("sposob_platnosci_kod").toString().toUpperCase());
                            rowOette.put("RD5OETTE", activityContextMap.get("termin_platnosci_kod").toString());
                            rowOette.put("RJ5OETTE", String.valueOf(activityContextMap.get("termin_platnosci_liczba")));
                            rowOette.put("TV5OETTE", kod_kraju);
                        } else {
                            rowOette.put("CO5OETTE", "");
                            rowOette.put("RG5OETTE", "");
                            rowOette.put("RD5OETTE", "");
                            rowOette.put("RJ5OETTE", "");
                            rowOette.put("TV5OETTE", "");
                        }
                        rowOette.put("TRTOETTE", "S");
                        rowOette.put("TMSOETTE", 2);
                        rowOette.put("PR1OETTE", "");
                        rowOette.put("UDMOETTE", "WORKFLOW");
                        rowOette.put("DDMOETTE", today);
                        rowOette.put("DA1OETTE", "?");
                        rowOette.put("G05OETTE", activityContextMap.get("id_wniosku").toString());
                        rowOette.put("G06OETTE", activityContextMap.get("kod_przewoznika").toString());
                        rowOette.put("G01OETTE", activityContextMap.get("g01oette").toString());
                        rowOette.put("LI4OETTE", activityContextMap.get("li4oette").toString());
                        rowOette.put("LI5OETTE", activityContextMap.get("li5oette").toString());
                        rowOette.put("NU1OETTE", String.valueOf(activityContextMap.get("nu1oette")));
                        rowOette.put("DA2OETTE", activityContextMap.get("da2oette").toString());
                        rowOette.put("RATOETTE", activityContextMap.get("rating").toString());
                        rowOette.put("COTOETTE", activityContextMap.get("notowanie").toString());
                        rowOette.put("FAMOETTE", activityContextMap.get("rodzina").toString());
                        rowOette.put("PR2OETTE", activityContextMap.get("pr2oette").toString());
                        rowOette.put("PR3OETTE", activityContextMap.get("pr3oette").toString());
                        rowOette.put("PR5OETTE", activityContextMap.get("pr5oette").toString());
                        rowOette.put("I12OETTE", activityContextMap.get("i12oette").toString());
                        rowOette.put("I13OETTE", activityContextMap.get("i13oette").toString());
                        rowOette.put("I16OETTE", activityContextMap.get("i16oette").toString());
                        rowOette.put("I17OETTE", activityContextMap.get("i17oette").toString());
                        rowOette.put("I18OETTE", activityContextMap.get("i18oette").toString());
                        rowOette.put("I20OETTE", activityContextMap.get("i20oette").toString());
                        rowOette.put("IC6OETTE", activityContextMap.get("ic6oette").toString());
                        rowOette.put("IC9OETTE", activityContextMap.get("ic9oette").toString());
                        if (relacjaBiznesowa.compareTo("Klient") == 0) {
                            rowOette.put("IC3OETTE", activityContextMap.get("ic3oette").toString());
                            rowOette.put("IC4OETTE", activityContextMap.get("ic4oette").toString());
                            rowOette.put("IC7OETTE", activityContextMap.get("ic7oette").toString());
                            rowOette.put("IC8OETTE", activityContextMap.get("ic8oette").toString());
                            rowOette.put("I10OETTE", activityContextMap.get("i10oette").toString());
                        }
                    }
                    ExportDataPZK.this.logInsertingValues(rowOette);
                    ExportDataPZK.this.insertRecord("OPS$DBO", session, "OETTE", rowOette);
                    log.debug((Object)"-------OETTA - MPM.Dane_Adresowe");
                    String L_kraj = activityContextMap.get("kraj").toString();
                    String[] T_kraj = L_kraj.split(";", -1);
                    String L_kod_kraju = activityContextMap.get("kod_kraju").toString();
                    String[] T_kod_kraju = L_kod_kraju.split(";", -1);
                    String L_nr_adresu = "01";
                    if (activityContextMap.containsKey("nr_adresu") && !activityContextMap.get("nr_adresu").toString().isEmpty()) {
                        L_nr_adresu = activityContextMap.get("nr_adresu").toString();
                    }
                    String[] T_nr_adresu = L_nr_adresu.split(";", -1);
                    String L_miasto = activityContextMap.get("miasto").toString();
                    String[] T_miasto = L_miasto.split(";", -1);
                    String L_kod_pocztowy = activityContextMap.get("kod_pocztowy").toString();
                    String[] T_kod_pocztowy = L_kod_pocztowy.split(";", -1);
                    String L_ulica = activityContextMap.get("ulica").toString();
                    String[] T_ulica = L_ulica.split(";", -1);
                    String ulica = "";
                    String L_telefon_1_t = activityContextMap.get("telefon").toString();
                    if (activityContextMap.containsKey("telefon_1_t")) {
                        L_telefon_1_t = activityContextMap.get("telefon_1_t").toString();
                    }
                    String[] T_telefon_1_t = L_telefon_1_t.split(";", -1);
                    String L_telefon_2_t = activityContextMap.get("telefon_2").toString();
                    if (activityContextMap.containsKey("telefon_2_t")) {
                        L_telefon_2_t = activityContextMap.get("telefon_2_t").toString();
                    }
                    String[] T_telefon_2_t = L_telefon_2_t.split(";", -1);
                    String L_osoba_kontaktowa_t = activityContextMap.get("osoba_kontaktowa").toString();
                    if (activityContextMap.containsKey("osoba_kontaktowa_t")) {
                        L_osoba_kontaktowa_t = activityContextMap.get("osoba_kontaktowa_t").toString();
                    }
                    String[] T_osoba_kontaktowa_t = L_osoba_kontaktowa_t.split(";", -1);
                    String L_osoba_kontaktowa_ksie_t = activityContextMap.get("osoba_kontaktowa_ksiego").toString();
                    if (activityContextMap.containsKey("osoba_kontaktowa_ksie_t")) {
                        L_osoba_kontaktowa_ksie_t = activityContextMap.get("osoba_kontaktowa_ksie_t").toString();
                    }
                    String[] T_osoba_kontaktowa_ksie_t = L_osoba_kontaktowa_ksie_t.split(";", -1);
                    String L_adres_email_ogolny_t = activityContextMap.get("email").toString();
                    if (activityContextMap.containsKey("adres_email_ogolny_t")) {
                        L_adres_email_ogolny_t = activityContextMap.get("adres_email_ogolny_t").toString();
                    }
                    String[] T_adres_email_ogolny_t = L_adres_email_ogolny_t.split(";", -1);
                    String L_adres_email_zmowieniafa = activityContextMap.get("adres_email_do_weryfika").toString();
                    if (activityContextMap.containsKey("adres_email_zmowieniafa")) {
                        L_adres_email_zmowieniafa = activityContextMap.get("adres_email_zmowieniafa").toString();
                    }
                    String[] T_adres_email_zmowieniafa = L_adres_email_zmowieniafa.split(";", -1);
                    String L_aktywny = "true";
                    if (activityContextMap.containsKey("aktywny") && !activityContextMap.get("aktywny").toString().isEmpty()) {
                        L_aktywny = activityContextMap.get("aktywny").toString();
                    }
                    String[] T_aktywny = L_aktywny.split(";", -1);
                    String L_glowny = "true";
                    if (activityContextMap.containsKey("glowny") && !activityContextMap.get("glowny").toString().isEmpty()) {
                        L_glowny = activityContextMap.get("glowny").toString();
                    }
                    String[] T_glowny = L_glowny.split(";", -1);
                    String tiaoeatt = "";
                    String L_utworzono_dnia = today;
                    if (activityContextMap.containsKey("utworzono_dnia") && !activityContextMap.get("utworzono_dnia").toString().isEmpty()) {
                        L_utworzono_dnia = activityContextMap.get("utworzono_dnia").toString();
                    }
                    String[] T_utworzono_dnia = L_utworzono_dnia.split(";", -1);
                    String L_przeznaczenie = "CLFPR";
                    if (activityContextMap.containsKey("przeznaczenie") && !activityContextMap.get("przeznaczenie").toString().isEmpty()) {
                        L_przeznaczenie = activityContextMap.get("przeznaczenie").toString();
                    }
                    String[] T_przeznaczenie = L_przeznaczenie.split(";", -1);
                    String L_utworzyl = "WORKFLOW";
                    if (activityContextMap.containsKey("utworzyl") && !activityContextMap.get("utworzyl").toString().isEmpty()) {
                        L_utworzyl = activityContextMap.get("utworzyl").toString();
                    }
                    String[] T_utworzyl = L_utworzyl.split(";", -1);
                    for (int i = 0; i < T_kod_kraju.length; ++i) {
                        rowOetta.put("TIEOETTA", nr_kontrahenta);
                        rowOetta.put("NOROETTA", activityContextMap.get("nazwa_skrocona").toString());
                        rowOetta.put("CEEOETTA", activityContextMap.get("nip").toString());
                        if (typOperacji.compareTo("Nowy kontrahent") == 0) {
                            rowOetta.put("NOMOETTA", activityContextMap.get("nazwa_kontrahenta").toString());
                            rowOetta.put("TMSOETTA", 1);
                        }
                        if (typOperacji.compareTo("Modyfikacja") == 0) {
                            rowOetta.put("SIROETTA", nr_kontrahenta);
                            rowOetta.put("DDMOETTA", today);
                            rowOetta.put("TMSOETTA", 2);
                            rowOetta.put("TRTOETTA", "S");
                            rowOetta.put("UDMOETTA", "WORKFLOW");
                            rowOetta.put("EM2OETTA", activityContextMap.get("adres_email_2").toString());
                            rowOetta.put("EM3OETTA", activityContextMap.get("adres_email_3").toString());
                        }
                        rowOetta.put("NUMOETTA", String.format("%02d", Integer.parseInt(T_nr_adresu[i])));
                        rowOetta.put("LANOETTA", T_kraj[i].compareToIgnoreCase("POLSKA") == 0 ? "PL" : "EN");
                        rowOetta.put("PAYOETTA", T_kod_kraju[i]);
                        rowOetta.put("ISOOETTA", kod_kraju_nip);
                        rowOetta.put("VILOETTA", T_miasto[i]);
                        rowOetta.put("PTTOETTA", T_kod_pocztowy[i]);
                        ulica = T_ulica[i];
                        rowOetta.put("AD1OETTA", ulica.substring(0, ulica.length() >= 32 ? 32 : ulica.length()));
                        if (ulica.length() > 32) {
                            rowOetta.put("AD2OETTA", ulica.substring(32, ulica.length() >= 64 ? 64 : ulica.length()));
                        }
                        if (ulica.length() > 64) {
                            rowOetta.put("AD3OETTA", ulica.substring(64, ulica.length() >= 96 ? 96 : ulica.length()));
                        }
                        rowOetta.put("TELOETTA", T_telefon_1_t[i]);
                        rowOetta.put("GSMOETTA", T_telefon_2_t[i]);
                        rowOetta.put("INIOETTA", T_osoba_kontaktowa_t[i]);
                        rowOetta.put("INCOETTA", T_osoba_kontaktowa_ksie_t[i]);
                        rowOetta.put("EMLOETTA", T_adres_email_ogolny_t[i]);
                        if (relacjaBiznesowa.compareTo("Klient") == 0) {
                            rowOetta.put("EM4OETTA", T_adres_email_zmowieniafa[i]);
                        }
                        if (relacjaBiznesowa.compareTo("Dostawca") == 0) {
                            rowOetta.put("EM5OETTA", T_adres_email_zmowieniafa[i]);
                        }
                        rowOetta.put("ETAOETTA", T_aktywny[i].compareToIgnoreCase("true") == 0 ? "A" : "I");
                        rowOetta.put("TYPOETTA", T_glowny[i].compareToIgnoreCase("true") == 0 ? "G" : "");
                        if (T_glowny[i].compareToIgnoreCase("true") == 0) {
                            tiaoeatt = String.format("%02d", Integer.parseInt(T_nr_adresu[i]));
                        }
                        rowOetta.put("DCROETTA", T_utworzono_dnia[i]);
                        rowOetta.put("DESOETTA", T_przeznaczenie[i]);
                        rowOetta.put("UCROETTA", T_utworzyl[i]);
                        rowOetta.put("DEVOETTA", activityContextMap.get("waluta_fakturowania").toString());
                        rowOetta.put("JUROETTA", activityContextMap.get("forma_prawna").toString());
                        rowOetta.put("ROLOETTA", "C");
                        ExportDataPZK.this.logInsertingValues(rowOetta);
                        ExportDataPZK.this.insertRecord("OPS$DBO", session, "OETTA", rowOetta);
                    }
                    log.debug((Object)"-------OETTD - MPM.Dane_Bankowe");
                    String tidoeatt = "01";
                    List<String> nrRachunkowBankowychIban = Arrays.asList(activityContextMap.get("numer_rachunku_bankoweg").toString().split(";"));
                    if (nrRachunkowBankowychIban.size() > 0) {
                        log.debug((Object)("Liczba rachunk\u00f3w bankowych: " + nrRachunkowBankowychIban.size()));
                    } else {
                        log.debug((Object)"Liczba rachunk\u00f3w bankowych: 0");
                    }
                    String L_nr_rachunku = "1";
                    if (activityContextMap.containsKey("nr_rachunku") && !activityContextMap.get("nr_rachunku").toString().isEmpty()) {
                        L_nr_rachunku = activityContextMap.get("nr_rachunku").toString();
                    }
                    String[] T_nr_rachunku = L_nr_rachunku.split(";", -1);
                    String L_przeznaczenie_b = "true";
                    if (activityContextMap.containsKey("przeznaczenie_b") && !activityContextMap.get("przeznaczenie_b").toString().isEmpty()) {
                        L_przeznaczenie_b = activityContextMap.get("przeznaczenie_b").toString();
                    }
                    String[] T_przeznaczenie_b = L_przeznaczenie_b.split(";", -1);
                    String L_aktywny_b = "true";
                    if (activityContextMap.containsKey("aktywny_b") && !activityContextMap.get("aktywny_b").toString().isEmpty()) {
                        L_aktywny_b = activityContextMap.get("aktywny_b").toString();
                        log.debug((Object)("L_aktywny_b: " + L_aktywny_b));
                    }
                    String[] T_aktywny_b = L_aktywny_b.split(";", -1);
                    String L_utworzyl_b = "WORKFLOW";
                    if (activityContextMap.containsKey("utworzyl_b") && !activityContextMap.get("utworzyl_b").toString().isEmpty()) {
                        L_utworzyl_b = activityContextMap.get("utworzyl_b").toString();
                    }
                    String[] T_utworzyl_b = L_utworzyl_b.split(";", -1);
                    String L_utworzono_dnia_b = today;
                    if (activityContextMap.containsKey("utworzono_dnia_b") && !activityContextMap.get("utworzono_dnia_b").toString().isEmpty()) {
                        L_utworzono_dnia_b = activityContextMap.get("utworzono_dnia_b").toString();
                    }
                    String[] T_utworzono_dnia_b = L_utworzono_dnia_b.split(";", -1);
                    for (int i = 0; i < nrRachunkowBankowychIban.size(); ++i) {
                        String numerRachunku = nrRachunkowBankowychIban.get(i);
                        rowOettd.put("TIEOETTD", nr_kontrahenta);
                        log.debug((Object)(T_nr_rachunku[i] + " - NUMOETTD " + String.format("%02d", Integer.parseInt(T_nr_rachunku[i]))));
                        rowOettd.put("NUMOETTD", String.format("%02d", Integer.parseInt(T_nr_rachunku[i])));
                        rowOettd.put("DESOETTD", T_przeznaczenie_b[i].compareToIgnoreCase("true") == 0 ? "P" : "D");
                        log.debug((Object)("DESOETTD: " + (T_przeznaczenie_b[i].compareToIgnoreCase("true") == 0 ? "P" : "D")));
                        if (T_przeznaczenie_b[i].compareToIgnoreCase("true") == 0) {
                            tidoeatt = String.format("%02d", Integer.parseInt(T_nr_rachunku[i]));
                            log.debug((Object)("tidoeatt: " + tidoeatt));
                        }
                        rowOettd.put("BICOETTD", numerRachunku.length() > 0 ? activityContextMap.get("swift").toString() : "");
                        rowOettd.put("BNQOETTD", ".");
                        rowOettd.put("BNROETTD", ".");
                        rowOettd.put("CCTOETTD", "");
                        rowOettd.put("DCPOETTD", numerRachunku.length() > 0 ? numerRachunku.substring(4) : "");
                        rowOettd.put("IBAOETTD", numerRachunku.length() > 0 ? numerRachunku : "");
                        rowOettd.put("PAYOETTD", numerRachunku.length() > 0 ? numerRachunku.substring(0, 2) : "PL");
                        rowOettd.put("ETAOETTD", T_aktywny_b[i].compareToIgnoreCase("true") == 0 ? "A" : "I");
                        log.debug((Object)("ETAOETTD: " + (T_aktywny_b[i].compareToIgnoreCase("true") == 0 ? "A" : "I")));
                        rowOettd.put("ROLOETTD", "D");
                        rowOettd.put("UCROETTD", T_utworzyl_b[i]);
                        rowOettd.put("DCROETTD", T_utworzono_dnia_b[i]);
                        if (typOperacji.compareTo("Nowy kontrahent") == 0) {
                            rowOettd.put("TMSOETTD", 1);
                        }
                        if (typOperacji.compareTo("Modyfikacja") == 0) {
                            rowOettd.put("TMSOETTD", 2);
                            rowOettd.put("TRTOETTD", "S");
                            rowOettd.put("UDMOETTD", "WORKFLOW");
                            rowOettd.put("DDMOETTD", today);
                            rowOettd.put("CBNOETTD", ".");
                        }
                        ExportDataPZK.this.logInsertingValues(rowOettd);
                        ExportDataPZK.this.insertRecord("OPS$DBO", session, "OETTD", rowOettd);
                    }
                    log.debug((Object)("-------OEATT - MPM.Dane_Przypisanie - nr " + nr));
                    rowOeatt.put("TIEOEATT", nr_kontrahenta);
                    rowOeatt.put("ETSOEATT", "DSSSL");
                    if (typOperacji.compareTo("Nowy kontrahent") == 0 || typOperacji.compareTo("Modyfikacja") == 0 && nr.equals("1")) {
                        rowOeatt.put("COLOEATT", typ_rozrachunkowy);
                        rowOeatt.put("RGMOEATT", activityContextMap.get("sposob_platnosci_kod").toString().toUpperCase());
                        rowOeatt.put("RGJOEATT", String.valueOf(activityContextMap.get("termin_platnosci_liczba")));
                        rowOeatt.put("RGDOEATT", activityContextMap.get("termin_platnosci_kod").toString());
                        rowOeatt.put("TVAOEATT", kod_kraju);
                    } else {
                        rowOette.put("COLOEATT", "");
                        rowOette.put("RGMOEATT", "");
                        rowOette.put("RGJOEATT", "");
                        rowOette.put("RGDOEATT", "");
                        rowOette.put("TVAOEATT", "");
                    }
                    if (typOperacji.compareTo("Nowy kontrahent") == 0) {
                        if (relacjaBiznesowa.compareTo("Pracownik") == 0) {
                            rowOeatt.put("TA2OEATT", "01");
                            rowOeatt.put("TD2OEATT", "01");
                            rowOeatt.put("COCOEATT", "K");
                            rowOeatt.put("RG2OEATT", "ELPRZ");
                            rowOeatt.put("RJ2OEATT", "30");
                            rowOeatt.put("RD2OEATT", "FA");
                            rowOeatt.put("TV2OEATT", "23");
                        }
                        rowOeatt.put("TMSOEATT", 1);
                    }
                    rowOeatt.put("TIAOEATT", tiaoeatt);
                    rowOeatt.put("TIDOEATT", tidoeatt);
                    rowOeatt.put("ETAOEATT", status);
                    String dcroeatt = today;
                    if (activityContextMap.containsKey("dcroeatt") && !activityContextMap.get("dcroeatt").toString().isEmpty()) {
                        dcroeatt = activityContextMap.get("dcroeatt").toString();
                    }
                    rowOette.put("UCROETTE", dcroeatt);
                    String ucroeatt = "WORKFLOW";
                    if (activityContextMap.containsKey("ucroeatt") && !activityContextMap.get("ucroeatt").toString().isEmpty()) {
                        ucroeatt = activityContextMap.get("ucroeatt").toString();
                    }
                    rowOette.put("UCROETTE", ucroeatt);
                    if (typOperacji.compareTo("Modyfikacja") == 0) {
                        if (nr.equals("2")) {
                            rowOette.put("COCOEATT", typ_rozrachunkowy);
                            rowOeatt.put("RG2OEATT", activityContextMap.get("sposob_platnosci_kod").toString().toUpperCase());
                            rowOeatt.put("RJ2OEATT", String.valueOf(activityContextMap.get("termin_platnosci_liczba")));
                            rowOeatt.put("RD2OEATT", activityContextMap.get("termin_platnosci_kod").toString());
                            rowOeatt.put("TV2OEATT", kod_kraju);
                        } else {
                            rowOette.put("COCOEATT", "");
                            rowOette.put("RG2OEATT", "");
                            rowOette.put("RJ2OEATT", "");
                            rowOette.put("RD2OEATT", "");
                            rowOette.put("TV2OEATT", "");
                        }
                        if (nr.equals("3")) {
                            rowOette.put("CO3OEATT", typ_rozrachunkowy);
                            rowOeatt.put("RG3OEATT", activityContextMap.get("sposob_platnosci_kod").toString().toUpperCase());
                            rowOeatt.put("RJ3OEATT", String.valueOf(activityContextMap.get("termin_platnosci_liczba")));
                            rowOeatt.put("RD3OEATT", activityContextMap.get("termin_platnosci_kod").toString());
                            rowOeatt.put("TV3OEATT", kod_kraju);
                        } else {
                            rowOette.put("CO3OEATT", "");
                            rowOette.put("RG3OEATT", "");
                            rowOette.put("RJ3OEATT", "");
                            rowOette.put("RD3OEATT", "");
                            rowOette.put("TV3OEATT", "");
                        }
                        if (nr.equals("4")) {
                            rowOette.put("CO4OEATT", typ_rozrachunkowy);
                            rowOeatt.put("RG4OEATT", activityContextMap.get("sposob_platnosci_kod").toString().toUpperCase());
                            rowOeatt.put("RJ4OEATT", String.valueOf(activityContextMap.get("termin_platnosci_liczba")));
                            rowOeatt.put("RD4OEATT", activityContextMap.get("termin_platnosci_kod").toString());
                            rowOeatt.put("TV4OEATT", kod_kraju);
                        } else {
                            rowOette.put("CO4OEATT", "");
                            rowOette.put("RG4OEATT", "");
                            rowOette.put("RJ4OEATT", "");
                            rowOette.put("RD4OEATT", "");
                            rowOette.put("TV4OEATT", "");
                        }
                        if (nr.equals("5")) {
                            rowOette.put("CO5OEATT", typ_rozrachunkowy);
                            rowOeatt.put("RG5OEATT", activityContextMap.get("sposob_platnosci_kod").toString().toUpperCase());
                            rowOeatt.put("RJ5OEATT", String.valueOf(activityContextMap.get("termin_platnosci_liczba")));
                            rowOeatt.put("RD5OEATT", activityContextMap.get("termin_platnosci_kod").toString());
                            rowOeatt.put("TV5OEATT", kod_kraju);
                        } else {
                            rowOette.put("CO5OEATT", "");
                            rowOette.put("RG5OEATT", "");
                            rowOette.put("RJ5OEATT", "");
                            rowOette.put("RD5OEATT", "");
                            rowOette.put("TV5OEATT", "");
                        }
                        rowOeatt.put("TMSOEATT", 2);
                        rowOeatt.put("RATOEATT", activityContextMap.get("rating").toString());
                        rowOeatt.put("COTOEATT", activityContextMap.get("notowanie").toString());
                        rowOeatt.put("TRTOEATT", "S");
                        rowOeatt.put("GESOEATT", activityContextMap.get("administrator").toString());
                        rowOeatt.put("PR1OEATT", pr1oette);
                        rowOeatt.put("PR2OEATT", activityContextMap.get("pr2oette").toString());
                        rowOeatt.put("PR3OEATT", activityContextMap.get("pr3oette").toString());
                        rowOeatt.put("PR4OEATT", rodzajPodmiotu.compareToIgnoreCase("POWI\u0104ZANY") == 0 ? "D/G" : "");
                        rowOeatt.put("PR5OEATT", activityContextMap.get("pr5oette").toString());
                        rowOeatt.put("UDMOEATT", "WORKFLOW");
                        rowOeatt.put("DDMOEATT", today);
                        rowOeatt.put("DA2OEATT", activityContextMap.get("da2oette").toString());
                        rowOeatt.put("G01OEATT", activityContextMap.get("g01oette").toString());
                        rowOeatt.put("G05OEATT", activityContextMap.get("id_wniosku").toString());
                        rowOeatt.put("G06OEATT", activityContextMap.get("kod_przewoznika").toString());
                        rowOeatt.put("I11OEATT", activityContextMap.get("kod_grupy_klienckiej").toString());
                        rowOeatt.put("I12OEATT", activityContextMap.get("i12oette").toString());
                        rowOeatt.put("I13OEATT", activityContextMap.get("i13oette").toString());
                        rowOeatt.put("I16OEATT", activityContextMap.get("i16oette").toString());
                        rowOeatt.put("I19OEATT", activityContextMap.get("kod_branzy").toString());
                        rowOeatt.put("IC2OEATT", activityContextMap.get("kod_klienta").toString());
                        rowOeatt.put("IC3OEATT", ic3oette);
                        rowOeatt.put("LI1OEATT", activityContextMap.get("kod_przewoznika").toString());
                        rowOeatt.put("LI3OEATT", activityContextMap.get("kategoria_zakupowa").toString());
                        rowOeatt.put("LI4OEATT", activityContextMap.get("li4oette").toString());
                        rowOeatt.put("LI5OEATT", activityContextMap.get("li5oette").toString());
                        rowOeatt.put("NU1OEATT", activityContextMap.get("nu1oette").toString());
                        if (relacjaBiznesowa.compareTo("Klient") == 0) {
                            rowOeatt.put("I10OEATT", activityContextMap.get("i10oette").toString());
                            rowOeatt.put("IC1OEATT", activityContextMap.get("klasyfikacja_m2s").toString());
                            rowOeatt.put("IC4OEATT", activityContextMap.get("ic4oette").toString());
                            rowOeatt.put("IC7OEATT", activityContextMap.get("ic7oette").toString());
                            rowOeatt.put("IC8OEATT", activityContextMap.get("ic8oette").toString());
                            rowOeatt.put("LI2OEATT", activityContextMap.get("kod_dynamics_crm").toString());
                        }
                    }
                    ExportDataPZK.this.logInsertingValues(rowOeatt);
                    ExportDataPZK.this.insertRecord("OPS$DBO", session, "OEATT", rowOeatt);
                    connection.commit();
                }
                catch (Exception e) {
                    if (connection != null) {
                        connection.rollback();
                    }
                    log.debug((Object)"-------ExportDataPZK exception-------");
                    log.error((Object)e.getMessage(), (Throwable)e);
                    CommentService comments = ServiceFactory.getCommentService();
                    Comment comment = new Comment();
                    comment.setActivityId(activityContext.getActivityId());
                    comment.setComment("B\u0142\u0105d wysy\u0142ania danych do Qualiaca. Przyczyna:" + e.getMessage());
                    comment.setProcessId(activityContext.getProcessId());
                    comment.setUserId("admin");
                    comment.setTimestamp(Long.valueOf(new Date().getTime()));
                    comments.createComment(comment);
                    throw e;
                }
                return null;
            }
        });
    }

    private boolean insertRecord(String dbSchema, DatabaseSession session, String tableName, Map<String, Object> row) {
        Record record = StringUtils.hasText((String)dbSchema) ? session.createRecord(dbSchema, tableName) : session.createRecord(tableName);
        this.setRecordData(record, row);
        session.insert(record);
        return true;
    }

    private void setRecordData(Record record, Map<String, Object> row) {
        for (Map.Entry<String, Object> entry : row.entrySet()) {
            record.set(entry.getKey(), entry.getValue());
        }
    }

    private String getNewNumoette(Database database) {
        SequenceService sequenceService = ServiceFactory.getSequenceService();
        String sequenceName = "pzk_export_data";
        long lNNNN = 0L;
        if (!sequenceService.sequenceExist(sequenceName)) {
            sequenceService.createSequence(sequenceName, 1, 1);
            lNNNN = sequenceService.getCurrentSequenceValue(sequenceName);
        } else {
            lNNNN = sequenceService.getNextSequenceValue(sequenceName);
        }
        long resultValue = 99999L - lNNNN;
        Object resultValueString = String.valueOf(resultValue);
        resultValueString = "00000" + (String)resultValueString;
        return ((String)resultValueString).substring(((String)resultValueString).length() - 5);
    }

    private void logInsertingValues(Map<String, Object> rowOette) {
        try {
            for (String keys : rowOette.keySet()) {
                log.debug((Object)(keys + ":" + String.valueOf(rowOette.get(keys))));
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

