/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.Integrations;

import com.suncode.pwfl.dbconfig.DatabaseConnectionConfigEntry;
import com.suncode.pwfl.dbconfig.DatabaseConnectionConfigService;
import com.suncode.pwfl.plugin.modules.dbconfig.DatabaseConnectionConfig;
import com.suncode.pwfl.util.SpringContext;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class Integration {
    public static Logger log = Logger.getLogger(Integration.class);
    private static volatile HikariDataSource dataSource;

    private static synchronized DataSource getDataSource() throws SQLException {
        if (dataSource == null) {
            List configs = ((DatabaseConnectionConfigService)SpringContext.getBean(DatabaseConnectionConfigService.class)).getConfigsByPluginId("com.suncode.plugin-dbexplorer");
            if (configs != null && !configs.isEmpty()) {
                for (DatabaseConnectionConfigEntry entry : configs) {
                    for (DatabaseConnectionConfig configObj : entry.getConfigs()) {
                        if (configObj == null || !"QUALIAC".equals(configObj.getName())) continue;
                        HikariConfig config = new HikariConfig();
                        config.setDriverClassName(configObj.getDriverClassName());
                        config.setJdbcUrl(configObj.getJdbcUrl());
                        config.setUsername(configObj.getUsername());
                        config.setPassword(configObj.getPassword());
                        config.setMaximumPoolSize(20);
                        config.setMinimumIdle(10);
                        config.setConnectionTimeout(30000L);
                        config.setLeakDetectionThreshold(60000L);
                        config.setAutoCommit(true);
                        config.setPoolName("QualiacPoolPlugin");
                        dataSource = new HikariDataSource(config);
                        return dataSource;
                    }
                }
            }
            throw new SQLException("Nie znaleziono konfiguracji bazy QUALIAC");
        }
        return dataSource;
    }

    public static Connection getConnection() throws SQLException, ClassNotFoundException {
        log.trace((Object)"************************* getConnection() ********************");
        long nStart = System.currentTimeMillis();
        Connection con = null;
        try {
            Locale backup = Locale.getDefault();
            log.debug((Object)("Backing up locale: " + backup.toString()));
            con = Integration.getDataSource().getConnection();
            try {
                log.debug((Object)"Setting locale to: US");
                Locale.setDefault(Locale.US);
            }
            catch (Exception e) {
                log.debug((Object)"Failed to set locale. Restoring from backup.");
                Locale.setDefault(backup);
            }
            log.debug((Object)"Successfully connected to Oracle database");
        }
        catch (Exception e) {
            if (con != null) {
                try {
                    con.close();
                    log.debug((Object)"Connection closed due to error");
                }
                catch (SQLException closeEx) {
                    log.error((Object)("Error closing connection: " + closeEx.getMessage()), (Throwable)closeEx);
                }
            }
            log.error((Object)("Error connecting to database: " + e.getMessage()), (Throwable)e);
            throw new SQLException("Cannot establish connection to QUALIAC database", e);
        }
        if (log.isTraceEnabled()) {
            long nStop = System.currentTimeMillis();
            log.trace((Object)("Connected in: " + (nStop - nStart) + " ms"));
        }
        return con;
    }

    public static void disconnect(Connection conn) {
        log.trace((Object)"************************* disconnect() ********************");
        long nStart = System.currentTimeMillis();
        try {
            if (conn == null) {
                log.warn((Object)"Polaczenie, ktore mialo byc zamkniete, jest null'em.");
            } else if (conn.isClosed()) {
                log.warn((Object)"Polaczenie, ktore mialo byc zamkniete, jest juz zamkniete.");
            } else {
                conn.close();
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        if (log.isTraceEnabled()) {
            long nStop = System.currentTimeMillis();
            log.trace((Object)("Disconnected in : " + (nStop - nStart)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Map<String, String>> executeQuery(Connection con, String query) throws SQLException {
        log.debug((Object)"************************* executeQuery() ********************");
        long nStart = System.currentTimeMillis();
        Statement stmt = null;
        ResultSet rset = null;
        ArrayList<Map<String, String>> results = new ArrayList<Map<String, String>>();
        try {
            if (con != null && !con.isClosed()) {
                log.debug((Object)"ExeccuteQuery: ".concat(query));
                if (query.contains("INSERT") || query.contains("UPDATE")) {
                    stmt = con.createStatement();
                    stmt.executeUpdate(query);
                } else {
                    DatabaseMetaData metaData = con.getMetaData();
                    if (metaData.supportsTransactionIsolationLevel(1)) {
                        con.setTransactionIsolation(1);
                    }
                    stmt = con.createStatement();
                    rset = stmt.executeQuery(query);
                    ResultSetMetaData rsmd = rset.getMetaData();
                    int numColumns = rsmd.getColumnCount();
                    while (rset.next()) {
                        HashMap<String, String> oneRow = new HashMap<String, String>();
                        for (int i = 1; i < numColumns + 1; ++i) {
                            String columnName = rsmd.getColumnName(i);
                            Object obj = rset.getObject(columnName);
                            String value = "";
                            if (obj != null) {
                                value = obj.toString();
                            }
                            oneRow.put(columnName, value);
                        }
                        results.add(oneRow);
                    }
                }
            } else {
                log.debug((Object)"Brak po\u0142\u0105czenia z baz\u0105");
            }
        }
        catch (SQLException e) {
            log.error((Object)"Blad w momencie wywolywania zapytania");
            throw e;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (rset != null) {
                    rset.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"Blad w momencie zamykania Statement/ResultSet");
                throw e;
            }
        }
        if (log.isTraceEnabled()) {
            long nStop = System.currentTimeMillis();
            log.trace((Object)("Query executed in : " + (nStop - nStart)));
        }
        return results;
    }
}

